//-----------------------------------------------------------
//
//-----------------------------------------------------------
class TestPawn extends GBPawn;


// Play appropriate crouching animations
simulated function AnimateCrouchWalking()
{
	MovementAnims[0]='interact_caress';
	MovementAnims[1]='interact_putdown01';
	MovementAnims[2]='interact_pickup01';
	MovementAnims[3]='RCrouch';
	TurnLeftAnim='LCrouch';
	TurnRightAnim='RCrouch';
}


// Play appropriate walking animations
simulated function AnimateWalking()
{
	MovementAnims[0]='walk_normal';
	MovementAnims[1]='walk_backwalk';
	MovementAnims[2]='walk_normal';
	MovementAnims[3]='walk_normal';
	TurnLeftAnim='walk_normal';
	TurnRightAnim='walk_normal';
}

/*
native(259) final function PlayAnim( name Sequence, optional float Rate, optional float TweenTime, optional int Channel );
native(260) final function LoopAnim( name Sequence, optional float Rate, optional float TweenTime, optional int Channel );
native(294) final function TweenAnim( name Sequence, float Time, optional int Channel );
native(282) final function bool IsAnimating(optional int Channel);
native(261) final latent function FinishAnim(optional int Channel);
native(263) final function bool HasAnim( name Sequence );
native final function StopAnimating( optional bool ClearAllButBase ); */
// Play appropriate idle animations
simulated function PlayWaiting()
{
	LoopAnim(IdleAnim,1.0,0.2,0);
}

// Play appropriate running animations
simulated function AnimateRunning()
{
	MovementAnims[0]='run_normal';
	MovementAnims[1]='walk_backwalk';
	MovementAnims[2]='run_normal';
	MovementAnims[3]='run_normal';
	TurnLeftAnim='run_normal';
	TurnRightAnim='run_normal';
}

// Play appropriate flying animations
simulated function AnimateFlying()
{
	MovementAnims[0]='walk_loop';
	MovementAnims[1]='walk_loop';
	MovementAnims[2]='walk_loop';
	MovementAnims[3]='walk_loop';
	TurnLeftAnim='walk_loop';
	TurnRightAnim='walk_loop';
}

defaultproperties
{
	Mesh=Mesh'_PGA-EmoboySized.emoboy_mesh'
	IdleAnim="stand_normal"
	MovementAnims[0]="run_normal"
	MovementAnims[1]="run_normal"
	MovementAnims[2]="run_normal"
	MovementAnims[3]="run_normal"
	TurnLeftAnim="walk_loop"
	TurnRightAnim="walk_loop"
	bPhysicsAnimUpdate=true
	bCanCrouch=false
	GroundSpeed=440
	Skins(0)=Texture'_PGTX-Emoboy.emoboy_skin'
	Skins(1)=Texture'_PGTX-Emoboy.emoboy_clothes_01'
	bActorShadows=true
	BaseEyeHeight=128

CustomAnimations[0]="ambi_impatient"
CustomAnimations[1]="ambi_lookaround01"
CustomAnimations[2]="ambi_lookaround02"
CustomAnimations[3]="ambi_lookleft"
CustomAnimations[4]="ambi_lookright"
CustomAnimations[5]="ambi_scratch"
CustomAnimations[6]="ambi_yawn"
CustomAnimations[7]="fight_beating"
CustomAnimations[8]="fight_kickdown"
CustomAnimations[9]="fight_kickup"
CustomAnimations[10]="fight_runshoot"
CustomAnimations[11]="fight_shootpistol"
CustomAnimations[12]="fight_slaps"
CustomAnimations[13]="interact_automat"
CustomAnimations[14]="interact_caress"
CustomAnimations[15]="interact_manipulate01"
CustomAnimations[16]="interact_manipulate02"
CustomAnimations[17]="interact_pickup01"
CustomAnimations[18]="interact_pickup02"
CustomAnimations[19]="interact_putdown01"
CustomAnimations[20]="interact_putdown02"
CustomAnimations[21]="interact_putfront01"
CustomAnimations[22]="interact_putfront02"
CustomAnimations[23]="interact_throw01"
CustomAnimations[24]="interact_throw02"
CustomAnimations[25]="interact_throwfrompocket01"
CustomAnimations[26]="interact_throwfrompocket02"
CustomAnimations[27]="interact_touchhorrified"
CustomAnimations[28]="interact_whatisthis"
CustomAnimations[29]="navi_bigjump"
CustomAnimations[30]="navi_crawl"
CustomAnimations[31]="navi_lieonback01"
CustomAnimations[32]="navi_lieonback02"
CustomAnimations[33]="navi_lieonstomach01"
CustomAnimations[34]="navi_lieonstomach02"
CustomAnimations[35]="navi_sit01"
CustomAnimations[36]="navi_sit02"
CustomAnimations[37]="navi_sitonground01"
CustomAnimations[38]="navi_sitonground02"
CustomAnimations[39]="navi_slip"
CustomAnimations[40]="navi_strafeleft"
CustomAnimations[41]="navi_strafeleft2"
CustomAnimations[42]="navi_straferight"
CustomAnimations[43]="navi_straferight2"
CustomAnimations[44]="opendoor_angry"
CustomAnimations[45]="opendoor_confident"
CustomAnimations[46]="opendoor_depressed"
CustomAnimations[47]="opendoor_happy"
CustomAnimations[48]="opendoor_normal"
CustomAnimations[49]="run_chasing"
CustomAnimations[50]="run_ducking"
CustomAnimations[51]="run_normal"
CustomAnimations[52]="run_normal2"
CustomAnimations[53]="social_agree"
CustomAnimations[54]="social_agreeangry"
CustomAnimations[55]="social_applause01"
CustomAnimations[56]="social_applause02"
CustomAnimations[57]="social_biglaugh"
CustomAnimations[58]="social_braviss"
CustomAnimations[59]="social_cantbelieve"
CustomAnimations[61]="social_champions"
CustomAnimations[62]="social_cheer"
CustomAnimations[63]="social_despair"
CustomAnimations[64]="social_disagree"
CustomAnimations[65]="social_explain"
CustomAnimations[66]="social_eplainangry"
CustomAnimations[67]="social_fyeah"
CustomAnimations[68]="social_fyou"
CustomAnimations[69]="social_happydance01"
CustomAnimations[70]="social_happydance02"
CustomAnimations[71]="social_happyjump01"
CustomAnimations[72]="social_happyjump02"
CustomAnimations[73]="social_heywatchit"
CustomAnimations[74]="social_idontthinkso"
CustomAnimations[75]="social_listen"
CustomAnimations[76]="social_listenangry"
CustomAnimations[77]="social_mememe"
CustomAnimations[78]="social_noway"
CustomAnimations[79]="social_persuasion"
CustomAnimations[80]="social_pleading"
CustomAnimations[81]="social_shocked"
CustomAnimations[82]="social_shoutwave"
CustomAnimations[83]="social_shoutwavebig"
CustomAnimations[84]="social_shrug"
CustomAnimations[85]="social_talkangry"
CustomAnimations[86]="social_talkimportant"
CustomAnimations[87]="social_tantrum"
CustomAnimations[88]="social_thatsit"
CustomAnimations[89]="social_thisandthis"
CustomAnimations[90]="social_threaten"
CustomAnimations[91]="social_turnleave"
CustomAnimations[92]="social_waithere"
CustomAnimations[93]="social_welcome"
CustomAnimations[94]="social_whatever"
CustomAnimations[95]="social_youknow"
CustomAnimations[96]="social_yousee"
CustomAnimations[97]="sprint_loop"
CustomAnimations[98]="sprint_loopstart"
CustomAnimations[99]="sprint_loopstop"
CustomAnimations[100]="stand_angry"
CustomAnimations[101]="stand_confident"
CustomAnimations[102]="stand_depressed"
CustomAnimations[103]="stand_gay"
CustomAnimations[104]="stand_happy"
CustomAnimations[105]="stand_normal"
CustomAnimations[106]="stand_wall01"
CustomAnimations[107]="stand_wall02"
CustomAnimations[108]="walk_angry"
CustomAnimations[109]="walk_backwalk"
CustomAnimations[110]="walk_confident"
CustomAnimations[111]="walk_depressed"
CustomAnimations[112]="walk_drunk"
CustomAnimations[113]="walk_gay"
CustomAnimations[114]="walk_happy"
CustomAnimations[115]="walk_injured"
CustomAnimations[116]="walk_loop"
CustomAnimations[117]="walk_normal"
CustomAnimations[118]="walk_normal2"
CustomAnimations[119]="walk_tired"


}
