/*
Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.
*/

//=============================================================================
// DeathMatchPlus.
//=============================================================================
class Scenario extends RTGameInfo
	config(GameBotsUE2);


var BotServer		theBotServer;
var config bool		bAllowControlServer;
var ControlServer theControlServer;
var bool		bServerLoaded, bBoolResult;
var int			NumRemoteBots;
var string GameClass;

var config string RemoteBotController;

var config string BotServerClass;

var config string ControlServerClass;

var config string HudMutatorClass;

//this is ID counter that is used for objects in UnrealScript that doesn't have
//exportable unique ID - (dropped weapons, vehicles or projectiles)
var int GameBotsID;

var config int BotServerPort;
var config int ControlServerPort;

//if true we will pick some random free ports for bot and control server and write
//them down to a file in UserLog directory (name is set in LoggerFileName)
var config bool bRandomPorts;

//enables vehicles in the game
var config bool bVehiclesEnabled;

//if set to true all weapons from map will be erased
var bool bShouldEraseAllWeapons;

//here we store if our connections to bot and cotrol server are protected by pass
//will force a bit changed initial protocol (to check password)
var bool bPasswordProtected;

//here we store Password for bot and control connections
var string Password;

//who initiated the password protection
var string PasswordByIP;

// This class is used for pausing the game. We supply it to Level.Pauser variable.
var PauserFeed LevelPauserFeed;
//Here we store all available maps
var array<string> Maps;

//this function is called even before PreBeginPlay, we parse GB parameters from
//command line here
event InitGame(string Options, out string Error )
{
	local string InOpt;
	local Mutator M;
	local bool bFound;

	super.InitGame(Options, Error);

	bFound = false;
	//Make sure the GBHUDMutator is on!
	for (M = BaseMutator; M != None; M = M.NextMutator)
	{
    	if (M.IsA('GBHudMutator'))
    	{
    		bFound = true;
			break;
		}

	}
	if (!bFound)
		AddMutator(HudMutatorClass);

	BotServerPort = Clamp(GetIntOption( Options, "BotServerPort", BotServerPort ),2000,32000);
	ControlServerPort = Clamp(GetIntOption( Options, "ControlServerPort", ControlServerPort ),2000,32000);

	InOpt = ParseOption( Options,"bRandomPorts");
	if ( InOpt != "" )
		bRandomPorts = bool(InOpt);


	InOpt = ParseOption( Options, "Password");
	if (InOpt != "")
	{
	    bPasswordProtected = true;
	    PasswordByIP = Level.GetAddressURL();
	    Password = InOpt;
	}
	else
	{
		bPasswordProtected = false;
	}

}

//This function is automaticaly called after beginning of the game
function PostBeginPlay()
{
	local GameInfo FoundGameInfo; //for vehicle support

	Super.PostBeginPlay();

	if(!bServerLoaded)
    {
		if (bAllowControlServer)
        {
			theControlServer = spawn(class<ControlServer>(DynamicLoadObject(ControlServerClass, class'class')),self);
			theControlServer.ListenPort = ControlServerPort;
		}

		theBotServer = Spawn(class<BotServer>(DynamicLoadObject(BotServerClass, class'Class')),self);
		theBotServer.ListenPort = BotServerPort;

		bServerLoaded = true;
	}
	else
	{

		theBotServer.bClosed = false;
		theBotServer.Listen();

		theControlServer.bClosed = false;
		theControlServer.Listen();
	}

    GameBotsID = 0;
	//Commented, not compatible with linux. Passing message to console
	//LogPorts();
	Log("GB server on.");
	Log(" BotServerPort:"$theBotServer.ListenPort);
	//Test();
	LoadMapsFromPrefix(MapPrefix);

}


function LoadMapsFromPreFix(string Prefix)
{
   local string FirstMap,NextMap,MapName,TestMap;
   local int i, z;

   FirstMap = Level.GetMapName(PreFix, "", 0);
   NextMap = FirstMap;
   i = 0;
   while(!(FirstMap ~= TestMap))
   {
      MapName = NextMap;
      z = InStr(Caps(MapName), ".URT");
      if(z != -1)
         MapName = Left(MapName, z);  // remove "."

      Maps[i] = MapName;

      NextMap = Level.GetMapName(PreFix, NextMap, 1);
      TestMap = NextMap;
      i += 1;
   }
}

event Broadcast( Actor Sender, coerce string Msg, optional name Type )
{
	local Controller C;

	super.Broadcast(Sender,Msg,Type);
	//needed here, otherwise our bots wont get the message because they are not
	//PlayerControllers
	for(C = Level.ControllerList; C != none; C = C.NextController) {
		if(C.isA('RemoteBot') && (C != Sender))
			RemoteBot(C).RemoteNotifyClientMessage(Controller(Sender),Msg);
	}

}

function BroadcastTeam( Controller Sender, coerce string Msg, optional name Type )
{
	local Controller C;

	super.BroadcastTeam(Sender,Msg,Type);
	//needed here, otherwise our bots wont get the message because they are not
	//PlayerControllers
	for(C = Level.ControllerList; C != none; C = C.NextController) {
		if(C.isA('RemoteBot') && (C != Sender))
			RemoteBot(C).RemoteNotifyTeamMessage(Sender,Msg);
	}

}


//This function returns text information about game
function string GetGameInfo()
{
	local string outStr;

	outStr = " {TimeLimit " $ TimeLimit $ "}";

	return outStr;
}

//Returns game status - list of players and their score
function SendGameStatus(GBClientClass requester)
{

}

//Used for restarting our RemoteBots
function RemoteRestartPlayer( Controller aPlayer, optional vector startLocation, optional rotator startRotation )
{
	log("We are in RemoteRestartPlayer");

	SpawnPawn( RemoteBot(aPlayer), startLocation, startRotation);

}

//Rewriten so we can set the position and respawn playercontrollers
function RestartPlayer(Controller aPlayer)
{
	log("We are in RestartPlayer");
	if (!aPlayer.IsA('RemoteBot'))
		super.RestartPlayer(aPlayer);
}

//Main function for adding bot to the game (creates also controller)
function RemoteBot AddRemoteBot
(
	BotConnection theConnection,
	string clientName,
	int TeamNum,
	optional string className,
	optional string DesiredSkin,
	optional float DesiredSkill,
	optional float DesiredAccuracy,
	optional bool ShouldLeadTarget
)
{
	local RemoteBot NewBot;
	local GBReplicationInfo repInfo;

	//I dont think location here is necessary. Its just controller class
	NewBot = Spawn(class<RemoteBot>(DynamicLoadObject(RemoteBotController, class'Class')),self);

	if ( NewBot == None )
	{
		log("In AddRemoteBot() - Cant spawn RemoteBot ");
		return None;
	}

	//AddBotToList(NewBot); //Test

	//hook up connection to socket
	NewBot.myConnection = theConnection;

	NewBot.bIsPlayer = true;
	NewBot.bHidden = false;

	// Set the player's ID.
	NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;

	// Add custom GBReplicationInfo
	repInfo = class'GBReplicationInfo'.Static.SpawnFor(NewBot);
	repInfo.MyPRI = NewBot.PlayerReplicationInfo;

	//Increase numbers properly, so no epic bot will join the game
	//MinPlayers = Max(MinPlayers+1, NumPlayers + NumBots + 1);
	NumRemoteBots++;
	NumPlayers++;

	if ( clientName != "" )
	{
		NewBot.PlayerReplicationInfo.PlayerName = clientName;
		changeName( newBot, clientName, true );
	}
    if (className != "")
        NewBot.PawnClass = class<Pawn>(DynamicLoadObject(className, class'Class'));
    else
        NewBot.PawnClass = class<Pawn>(DynamicLoadObject("GameBotsUE2.UDNMale", class'Class'));

	return NewBot;
}

//Here we spawn and respawn the bot Pawn - thats the visible avatar of the bot
function SpawnPawn
(
	RemoteBot NewBot,
	optional vector startLocation,
	optional rotator startRotation
)
{
	local NavigationPoint startSpot;

	if (NewBot == None)
	{
    	log("In SpawnPawn(), - NewBot is None! ");
    	return;
	}

	if (NewBot.Pawn != None)
	{
		log("In SpawnPawn(), - "$NewBot$" Pawn already spawned ");
		return;
	}


	if (StartLocation != vect(0,0,0))
	{
		if (StartRotation != rot(0,0,0))
		{
			NewBot.Pawn = Spawn(NewBot.PawnClass,newBot,,StartLocation,StartRotation);
		}
		else
		{
            NewBot.Pawn = Spawn(NewBot.PawnClass,newBot,,StartLocation, );
		}
	}
	else
	{
		StartSpot = FindPlayerStart(NewBot);
		NewBot.Pawn = Spawn(NewBot.PawnClass,newBot,,StartSpot.Location,StartSpot.Rotation);
	}

	if (NewBot.Pawn == None)
	{
    	log("In SpawnPawn() - Cant spawn the pawn of bot "$NewBot);
		return;
	}
	else
	{
		//for some reason when we spawn a pawn at desired location and not startspot, his
		//physics will be set to none - need to set it to some normal one
		NewBot.Pawn.SetPhysics(Phys_Walking);
	}

    log("In SpawnPawn() - Pawn Spawned. class should match: " $ NewBot.PawnClass $ " and " $ NewBot.Pawn.Class);

	newBot.Pawn.Controller = newBot;

    NewBot.PreviousPawnClass = NewBot.Pawn.Class;

    NewBot.Possess(NewBot.Pawn);
    NewBot.PawnClass = NewBot.Pawn.Class;

	//Notify spawning
	NewBot.myConnection.SendLine("SPW");

	NewBot.GotoState('StartUp', 'DoStop'); //TODO: Really here?
}

function bool AddRemoteBotToTeam(AIController NewBot, int TeamNum)
{
	return true;
}

//This function is called, when somebody on the server dies.
function Killed( Controller Killer, Controller Killed, Pawn KilledPawn, class<DamageType> damageType )
{
	local Controller C;

	Super.Killed(Killer, Killed, KilledPawn, damageType);

	//Send DIE message to killed bot
	if( (Killed != none) && Killed.isA('RemoteBot'))
	{
		RemoteBot(Killed).RemoteDied(Killer, damageType);
    }

	//Send KIL message to other bots
	for(C = Level.ControllerList; C != none; C = C.NextController)
	{
		if( C.isA('RemoteBot') && C != Killed )
		{
			RemoteBot(C).RemoteKilled(Killer, Killed, KilledPawn, damageType);
		}
	}
}

//Called when new human player enters the game
event PlayerController Login( string Portal, string Options, out string Error )
{
	local PlayerController Loging;

	Loging = super.Login( Portal, Options, Error );

	//Add our custom replication info
	return Loging;
}

//Called when somebody (bot/player) leaves game
function Logout(controller Exiting)
{
	RemoteNotifyLogout(Exiting);
	if(!exiting.IsA('RemoteBot'))
	{
		Super.Logout(Exiting);
	}
	else
	{
		//RemoveBotFromList(RemoteBot(Exiting)); //test
		Super(GameInfo).Logout(Exiting);
		NumRemoteBots--;
		NumPlayers--; //we count RemoteBots as players too
	}
}

//Notification about player leaving the server
function RemoteNotifyLogout(Controller Exiting)
{
	local GBClientClass A;
	local string outstring;

	outstring = "LEFT {Id " $ Exiting$Exiting.PlayerReplicationInfo.PlayerID $
		"} {Name " $ Exiting.PlayerReplicationInfo.PlayerName $
		"}";

    //Finding any GBClientClass for sending the message
	A = theBotServer.ChildList;

	if (A == none)
	{
	//Control server not yet implemented
	/*	if (theControlServer != None)
		{
			A = theControlServer.ChildList;
			if (A != none)
				A.GlobalSendLine(outstring,true,true);
		}
		*/
	}
	else
	{
		A.GlobalSendLine(outstring,true,true);
	}
}

//We send a notification to our remote bots, that new player joined the server
function RemoteNotifyLoging( Controller Loging )
{
	local GBClientClass A;
	local string outstring;

	outstring = "JOIN {Id " $ Loging$Loging.PlayerReplicationInfo.PlayerID $
		"} {Name " $ Loging.PlayerReplicationInfo.PlayerName $
		"}";

   	//Finding any GBClientClass for sending the message
	A = theBotServer.ChildList;

	if (A != none)
	   A.GlobalSendLine(outstring,true,true);
}

// PlayerControllerClassName="Runtime.RTPlayerController"
defaultproperties
{
	bPauseable=true
	bAllowControlServer=true
	BroadcastHandlerClass="Engine.BroadcastHandler"
	PlayerControllerClassName="GameBotsUE2.GBPlayer"
	RemoteBotController="GameBotsUE2.RemoteBot"
    HudMutatorClass="GameBotsUE2.GBHudMutator"
	BotServerClass="GameBotsUE2.BotServer"
	ControlServerClass="GameBotsUE2.ControlServer"
	GameName="GameBots DeathMatch"
	GameClass="Scenario"
	Acronym="Scenario"
	MapPrefix=""
	BotServerPort=3000
	ControlServerPort=3001
	HUDType="GameBotsUE2.GBHUD"
}
