/*
Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.
*/

//=============================================================================
// RemoteBot.
// Basedon Bot class
//=============================================================================
class RemoteBot extends AIController
	config(GameBotsUE2);


var config bool bDebug;

//maybe link to bot's periphreal vision? UT bots need much less of an arc though
//like Pawn's PeriphrealVision, this value should be the cosine of the limits
//of visual field. (i.e. 0.707 = 45 degrees to each side, or a 90* arc.)
var config float remoteVisionLimit;

//The socket to the agent
var BotConnection myConnection;


//The three remote vars compliment the my vars right below. The only one
//that ever needs to be duplicated is RemoteEnemy and myTarget
//just need RemoteDestination || myDestination and RFocus || myFocus

//Who the remote bot is trying to shoot at. Used by the aiming code.
var Actor RemoteEnemy;
//Thing the remote bot is trying to move to.
var Actor RemoteDestination;
//Thing the remote bot is looking at.
var Actor myFocus;

//The spot the bot is shooting at
var FocusActorClass myTarget;

//If false, we will update myTarget location according our current focal point
var bool bTargetLocationLocked;

//The spot the bot is moving to
var vector myDestination;
//The spot the bot is looking at
var vector myFocalPoint;

//This is an indicator that we are in StartUp:MoveContinuous state. We need this, so turn
//command work properly when the bot is moving continuous!
var bool movingContinuous;

// time that last sent a WAL message
var float lastWallHitTime;

// time that last sent a BMP message
var float lastBumpTime;

var name BoneName;


var config float DeltaTime;

//var actor HitWall;

//var vector HitNormal;

//var vector HitLocation;

//Used for smooth movement, see StartUp state
var vector pendingDestination;

//If true bot will respawn automatically when killed
var config bool bAutoSpawn;

//When true auto raytracing producing sync. ATR messsages will be on
var config bool bAutoTrace;

//If true we will draw trace lines (results of AutoTrace() functionsin BotConnection)
//in the game
var config bool bDrawTraceLines;

//If we should spawn an actor at the point the bot has set as focal point
var config bool bShowFocalPoint;

//If we should provide aim correct based on bot Skill also when shooting at Location
var config bool bPerfectLocationAim;

//If we should include FadeOut attribute into message text or not. for debug.
var config bool bIncludeFadeOutInMsg;

//maximum number we can multiply BaseSpeed of the bot
var config float MaxSpeed;

//For disabling auto pickup, custom varialbe, will affect Pawn.bCanPickupInventory
var config bool bDisableAutoPickup;

//By this default pawn speed will be multiplied ranges from 0.1 to 2
var config float SpeedMultiplier;

//helper variable to store the direction we want to go with CMOVE
var vector cmoveDirection;

//You need also to enable text to speech in UT2004 settings
var config bool bSpeakingBots;

//this is here, so we can properly debug the bot in java. it is the adress we need
//to connect to in order to debug the bot (in Pogamut the bots are now run each one in
//different JVM)
var string jmx;

//here we store what action is our bot currently doing - this is set by the user
var string currentBDIAction;

//Our custom Replication Info holding information we want to draw on the HUD on
//the client
var GBReplicationInfo repInfo;

//Holds all movers in the level, initialized at the beginning of the communication
var Array<Mover> MoverArray;

replication {
	// Things the server should send to the client.
	reliable if (Role == Role_Authority)
		repInfo;
}

/* UnderLift()
called by mover when it hits a pawn with that mover as its pendingmover while moving to its destination
Not usefull for us, but overriding at least. :-/
*/
function UnderLift(Mover M)
{
//	myConnection.SendLine("UNDLFT {Id " $ M $ "}");
}

//movers are static, we will put all movers to the dynamic array, this
//significantly decrease the time we need to process them all in checkVision() fc
function initMoverArray()
{
	local Mover M;

	foreach AllActors(class'Mover',M)
	{
		MoverArray[MoverArray.Length] = M;
    }
}

//override - using translocator in this function
event NotifyMissedJump()
{
	// SENDMESSAGE
	// !!! possible new message?

}

//Spawns a pickup class on the bot possition - if able the bot will collect the
//item instantly, otherwise it dissapears after 2 seconds
function pickup SpawnInventory( class<pickup> PickupType )
{
	local Pickup Copy;
//	local inventory Inv;

	if (Pawn == None)
		return None;

	Copy = Spawn(PickupType,Pawn,,Pawn.Location,rot(0,0,0));
	Copy.bDropped = true;
	Copy.LifeSpan = 2;

	return Copy;
}

simulated function RemoteDestroyPawn() {

	if ( Pawn != None )
	{
		//SetLocation(Pawn.Location);
		Pawn.RemoteRole = ROLE_SimulatedProxy;
		//Pawn.bHidden = true;
		//Pawn.UnPossessed();
		//Pawn.UnPossessed();
		//Pawn.Destroy();
		Pawn.Died(self, class'DamageType', Pawn.Location);
		Pawn.Destroy();
	}
		/*if (Pawn != None)
			Pawn.Died(self, class'DamageType', Pawn.Location);
		if (Pawn != none)
			Pawn.Destroy();*/
}

//This function is called by the RESPAWN command - it makes sure everything will work ok
function RespawnPlayer(optional vector startLocation, optional rotator startRotation)
{
	if (IsInState('Dead') && !bAutoSpawn) //
	{
		RemoteRestartPlayer(startLocation,startRotation);
	}
	else if (bAutoSpawn)
	{
		bAutoSpawn = false; //otherwise it would get respawned in Dead state without specifyed locatin, rotation
        RemoteDestroyPawn();
		GotoState('Dead');
		RemoteRestartPlayer(startLocation,startRotation);
		bAutoSpawn = true;

	}
	else  if (!IsInState('Dead') && !bAutoSpawn)
	{
        RemoteDestroyPawn();
		GotoState('Dead');
		RemoteRestartPlayer(startLocation,startRotation);

	}
}

//This function handles actual bot respawning - when it dies for instance
function RemoteRestartPlayer(optional vector startLocation, optional rotator startRotation)
{
	if( Level.Game.isA('Scenario'))
	{
		Scenario(Level.Game).RemoteRestartPlayer( self, startLocation, startRotation );
	}

	if (Pawn != None)
	{
		gotostate('StartUp','DoStop');
	}
	else
	{
		log("Pawn is None after ResartPlayer");
	}

}

//Function which determines if our weapon should fire again or stop firing
function bool WeaponFireAgain(float RefireRate, bool bFinishedFire)
{

	if (!RemoteHasAmmo())
	{
		Super.StopFiring();
		return false;
	}

	return true;
}

//Use from local code - stops firing and ticks weapon to let it stop
function HaltFiring()
{
	//Pawn.Weapon.StopFire(Pawn.Weapon.BotMode);
	bFire = 0;
	bAltFire = 0;
	Super.StopFiring();
	//Pawn.Weapon.Tick(0.001);
}


//Overriding function, otherwise code from states in Controller.uc would be executed
function HearNoise (float Loudness,actor Actor )
{

}

//Called when our bot may hear some sound.
event AIHearSound( actor Actor, int Id, sound S, vector SoundLocation, vector Parameters, bool Attenuate ) {

	local float floatDist;
	local string prefix;
	local vector myLocation;

 	if (Pawn == none)
		return;

   	//log("NOISE - parameters "$Parameters);

	floatDist = sqrt(square(Pawn.Location.x - Actor.Location.x) + square(Pawn.Location.y - Actor.Location.y) + square(Pawn.Location.z - Actor.Location.z));


	if( Actor.IsA('Pickup') )
    	prefix = "HRP";
    else
    	prefix = "HRN";

	if (Pawn != none){
		myLocation = Pawn.Location;
	}
	else
	{
		myLocation = Location;
	}


	myConnection.SendLine(prefix $ " {Source " $ myConnection.GetUniqueId(Actor) $
		"} {Type " $ actor.Class $
		"} {Rotation " $ rotator(actor.Location - myLocation) $
		"}");

}

event SoakStop(string Problem)
{
	myConnection.SendLine("SOAKED {Problem " $ Problem $"}");
	log("We are Soaked! Problem: "$Problem);
}

//Zone the bot is standing on has changed
singular event BaseChange()
{
	Super(Pawn).BaseChange();
	// !!! possible SENDMESSAGE
	//myConnection.SendLine("BASETEST" $ib$as$ "Actor" $ib$ HitActor $ae$ib$as$"Location" $ib$ HitLocation $ae);
}


//Called right before bot falls off something
//If bot running, set bCanJump to true - let him fall
//if walking, won't fall
event MayFall()
{
	local bool bFall;

	bFall = !Pawn.bIsWalking;

	if(!bfall)
	{
		GotoState('Startup', 'Begin');
	}

	myConnection.SendLine("FAL {Fell " $ bFall $
		"} {Location " $ Pawn.Location $
		"}");

	Pawn.bCanJump = bFall;
}

//Called when the bot land on the ground after falling
function bool NotifyLanded(vector HitNormal)
{
	myConnection.SendLine("LAND {HitNormal " $ HitNormal $ "}");

	//restart, so we continue moving and not going back to our previous
	//destination, as we may be over it because of the fall
	if (movingContinuous)
		gotoState('StartUp','MoveContRepeat');
}

//TODO: This function returns wrong numbers - reimplement?
function float GetSpeed()
{
	if(Pawn.bIsWalking)
	{
		return Pawn.WalkingPct;
	}
	else
	{
		return 1.0;
	}
}

//Called each time we have picked up something - ammo, weapon, health etc.
function HandlePickup(Pickup Pickup)
{
	local string InventoryId;

	InventoryId = string(Pawn.FindInventoryType(Pickup.InventoryType));

	myConnection.SendLine("IPK {Id " $ myConnection.GetUniqueId(Pickup) $
		"} {InventoryId " $ InventoryId $
		"} {Location " $ Pickup.Location $
		"} {Amount " $ myConnection.GetItemAmount(Pickup) $
		"} {Dropped " $ Pickup.bDropped $
		"} {Type " $ Pickup.Class $
		"}");
}

// Called when get new weapon or ammunition for weapon we do not have yet.
// Called just once per weapon type or per new ammunition type (notify new object in our inventory, NOT pickup)
// For exporting weapons we have new attributes.
function NotifyAddInventory( Inventory inputInventory )
{
	local string outstring;

	//For weapons
	local Weapon inputWeapon;
	local bool bUseAlternateAmmo;

	Super.NotifyAddInventory(inputInventory);

    outstring = "AIN {Id " $ myConnection.GetUniqueId(inputInventory) $
		"} {Type " $ inputInventory.class $
		"} {PickupType " $ inputInventory.PickupClass $
		"}";

	myConnection.SendLine(outstring);
}

function SetHealth(int amount)
{
	if (Pawn == none)
		return;
	if ((amount > 0) && (amount < 200))
		Pawn.Health = amount;
}

function BotVoiceMessage(name messagetype, byte MessageID, Controller Sender);

// !!! need functions to send arbitrary string messages

function SendVoiceMessage(PlayerReplicationInfo Sender, PlayerReplicationInfo Recipient, name messageType, byte messageID, name broadcastType)
{
	super.SendVoiceMessage( Sender, Recipient, messageType, messageID, broadcastType );
}

//functions to send tokenized messages
/*
function SendTeamMessage(PlayerReplicationInfo Recipient, name MessageType, byte MessageID, float Wait)
{
	//log(self@"Send message"@MessageType@MessageID@"at"@Level.TimeSeconds);
	if ( (MessageType == OldMessageType) && (MessageID == OldMessageID)
		&& (Level.TimeSeconds - OldMessageTime < Wait) )
		return;

	//log("Passed filter");
	OldMessageID = MessageID;
	OldMessageType = MessageType;

	SendVoiceMessage(PlayerReplicationInfo, Recipient, MessageType, MessageID, 'TEAM');
}*/
/*
function SendGlobalMessage(PlayerReplicationInfo Recipient, name MessageType, byte MessageID, float Wait)
{
	//log(self@"Send message"@MessageType@MessageID@"at"@Level.TimeSeconds);
	if ( (MessageType == OldMessageType) && (MessageID == OldMessageID)
		&& (Level.TimeSeconds - OldMessageTime < Wait) )
		return;

	//log("Passed filter");
	OldMessageID = MessageID;
	OldMessageType = MessageType;

	SendVoiceMessage(PlayerReplicationInfo, Recipient, MessageType, MessageID, 'GLOBAL');
}*/


//handles sending messages to all and to team
function RemoteBroadcast( string Id, coerce string Msg, bool bGlobal, float FadeOut )
{

	local Controller C;
	local string MsgForVoice;

	MsgForVoice = Msg;
	if (bIncludeFadeOutInMsg)
		Msg = Msg $ " FadeOut=" $ FadeOut $ " s.";

    //Set the text bubble, which will be shown on the HUDs of Human players
    //when they see the bot
    repInfo.SetTextBubble(Msg, FadeOut);

	if (Id != "")
	{
		for (C = Level.ControllerList; C != none; C=C.NextController)
		{
			if ( (C $ C.PlayerReplicationInfo.PlayerId) == Id)
			{
				if (C.IsA('RemoteBot') && (C != self))
					RemoteBot(C).RemoteNotifyTeamMessage(self,"Private:"$Msg);
				//TODO: What if the reciever is a player?
       			return;
			}
		}

		//If we haven't found Id or Id doesn't belong to RemoteBot we will end
		return;
	}

	if ( bGlobal || !Level.Game.bTeamGame )
	{
	    //Send the message to the game channel - will also send it to remote bots
	    Level.Game.Broadcast(self, Msg, 'Say');
	    return;
	}

	if (Level.Game.bTeamGame)
	{
		//Send the message to team channel - will also send it to remote bots
		Level.Game.BroadcastTeam(self, Msg, 'TeamSay');
		return;
	}
}

//Event for receiving string messages, called manually
event RemoteNotifyClientMessage( Controller C, coerce string S )
{
	//Could cause some parsing problems, so replacing
	//S = Repl(S, "{", "_", false );
	//S = Repl(S, "}", "_", false );

	myConnection.SendLine("VMS {Id "$ myConnection.GetUniqueId(C) $
		"} {Name " $ C.PlayerReplicationInfo.PlayerName $
		"} {Text " $ S $"}");
}

//Event for receiving string messages, called manually
event RemoteNotifyTeamMessage( Controller C, coerce string S )
{
	//Could cause some parsing problems, so replacing
	//S = Repl(S, "{", "_", false );
	//S = Repl(S, "}", "_", false );

	myConnection.SendLine("VMT {Id "$ myConnection.GetUniqueId(C) $
		"} {Name " $ C.PlayerReplicationInfo.PlayerName $
		"} {Text " $ S $"}");
}

//other code may try to call this. make sure nada happens
//!!! need to change - make sure orders are actually recorded somewhere
//             for reference
function SetOrders(name NewOrders, Controller OrderGiver);

//The bot (or some part of the bot - legs) entered new volume
event bool NotifyPhysicsVolumeChange( PhysicsVolume NewVolume )
{

	//this code is taken from super class (Bot). Had to disable automatic jumping out of water
	//super class is not called anymore
	if ( newVolume.bWaterVolume )
	{
		if (!Pawn.bCanSwim)
			MoveTimer = -1.0;
		else if (Pawn.Physics != PHYS_Swimming)
			Pawn.setPhysics(PHYS_Swimming);
	}
	else if (Pawn.Physics == PHYS_Swimming)
	{
		if ( Pawn.bCanFly )
			 Pawn.SetPhysics(PHYS_Flying);
		else
		{
			Pawn.SetPhysics(PHYS_Falling);
			/*if ( Pawn.bCanWalk && (Abs(Pawn.Acceleration.X) + Abs(Pawn.Acceleration.Y) > 0)
				&& (Destination.Z >= Pawn.Location.Z)
				&& Pawn.CheckWaterJump(jumpDir) )
			{
				Pawn.JumpOutOfWater(jumpDir);
				bNotifyApex = true;
				bPendingDoubleJump = true;
			}*/
		}
	}

	myConnection.SendLine("VCH {Id " $ myConnection.GetUniqueId(NewVolume) $
		"} {ZoneVelocity " $ NewVolume.ZoneVelocity $  //vector
		"} {ZoneGravity " $ NewVolume.Gravity $  //vector
		"} {GroundFriction " $ NewVolume.GroundFriction $  //float
		"} {FluidFriction " $ NewVolume.FluidFriction $  //float
		"} {TerminalVelocity " $ NewVolume.TerminalVelocity $  //float
		"} {WaterVolume " $ NewVolume.bWaterVolume $
		"} {PainCausing " $ NewVolume.bPainCausing $
		"} {Destructive " $ NewVolume.bDestructive $
		"} {DamagePerSec " $ NewVolume.DamagePerSec $ //float
		"} {DamageType " $ NewVolume.DamageType $
		"} {NoInventory " $ NewVolume.bNoInventory $
		"} {MoveProjectiles " $ NewVolume.bMoveProjectiles $
		"} {NeutralZone " $ NewVolume.bNeutralZone $
		"}");

	return false;

}

//The bot entered a new zone
function ZoneChange(ZoneInfo newZone)
{
	Super.ZoneChange(newZone);
	if (myConnection == none)
		return;
	myConnection.SendLine("ZCB {Id " $ myConnection.GetUniqueId(NewZone) $ "}");
}

//Not used yet - should we use this somewhere?
function GetPhysicsVolume()
{
	local PhysicsVolume V, winner;

	winner = none;

	ForEach TouchingActors(class'PhysicsVolume',V)
	{
		if (winner == none)
			winner = V;
		else
		{
			if (winner.Priority < V.Priority )
			{
				winner = V;
			}
		}
	}

	if (winner != none)
		NotifyPhysicsVolumeChange( winner );
	else
		myConnection.SendLine("VCH {Id None}");

}

//Called when weapon is switched - may happen automatically
function ChangedWeapon()
{
//	local int usealt;

	if ( (Pawn.Weapon != none) && (Pawn.Weapon == Pawn.PendingWeapon) )
	{
		SwitchToBestWeapon();
		if ( Pawn.Weapon.GetStateName() == 'DownWeapon' )
			Pawn.Weapon.GotoState('Idle');
		Pawn.PendingWeapon = None;
	}
	else
		super.ChangedWeapon();

	if ( Pawn.Weapon != None )
	{
		if (bFire > 0)
		{
 			bAltFire = 0;
			bFire = 1;
			Pawn.Weapon.Fire(1.0);
		}
 		else if (bAltFire > 0)
 		{
			bAltFire = 0;
			bFire = 1;
			Pawn.Weapon.AltFire(1.0);
		}
		Pawn.Weapon.SetHand(0);

	}
	// !!! use or just make people get from status update
	myConnection.SendLine("CWP {Id " $ myConnection.GetUniqueId(Pawn.Weapon) $
				"} {Type " $ Pawn.Weapon.Class $"}");
}

event Touch( Actor Other )
{
	//TODO: Add a check if actor is a player or bot
	myConnection.SendLine("TCH {Id " $ myConnection.GetUniqueId(Other) $
							"} {Location " $ Other.Location $
							"} {Rotation " $ Other.Rotation $"}");
}

// called from pathnodes that unitelligent creatures are supposed to avoid
function FearThisSpot(AvoidMarker aSpot);

//called on hitting a wall
event bool NotifyHitWall( vector HitNormal, actor HitWall )
{
	if ( Level.TimeSeconds - 0.5 >= lastWallHitTime )
	{
		myConnection.SendLine("WAL {Id " $ myConnection.GetUniqueId(HitWall) $
			"} {Normal " $ HitNormal $
			"} {Location " $ Pawn.Location $"}");

		lastWallHitTime = Level.TimeSeconds;
	}

	return true;
}


//called on collisions with other actors
event bool NotifyBump(actor Other)
{
	local vector VelDir, OtherDir;
	local float speed;

	if ( TimerRate <= 0 )
		setTimer(1.0, false);

	speed = VSize(Velocity);
	if ( speed > 10 )
	{
		VelDir = Velocity/speed;
		VelDir.Z = 0;
		OtherDir = Other.Location - Location;
		OtherDir.Z = 0;
		OtherDir = Normal(OtherDir);
		if ( (VelDir Dot OtherDir) > 0.8 )
		{
			Velocity.X = VelDir.Y;
			Velocity.Y = -1 * VelDir.X;
			Velocity *= FMax(speed, 280);
		}
	}

	if ( Level.TimeSeconds - 0.5 >= lastBumpTime )
	{

		myConnection.SendLine("BMP {Id " $ myConnection.GetUniqueId(Other) $
			"} {Location " $ Other.Location $"}");

		lastBumpTime = Level.TimeSeconds;
	}

	// Need to disable bumping ???
	//Disable('Bump');
	//TODO: Experiment with this?
	return false;
}

//called periodicaly for each player in view
function SeePlayer(Pawn SeenPlayer)
{
/* Temporary suspended - for now
	local Controller C;
	local string TeamIndex, OutString, WeaponClass;

	if (SeenPlayer == none)
		return;

   	C = SeenPlayer.Controller;

	if(Level.Game.isA('BotTeamGame'))
	{
		TeamIndex = string(C.PlayerReplicationInfo.Team.TeamIndex);
	}
	else
	{
		TeamIndex = "255";
	}
	if (C.Pawn.Weapon != none)
	{
		WeaponClass = string(C.Pawn.Weapon.Class);
	}
	else
	{
		WeaponClass = "None";
	}
	outstring = "PLR {Id " $ myConnection.GetUniqueId(C) $
		"} {Rotation " $ C.Pawn.Rotation $
		"} {Location " $ C.Pawn.Location $
		"} {Velocity " $ C.Pawn.Velocity $
		"} {Name " $ C.PlayerReplicationInfo.PlayerName $
		"} {Team " $ TeamIndex $
		"} {Reachable " $ actorReachable(C.Pawn) $
		"} {Weapon " $ WeaponClass $
		"}";

	if((C.Pawn.Weapon != none) && C.Pawn.Weapon.GetFireMode(0).IsFiring() )
		outstring = outstring $" {Firing 1}";
	else if((C.Pawn.Weapon != none) && C.Pawn.Weapon.GetFireMode(1).IsFiring() )
		outstring = outstring $" {Firing 2}";
	else
		outstring = outstring $" {Firing 0}";

	myConnection.sendLine(outstring);
*/
}

//picks up an item if we are touching it
function RemotePickup(string target)
{
	local Pickup P;

	log("My target "$ target);

	if ((target != "") && (Pawn != none))
		foreach Pawn.TouchingActors(class'Pickup', P) {
			log("First touching: " $ P $ " and his id: " $ myConnection.getUniqueId(P));
			if (target == myConnection.getUniqueId(P))
			{

				//TODO: This can cause problems, if our bot will be touching mutliple items
				//he may pick them up all.
				Pawn.bCanPickupInventory = true;
				P.Touch(Pawn);
				Pawn.bCanPickupInventory = false;
			    //log("We've got it");
				break;
			}
		}
}

/* Added func RemoteKilled - should make things cleaner, called from GameTypeGame server
	25.10.2006 Michal Bida
*/
function RemoteKilled(Controller Killer, Controller Killed, Pawn KilledPawn, class<DamageType> damageType)
{
	local string outstring;

	outstring = "KIL {Id " $ myConnection.GetUniqueId(Killed) $
		"} {KilledPawn " $ KilledPawn $
        "} {Killer " $ myConnection.GetUniqueId(Killer) $
		"}";
	if (CanSee(KilledPawn))
	{
		outstring = outstring $ " {DamageType " $ damageType $
		"}";
	}

	myConnection.sendLine(outstring);
}

/* Added func RemoteDied - should make things cleaner, called from GameTypeGame server
	25.10.2006 Michal Bida
*/
function RemoteDied(Controller Killer, class<DamageType> damageType)
{
	myConnection.SendLine("DIE {Killer " $ myConnection.GetUniqueId(Killer) $
		"} {DamageType " $ damageType $
		"}");
}


//Jumps a bot
function RemoteJump(bool bDouble)
{

	if (Pawn == none)
		return;

	if (Pawn.Physics != PHYS_Falling)  //TODO: Check all bad physics
	{
		Pawn.DoJump(true);

		if (bDouble)
		{
			//Pawn.Velocity = EAdjustJump(xPawn(Pawn).JumpZ + xPawn(Pawn).MultiJumpBoost,0);
			//Pawn.Velocity.z += xPawn(Pawn).JumpZ;// + xPawn(Pawn).MultiJumpBoost;
			//EAdjustJump(0,Pawn.GroundSpeed);
			//EAdjustJump(Pawn.Velocity.Z,Pawn.GroundSpeed);
			//Pawn.DoDoubleJump(true);
		}
	}
}

//Intercept FireWeapon - is called from other code
function FireWeapon();

function bool RemoteHasAmmo()
{
	if ( (Pawn == none) || (Pawn.Weapon == none) )
		return false;

	return false;
}

function RemoteFireWeapon(bool bUseAltMode)
{

	if ((Pawn == none) || (Pawn.Weapon == none))
		return;



}

// check for line of sight to target deltatime from now.
//used by missle launcher and others to abort firing
// may want to reimplement
function bool CheckFutureSight(float deltatime)
{
	return true;
}

// Projectiles are handled elsewhere
// This function is not just for projectiles, is called also from other code

/* Receive warning now only for instant hit shots and vehicle run-over warnings */

event ReceiveWarning(Pawn shooter, float projSpeed, vector FireDir)
{
	log("We ve been in ReceiveWarning");
	//TODO: New special projectiles message?

}


//Called when someone other than this bot dies.
//TODO: We dont need this
function Killed(pawn Killer, pawn Other, name damageType);

//Pointless callback
function EnemyAcquired();

//All kinds of things can call this mostly special trigger points
function Trigger( actor Other, pawn EventInstigator )
{
	myConnection.SendLine("TRG {Actor " $ myConnection.GetUniqueId(Other) $
		"} {EventInstigator " $ myConnection.GetUniqueId(EventInstigator) $
		"}");
}


//Don't handle impact jumps or low gravity manuevers for bots
function ImpactJump();

//Called when bot is injured
function NotifyTakeHit
(
	pawn InstigatedBy,
	vector HitLocation,
	int Damage,
	class<DamageType> damageType,
	vector Momentum
)
{
	local float enemyDist;
	local vector enemyDir, X, Y, Z;
	local string messageString;

	Super.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);

	messageString = "DAM {Damage " $ Damage $
		"} {DamageType " $ damageType $
		"}";

	//TODO: !!! need to fix this and projectile detection to match our
	//periphreal vision parameter.
	// only if tight FOV
	GetAxes(Rotation,X,Y,Z);
	enemyDist = VSize(instigatedBy.Location - Location);
	enemyDir = (instigatedBy.Location - Location)/enemyDist;

	if ((enemyDir Dot X) > 0.8)
		messageString = messageString $" {Instigator " $ myConnection.GetUniqueId(instigatedBy) $"}";

	myConnection.SendLine(messageString);

	//Here we notifyies RemoteBot about they made a hit.
	if( InstigatedBy != none && InstigatedBy.Controller != none && InstigatedBy.Controller.isA('RemoteBot'))
	{
	    RemoteBot(InstigatedBy.Controller).RemoteNotifyHit(self, Damage, DamageType );
    }
}

function RemoteNotifyHit(Controller Victim, int Damage, class<DamageType> damageType)
{
	myConnection.sendLine("HIT {Id " $ myConnection.GetUniqueId(Victim) $
		"} {Damage " $ Damage $
        "} {DamageType " $ DamageType $
		"}");
}


function SetFall()
{
	if (Pawn.bCanFly)
	{
		Pawn.SetPhysics(PHYS_Flying);
		return;
	}
	if (bDebug)
		log("In RemoteBot.uc: SetFall() enganged.");
	/*
	if ( Pawn.bNoJumpAdjust )
	{
		Pawn.bNoJumpAdjust = false;
		return;
	}
	else
	{
		bPlannedJump = true;
		Pawn.Velocity = EAdjustJump(Pawn.Velocity.Z,Pawn.GroundSpeed);
		Pawn.Acceleration = vect(0,0,0);
	} */
}


//**********************************************************************************
//Base RemoteBot AI, that controls the Pawn (makes him move)

auto state StartUp
{
	function BeginState()
	{
		//log("StartUp,BeginState");
		//TODO:HACK: Should examine Squad issues if it should be here
        movingContinuous = false;

        if (Pawn != none)
	        Pawn.SetPhysics(PHYS_Walking);
	}
Begin:
	movingContinuous = false;
    //This is necessary, because if someone keeps shooting on our bot,
	//sometimes it starts sliding to side
	//log("Physics "$Physics$"Pawn Physics "$Pawn.Physics);
	if (Pawn != none)
	{
		if (Pawn.Physics != PHYS_Falling)
		{
			Pawn.Velocity = vect(0,0,0);
			Pawn.Acceleration = vect(0,0,0);
			MoveTimer = -1.0; //TODO: Should check what the hell is this
		}
	}
 	sleep(0.5);
	goto 'Begin';
DoStop:
	movingContinuous = false;
	if (Pawn != none)
	{
		if (Pawn.Physics == PHYS_Falling) //TODO: This is just a test, but it should repair one issue.
		{
			WaitForLanding(); //We wait when we are on ground and THEN we will stop.
			Pawn.Velocity = vect(0,0,0);
			Pawn.Acceleration = vect(0,0,0);
			MoveTimer = -1.0;
		}
		else
		{
			Pawn.Velocity = vect(0,0,0);
			Pawn.Acceleration = vect(0,0,0);
			MoveTimer = -1.0; //TODO: Should check what the hell is this
		}
	}
	//Pawn.PlayWaiting();
	goto 'Begin';
MoveToActor:
	movingContinuous = false;
	if (Pawn != None)
	{
		MoveToward(MoveTarget, , , , Pawn.bIsWalking);
		//There is an issue when the bot finish its movement, sometimes he goes a bit
		//over the target point, this caused turning back, because moveTo functions sets focalpoint
		//after it ends to its target point, to prevent this, we will set our own FocalPoint counted in advance
		FocalPoint = myFocalPoint;
	}
	goto 'Begin';
Move: //Moves swiftly between two locations - could be a problem normaly because of TCP/IP delays
	movingContinuous = false;
	if (Pawn != None)
	{
		if (Focus == none)
		{
			MoveTo( myDestination, , Pawn.bIsWalking );
			MoveTo( pendingDestination, , Pawn.bIsWalking);
		}
		else
		{
			MoveTo( myDestination, Focus, Pawn.bIsWalking );
			MoveTo( pendingDestination, Focus, Pawn.bIsWalking);
		}
		//There is an issue when the bot finish its movement, sometimes he goes a bit
		//over the target point, this caused turning back, because moveTo functions sets focalpoint
		//after it ends to its target point, to prevent this, we will set our own FocalPoint counted in advance
		FocalPoint = myFocalPoint;
	}
	goto 'Begin';
MoveContinuous:
	if (Pawn != None)
	{
		//to prevent that our focal point moves too much above or below us
		//remember we want to move
		myFocalPoint.z = Pawn.Location.z;
	 	cmoveDirection = vector(rotator(myFocalPoint - Pawn.Location));
	}
MoveContRepeat:
	if (Pawn != None)
	{
		movingContinuous = true;
		MoveTo( Pawn.Location + 500 * cmoveDirection, , Pawn.bIsWalking );

		myFocalPoint = Pawn.Location + 500 * cmoveDirection;
		FocalPoint = myFocalPoint;
		goto 'MoveContRepeat';
	}
	goto 'Begin';
}


state GameEnded
{
ignores SeePlayer, EnemyNotVisible, HearNoise, TakeDamage, Bump, Trigger, HitWall, ZoneChange, Falling, ReceiveWarning;

	function SpecialFire()
	{
	}
	function bool TryToDuck(vector duckDir, bool bReversed)
	{
		return false;
	}
	function SetFall()
	{
	}
	function LongFall()
	{
	}
	function Killed(pawn Killer, pawn Other, name damageType)
	{
	}
	function ClientDying(class<DamageType> DamageType, vector HitLocation)
	{
	}

	function BeginState()
	{
		Pawn.SimAnim.AnimRate = 0.0;
		bFire = 0;
		bAltFire = 0;

		SetCollision(false,false,false);
		SetPhysics(PHYS_None);
		Velocity = vect(0,0,0);
		myConnection.SendLine("FIN");
	}
}

state Dead
{
ignores SeePlayer, HearNoise, KilledBy;

function BeginState()
{
	log("State: Dead, BeginState()");

	//We can be sent to this state sometimes, when it is not desired ( by game mechanics)
	//Escaping here
	if (Pawn != none)
		gotostate('StartUp','Begin');

	//This is taken from working AI in UT2004, probably needed to assure bot
	//will behave normally after restart - 02/03/07 Michal Bida
	movingContinuous = false;
	Enemy = None;
	Focus = None;
	Target = None;
	RouteGoal = None;
	MoveTarget = None;
	bFire = 0;
	bAltFire = 0;
	Super.StopFiring(); //Not needed anymore to call super, but for sure.


}
/*
function EndState()
{
	myConnection.sendLine("SPW2");
}*/
Begin:
	//log("In Dead:Begin:");
	//AutoSpawn policy
	if (Pawn != None)
		gotostate('StartUp','Begin');

	if (bAutoSpawn)// && !Level.Game.bWaitingToStartMatch)
	{
		RemoteRestartPlayer();
	//	if (Pawn == none) //bug during restart?
	//		goto('Begin');
		//ServerRestartPlayer(); //Dunno if this is needed here - Could it cause troubles?
	}

	if (Pawn != None)
		gotostate('StartUp','Begin');
/*	if (!Level.Game.bWaitingToStartMatch)
	{
		RemoteRestartPlayer();
	}
	if (Pawn != None)
		gotostate('StartUp','Begin');*/
	sleep(1.0);
	goto('Begin');

}



//-------------RemoteBot Specific Functions--------------------

// True if location loc is in bot's field of view. Does not take into account occlusion by geometry!
// Possible optimization: Precompute cos(obsController.FovAngle / 2) for InFOV - careful if it can change.
function bool InFOV(vector loc) {
	local vector view;   // vector pointing in the direction obsController is looking.
	local vector target; // vector from obsController's position to the target location.

	view = vector(GetViewRotation());

	if (Pawn != none) {
		target = loc - (Pawn.Location + Pawn.EyePosition());
	} else {
		target = loc - Location;
	}

	return Acos(Normal(view) dot Normal(target)) * 57.2957795 < FovAngle / 2; // Angle between view and target is less than FOV
	// 57.2957795 = 180/pi = 1 radian in degrees  --  convert from radians to degrees
}

function checkSelf()
{
	local string outstring, TeamIndex, altFiring, pawnWeapon;
	local rotator PawnRotation;
	local bool bIsShooting;

	local vector FloorLocation, FloorNormal;

	//TODO Teams?
    TeamIndex = "255";

	if( Pawn != none )
	{

		PawnRotation = Pawn.Rotation;
		//PawnRotation.Pitch = int(Pawn.ViewPitch) * 65556/255;
		if (Pawn.Weapon != none) {
			pawnWeapon = string(Pawn.Weapon);
		} else {
			pawnWeapon = "None";
		}

		FloorNormal = vect(0,0,0);
		Trace(FloorLocation,FloorNormal,Pawn.Location + vect(0,0,-1000),Pawn.Location, false, ,);

		outstring = "SLF {Id " $ myConnection.GetUniqueId(self) $
			"} {Vehicle False" $
			"} {Rotation " $ PawnRotation $
			"} {Location " $ Pawn.Location $
			"} {Velocity " $ Pawn.Velocity $
			"} {Name " $ PlayerReplicationInfo.PlayerName $
			"} {Team " $ TeamIndex $
			"} {Health " $ Pawn.Health $
			"} {Weapon " $ pawnWeapon $
			//"} {Shooting " $ bIsShooting $
			//"} {Armor " $ int(Pawn.ShieldStrength) $
			//"} {SmallArmor " $ int(xPawn(Pawn).SmallShieldStrength) $
			//"} {Adrenaline " $ int(Adrenaline) $
			"} {Crouched " $ Pawn.bIsCrouched $
			"} {Walking " $ Pawn.bIsWalking $
			"} {FloorLocation " $ FloorLocation $
			"} {FloorNormal " $ FloorNormal $
			//"} {Combo " $ xPawn(Pawn).CurrentCombo $
			//"} {UDamageTime " $ xPawn(Pawn).UDamageTime $
			"}";

 		if (currentBDIAction != "")
			outstring = outstring $ " {Action " $ currentBDIAction $"}";
		else
			outstring = outstring $ " {Action None}";

        //log("Debug: bFire "$bFire$" bAltFire "$bAltFire);

		myConnection.sendLine(outstring);
	}
	else
	{
		log("Pawn is none in CheckSelf() ");
	}


}

function checkVision()
{
	local Pickup Pickup; //Respawned Inventory on the map is now Pickup;
	local Mover M;
	local Controller C;
	local NavigationPoint N;
//	local vector HitL, HitN;
	local int temp;
	local string outstring, TeamIndex, WeaponClass;
	local bool flagVisible;
	local Projectile Proj;
	local vector FireDir;
	local float projDistance;

	local int i;


	if( Pawn == none )
	{
		log("In CheckVision() - Pawn is none ");
		return;
	}

	//!!! view rotation sometimes falls out of synch with rotation? wtf?

	for ( C=Level.ControllerList; C!=None; C=C.NextController )
	{
		if( C != self && C.Pawn != none && CanSee(C.Pawn))//to match peripheral vision
		{

			if(Level.Game.isA('BotTeamGame'))
			{
				TeamIndex = string(C.PlayerReplicationInfo.Team.TeamIndex);
			}
			else
			{
    			TeamIndex = "255";
			}
			if (C.Pawn.Weapon != none)
			{
				WeaponClass = string(C.Pawn.Weapon.Class);
			}
			else
			{
				WeaponClass = "None";
			}
			outstring = "PLR {Id " $ myConnection.GetUniqueId(C) $
				"} {Rotation " $ C.Pawn.Rotation $
				"} {Location " $ C.Pawn.Location $
				"} {Velocity " $ C.Pawn.Velocity $
				"} {Name " $ C.PlayerReplicationInfo.PlayerName $
				"} {Team " $ TeamIndex $
				"} {Reachable " $ actorReachable(C.Pawn) $
				"} {Weapon " $ WeaponClass $
				"}";

			if (C.IsA('RemoteBot') && (RemoteBot(C).currentBDIAction != ""))
				outstring = outstring $ " {Action " $ RemoteBot(C).currentBDIAction $"}";
			else
				outstring = outstring $ " {Action None}";

			myConnection.sendLine(outstring);

        }//end if
	}//end for P=Level.ControllerList

	foreach DynamicActors(class'Pickup',Pickup)
	{
		if( (Pickup.GetStateName() == 'Pickup') && !Pickup.bHidden && inFOV(Pickup.Location) && LineOfSightTo(Pickup) )
		{
			myConnection.SendLine("INV {Id " $ myConnection.GetUniqueId(Pickup) $
				"} {Location " $ Pickup.Location $
				"} {Amount " $ myConnection.GetItemAmount(Pickup) $
				"} {Reachable " $ actorReachable(Pickup) $
				"} {Visible True" $ //for compatibility reasons, we know its true due to the check up in if statement
				"} {Dropped " $ Pickup.bDropped $
				"} {Type " $ Pickup.Class $
				"}");

		}
	}

	foreach DynamicActors(class'Projectile',Proj)
	{
		if (Proj.IsA('FlakChunk'))
			FireDir = Normal(Proj.Velocity);
		else
			FireDir = vector(Proj.Rotation);

		if (inFOV(Proj.Location) && LineOfSightTo(Proj))
		{
			projDistance = VSize(Pawn.Location - Proj.Location);

			myConnection.SendLine("PRJ {Id " $ myConnection.GetUniqueId(Proj) $
				"} {Time " $ (projDistance/Proj.Speed) $
				"} {Direction " $ FireDir $
				"} {Speed " $ Proj.Speed $
				"} {Velocity " $ Proj.Velocity $
				"} {Location " $ Proj.Location $
				"} {Origin " $ Proj.Instigator.Location $
				"} {DamageRadius " $ Proj.DamageRadius $
				"} {Type " $ Proj.Class $
				"}");
		}

	}//end PRJ

	for (i = 0; i < MoverArray.Length; i++)
	{
		M = MoverArray[i];
		if( (!M.bHidden && inFOV(M.Location) && LineOfSightTo(M)) ||
			( ( Abs(Pawn.Location.x - M.Location.x) < 100 ) && ( Abs(Pawn.Location.y - M.Location.y) < 100 ) &&
			 ( Abs(Pawn.Location.Z - M.Location.Z) < 250 )) )//&& Pawn.FastTrace(M.Location) )
		{

			outstring = "MOV {Id " $ M $
				"} {Location " $ M.Location $
				"} {Reachable " $ actorReachable(M) $ //not sure if this works for lifts(bots may be forced to wait for lift)
				"} {Visible True" $ //for compatibility reasons, we know its true due to the check up in if statement
				"} {DamageTrig " $ M.bDamageTriggered $
				"} {Type " $ M.Class $
				"} {IsMoving " $ M.bInterpolating $
				"} {Velocity " $ M.Velocity $
				"} {MoveTime " $ M.MoveTime $
				"} {OpenTime " $ M.StayOpenTime $
				"} {State " $ M.GetStateName() $
				"}";

			myConnection.SendLine(outstring);
		}
	}

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		//Added attribute Visible, so inFront is not here anymore
		if( LineOfSightTo(N) )//FastTrace(N.Location) )
		{

			outstring = "NAV {Id " $ N $
				"} {Location " $ N.Location $
				"} {Visible " $ inFOV( N.Location ) $
				"} {Reachable " $ actorReachable(N) $
				"}";

			if (N.IsA('InventorySpot')) {
				outstring = outstring $ " {ItemSpawned " $ InventorySpot(N).markedItem.IsInState('Pickup') $ "}";
			}
			if (N.IsA('Door')) {
				outstring = outstring $ " {DoorOpened " $ Door(N).bDoorOpen $ "}";
			}

			/*	Location returned to all NavPoints for now
			if (N.IsA('LiftCenter'))
   				{
   					outstring = outstring $ " {Location "$ N.Location $"}";
   				}*/
			myConnection.SendLine(outstring);

		}
	}//end for N=Level.NavigationPointList

}


simulated event Destroyed()
{
	//Destroying bot Pawn
    RemoteDestroyPawn();

    if (repInfo != none) {
		repInfo.Destroy();
	}

	//Destroying actor for aiming our shooting on location
    if (myTarget != none)
    {
		myTarget.Destroy();
	}

	if (myConnection != none)
		myConnection.SendLine("FIN");
	else
		log("Problem with sending FIN, myConnection = none");

    Super.Destroyed();
    /*

	*/
}

simulated function Tick(float DeltaTime)
{
	super.Tick(DeltaTime);
	//log("In RemoteBot: Tick()");
}

//-----------------

defaultproperties
{
	remoteVisionLimit=0.707000
	SpeedMultiplier=1.0
	bDrawTraceLines=true
	bIncludeFadeOutInMsg=false
	bShowFocalPoint=false
	bPerfectLocationAim=false
	bSpeakingBots=false
	bAutoTrace=false
	bAutoSpawn=true
	bIsPlayer=true //so player replication info is spawned
	MaxSpeed=2.00000
}
