/*
Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.
*/

class GBReplicationInfo extends ReplicationInfo;

//pointer to native replication info (holds player name, etc.)
var PlayerReplicationInfo MyPRI;

//actual bot location
var vector myLocation;

//actual bot velocity
var vector myVelocity;

//actual bot focus point
var vector myFocus;

//actual bot rotation
var rotator myRotation;

//pointer to our current pawn - none if dead
var Pawn myPawn;

//if bot focus is an actor, here will be the name of this actor
var string myFocusName;

//bot actual health
var int myHealth;

//last command received by GB
var string myLastGBCommand;

//holds text bubble text drawn above bots head
var string myTextBubble;

//how long is the text bubble displayed
var int currentTextBubbleCounter;

//if this counter will be reached, we will erase text bubble
var float maxTextBubbleCounter;

//A set of locations we will draw lines between
//should be used for visualizing of bot actual path
var vector CustomRoute[16];

//how often we will update info on the client in seconds
const updateFrequency = 0.05;

replication
{
	reliable if (ROLE == ROLE_Authority)
		MyPRI, myFocus, myFocusName, myPawn, myLocation, myRotation,
		myVelocity, myHealth, myLastGBCommand, myTextBubble, CustomRoute;
}

event PostBeginPlay()
{
	if ( Role < ROLE_Authority )
		return;

	Timer();
	SetTimer(0.05, true);
}

simulated function vector GetVelocity()
{
	return myVelocity;
}

simulated function rotator GetRotation()
{
	return myRotation;
}

simulated function vector GetLocation()
{
	return myLocation;
}

simulated function int GetHealth()
{
	return myHealth;
}

simulated function Pawn GetPawn()
{
	return myPawn;
}

simulated function vector GetFocus()
{
	return myFocus;
}

simulated function string GetFocusName()
{
	return myFocusName;
}

//time in seconds
function SetTextBubble(string text, float time)
{
	currentTextBubbleCounter = 0;
	maxTextBubbleCounter = time / updateFrequency;
	myTextBubble = text;
}

simulated function string GetTextBubble()
{
	return myTextBubble;
}

function SetLastGBCommand(string command)
{
	myLastGBCommand = command;
}

simulated function string GetLastGBCommand()
{
	return myLastGBCommand;
}

//sets one member of CustomRoute array
function SetCustomRoute(vector v, int i)
{
	CustomRoute[i] = v;
}

simulated function vector GetCustomRoute(int i)
{
	return CustomRoute[i];
}

function UpdateInformation()
{
    local Pawn P;
    local Controller C;

	//updating text bubble
	currentTextBubbleCounter++;
	if (currentTextBubbleCounter > maxTextBubbleCounter)
		myTextBubble = "";

    C = Controller(Owner);

    if( C != None )
        P = C.Pawn;

    if( P == none ) {
    	myPawn = none;
        return;
    } else
    	myPawn = P;

	myLocation = P.Location;
	myRotation = P.Rotation;
	//myRotation.Pitch = int(P.ViewPitch) * 65556/255;
	myVelocity = P.Velocity;
	myHealth = P.Health;

	if (C.Focus != none) {
		myFocusName = string(C.Focus);
		myFocus = C.Focus.Location;
	} else {
		myFocusName = "";
		myFocus = C.FocalPoint;
	}
}

function Timer()
{
	UpdateInformation();
	SetTimer(updateFrequency, true);
}

// should be called right after the PlayerReplicationInfo was spawned
static function GBReplicationInfo SpawnFor(RemoteBot theBot)
{
	if ( theBot.repInfo != None )
		return theBot.repInfo;

	// spawn a new one
	if ( theBot != None )
	{
		theBot.repInfo = theBot.Spawn(default.Class, theBot);
	}
	return theBot.repInfo;
}

defaultproperties
{
	NetUpdateFrequency=40
}

