/*
Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.
*/


//-----------------------------------------------------------
//
//-----------------------------------------------------------
class GBPawn extends Pawn;

#exec OBJ LOAD FILE=_PGTX-EmoBoy.utx

// Warning override of Pawn variable because the pawn Shadow is just a projector
var ShadowProjector Shadow;

var globalconfig bool bPlayerShadows;
var globalconfig bool bBlobShadow;

//animation used for idling
var name IdleAnim;

//Alternate Idle animation
var name CustomAnim;

//list of animations we should play
var name AnimList[8];

//server sided boolean used to play custom animations
var bool bPlayedAnimAction;

//here we put the names of animations we would like to be allowed to play
//(we put the values in defaultproperties)
var name CustomAnimations[128];

var texture MyTexture[2];

var texture MyHappyTex[2];

replication
{
	reliable if(Role == Role_Authority)
		AnimList, CustomAnim, MyTexture, MyHappyTex;   //not used right now
}

simulated event PostBeginPlay()
{
	Super.PostBeginPlay();

	// if this pawn is supposed to cast dynamic shadows
	if(bActorShadows && bPlayerShadows)
	{
		// Spawn the shadow and intialize it
		Shadow = Spawn(class'ShadowProjector',None,'',Location);
		Shadow.ShadowActor = self;
		Shadow.LightDirection = Normal(vect(1,1,3));
		Shadow.LightDistance = 380;
		Shadow.MaxTraceDistance = 3000;
		Shadow.bBlobShadow = bBlobShadow;
		Shadow.InitShadow();
		Shadow.UpdateShadow();
	}

	//MyHappyTex[0]=Texture(DynamicLoadObject("_PGTX-Emoboy.emoboy_clothes_01", class'Texture'));
	//MyHappyTex[1]=Texture(DynamicLoadObject("_PGTX-Emoboy.emoboy_skin", class'Texture'));
}

event Bump(Actor other)
{
	local KActor kActor;

	super.Bump(other);

	if(KActor(other) != None)
		kActor = KActor(other);
	else
		return;

	kActor.KAddImpulse(Normal(other.Location - Location) * 10000, location);
}

function ServerChangeTexture() {
	MyTexture[0]=MyHappyTex[0];
	MyTexture[1]=MyHappyTex[1];
	//MyTexture[0]=Texture(DynamicLoadObject("_PGTX-Emoboy.emoboy_clothes_01", class'Texture'));
	//MyTexture[1]=Texture(DynamicLoadObject("_PGTX-Emoboy.emoboy_skin", class'Texture'));
}

simulated function changeTexture() {
	MyTexture[0]=MyHappyTex[0];
	MyTexture[1]=MyHappyTex[1];
	//MyTexture[0]=Texture(DynamicLoadObject("_PGTX-Emoboy.emoboy_clothes_01", class'Texture'));
	//MyTexture[1]=Texture(DynamicLoadObject("_PGTX-Emoboy.emoboy_skin", class'Texture'));
}

simulated event Destroyed() {

	//destroying shadow
	if (Shadow != none)
		Shadow.Destroy();

	super.Destroyed();
}

event TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, class<DamageType> DamageType)
{
	// Never take damage or die
}

simulated function SetAnimList(name NewMember, int i)
{
	AnimList[i] = NewMember;
}

simulated event AnimEnd(int Channel)
{
	local int i;

	Super.AnimEnd(Channel);

	if(Channel == 0 && bPlayedAnimAction) //idle channel
	{
		if (AnimList[0] != '')
		{
			SetAnimAction(AnimList[0]);
			for (i = 0; i < 7; i++) {
				AnimList[i] = AnimList[i+1];
			}
		}
		else
		{
			PlayWaiting(); //reset to normal idle
			bPlayedAnimAction = false;
			AnimAction = '';
		}
	}
}

//Called to have all clients play a single animation in the idle animation channel
simulated event SetAnimAction(name NewAction)
{
	AnimAction = NewAction;
	PlayAnim(NewAction, 1.0, 0.2); //Play on base channel, which is the idle channel
	bPlayedAnimAction = true;
}

// Called whenever a player changes their movement type.
simulated function PlayMoving()
{
	if ( (Physics == PHYS_None)
		|| ((Controller != None) && Controller.bPreparingMove) )
	{
		// bot is preparing move - not really moving
		PlayWaiting();
		return;
	}
	if ( Physics == PHYS_Walking )
	{
		if ( bIsCrouched )
		{
			AnimateCrouchWalking();
		}
		else if ( bIsWalking )
		{
			AnimateWalking();
		}
		else
		{
			AnimateRunning();
		}
	}
	else if ( (Physics == PHYS_Swimming)
		|| ((Physics == PHYS_Falling) && TouchingWaterVolume()) )
		AnimateWalking();
	else if ( Physics == PHYS_Ladder )
		AnimateWalking();
	else if ( Physics == PHYS_Flying )
		AnimateFlying();
	else // default
	{
		if ( bIsCrouched )
			AnimateCrouchWalking();
		else if ( bIsWalking )
			AnimateWalking();
		else
			AnimateRunning();
	}
}

// Play appropriate idle animations
simulated function PlayWaiting()
{
	if (CustomAnim == ''){
		LoopAnim(IdleAnim);
	} else {
		LoopAnim(CustomAnim);
	}
}


// Play appropriate crouching animations
simulated function AnimateCrouchWalking()
{
	MovementAnims[0]='FCrouch';
	MovementAnims[1]='BCrouch';
	MovementAnims[2]='LCrouch';
	MovementAnims[3]='RCrouch';
	TurnLeftAnim='LCrouch';
	TurnRightAnim='RCrouch';
}


// Play appropriate walking animations
simulated function AnimateWalking()
{
	MovementAnims[0]='FWalk';
	MovementAnims[1]='BWalk';
	MovementAnims[2]='LWalk';
	MovementAnims[3]='RWalk';
	TurnLeftAnim='LWalk';
	TurnRightAnim='RWalk';
}

// Play appropriate running animations
simulated function AnimateRunning()
{
	MovementAnims[0]='FRun';
	MovementAnims[1]='bRun';
	MovementAnims[2]='LRun';
	MovementAnims[3]='RRun';
	TurnLeftAnim='LRun';
	TurnRightAnim='RRun';
}

// Play appropriate flying animations
simulated function AnimateFlying()
{
	MovementAnims[0]='Swim';
	MovementAnims[1]='Swim';
	MovementAnims[2]='Swim';
	MovementAnims[3]='Swim';
	TurnLeftAnim='Swim';
	TurnRightAnim='Swim';
}

simulated event PostNetReceive() {
	//if (MyTexture[0] != none && Skins[0].Name != MyTexture[0].Name)
	//	Skins[0]=MyTexture[0];
	//if (MyTexture[1] != none && Skins[1].Name != MyTexture[1].Name)
	//	Skins[1]=MyTexture[1];
}

defaultproperties
{
	//MyTexture(0)=Texture'CivilTex.cloth'
	//MyTexture(1)=Texture'CivilTex.Skin'
	//MyHappyTex(0)=Texture'_PGTX-Emoboy.emoboy_clothes_01'
	//MyHappyTex(1)=Texture'_PGTX-Emoboy.emoboy_skin'
	bActorShadows=true
	bPlayerShadows=true
	bNetNotify=true
}
