/*
Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.
*/

// Interaction class creates custom GB Hud and handles keyInput
// The reachability grid is drawn here
class GBHUDInteraction extends Interaction;

//Holds our GBHUD
var GBHUD MyHUD;

var name LastPlayerState;

var private bool bPressedAlt;

//Called as the first function. Prepare everything here.
event Initialized()
{
	InitHud();
}

//Called when the server will change the map - we will have to destroy everything
event NotifyLevelChange()
{
	//ViewportOwner.Actor.ClearStayingDebugLines();
    ViewportOwner.InteractionMaster.RemoveInteraction(self);
}

//Here we will spawn our GBHUD and set it also to the Player
function InitHud()
{
	if (ViewportOwner.Actor.myHUD.IsA('GBHUD'))
	    MyHUD = GBHUD(ViewportOwner.Actor.myHUD);
}

function DoTest()
{
	/*local GUIPAGE MyGUI;

	MyGUI = CreateMenu("DialogGUI");
	OpenMenu("DialogGUI", ,);
	  */
}

//Here we handle our GB key presses
function bool KeyEvent(EInputKey InputKey, EInputAction InputAction, FLOAT Delta )
{

	if (InputKey == IK_Alt)
    	if (InputAction == IST_Press)
			bPressedAlt = True;
    	else if (InputAction == IST_Release)
			bPressedAlt = False;

	 if (bPressedAlt && InputAction == IST_Press)
	 {
		switch (InputKey)
		{
			case IK_B:
				MyHUD.bDisplayHealthBar = !MyHUD.bDisplayHealthBar;
			break;
			case IK_D:
				MyHUD.bDisplayDebug = !MyHUD.bDisplayDebug;
			break;
		    case IK_G:
			    MyHUD.bDrawNavPointsGrid = !MyHUD.bDrawNavPointsGrid;
			break;
		    case IK_H:
		    	MyHUD.bDisplayHelp = !MyHUD.bDisplayHelp;
			break;
			case IK_I:
				MyHUD.bDisplayInformation = !MyHUD.bDisplayInformation;
			break;
			case IK_L:
				MyHUD.bDisplayPlayerList = !MyHUD.bDisplayPlayerList;
			break;
			case IK_M:
				MyHUD.bDisplayMyLocation = !MyHUD.bDisplayMyLocation;
			break;
			case IK_N:
				MyHUD.bDrawNavPointsNames = !MyHUD.bDrawNavPointsNames;
			break;
			case IK_P:
				MyHUD.DisplayPlayerPositions += 1;
				if (MyHUD.DisplayPlayerPositions > 2)
					MyHUD.DisplayPlayerPositions = 0;
			break;
			case IK_R:
				MyHUD.bDisplayRoute = !MyHUD.bDisplayRoute;
			break;
		    case IK_T:
		    	DoTest();
			break;
			case IK_U:
				MyHUD.bDisplayTextBubble = !MyHUD.bDisplayTextBubble;
			break;
    		case IK_LeftBracket :
				if (MyHUD.NavPointBeaconDrawDistance < 4000)
					MyHUD.NavPointBeaconDrawDistance += 100;
			break;
		    case IK_RightBracket:
				if (MyHUD.NavPointBeaconDrawDistance > 100)
					MyHUD.NavPointBeaconDrawDistance -= 100;
			break;
			case IK_Shift:
				if (!ViewportOwner.Actor.IsInState('PlayerMousing'))
				{
					LastPlayerState = ViewportOwner.Actor.GetStateName();
					//ViewportOwner.Actor.GotoState('PlayerMousing');
				}
				else
				{
					//ViewportOwner.Actor.GotoState(LastPlayerState);
				}

			break;
		}
		return true; //This means that this key combinations won't be parsed by other KeyEvents
	}


    return super.KeyEvent(InputKey, InputAction, Delta );
}

/* This function is called by engine, we will forward this to our HUD, so we can
	draw information on it.
*/
function PostRender( canvas Canvas )
{

}

defaultproperties
{
    bVisible=true
    bActive=true
}
