/*
Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.
*/

class GBClientClass extends TcpLink
	config(GameBotsUE2);

//Maximum number of arguments
const ArgsMaxCount = 15;

// the main variables where we have incoming messages stored
var string ReceivedData;
var string ReceivedArgs[ArgsMaxCount];
var string ReceivedVals[ArgsMaxCount];

//for logging purposes
var string lastGBCommand;

//used to store info inside function where local wont work
//set property text dosent seem to work with a local
var actor tempActor;

// set true for verbose debug logs
var config bool bDebug;

// set true for iterative mode
var config bool bIterative;

// enables disables cheating - invulnerability, spawning items for bots
var config bool bAllowCheats;

// if control server or bots can or cannot pause the game
var config bool bAllowPause;

//this is helper variable so we can cast from class<Inventory> to class<Weapon> in fc. GetItemAmount
var class<Weapon> curWeapon;

//For bot exporting (ExportPlayers())
var bool bExportHumanPlayers;
var bool bExportRemoteBots;
var bool bExportUnrealBots;

var GBClientClass Next; //create list of all classes

struct PickupStruct
{
	var() class<Pickup> PickupClass;
};

var array<PickupStruct> ExportedPickup;


//Here is where we handle incoming commands
/* Commands expected to look like:
runto {Argument value} {Arg value}...
Currently hard coded to take no more than ArgsMaxCount args
Command type and arguments can be
any length, but first space terminates the name. Values can
have spaces or any other kind of character.
*/
function ReceivedLine(string S)
{
	local string cmdType, argBody, rem;
	local int endloc, wordsplit, attrNum;

	if(bDebug)
		log(S);

	wordsplit = InStr(S," ");
	if( wordsplit == -1)
		wordsplit = Len(S);

	cmdType = left(S,wordsplit);
	rem = mid(S,InStr(S,"{"));

	attrNum = 0;
	// clear previously received attr/val pairs
	while(attrNum < ArgsMaxCount)
	{
		if (ReceivedArgs[attrNum] == "")
			break;

		ReceivedArgs[attrNum] = "";
		ReceivedVals[attrNum] = "";

		attrNum++;
	}

	attrNum = 0;

	//iterate through attr/val pairs, storring them in the
	//parallel arrays ReceivedArgs and ReceivedVals
	while(attrNum < ArgsMaxCount && rem != "")
	{
		endloc = InStr(rem,"}");
		argBody = mid(rem,1,(endloc - 1));

		wordsplit = InStr(argBody," ");
		ReceivedArgs[attrNum] = left(argBody,wordsplit);
		ReceivedVals[attrNum] = mid(argBody,(wordsplit + 1));

		rem = mid(rem,1); //advance
		rem = mid(rem,InStr(rem,"{"));
		attrNum++;
	}

	cmdType = Caps(cmdType);

	ProcessAction(cmdType);
}

//Recieve info - parse into lines and call RecievedLine
event ReceivedText( string Text )
{
	local int i;
	local string S;

    if(bDebug)
    	log("Recieved - "$Text);

	ReceivedData = ReceivedData $ Text;
	//for logging purposes
	lastGBCommand = Text;

	// remove a LF which arrived in a new packet
	// and thus didn't get cleaned up by the code below
	if(Left(ReceivedData, 1) == Chr(10))
		ReceivedData = Mid(ReceivedData, 1);
	i = InStr(ReceivedData, Chr(13));
	while(i != -1)
	{
		S = Left(ReceivedData, i);
		i++;
		// check for any LF following the CR.
		if(Mid(ReceivedData, i, 1) == Chr(10))
			i++;

		ReceivedData = Mid(ReceivedData, i);

		ReceivedLine(S);

		if(LinkState != STATE_Connected)
			return;

		i = InStr(ReceivedData, Chr(13));
	}
}

function ProcessAction(string cmdType)
{
	//Shouldnt be called, just for inheritance
	log("Error - we are in GBClientClass, ProcessAction() ");
}

// function for getting string value of input received attribute
function string GetArgVal(string argName)
{

	local int i;
	while (i < ArgsMaxCount && ReceivedArgs[i] != "")
	{
		if (ReceivedArgs[i] ~= argName)
			return ReceivedVals[i];
		i++;
	}

	return "";
}

// should use int's for locations rather than floats
// we don't need to be that precise
function ParseVector(out vector v, string vecName)
{
	local int i;
	local string rem;
	local string delim;

	delim = " ";

	rem = GetArgVal(vecName);
	if(rem != "")
	{
		if( InStr(rem,delim) == -1 )
			delim = ",";
		i = InStr(rem,delim);
		v.X = float(left(rem,i));
		rem = mid(rem,i+1);
		i = InStr(rem,delim);
		v.Y = float(left(rem,i));
		v.Z = float(mid(rem,i+1));
	}
	else
	{
		v.x = float( GetArgVal("x") );
		v.y = float( GetArgVal("y") );
		v.z = float( GetArgVal("z") );
	}
}

// function for parsing rotation
function ParseRot(out rotator rot, string rotName)
{
    local int i;
    local string rem;
    //local float y,p,r;
    local string delim;

    delim = " ";

	rem = GetArgVal(rotName);
	if(rem != "")
	{
        if( InStr(rem,delim) == -1 )
        	delim = ",";
        i = InStr(rem,delim);
        rot.Pitch = float(left(rem,i));
        rem = mid(rem,i+1);
        i = InStr(rem,delim);
        rot.Yaw = float(left(rem,i));
        rot.Roll = float(mid(rem,i+1));
	}
	else
	{
		rot.Pitch = float( GetArgVal("pitch") );
		rot.Yaw = float( GetArgVal("yaw") );
		rot.Roll = float( GetArgVal("roll") );
	}
}

//Send a line to the client
function SendLine(string Text, optional bool bNoCRLF)
{
    if(bDebug)
    	log("    Sending: "$Text);
	if(bNoCRLF)
		SendText(Text);
	else
		SendText(Text$Chr(13)$Chr(10));
}


//When we need to tell something to all
function GlobalSendLine(string Text, bool bNotifyAllControlServers, bool bNotifyAllBots, optional bool bNoCRLF)
{
	local GBClientClass G;

	if ((Scenario(Level.Game).theControlServer != none) && bNotifyAllControlServers)
	{
		for (G = Scenario(Level.Game).theControlServer.ChildList; G != None; G = G.Next )
		{
			G.SendLine(Text, bNoCRLF);
		}
	}

	if (bNotifyAllBots)
	{
		for (G = Scenario(Level.Game).theBotServer.ChildList; G != None; G = G.Next )
		{
		    if (BotConnection(G).theBot != none)
				G.SendLine(Text, bNoCRLF);
		}
	}
}

//sends NFO message
function SendGameInfo()
{
	local string gameInfoStr, levelName, PauseResult;
	local int i;

	gameInfoStr = Scenario(Level.Game).GetGameInfo();
	levelName = string(Level);
	i = InStr(Caps(levelName), ".LEVELINFO");

	if(i != -1)
		levelName = Left(levelName, i);

	if (Level.Pauser != None)
		PauseResult = "True";
	else
		PauseResult = "False";

	SendLine("NFO {Gametype " $ Scenario(Level.Game).GameClass $
		"} {WeaponStay " $ Level.Game.bWeaponStay $
		"} {GamePaused " $ PauseResult $
		"} {BotsPaused " $ Level.bPlayersOnly $
		"} {Level " $ levelName $
		"}" $ gameInfoStr);   //last part may differ according to the game type
}

//Get amount of goodies we are provided when we pick various items
function int GetItemAmount(Pickup Pickup)
{
	return 1;
}

//Here the unique IDs are created from objects in UT
function string GetUniqueId(Actor inputActor)
{
	if (inputActor == none)
		return "None";

	if (inputActor.IsA('Controller'))
	{
		if (Controller(inputActor).PlayerReplicationInfo != none)
		{
			return inputActor $ Controller(inputActor).PlayerReplicationInfo.PlayerID;
		}
	}
	else if (inputActor.IsA('Projectile'))
	{
		if (string(inputActor.Group) == "None")
		{
			Scenario(Level.Game).GameBotsID++;
			inputActor.SetPropertyText("Group",string(Scenario(Level.Game).GameBotsID));
		}

		return inputActor $ inputActor.Group;
	}
	else if (inputActor.IsA('Pawn'))
	{
    	if ((Pawn(inputActor).Controller != none) && (Pawn(inputActor).Controller.PlayerReplicationInfo != none))
    	{
			return Pawn(inputActor).Controller $ Pawn(inputActor).Controller.PlayerReplicationInfo.PlayerID;
		}
	}
	else if (inputActor.IsA('Pickup'))
	{
		//The pickups that have pickup base doesn't have unique Id
		//We will send the Id of their pickup base that is unique instead
		//TODO: In UE2 no pickup base in pickup
		//if (Pickup(inputActor).PickUpBase == none)
			return string(inputActor);
		//else
		//	return string(Pickup(inputActor).PickUpBase);
	}

	//If we dont recognize the object, we simply return it as it is
	return string(inputActor);
}

function ExportItemClasses()
{
	SendLine("SITC");
	SendLine("EITC");
}

function ExportGameStatus()
{
	Scenario(Level.Game).SendGameStatus(self);
}

//Sends list of all mutators on the server (MUT batch info mess.)
function ExportMutators()
{
	local Mutator M;

	SendLine("SMUT");
	for (M = Scenario(Level.Game).BaseMutator; M != None; M = M.NextMutator)
	{
		SendLine("MUT {Id " $ M $
			"} {Name " $ M.Name $
			"}");
	}
	SendLine("EMUT");

}

//Sends list of all movers on the server (MOV batch info mess.)
function ExportMovers()
{
	local Mover M;
	local string outstring;

	SendLine("SMOV");
	foreach AllActors(class'Mover',M)
	{
		outstring = "MOV {Id " $ M $
			"} {Location " $ M.Location $
			"} {DamageTrig " $ M.bDamageTriggered $
			"} {Type " $ M.Class $
			"} {IsMoving " $ M.bInterpolating $
			"} {Velocity " $ M.Velocity $
			"} {MoveTime " $ M.MoveTime $
			"} {OpenTime " $ M.StayOpenTime $
			"} {State " $ M.GetStateName() $
			"}";
		if (M.myMarker != none) {
			outstring = outstring $ " {NavPointMarker " $ M.myMarker $ "}";
		}

		SendLine(outstring);

	}
	SendLine("EMOV");
}

//Exports all navpoints in a level also with their reachable graph
function ExportNavPoints()
{
	local string message, flag;
	local NavigationPoint N, First;
	local int i,j,PathListLength;

	SendLine("SNAV");
	First = Level.NavigationPointList.NextNavigationPoint; //will be used in second loop, to eliminate already procesed objects

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		flag = "PathNode";

		message = "NAV {Id " $ N $
			"} {Location " $ N.Location $
			"} {Visible false} {Reachable false}";

		if (N.IsA('InventorySpot'))
		{
			flag = "InventorySpot";

			message = message $ " {Item " $ InventorySpot(N).markedItem $
				"} {ItemClass " $ InventorySpot(N).markedItem.Class $
				"} {ItemSpawned " $ InventorySpot(N).markedItem.IsInState('Pickup') $"}";
		}
		else if (N.IsA('PlayerStart'))
		{
			flag = "PlayerStart";
		}
		else if (N.IsA('Door'))
		{
		 	flag = "Door";
		 	message = message $ " {Mover " $ Door(N).MyDoor $ "}";
		}
		else if (N.IsA('LiftCenter'))
		{
			flag = "LiftCenter";
			message = message $ " {Mover " $ LiftCenter(N).MyLift $
				"} {LiftOffset " $ LiftCenter(N).LiftOffset $ "}";	// starting vector between MyLift location and LiftCenter location
		}
		else if (N.IsA('LiftExit'))
		{
		    flag = "LiftExit";
		    message = message $ " {Mover " $ LiftExit(N).MyLift $ "}";
		}

		message = message $" {Flag " $ flag $ "}";
		SendLine(message);

		i = 0;
		PathListLength = N.PathList.Length;
		SendLine("SNGP");
		while (i < PathListLength)
		{
			message = "INGP {Id " $ N.PathList[i].End $
				"} {Flags " $ N.PathList[i].reachFlags $
				"} {CollisionR " $ N.PathList[i].CollisionRadius $
				"} {CollisionH " $ N.PathList[i].CollisionHeight $
				"}";

			SendLine(message);
			i++;
		}
		SendLine("ENGP");

	}
	SendLine("ENAV");

}

function ExportInventory()
{
	local Pickup Pickup;

	SendLine("SINV");

	foreach AllActors(class'Pickup',Pickup)
	{

		SendLine("INV {Id " $ GetUniqueId(Pickup) $
			"} {Location " $ Pickup.Location $
			"} {Amount " $ GetItemAmount(Pickup) $
			"} {Dropped " $ Pickup.bDropped $
			"} {Type " $ Pickup.Class $
			"} {Visible false} {Reachable false}");
	}

	SendLine("EINV");

}

//Exports all players in the level
function ExportPlayers(optional bool bLimitedInfo)
{
	local Controller C;
	local string message, TeamIndex, WeaponClass;

	for(C = Level.ControllerList; C != None; C = C.NextController )
	{
		if ((bExportRemoteBots && C.IsA('RemoteBot')) || (bExportHumanPlayers && C.IsA('GBxPlayer')) || (bExportUnrealBots && C.IsA('GBxBot')))
		{

			if (C.PlayerReplicationInfo.Team != none)
				TeamIndex = string(C.PlayerReplicationInfo.Team.TeamIndex);
			else
    			TeamIndex = "255";

			if ((C.Pawn != none) && (C.Pawn.Weapon != none))
				WeaponClass = string(C.Pawn.Weapon.Class);
			else
				WeaponClass = "None";

			message = "PLR {Id " $ GetUniqueId(C) $
				"} {Name " $ C.PlayerReplicationInfo.PlayerName $
				"} {Team " $ TeamIndex $
				"} {Visible True}";

			if (!bLimitedInfo)
			{
				if (C.IsA('RemoteBot'))
				{
	            	message = message $ " {Jmx " $ RemoteBot(C).jmx
						$ "} {Action " $ RemoteBot(C).currentBDIAction $ "}";
	            }

				if (C.Pawn != none)
					message = message$" {Location " $ C.Pawn.Location $
						"} {Rotation " $ C.Pawn.Rotation $
						"} {Velocity " $ C.Pawn.Velocity $
						"} {Weapon " $ WeaponClass $
						"}";
				else
					message = message$" {Location " $ C.Location $
						"} {Rotation " $ C.Rotation $
						"} {Velocity " $ C.Velocity $
						"}";

			}
			SendLine(message);
		}

    }
}

function GetPlayers()
{
	local Controller C;
	local string message;
	local string Dead;

	for(C = Level.ControllerList; C != None; C = C.NextController )
	{
		if (C.IsA('RemoteBot') || C.IsA('GBxPlayer') || C.IsA('GBxBot'))
		{
			/*if (C.IsA('RemoteBot')
			{
				Type = "RemoteBot";
			}*/

			if (C.Pawn == None)
				Dead = "True";
			else
				Dead = "False";

			message = "PLR {Id " $ GetUniqueId(C) $
				"} {Name " $ C.PlayerReplicationInfo.PlayerName $
				"} {PlayerType " $ C $
				"} {PlayerDead " $ Dead $"}";

			if (C.Pawn != none)
			{
				message = message $ " {Location " $ C.Pawn.Location $
					"} {Rotation " $ C.Pawn.Rotation $ "}";
			}

			SendLine(message);
		}

    }
}

defaultproperties
{
	bAllowPause=true
	bExportHumanPlayers=true
	bExportRemoteBots=true
	bExportUnrealBots=true

}
