/*
Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.
*/

//=============================================================================
// BotConnection.
// Based connection class
//=============================================================================
class BotConnection extends GBClientClass;

//------------Variables---------------------------

// delay between visionUpdates
var config float visionTime;

// on / off all synchronous messages
var config bool bSynchronousMessagesOff;

//true if we will ignore player limit on the server
var config bool bIgnoreMaxPlayers;

//used to store info inside function where local wont work
//set property text dosent seem to work with a local
var bool tempBool;

var() class<Pickup> tempPickupClass;

//use to set name variables - normaly cant convert string to name
var name tempName;

// the one server and the actual bot we're in control of
var BotServer Parent;
var RemoteBot theBot;


var FocusActorClass FocusActor;

var Vehicle CarVehicle;
var() class<Vehicle> SpawnVec;

//RAY TRACING
struct CustomRay{
	var() config string Id;
	var() config rotator Rotation;
	var() config float Length;
	var() config bool FastTrace;
	var() config bool TraceActors;
	var() config bool ProvideFloorCorrection;
	var() config Beam VisualizerMiss;
	var() config Beam VisualizerHit;
};

var BeamRed hitViz[2];

var array<CustomRay> CustomRayList;


var name TraceBone;

function DoTest() {
	GBPawn(theBot.Pawn).ServerChangeTexture();
	GBPawn(theBot.Pawn).changeTexture();
}

//------------Events---------------------------

// triggered when a socket connection with the server is established
event Accepted()
{
	if(bDebug)
		log("Accepted BotConnection" @ self);

	if (!bIgnoreMaxPlayers &&
		(( Level.Game.NumPlayers >= Level.Game.MaxPlayers) ||
		(Parent.ConnectionCount >= Level.Game.MaxPlayers)) )
	{
		SendLine("HELLO_BOT {ServerFull True}");
		Destroy();
	}
	else
		SendLine("HELLO_BOT");

	if (Scenario(Level.Game).bPasswordProtected)
		gotoState('checkingPassword','Waiting');
	else
		gotoState('waiting','Waiting');
}

event Closed()
{
	Destroy();
}

event Destroyed()
{
	if (theBot != None)
	{
		theBot.Destroy();
	}

	if (FocusActor != None)
	{
		FocusActor.Destroy();
	}
	//Destroying autotrace visualizers
	RemoveCustomRay("All");

}


//------------Functions---------------------------

function PostBeginPlay()
{
	Parent = BotServer(Owner);


	if(bDebug)
		log("Spawned BotConnection");
	SaveConfig();
}

//triggered when weve gotten READY message from client, or after succesfull password check
//we will send game nfo, all navpoints and all items in a map
function ExportStatus()
{
	//Methods defined in super class
	SendGameInfo(); //NFO message
	ExportMutators(); //SMUT, MUT, EMUT messages
	ExportItemClasses(); //SITC, ITC, EITC messages
	ExportNavPoints(); //SNAV, NAV, ENAV messages
	ExportMovers();
	ExportInventory(); //SINV, IINV, EINV messages
	SendLine("SPLR");
	ExportPlayers(true); //true for limited info, PLR messages
	SendLine("EPLR");
}

//Init recieved from client
function InitBot()
{
	local string clientName, className, temp, DesiredSkin, outstring;
	local int teamNum;
	local vector StartLocation;
	local rotator StartRotation;
	local float DesiredSkill, DesiredAccuracy;
	local bool ShouldLeadTarget;

	clientName = GetArgVal("Name");

	DesiredSkin = GetArgVal("Skin");

	className = GetArgVal("ClassName");

	log("In INIT. ClassName received: " $ className);

	temp = GetArgVal("Team");
	if( temp != "" )
		teamNum = int(temp);
	else
		teamNum = 255;

	temp = GetArgVal("DesiredSkill");
	if (temp != "")
		DesiredSkill = float(temp);
	else
		DesiredSkill = -1; //that means deufault value will be used

   	temp = GetArgVal("DesiredAccuracy");
	if (temp != "")
		DesiredAccuracy = float(temp);
	else
		DesiredAccuracy = -1; //that means deufault value will be used

	temp = GetArgVal("ShouldLeadTarget");
	if (temp != "")
		ShouldLeadTarget = bool(temp);
	else
		ShouldLeadTarget = false;

	// add the bot into the game
	theBot = Scenario(Level.Game).AddRemoteBot(
		self,
		clientName,
		teamNum,
		className,
		DesiredSkin,
		DesiredSkill,
		DesiredAccuracy,
		ShouldLeadTarget
	);

	//Here the spawning of the pawn is handled - after weve got controler created
	if(theBot != None)
	{
		//init bot movers array
		theBot.initMoverArray();

		if (GetArgVal("ManualSpawn")!="")
			theBot.bAutoSpawn = !bool(GetArgVal("ManualSpawn"));

		if (GetArgVal("AutoPickupOff") != "")
			theBot.bDisableAutoPickup = bool(GetArgVal("AutoPickupOff"));

		theBot.jmx = GetArgVal("Jmx");

		if (GetArgVal("AutoTrace")!="")
			theBot.bAutoTrace = bool(GetArgVal("AutoTrace"));

		if (theBot.bAutoTrace && CustomRayList.Length == 0)
		{
			AddDefaultRays();
		}

		FocusActor = Spawn(class'FocusActorClass',self,,,);
		FocusActor.bHidden = true;

		// for shooting at the location
		theBot.myTarget = Spawn(class'FocusActorClass',theBot,,,);
		theBot.myTarget.bHidden = true;

		SendNotifyConf();
		//FocusActor.Test();
        if (bDebug)
			log("Succesfully Added bot "$theBot);

        outstring = "INITED {BotId " $ GetUniqueId(theBot) $
       		"} {HealthStart " $ theBot.PawnClass.Default.Health $
       		//"} {HealthFull " $ int(theBot.PawnClass.Default.HealthMax) $
       		//"} {HealthMax " $ int(theBot.PawnClass.Default.SuperHealthMax) $
       		//"} {AdrenalineStart " $ int(thebot.Adrenaline) $
       		//"} {AdrenalineMax " $ int(thebot.AdrenalineMax) $
       		//"} {ShieldStrengthStart " $ int(class'xPawn'.Default.ShieldStrength) $
       		//"} {ShieldStrengthMax " $ int(class'xPawn'.Default.ShieldStrengthMax) $
       		//"} {MaxMultiJump " $ class'xPawn'.Default.MaxMultiJump $
       		"} {DamageScaling " $ theBot.PawnClass.Default.DamageScaling $
       		"} {GroundSpeed " $ theBot.PawnClass.Default.GroundSpeed $
       		"} {WaterSpeed " $ theBot.PawnClass.Default.WaterSpeed $
       		"} {AirSpeed " $ theBot.PawnClass.Default.AirSpeed $
       		"} {LadderSpeed " $ theBot.PawnClass.Default.LadderSpeed $
       		"} {AccelRate " $ theBot.PawnClass.Default.AccelRate $
       		"} {JumpZ " $ theBot.PawnClass.Default.JumpZ $
       		//"} {MultiJumpBoost " $ class'xPawn'.Default.MultiJumpBoost $
       		"} {MaxFallSpeed " $ theBot.PawnClass.Default.MaxFallSpeed $
       		//"} {DodgeSpeedFactor " $ theBot.PawnClass.Default.DodgeSpeedFactor $
       		//"} {DodgeSpeedZ " $ theBot.PawnClass.Default.DodgeSpeedZ $
       		"} {AirControl " $ theBot.PawnClass.Default.AirControl $
       		"}";

       	SendLine(outstring);

		if ( GetArgVal("Location")!="" )
		{
        	ParseVector(StartLocation,"Location");

        	if ( GetArgVal("Rotation")!="" )
			{
				ParseRot(StartRotation,"Rotation");
				Scenario(Level.Game).SpawnPawn(theBot,StartLocation,StartRotation);
			}
			else
			{
				Scenario(Level.Game).SpawnPawn(theBot,StartLocation, );
			}
		}
		else
		{
			if ( GetArgVal("Rotation")!="" )
			{
				ParseRot(StartRotation,"Rotation");
				Scenario(Level.Game).SpawnPawn(theBot, ,StartRotation);
			}
		}

		if (theBot.Pawn != none)
			theBot.GotoState('StartUp', 'Begin');
		else
			theBot.GotoState('Dead', 'Begin');

		gotoState('monitoring','Running');
	}
	else
	{
		if (bDebug)
			log("In InitReceived() - Error adding bot");
	}

}

function SendNotifyConf()
{
	local string outstring;
	local string confchId;

	confchId = GetUniqueId(theBot) $ "_CONFCH";

	outstring="CONFCH {Id " $ confchId $
		"} {BotId " $ GetUniqueId(theBot) $
		"} {ManualSpawn " $ !theBot.bAutoSpawn $
		"} {AutoTrace " $ theBot.bAutoTrace $
	//	"} {Invulnerable " $ theBot.bGodMode $
		"} {Name " $ theBot.PlayerReplicationInfo.PlayerName $
		"} {SpeedMultiplier " $ theBot.SpeedMultiplier $
		"} {VisionTime " $ theBot.myConnection.VisionTime $
		"} {ShowDebug " $ theBot.bDebug $
		"} {Action " $ theBot.currentBDIAction $
		"} {ShowFocalPoint " $ theBot.bShowFocalPoint $
		"} {DrawTraceLines " $ theBot.bDrawTraceLines $
		"} {SynchronousOff " $ theBot.myConnection.bSynchronousMessagesOff $
		"} {AutoPickupOff " $ theBot.bDisableAutoPickup $
		"}";

	//notify that variables changed
	SendLine(outstring);

	//notify all control servers that variables changed
	GlobalSendLine(outstring,true,false);
}

function SendNotifyPause ( bool bGamePaused )
{
	local Controller C;
	local GBClientClass G;

	for(C = Level.ControllerList; C != None; C = C.NextController )
	{
		if( C.IsA('RemoteBot') )
		{
			if (bGamePaused)
				RemoteBot(C).myConnection.SendLine("PAUSED");
			else
				RemoteBot(C).myConnection.SendLine("RESUMED");
		}
	}


}


//Main function for processing commands
function ProcessAction(string cmdType)
{
	if(bDebug)
		log("comandType:"@cmdType);
	if (theBot != none)
		theBot.repInfo.SetLastGBCommand(lastGBCommand);

	if (bIterative)
		Level.Pauser = None;

    if (IsInState('checkingPassword'))
	{
		switch(cmdType)
		{
			case "PASSWORD":
				ReceivedPassword();
			break;
			case "READY":
				ReceivedReady();
			break;
		}
	}
	else
	{
		switch(cmdType)
		{
			case "ACT":
				ReceivedAct();
			break;
			case "ADDRAY":
				ReceivedAddRay();
			break;
			case "CHECKREACH":
				ReceivedCheckReach();
			break;
			case "CMOVE":
				ReceivedCMove();
			break;
			case "CONF":
				ReceivedConf();
			break;
			case "TEST":
				DoTest();
			break;
			case "FTRACE":
				ReceivedFTrace();
			break;
			case "GETINVS":
				ExportInventory();
			break;
			case "GETNAVS":
				ExportNavPoints();
			break;
			case "GETPATH":
				ReceivedGetPath();
			break;
    		case "INIT":
				ReceivedInit();
			break;
			case "JUMP":
				ReceivedJump();
			break;
			case "MESSAGE":
				ReceivedMessage();
			break;
			case "MOVE":
				ReceivedMove();
			break;
			case "PICK":
				ReceivedPick();
			break;
			case "PING":
				SendLine("Pong");
			break;
			case "QUIT":
				Closed();
			break;
			case "READY":
				ReceivedReady();
			break;
			case "REMOVERAY":
				ReceivedRemoveRay();
			break;
			case "RESPAWN":
				ReceivedRespawn();
			break;
			case "ROTATE":
				ReceivedRotate();
			break;
			case "SETCROUCH":
				ReceivedSetCrouch();
			break;
			case "SETROUTE":
				ReceivedSetRoute();
			break;
    	    case "SETWALK":
				ReceivedSetWalk();
			break;
			case "STOP":
				ReceivedStop();
			break;
			case "TRACE":
				ReceivedTrace();
			break;
			case "TURNTO":
				ReceivedTurnTo();
			break;
		}//end switch
	}
}

function ReceivedAct()
{
	local string tmp;
	local int i;

	if (theBot == None || theBot.Pawn == None)
		return;

	for (i=0;i<8;i++) {

		tmp = GetArgVal("List"$i);
		if (tmp != "")
		{
			SetPropertyText("tempName",tmp);
			GBPawn(theBot.Pawn).SetAnimList(tempName,i);
			//theBot.Pawn.SetAnimAction(tempName);
			//theBot.Pawn.FinishAnim();
			//SendLine("ACTFIN");
		}
		else
			break;
	}

	tmp = GetArgVal("Name");
	if (tmp != "")
	{
		SetPropertyText("tempName",tmp);
		GBPawn(theBot.Pawn).SetAnimAction(tempName);
		//theBot.Pawn.SetAnimAction(tempName);
		//theBot.Pawn.FinishAnim();
		//SendLine("ACTFIN");
	}
}

function ReceivedAddRay()
{
	local string target;
	local float floatNumber;
	local vector v;
	local bool boolResult, boolResult2, boolResult3;

	target = GetArgVal("Id");

	if (target == "Default")
	{
		AddDefaultRays();
	}
	else
	{
		ParseVector(v,"Direction");
		floatNumber = float(GetArgVal("Length"));
		boolResult = bool(GetArgVal("FastTrace"));
		boolResult2 = bool(GetArgVal("TraceActors"));
		boolResult3 = bool(GetArgVal("FloorCorrection"));
		AddCustomRay(target,v,floatNumber,boolResult,boolResult2,boolResult3);
	}

}

function ReceivedCheckReach()
{
	local Controller C;
	local string target, id;
	local vector v;
	local bool boolResult;

	if (theBot == None || theBot.Pawn == None)
		return;

	target = GetArgVal("Target");
	id = GetArgVal("Id");
	if(target == "")
	{
		ParseVector(v,"Location");
		boolResult = theBot.PointReachable(v);
		sendLine("RCH {Id " $ id $
			"} {Reachable " $ boolResult $
			"} {From " $ theBot.Pawn.Location $
			"}");
	}
	else
	{
		for(C = Level.ControllerList; C != None; C = C.NextController )
		{
			if( ( C $ C.PlayerReplicationInfo.PlayerID ) == target )
			{
				break;
			}
		}
		if (C != None)
		{
			boolResult = theBot.actorReachable( C.Pawn );
			sendLine("RCH {Id " $ id $
				"} {Reachable " $ boolResult $
				"} {From " $ theBot.Pawn.Location $
				"} {To " $ C.Pawn.Location $
				"}");
		}
		else
		{
			SetPropertyText("tempActor",target);
			if (tempActor != None)
			{
				boolResult = theBot.actorReachable( tempActor );
				sendLine("RCH {Id " $ id $
					"} {Reachable " $ boolResult $
					"} {From " $ theBot.Pawn.Location $
					"} {To " $ tempActor.Location $
					"}");
			}
		}
	}

}

function ReceivedCMove()
{

	local rotator yawRotation;

	if (theBot == None || theBot.Pawn == None)
		return;

	//We need to reset focus, otherwise the focus would reset focal point to its own location
	theBot.Focus = None;
	theBot.myFocus = None;

	yawRotation.Yaw = theBot.Pawn.Rotation.Yaw;
    theBot.myFocalPoint = theBot.Pawn.Location + 500 * vector(yawRotation);
	theBot.GotoState('StartUp','MoveContinuous');
}

function ReceivedConf()
{
	local float floatNumber;
	local string target;

	if (theBot == none)
		return;

	if (GetArgVal("AutoTrace") != "")
		theBot.bAutoTrace = bool(GetArgVal("AutoTrace"));
	if (GetArgVal("DrawTraceLines") != "")
		theBot.bDrawTraceLines = bool(GetArgVal("DrawTraceLines"));
	if (GetArgVal("ManualSpawn") != "")
		theBot.bAutoSpawn = !bool(GetArgVal("ManualSpawn"));
	if (GetArgVal("ShowFocalPoint")!="")
		theBot.bShowFocalPoint = bool(GetArgVal("ShowFocalPoint"));
	if (GetArgVal("ShowDebug")!="")
		theBot.bDebug = bool(GetArgVal("ShowDebug"));
    if (GetArgVal("Action") != "")
		theBot.currentBDIAction = GetArgVal("Action");
	if (GetArgVal("Name") != "")
	{
		target = GetArgVal("Name");
		theBot.PlayerReplicationInfo.PlayerName = target;
		Level.Game.changeName( theBot, target, true );
	}
	if (GetArgVal("SpeedMultiplier") != "")
	{
		floatNumber = float(GetArgVal("Speed"));
		if ( (floatNumber >= 0.1) && (floatNumber <= theBot.MaxSpeed) )
		{
			theBot.SpeedMultiplier = floatNumber;
		    if (theBot.Pawn != none)
				theBot.Pawn.GroundSpeed = floatNumber * theBot.Pawn.Default.GroundSpeed;
		}
	}
	if ((GetArgVal("Invulnerable") != "") && (bAllowCheats == true))
		theBot.bGodMode = bool(GetArgVal("Invulnerable"));
	if ((GetArgVal("DrawTraceLines") != ""))
		theBot.bGodMode = bool(GetArgVal("DrawTraceLines"));
	if (GetArgVal("VisionTime") != "")
	{
		floatNumber = float(GetArgVal("VisionTime"));
		if ((floatNumber >= 0.1) && (floatNumber <= 2))
			visionTime = floatNumber;
	}
	if (GetArgVal("SynchronousOff") != "")
	{
		theBot.myConnection.bSynchronousMessagesOff = bool(GetArgVal("SynchronousOff"));
	}
	if (GetArgVal("AutoPickupOff") != "")
	{
		theBot.bDisableAutoPickup = bool(GetArgVal("AutoPickupOff"));
		if (theBot.Pawn != none)
			theBot.Pawn.bCanPickupInventory = !theBot.bDisableAutoPickup;
	}
	SendNotifyConf();

}

function ReceivedFTrace()
{
	local vector v,v2;
	local string target;

	if (theBot == None || theBot.Pawn == None)
		return;

	if (GetArgVal("From") == "")
	{
		if (theBot.Pawn != None)
			v = theBot.Pawn.Location;
		else
			return;

	}
	else
	{
		ParseVector(v,"From");
	}
	if (GetArgVal("To") == "")
	{
		return;
	}

	ParseVector(v2,"To");
	target = GetArgVal("Id");

	SendLine("FTR {Id " $ target $
		"} {From " $ v $
		"} {To " $ v2 $
		"} {Result " $ !FastTrace(v2,v) $
		"}");
}

function ReceivedGetPath()
{
	local vector v;
	local string id;
	local int i;

	if ( theBot == None )
		return;

	//clear the old path
	for ( i=0; i<16; i++ )
	{
		if ( theBot.RouteCache[i] == None )
			break;
		else
		{
			theBot.RouteCache[i] = None;
		}
	}

	ParseVector(v,"Location");
	theBot.FindPathTo(v);
	id = GetArgVal("Id");

	SendLine("SPTH {MessageId " $ id $ "}");
	for ( i=0; i<16; i++ )
	{
		if ( theBot.RouteCache[i] == None )
			break;
		else
		{
			SendLine("IPTH {RouteId " $ theBot.RouteCache[i] $"}");
		}
	}
	SendLine("EPTH");
}

function ReceivedInit()
{
	if (IsInState('waiting'))
	{
		InitBot();
	}
	else
	{
		if (bDebug)
			log("Bot already spawned");
	}
}



function ReceivedJump()
{
	local string tmp;
	local bool bDouble;

	if (theBot == None || theBot.Pawn == None)
		return;

	bDouble = false;
	tmp = GetArgVal("DoubleJump");
	if (tmp != "")
		bDouble = bool(tmp);

	theBot.RemoteJump(bDouble);

}

function ReceivedMessage()
{
	local string target, text;
	local bool boolResult;
	local float FadeOut;

	if (theBot == None )
		return;

	//Note - currently only allow messages under 256 chars
	target = GetArgVal("Id");
	text = GetArgVal("Text");
	boolResult = bool(GetArgVal("Global"));
	FadeOut = float(GetArgVal("FadeOut"));
	if(text != "")
	{
		theBot.RemoteBroadcast(target,text,boolResult,FadeOut);
	}

}

function ReceivedMove()
{
	local vector v,v2,focusLoc;
	local string focusId;
	local Actor tmpFocus;
	local Controller C;

	if (theBot == None || theBot.Pawn == None)
		return;

	//if first location not specified, we wont move
	if (GetArgVal("FirstLocation")=="")
		return;

	ParseVector(v,"FirstLocation");
	focusId = GetArgVal("FocusTarget");

	//set the destinations we want to traverse
	theBot.myDestination = v;
	theBot.Destination = v;
	if (GetArgVal("SecondLocation")!="")
	{
		ParseVector(v2,"SecondLocation");
		theBot.pendingDestination = v2;
	}
	else
	{
		theBot.pendingDestination = v;
	}

	if(focusId == "")
	{
		if (GetArgVal("FocusLocation")!="")
		{
			ParseVector(focusLoc,"FocusLocation");
			//Cant focus to location, but can to actor, we set position of our helper actor to desired
	        FocusActor.SetLocation(focusLoc);
	        //Lets se the bots focus to our helper actor
			theBot.Focus = FocusActor;
			theBot.myFocus = FocusActor;
			//Set FocalPoint accordingly (it would change to desired values anyway)
			theBot.myFocalPoint = FocusActor.Location;
			theBot.FocalPoint = FocusActor.Location;
		}
		else
		{
			//we reset old focus, if none focus set, the bot will turn towards destination
			theBot.Focus = none;
			theBot.myFocus = none;
			//todo: reset also target?

			//set myFocalPoint to prevent unwanted turning back at the end of movement
			//myFocalPoint will be set at the end of movement
			if (GetArgVal("SecondLocation")!="")
				theBot.myFocalPoint = v2 + 500 * vector(rotator(v2 - v));
			else
				theBot.myFocalPoint = v + 500 * vector(rotator(v - theBot.Pawn.Location));
		}
	}
	else //We have Id of the object we want to face
	{
		//First we determine if it is a bot id
		tmpFocus = None;
		for( C = Level.ControllerList; C != None; C = C.NextController)
		{
			if( (C$C.PlayerReplicationInfo.PlayerID) == focusId)
			{
				if( theBot.Pawn.LineOfSightTo(C.Pawn))
				{
					tmpFocus = C.Pawn;
					break;
				}
			}
		}
		//we found it is a bot id, lets set it as our focus
		if (tmpFocus != none)
		{
			//point the bot at the location of the target
			theBot.FocalPoint = tmpFocus.Location;
			theBot.myFocalPoint = tmpFocus.Location;
			theBot.Focus = tmpFocus;
			theBot.myFocus = tmpFocus;
			theBot.Target = tmpFocus;
		}
		else // it was not a bot id
		{
			//lets try if there is an object with this id
			//can be navpoint or some of the items have unique id
			setPropertyText("tempActor", focusId);
			//if succes, then set this object as our focus object
			if ((tempActor != none) && theBot.Pawn.LineOfSightTo(tempActor))
			{
				theBot.myFocus = tempActor;
				theBot.Focus = tempActor;
				theBot.myFocalPoint = tempActor.Location;
				theBot.FocalPoint = tempActor.Location;
			}
		}
	}
	theBot.GotoState('StartUp','Move');
}

function ReceivedPassword()
{
	local string target;

	target = GetArgVal("Password");

	if (target == Scenario(Level.Game).Password)
	{
		SendLine("PASSWDOK");
		ExportStatus();
		gotoState('waiting','Waiting');
	}
	else
	{
		SendLine("PASSWDWRONG");
		Closed();
	}

}

function ReceivedPause()
{
	local bool bWasPaused;

	if ((!bAllowPause) || theBot == None)
		return;

	if ((Level.bPlayersOnly == true) || (Level.Pauser != none))
		bWasPaused = true;
	else
		bWasPaused = false;


	if (GetArgVal("PauseBots")!="")
	{
		Level.bPlayersOnly = bool(GetArgVal("PauseBots"));
	}
	if (GetArgVal("PauseAll")!="")
	{
		if (bool(GetArgVal("PauseAll")))
		{
			if (Level.Pauser == None)
			{
				// we have to blame the pause on somebody
				Level.Pauser = Scenario(Level.Game).LevelPauserFeed;
			}
		}
		else
		{
			Level.Pauser = None;
		}

	}

	if (bWasPaused == true)
	{
		if ((Level.bPlayersOnly == false) && (Level.Pauser == none))
			SendNotifyPause(false); //send resume message
	}
	else
	{
		if ((Level.bPlayersOnly == true) || (Level.Pauser != none))
			SendNotifyPause(true); //send pause message
	}

}

function ReceivedPick()
{
	local string target;

	if (theBot == none)
		return;

	target = GetArgVal("Id");
	if (target != "")
		theBot.RemotePickup(target);

}

function ReceivedReady()
{
	if (IsInState('waiting'))
		ExportStatus();

	if ( IsInState('checkingPassword') )
		SendLine("PASSWORD {BlockedByIP " $ Scenario(Level.Game).PasswordByIP $"}");

}

function ReceivedRemoveRay()
{
	local string target;

	if (theBot == None)
		return;
	target = GetArgVal("Id");
	RemoveCustomRay(target);
}

function ReceivedRespawn()
{
	local vector v;
	local rotator r;

	if ( theBot == None )
		return;

	ParseVector(v,"StartLocation");
	ParseRot(r,"StartRotation");
	theBot.RespawnPlayer(v,r);
}

function ReceivedRotate()
{
	local string target;
	local rotator r;
	local int i;

	if (theBot.Pawn == None)
		return;

	target = GetArgVal("Axis");
	r = theBot.Rotation;
	i = int(GetArgVal("Amount"));
	if(target == "Vertical")
	{
		r.Pitch = r.pitch + i;
		//r.Yaw = theBot.Pawn.Rotation.Yaw;
	}
	else
	{
		r.Yaw += i;
	}

	theBot.myFocalPoint = theBot.Pawn.Location + ( vector(r) * 500);
	theBot.FocalPoint = theBot.myFocalPoint;
	theBot.myFocus = None;
	theBot.Focus = None; //theBot.Pawn.Location + ( vector(r) * 1000);

    if (theBot.movingContinuous)
		theBot.GotoState('StartUp','MoveContinuous');

	//We comment this so turning commands do not interupt moving commands.
	//theBot.StopWaiting();
	//theBot.GotoState('Startup', 'Turning');

}

function ReceivedSetCrouch()
{
	local string target;

	if (theBot == None || theBot.Pawn == None)
		return;

	target = GetArgVal("Crouch");
	SetPropertyText("tempBool",target);
	theBot.Pawn.ShouldCrouch( tempBool );

}

function ReceivedSetRoute()
{
	local string target;
	local vector v;
	local int i;

	if (theBot == None)
		return;

	if (bool(GetArgVal("Erase"))) {
		for (i=0;i<16;i++) {
			theBot.repInfo.SetCustomRoute(vect(0,0,0),i);
		}
	}

	for (i=0;i<16;i++) {
		ParseVector(v ,"Point"$i );
		//GBxPawn(theBot.Pawn).CustomRoute[i] = v;
		theBot.repInfo.SetCustomRoute(v,i);
		//log("Route"$i$": "$GBxPawn(theBot.Pawn).CustomRoute[i]);
	}
}

function ReceivedSetWalk()
{

	local string target;

	if (theBot == None || theBot.Pawn == None)
		return;

	target = GetArgVal("Walk");
	SetPropertyText("tempBool",target);
	theBot.Pawn.bIsWalking = tempBool;

}

function ReceivedStop()
{
	if (theBot == None || theBot.Pawn == None)
		return;

	theBot.GotoState('Startup', 'DoStop');
}

function ReceivedTrace()
{
	local bool boolResult;
	local vector v, v2, HitLocation, HitNormal;
	local string target, unrealId;

	if (GetArgVal("From") == "")
	{
		if (theBot.Pawn != None)
			v = theBot.Pawn.Location;
		else
			return;

	}else
	{
		ParseVector(v,"From");
	}
	if (GetArgVal("To") == "")
	{
		return;
	}
	ParseVector(v2,"To");
	boolResult = bool(GetArgVal("TraceActors"));
	target = GetArgVal("Id");

	tempActor = Trace(HitLocation,HitNormal,v2,v,boolResult, , );
	if (tempActor == None)
		boolResult = false;
	else
		boolResult = true;
	if (tempActor.IsA('Pawn'))
		unrealId = Pawn(tempActor).Controller $ Pawn(tempActor).Controller.PlayerReplicationInfo.PlayerID;
	else
		unrealId = string(tempActor);

	SendLine("TRC {Id " $ target $
		"} {From " $ v $
		"} {To " $ v2 $
		"} {Result " $ boolResult $
		"} {HitId " $ unrealId $
		"} {HitLocation " $ HitLocation $
		"} {HitNormal " $ HitNormal $
		"}");

}


function ReceivedTurnTo()
{
	local Controller C;
	local vector v;
	local rotator r;
	local string target;

	if (theBot == none || theBot.Pawn == None)
		return;

	target = GetArgVal("Target");
	if(target == "")
	{
		ParseRot(r,"Rotation");
		if(r.Yaw == 0 && r.Pitch == 0 && r.Roll == 0)
		{
			//no target or rotation defined
			ParseVector(v,"Location");
			theBot.FocalPoint = v;
			theBot.myFocalPoint = v;
			//We erase possible focus actors
			theBot.myFocus = None;
			theBot.Focus = None;

			if (theBot.movingContinuous)
				theBot.GotoState('StartUp','MoveContinuous');
		}
		else
		{
			//no target, yes rotation
			theBot.myFocalPoint = theBot.Pawn.Location + ( vector(r) * 500);
			theBot.FocalPoint = theBot.myFocalPoint;

			//We erase possible focus actors
			theBot.myFocus = None;
			theBot.Focus = None;

			if (theBot.movingContinuous)
				theBot.GotoState('StartUp','MoveContinuous');
		}
	}
	else
	{
		//target defined

		//First we try to find if we should focus to a player or bot
		for(C = Level.ControllerList; C != None; C = C.NextController )
		{
			if( target == (C $ C.PlayerReplicationInfo.PlayerID) )
			{
				break;
			}
		}//end for
		if (C != None)
		{
			//Pawn must exists and must be visible
			if ((C.Pawn != None) && theBot.Pawn.LineOfSightTo(C.Pawn))
			{
				//We set the Controller as our target
				theBot.FocalPoint = C.Pawn.Location;
				theBot.myFocalPoint = C.Pawn.Location;
				theBot.Focus = C.Pawn;
				theBot.myFocus = C.Pawn;

				if (theBot.movingContinuous)
					theBot.GotoState('StartUp','MoveContinuous');

			}
			else
			{
				return;
			}
		}
		else
		{
			tempActor = None;
			SetPropertyText("tempActor",target);
			//Actor must be visible
			if ((tempActor != None) && theBot.Pawn.LineOfSightTo(tempActor))
			{
				theBot.myFocus = tempActor;
				theBot.Focus = tempActor;
				theBot.myFocalPoint = tempActor.Location;
				theBot.FocalPoint = theBot.myFocalPoint;

				if (theBot.movingContinuous)
					theBot.GotoState('StartUp','MoveContinuous');
			}
			else
			{
				return;
			}
		}
	}
	//We comment this so turning commands do not interupt moving commands.
	//theBot.StopWaiting();
	//theBot.GotoState('Startup', 'Turning');

}

//Send a line to the client
function SendLine(string Text, optional bool bNoCRLF)
{
	if(bDebug)
		log("    Sending: "$Text);
	if(bNoCRLF)
		SendText(Text);
	else
		SendText(Text$Chr(13)$Chr(10));
}

//------------------ RAY TRACING

function bool LaunchRay (
	vector From,
	vector RealRayDirection, //current bot rotation
	CustomRay Ray,
	out vector To,
	out optional vector HitNormal,
	out optional vector HitLocation,
	out optional string HitId
	)
{
	local Actor HitActor; //shouldnt be object?

	To = From + (RealRayDirection * Ray.Length);
	HitId = "None";

	if (Ray.FastTrace == true)
	{
		return !FastTrace(To, From);
	}
	else
	{
		HitActor = Trace(HitLocation, HitNormal, To, From, Ray.TraceActors);
		if ( (HitActor != None) && HitActor.IsA('Pawn'))
			HitId = Pawn(HitActor).Controller $ Pawn(HitActor).Controller.PlayerReplicationInfo.PlayerID;
		else
			HitId = string(HitActor);
		if (HitActor != None)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
}

function AddCustomRay(string Id, vector Direction, float Length, bool FastTrace, bool TraceActors, bool ProvideFloorCorrection)
{
	local CustomRay Ray;
	local int i;

	//if the ray exists we will remove it
	for (i=0; i < CustomRayList.Length; i++)
	{
		if (CustomRayList[i].Id == Id)
		{
			if (CustomRayList[i].VisualizerMiss != none)
				CustomRayList[i].VisualizerMiss.Destroy();
			if (CustomRayList[i].VisualizerHit != none)
				CustomRayList[i].VisualizerHit.Destroy();

			CustomRayList.Remove(i,1);
			break;
		}
	}

	Ray.Id = Id;
	Ray.Rotation = rotator(Direction);
	Ray.Length = Length;
	Ray.FastTrace = FastTrace;
	Ray.TraceActors = TraceActors;
	Ray.ProvideFloorCorrection = ProvideFloorCorrection;

	//CustomRayList.Insert(CustomRayList.Length - 1, 1);
	CustomRayList[CustomRayList.Length] = Ray;
}

function RemoveCustomRay(string Id)
{
	local int i,j, CustomRayListLength;
	local bool found;

	if (Id == "All")
	{
		//destroy the visualizers
		for ( i=0; i < CustomRayList.Length; i++ )
		{
			if (CustomRayList[i].VisualizerMiss != none)
				CustomRayList[i].VisualizerMiss.Destroy();
			if (CustomRayList[i].VisualizerHit != none)
				CustomRayList[i].VisualizerHit.Destroy();

		}

		CustomRayList.Remove(0,CustomRayList.Length);
		return;
	}

	found = false;
	CustomRayListLength = CustomRayList.Length;
	log ("Length before removing "$CustomRayList.Length);
	i = 0;
	while (i < CustomRayListLength)
	{
		if (CustomRayList[i].Id == Id)
		{
			found = true;
			if (CustomRayList[i].VisualizerMiss != none)
				CustomRayList[i].VisualizerMiss.Destroy();
			if (CustomRayList[i].VisualizerHit != none)
				CustomRayList[i].VisualizerHit.Destroy();
			break;
		}
		i++;
	}

	if (found)
		CustomRayList.Remove(i,1);

		/*
	log ("Length after removing "$CustomRayList.Length);
	log ("ID of last obj in list "$CustomRayList[CustomRayListLength - 2].Id);
	log ("ID of deleted obj in list "$CustomRayList[CustomRayListLength - 1].Id);
	*/
}

function AddDefaultRays()
{
	local CustomRay Ray;
	local int i;

	//destroy the visualizers
	for ( i=0; i < CustomRayList.Length; i++ )
	{
		if (CustomRayList[i].VisualizerMiss != none)
			CustomRayList[i].VisualizerMiss.Destroy();
		if (CustomRayList[i].VisualizerHit != none)
			CustomRayList[i].VisualizerHit.Destroy();
	}

	//clear the list
	CustomRayList.Remove(0,CustomRayList.Length);

	Ray.Id = "StraightAhead";
	Ray.Rotation = rotator(vect(1,0,0));
	Ray.Length = 250;
	Ray.FastTrace = false;
	Ray.TraceActors = false;
	Ray.ProvideFloorCorrection = false;

	CustomRayList[0] = Ray;

	Ray.Id = "45toLeft";
	Ray.Rotation = rotator(vect(1,-1,0));
	Ray.Length = 200;
	Ray.FastTrace = false;
	Ray.TraceActors = false;
	Ray.ProvideFloorCorrection = false;

	CustomRayList[1] = Ray;

	Ray.Id = "45toRight";
	Ray.Rotation = rotator(vect(1,1,0));
	Ray.Length = 200;
	Ray.FastTrace = false;
	Ray.TraceActors = false;
	Ray.ProvideFloorCorrection = false;

	CustomRayList[2] = Ray;
}

function AutoTrace()
{
	local vector from, to, RealRayDirection;
	local bool result;
	local vector hitNormal, hitLocation;
	local string hitId;
	local int i, CustomRayListLength;
	local vector FloorNormal, FloorLocation;

	local HitPlane hitPl;

	if (theBot.Pawn == None)
		return;

	//we have to take into account also angle of the floor we are standing on
	FloorNormal = vect(0,0,0);
	Trace(FloorLocation,FloorNormal,theBot.Pawn.Location + vect(0,0,-100),theBot.Pawn.Location, false, ,);

	i = 0;
	CustomRayListLength = CustomRayList.Length;
	while ((i < CustomRayListLength) && (theBot.Pawn != None))
	{
		from = theBot.Pawn.Location;

		RealRayDirection = vector(theBot.Pawn.Rotation + CustomRayList[i].Rotation);
		if (CustomRayList[i].ProvideFloorCorrection)
		{
			//RealRayDirection += FloorNormal * (Normal(RealRayDirection) dot FloorNormal) * -1;
			RealRayDirection += FloorNormal * (RealRayDirection dot FloorNormal) * -1;
		}

		result = LaunchRay(from, RealRayDirection, CustomRayList[i], to, hitNormal, hitLocation, hitId );
		if (theBot.bDrawTraceLines)
		{
			if (theBot.Pawn != none )
			{
				if (CustomRayList[i].VisualizerHit == none)
				{
					CustomRayList[i].VisualizerHit = Spawn(class'BeamRed', theBot.Pawn,, theBot.Pawn.Location, theBot.Pawn.Rotation);
					CustomRayList[i].VisualizerHit.Instigator = theBot.Pawn;
   					CustomRayList[i].VisualizerHit.BeamDirection = CustomRayList[i].Rotation;
   					CustomRayList[i].VisualizerHit.BeamLength = CustomRayList[i].Length;
   					CustomRayList[i].VisualizerHit.bFloorCorrection = CustomRayList[i].ProvideFloorCorrection;

				}

   				if (CustomRayList[i].VisualizerMiss == none)
   				{
					CustomRayList[i].VisualizerMiss = Spawn(class'BeamGreen', theBot.Pawn,, theBot.Pawn.Location, theBot.Pawn.Rotation);
					CustomRayList[i].VisualizerMiss.Instigator = theBot.Pawn;
   					CustomRayList[i].VisualizerMiss.BeamDirection = CustomRayList[i].Rotation;
   					CustomRayList[i].VisualizerMiss.BeamLength = CustomRayList[i].Length;
   					CustomRayList[i].VisualizerMiss.bFloorCorrection = CustomRayList[i].ProvideFloorCorrection;

				}

				if (result) //use red
				{
					CustomRayList[i].VisualizerMiss.bHidden = true;
					CustomRayList[i].VisualizerHit.bHidden = false;

					//hit plane visualizer
					if (!CustomRayList[i].FastTrace) {     //TODO: make some limitations of number of planes
						hitPl = Spawn(class'HitPlane', theBot.Pawn,, hitLocation, rotator(hitNormal));
						hitPl.myDrawScale3D = vect(250,10000,10000);
						hitPl.SetTimer(2 * visionTime,false);
					}

				}
				else //use green
				{
					CustomRayList[i].VisualizerMiss.bHidden = false;
					CustomRayList[i].VisualizerHit.bHidden = true;
   				}

    				//log("CustomRay Visual. "$CustomRayList[i].Visualizer$"Instigator "$CustomRayList[i].Visualizer.Instigator$"LifeSpan "$CustomRayList[i].Visualizer.LifeSpan);

			}
		}
		SendLine("ATR {Id " $ CustomRayList[i].Id $
			"} {From " $ from $
			"} {To " $ to $
			"} {FastTrace " $ CustomRayList[i].fastTrace $
			"} {FloorCorrection " $ CustomRayList[i].ProvideFloorCorrection $
			"} {Result " $ result $
			"} {HitNormal " $ hitNormal $
			"} {HitLocation " $ hitLocation $
			"} {TraceActors " $ CustomRayList[i].traceActors $
			"} {HitId " $ hitId $
			"}");
		i++;
	}

}



//----------------- STATES

//Waiting state when connected
auto state waiting
{
Begin:
Waiting:
	sleep(5.0);
	goto 'Waiting';

}

state checkingPassword
{
Begin:
Waiting:
	sleep(5.0);
	goto 'Waiting';
}

state monitoring
{

Begin:
Running:
	if (bSynchronousMessagesOff)
		goto 'SynchronousOff';
	if(theBot != none && Level.Pauser == none && !theBot.IsInState('Dead') && !theBot.IsInState('GameEnded') )
	{
		//This is where synchronous batch messages are sent
		SendLine("BEG {Time " $ Level.TimeSeconds $"}");

		//log("Measuring Time of synchronous batch: ");
		//StopWatch(false);

        ExportGameStatus();
		theBot.checkSelf();
		theBot.checkVision();

		// if bAutoTrace true, then send results of all rays
		if (theBot.bAutoTrace)
			AutoTrace();

		//StopWatch(true);


		SendLine("END {Time " $ Level.TimeSeconds $"}");
	}
	//theBot.bDebug = true;
	if (theBot.bDebug && !theBot.IsInState('StartUp'))
		log(theBot.getStateName());
	if (bIterative)
		Level.Pauser=theBot.PlayerReplicationInfo;

		sleep(visionTime);
	goto 'Running';
SynchronousOff:
	if (!bSynchronousMessagesOff)
		goto 'Running';
	sleep(1);
	goto 'SynchronousOff';
}


//-----------------

defaultproperties
{
    visionTime=0.250000
    bIgnoreMaxPlayers=true
    TraceBone="Bip02 Spine"
}
