/*
Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.
*/

class Beam extends Actor;

var rotator BeamDirection; //Relative Beam Direction
var float BeamLength; //Beam Length
var bool bFloorCorrection; //if we should adjust ray according to floor normal

var vector myDrawScale3D; //draw scale of this actor, use to set length of the beam

var rotator BeamRotation; //rotation of the beam
var vector StartLocation; //location of the beam (has to be "in the middle" - between start and end location)
var bool bHit; //set in BotConnection - true if we hit something with this ray


replication {
	reliable if(Role == Role_Authority)
		BeamDirection, BeamLength, bFloorCorrection, myDrawScale3D,
		StartLocation, BeamRotation, bHit;
}

//This is our key function. This function is called on clients if the actor has set bNetNotify to true
//Here we will set the emitter to use our variables
simulated function PostNetReceive()
{
	local vector help;

	help.x=myDrawScale3D.x / 10000;
	help.y=myDrawScale3D.y / 10000;
	help.z=myDrawScale3D.z / 10000;

	SetDrawScale3D(help);

	SetLocation(StartLocation);
	SetRotation(BeamRotation);

	if ( Instigator == none )
	{
    	Destroy();
		return;
    }
	//SetBeamLocation();
}

//Here we compute all variables that will be replicated and setted on client in
//function PostNetReceive() - myDrawScale3D, StartLocation, BeamRotation
function Tick(float dt)
{
	local vector  RealRayDirection;
	local vector  FloorLocation, FloorNormal;

	RealRayDirection = vector(Owner.Rotation + BeamDirection);

	//we have to take into account also angle of the floor we are standing on
	if (bFloorCorrection)
	{
		FloorNormal = vect(0,0,0);
		Trace(FloorLocation,FloorNormal, Owner.Location + vect(0,0,-100), Owner.Location, false, ,);
		RealRayDirection += FloorNormal * (RealRayDirection dot FloorNormal) * -1;
	}

	myDrawScale3D.x = BeamLength * 10000 / 256 ;
	myDrawScale3D.Y = 250;
	myDrawScale3D.Z = 250;

	StartLocation = Owner.Location + (RealRayDirection * BeamLength/2);
	BeamRotation = rotator(RealRayDirection);
}

defaultproperties
{
	DrawType=DT_StaticMesh
	StaticMesh=StaticMesh'Editor.TexPropCube'
	Skins(0)=Texture'GameBotsUE2.green_box'
    bNoDelete=false
	bAlwaysRelevant=True
	bNetTemporary=False
	NetUpdateFrequency=100.000000
	NetPriority=3.000000
	bHidden=False
	bNetNotify=True  //this is important here, otherwise the function PostNetReceive() would not be called
	//RemoteRole=ROLE_SimulatedProxy
}
