/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.utils;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.ut2004.factory.direct.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UCCWrapper {
    protected LogCategory uccLog;
    protected static int fileCounter = 0;
    Process uccProcess = null;
    protected int gbPort = -1;
    protected int controlPort = -1;
    protected int observerPort = -1;
    protected IUT2004Server utServer = null;
    protected static final int basePort = 39782;
    protected static Integer nextUccWrapperUID = 0;
    protected int uccWrapperUID = 0;
    protected UCCWrapperConf configuration = null;
    Thread shutDownHook = new Thread("UCC wrapper finalizer"){

        public void run() {
            if (UCCWrapper.this.uccProcess != null) {
                UCCWrapper.this.uccProcess.destroy();
            }
        }
    };
    public static long stamp = System.currentTimeMillis();
    protected boolean stopped = false;

    public Logger getLogger() {
        return this.uccLog;
    }

    public UCCWrapperConf getConfiguration() {
        return this.configuration;
    }

    public IUT2004Server getUTServer() {
        this.stopCheck();
        if (this.utServer == null) {
            UT2004ServerFactory factory = new UT2004ServerFactory();
            UT2004ServerRunner serverRunner = new UT2004ServerRunner(factory, "NBUTServer", "localhost", this.controlPort);
            this.utServer = serverRunner.startAgent();
        }
        return this.utServer;
    }

    protected String getUnrealHome() {
        if (this.configuration.getUnrealHome() == null) {
            return Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UNREAL_HOME.getKey());
        }
        return this.configuration.getUnrealHome();
    }

    public UCCWrapper(UCCWrapperConf configuration) throws UCCStartException {
        this.uccLog = new LogCategory("Wrapper");
        this.uccLog.addHandler((ILogPublisher)new LogPublisher.ConsolePublisher((IAgentId)new AgentId("UCC")));
        if (configuration.log != null) {
            this.uccLog.setParent(configuration.log);
        }
        this.configuration = configuration;
        Integer n = nextUccWrapperUID;
        Integer n2 = nextUccWrapperUID = Integer.valueOf(nextUccWrapperUID + 1);
        this.uccWrapperUID = n;
        this.initUCCWrapper();
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    protected void initUCCWrapper() throws UCCStartException {
        boolean exception = false;
        try {
            String id = System.currentTimeMillis() + "a" + fileCounter++;
            String fileWithPorts = "GBports" + id;
            String uccHomePath = this.getUnrealHome();
            String systemDirPath = uccHomePath + File.separator + "System" + File.separator;
            String uccFile = "ucc.exe";
            String options = "";
            if (!System.getProperty("os.name").contains("Windows")) {
                options = " -nohomedir";
                uccFile = "ucc";
                if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                    uccFile = "ucc-bin";
                    if (System.getProperty("os.arch").toLowerCase().contains("amd64")) {
                        Logger.getLogger("UCCWrapper").info("64bit arch detected (os.arch property contains keyword amd64). Using 64bit binarry.");
                        uccFile = uccFile + "-linux-amd64";
                    }
                }
            }
            String execStr = systemDirPath + uccFile;
            String portsSetting = this.configuration.startOnUnusedPort ? "?PortsLog=" + fileWithPorts + "?bRandomPorts=true" : "";
            String parameter = this.configuration.mapName + "?game=" + this.configuration.gameBotsPack + "." + this.configuration.gameType + portsSetting + this.configuration.options + options;
            ProcessBuilder procBuilder = new ProcessBuilder(execStr, "server", parameter);
            procBuilder.directory(new File(systemDirPath));
            this.uccProcess = procBuilder.start();
            ScannerSink scanner = new ScannerSink(this.uccProcess.getInputStream());
            scanner.start();
            new StreamSink(this.uccProcess.getErrorStream()).start();
            scanner.portsBindedLatch.await(3L, TimeUnit.MINUTES);
            if (scanner.exception != null) {
                try {
                    this.uccProcess.destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.uccProcess = null;
                throw scanner.exception;
            }
            if (scanner.portsBindedLatch.getCount() > 0L) {
                scanner.interrupt();
                try {
                    this.uccProcess.destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.uccProcess = null;
                throw new UCCStartException("UCC did not start in 3 minutes, timeout.", this);
            }
            this.controlPort = scanner.controlPort;
            this.gbPort = scanner.botsPort;
        }
        catch (InterruptedException ex1) {
            exception = true;
            throw new UCCStartException("Interrupted.", ex1);
        }
        catch (IOException ex2) {
            exception = true;
            throw new UCCStartException("IO Exception.", ex2);
        }
        catch (UCCStartException ex3) {
            exception = true;
            throw ex3;
        }
        catch (Exception ex3) {
            exception = true;
            throw new UCCStartException("Exception.", ex3);
        }
        finally {
            if (exception) {
                try {
                    this.stop();
                }
                catch (Exception e) {}
            }
        }
    }

    public Process getProcess() {
        return this.uccProcess;
    }

    public synchronized void stop() {
        this.stopped = true;
        if (this.uccProcess != null) {
            this.uccProcess.destroy();
            Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            this.uccProcess = null;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getBotPort() {
        this.stopCheck();
        return this.gbPort;
    }

    public int getObserverPort() {
        this.stopCheck();
        return this.observerPort;
    }

    public int getControlPort() {
        this.stopCheck();
        return this.controlPort;
    }

    protected void stopCheck() {
        if (this.stopped) {
            throw new PogamutException("UCC already stopped.", (Object)this);
        }
    }

    public String getHost() {
        return "localhost";
    }

    public SocketConnectionAddress getBotAddress() {
        return new SocketConnectionAddress(this.getHost(), this.getBotPort());
    }

    public SocketConnectionAddress getServerAddress() {
        return new SocketConnectionAddress(this.getHost(), this.getControlPort());
    }

    public SocketConnectionAddress getObserverAddress() {
        return new SocketConnectionAddress(this.getHost(), this.getObserverPort());
    }

    public class ScannerSink
    extends StreamSink {
        public long startingTimeout;
        public UCCStartException exception;
        public CountDownLatch portsBindedLatch;
        public int controlPort;
        public int botsPort;
        Timer timer;
        TimerTask task;
        private final Pattern botPortPattern;
        private final Pattern controlPortPattern;
        private final Pattern observerPortPattern;
        private final Pattern commandletNotFoundPattern;
        private final Pattern mapNotFoundPattern;
        private final Pattern matchStartedPattern;

        public ScannerSink(InputStream is) {
            super(is);
            this.startingTimeout = 120000L;
            this.exception = null;
            this.portsBindedLatch = new CountDownLatch(1);
            this.controlPort = -1;
            this.botsPort = -1;
            this.timer = new Timer("UCC start timeout");
            this.task = null;
            this.botPortPattern = Pattern.compile("BotServerPort:(\\d*)");
            this.controlPortPattern = Pattern.compile("ControlServerPort:(\\d*)");
            this.observerPortPattern = Pattern.compile("ObservingServerPort:(\\d*)");
            this.commandletNotFoundPattern = Pattern.compile("Commandlet server not found");
            this.mapNotFoundPattern = Pattern.compile("No maplist entries found matching the current command line.*");
            this.matchStartedPattern = Pattern.compile("START MATCH");
            this.task = new TimerTask(){

                public void run() {
                    ScannerSink.this.exception = new UCCStartException("Starting timed out. Ports weren't bound in the required time (" + ScannerSink.this.startingTimeout + " ms).", this);
                    ScannerSink.this.timer.cancel();
                    ScannerSink.this.portsBindedLatch.countDown();
                }
            };
            this.timer.schedule(this.task, this.startingTimeout);
        }

        protected void handleInput(String str) {
            super.handleInput(str);
            if (this.portsBindedLatch.getCount() != 0L) {
                Matcher matcher = this.observerPortPattern.matcher(str);
                if (matcher.find()) {
                    UCCWrapper.this.observerPort = Integer.parseInt(matcher.group(1));
                }
                if ((matcher = this.controlPortPattern.matcher(str)).find()) {
                    this.controlPort = Integer.parseInt(matcher.group(1));
                }
                if ((matcher = this.botPortPattern.matcher(str)).find()) {
                    this.botsPort = Integer.parseInt(matcher.group(1));
                    this.raiseLatch();
                }
                if ((matcher = this.commandletNotFoundPattern.matcher(str)).find()) {
                    this.exception = new UCCStartException("UCC failed to start due to: Commandlet server not found.", this);
                    this.raiseLatch();
                }
                if ((matcher = this.mapNotFoundPattern.matcher(str)).find()) {
                    this.exception = new UCCStartException("UCC failed to start due to: Map not found.", this);
                    this.raiseLatch();
                }
                if ((matcher = this.matchStartedPattern.matcher(str)).find()) {
                    this.raiseLatch();
                }
            }
        }

        protected void raiseLatch() {
            this.timer.cancel();
            this.task.cancel();
            this.portsBindedLatch.countDown();
        }
    }

    protected class StreamSink
    extends Thread {
        protected InputStream os = null;

        public StreamSink(InputStream os) {
            this.setName("UCC Stream handler");
            this.os = os;
        }

        protected void handleInput(String str) {
            if (UCCWrapper.this.uccLog.isLoggable(Level.INFO)) {
                UCCWrapper.this.uccLog.info("ID" + UCCWrapper.this.uccWrapperUID + " " + str);
            }
        }

        public void run() {
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.os));
            String s = null;
            try {
                while ((s = stdInput.readLine()) != null) {
                    this.handleInput(s);
                }
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class UCCWrapperConf
    implements Serializable {
        String unrealHome = null;
        String mapName = "DM-TrainingDay";
        String gameBotsPack = "GameBots2004";
        String gameType = "BotDeathMatch";
        String mutators = "";
        String options = "";
        boolean startOnUnusedPort = true;
        transient Logger log = null;

        public UCCWrapperConf() {
        }

        public UCCWrapperConf(UCCWrapperConf uccConf) {
            this.unrealHome = uccConf.getUnrealHome();
            this.mapName = uccConf.getMapName();
            this.gameBotsPack = uccConf.getGameBotsPack();
            this.gameType = uccConf.getGameType();
            this.mutators = uccConf.getMutators();
            this.options = uccConf.getOptions();
            this.startOnUnusedPort = uccConf.isStartOnUnusedPort();
            this.log = uccConf.getLog();
        }

        public String toString() {
            if (this == null) {
                return "UCCWrapperConf";
            }
            return this.getClass().getSimpleName() + "[unrealHome=" + this.unrealHome + ", gameBotsPack=" + this.gameBotsPack + ", gameType=" + this.gameType + ", mutators=" + this.mutators + ", options=" + this.options + ", startOnUnusedPorts=" + this.startOnUnusedPort + "]";
        }

        public String getUnrealHome() {
            if (this.unrealHome == null) {
                return Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UNREAL_HOME.getKey());
            }
            return this.unrealHome;
        }

        public void setUnrealHome(String unrealHome) {
            this.unrealHome = unrealHome;
        }

        public UCCWrapperConf setStartOnUnusedPort(boolean startOnUnusedPort) {
            this.startOnUnusedPort = startOnUnusedPort;
            return this;
        }

        public UCCWrapperConf setGameBotsPack(String gameBotsPack) {
            this.gameBotsPack = gameBotsPack;
            return this;
        }

        public UCCWrapperConf setMapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public UCCWrapperConf setGameType(String gameType) {
            this.gameType = gameType;
            return this;
        }

        public UCCWrapperConf setOptions(String options) {
            this.options = options;
            return this;
        }

        public UCCWrapperConf setLogger(Logger log) {
            this.log = log;
            return this;
        }

        public String getMutators() {
            return this.mutators;
        }

        public void setMutators(String mutators) {
            this.mutators = mutators;
        }

        public Logger getLog() {
            return this.log;
        }

        public void setLog(Logger log) {
            this.log = log;
        }

        public String getMapName() {
            return this.mapName;
        }

        public String getGameBotsPack() {
            return this.gameBotsPack;
        }

        public String getGameType() {
            return this.gameType;
        }

        public String getOptions() {
            return this.options;
        }

        public boolean isStartOnUnusedPort() {
            return this.startOnUnusedPort;
        }
    }
}

