/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.base.communication.worldview.ILockableWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.base3d.agent.IAgent3D;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.translator.bot.BotFSM;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004CommunicationModule;
import cz.cuni.amis.utils.token.IToken;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UT2004BotModule<PARAMS extends UT2004AgentParameters>
extends UT2004CommunicationModule<PARAMS> {
    protected AdaptableProvider<ComponentDependencies> worldViewDependenciesProvider = new AdaptableProvider(null);
    private Class<? extends IUT2004BotController> botControllerClass;

    protected UT2004BotModule() {
    }

    public UT2004BotModule(Class<? extends IUT2004BotController> botControllerClass) {
        this.botControllerClass = botControllerClass;
    }

    @Override
    public void prepareNewAgent(PARAMS agentParameters) {
        super.prepareNewAgent(agentParameters);
        this.worldViewDependenciesProvider.set((Object)new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IToken)agentParameters.getAgentId()));
    }

    @Override
    protected void configureModules() {
        super.configureModules();
        this.addModule(new AbstractModule(){

            public void configure() {
                this.bind(IWorldMessageTranslator.class).to(BotFSM.class);
                this.bind(IWorldView.class).to(IVisionWorldView.class);
                this.bind(IVisionWorldView.class).to(ILockableVisionWorldView.class);
                this.bind(ILockableWorldView.class).to(ILockableVisionWorldView.class);
                this.bind(ILockableVisionWorldView.class).to(UT2004SyncLockableWorldView.class);
                this.bind(ComponentDependencies.class).annotatedWith((Annotation)Names.named((String)"UT2004SyncLockableWorldViewDependency")).toProvider(UT2004BotModule.this.worldViewDependenciesProvider);
                this.bind(IAgent.class).to(IAgent3D.class);
                this.bind(IAgent3D.class).to(IUT2004Bot.class);
                this.bind(IUT2004Bot.class).to(UT2004Bot.class);
                if (UT2004BotModule.this.botControllerClass != null) {
                    this.bind(IUT2004BotController.class).to(UT2004BotModule.this.botControllerClass);
                }
            }
        });
    }
}

