/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.translator.observer;

import com.google.inject.Inject;
import cz.cuni.amis.fsm.FSM;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.exception.TranslatorException;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.communication.translator.IWorldEventQueue;
import cz.cuni.amis.pogamut.ut2004.communication.translator.TranslatorContext;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemTranslator;
import cz.cuni.amis.pogamut.ut2004.communication.translator.observer.state.HelloObserverExpectedState;
import java.util.logging.Logger;

public class ObserverFSM
implements IWorldMessageTranslator {
    private IWorldEventQueue eventQueue = new IWorldEventQueue.Queue();
    private TranslatorContext context = null;
    private FSM<InfoMessage, TranslatorContext> fsm = null;
    private Logger log;

    @Inject
    public ObserverFSM(ItemTranslator translator, AgentLogger logger) {
        this.log = logger.getCategory(this.getClass().getSimpleName());
        this.context = new TranslatorContext(this.eventQueue, translator, this.log);
        this.fsm = new FSM((Object)this.context, HelloObserverExpectedState.class, this.log);
    }

    public IWorldChangeEvent[] processMessage(InfoMessage message) throws TranslatorException {
        this.fsm.push((Object)this.context, (Object)message);
        return this.eventQueue.popEvents();
    }

    public void reset() {
        this.context.reset();
        this.fsm.restart((Object)this.context);
    }

    public String toString() {
        return "ObserverFSM";
    }
}

