/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.translator;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.translator.IWorldEventQueue;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemTranslator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatorContext {
    private IWorldEventQueue events;
    private ItemTranslator itemTranslator;
    private Logger log;
    private List<NavPointNeighbourLink> neighbours = new ArrayList<NavPointNeighbourLink>();
    private Map<UnrealId, NavPoint> navPoints = new HashMap<UnrealId, NavPoint>();
    private Map<UnrealId, Item> items = new HashMap<UnrealId, Item>();
    private Map<UnrealId, List<NavPointNeighbourLink>> links = new HashMap<UnrealId, List<NavPointNeighbourLink>>();

    public TranslatorContext(IWorldEventQueue events, ItemTranslator itemTranslator, Logger log) {
        this.events = events;
        this.itemTranslator = itemTranslator;
        this.log = log;
    }

    public void reset() {
        this.neighbours = new ArrayList<NavPointNeighbourLink>();
        this.navPoints = new HashMap<UnrealId, NavPoint>();
        this.items = new HashMap<UnrealId, Item>();
        this.links = new HashMap<UnrealId, List<NavPointNeighbourLink>>();
    }

    public IWorldEventQueue getEventQueue() {
        return this.events;
    }

    public ItemTranslator getItemTranslator() {
        return this.itemTranslator;
    }

    public Logger getLogger() {
        return this.log;
    }

    public List<NavPointNeighbourLink> getNeighbours() {
        return this.neighbours;
    }

    public void setNeighbours(List<NavPointNeighbourLink> neighs) {
        this.neighbours = neighs;
    }

    public void setNavPointLinks(Map<UnrealId, List<NavPointNeighbourLink>> links) {
        this.links = links;
    }

    public Map<UnrealId, List<NavPointNeighbourLink>> getNavPointLinks() {
        return this.links;
    }

    public void setNavPoints(Map<UnrealId, NavPoint> navPoints) {
        this.navPoints = navPoints;
    }

    public Map<UnrealId, NavPoint> getNavPoints() {
        return this.navPoints;
    }

    public void setItems(Map<UnrealId, Item> items) {
        this.items = items;
    }

    public Map<UnrealId, Item> getItems() {
        return this.items;
    }

    public void processNavPointLinks() {
        if (this.getNavPoints() == null || this.getNavPointLinks() == null) {
            return;
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("Processing NavPoints<->Links.");
        }
        for (NavPoint navPoint : this.getNavPoints().values()) {
            navPoint.getIncomingEdges().clear();
            navPoint.getOutgoingEdges().clear();
        }
        for (NavPoint navPoint : this.getNavPoints().values()) {
            List<NavPointNeighbourLink> links = this.getNavPointLinks().get(navPoint.getId());
            ArrayList<NavPointNeighbourLink> fixedLinks = new ArrayList<NavPointNeighbourLink>(links.size());
            for (NavPointNeighbourLink link : links) {
                NavPoint targetNavPoint = this.navPoints.get(link.getId());
                NavPointNeighbourLink fixedLink = new NavPointNeighbourLink(link, navPoint, targetNavPoint);
                fixedLinks.add(fixedLink);
                navPoint.getOutgoingEdges().put(fixedLink.getId(), fixedLink);
                targetNavPoint.getIncomingEdges().put(navPoint.getId(), fixedLink);
            }
            this.getNavPointLinks().put(navPoint.getId(), fixedLinks);
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("Processing finished.");
        }
    }

    public void processNavPointsAndItems() {
        if (this.getItems() == null || this.getNavPoints() == null) {
            return;
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("Processing NavPoints<->Items.");
        }
        Map<UnrealId, Item> items = this.getItems();
        for (NavPoint navPoint : this.getNavPoints().values()) {
            if (navPoint.getItem() == null) continue;
            Item item = items.get(navPoint.getItem());
            if (item == null) {
                if (!this.getLogger().isLoggable(Level.WARNING)) continue;
                this.getLogger().warning("Item of id " + navPoint.getItem().getStringId() + " does not exist, referenced from navpoint " + navPoint.getId().getStringId() + ".");
                continue;
            }
            navPoint.setItem(item);
            item.setNavPoint(navPoint);
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("Processing finished.");
        }
    }
}

