/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UT2004TimeStuckDetector
implements IStuckDetector {
    private static final double NO_MOVEMENT_SIZE = 10.0;
    private static double DEFAULT_TIMEOUT = 3.0;
    private static double DEFAULT_WAITING_TIMEOUT = 10.0;
    private UT2004Bot bot;
    private double timeout;
    private double waitingTimeout;
    private boolean botWaiting = false;
    private SelfListener selfListener;
    private double lastMovementTime = Double.NEGATIVE_INFINITY;
    private boolean stuck = false;
    private Logger log;

    public UT2004TimeStuckDetector(UT2004Bot bot) {
        this(bot, DEFAULT_TIMEOUT, DEFAULT_WAITING_TIMEOUT);
    }

    public UT2004TimeStuckDetector(UT2004Bot bot, double timeout, double waitingTimeout) {
        if (this.log == null) {
            this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        }
        this.bot = bot;
        this.timeout = timeout;
        this.waitingTimeout = waitingTimeout;
        this.selfListener = new SelfListener((IWorldView)bot.getWorldView());
    }

    public void eventSelf(IWorldObjectEvent<Self> event) {
        if (((Self)event.getObject()).getVelocity().size() > 10.0 || this.lastMovementTime == Double.NEGATIVE_INFINITY) {
            this.lastMovementTime = ((Self)event.getObject()).getLastSeenTime();
        }
        if (this.botWaiting) {
            if (((Self)event.getObject()).getLastSeenTime() - this.lastMovementTime >= this.waitingTimeout) {
                this.stuck = true;
            }
        } else if (((Self)event.getObject()).getLastSeenTime() - this.lastMovementTime >= this.timeout) {
            this.stuck = true;
        }
    }

    public void setBotWaiting(boolean state) {
        this.botWaiting = state;
    }

    public boolean isStuck() {
        return this.stuck;
    }

    public void reset() {
        this.lastMovementTime = Double.NEGATIVE_INFINITY;
        this.stuck = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelfListener
    implements IWorldObjectListener<Self> {
        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, (IWorldObjectEventListener)this);
        }

        public void notify(IWorldObjectEvent<Self> event) {
            UT2004TimeStuckDetector.this.eventSelf(event);
        }
    }
}

