/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathExecutorHelper;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathNavigator;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.exception.PogamutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUT2004PathNavigator<PATH_ELEMENT extends ILocated>
implements IUT2004PathNavigator<PATH_ELEMENT> {
    protected UT2004Bot bot;
    protected IUT2004PathExecutorHelper<PATH_ELEMENT> executor;
    protected Self self;
    protected boolean botWaiting = false;

    protected void setBotWaiting(boolean state) {
        this.botWaiting = state;
        for (IStuckDetector detector : this.executor.getStuckDetectors()) {
            detector.setBotWaiting(state);
        }
    }

    @Override
    public void setBot(UT2004Bot bot) {
        this.bot = bot;
    }

    @Override
    public void setExecutor(IUT2004PathExecutorHelper<PATH_ELEMENT> owner) {
        this.executor = owner;
    }

    @Override
    public void navigate(ILocated focus) {
        if (this.bot == null) {
            throw new PogamutException("The 'bot' field is null (or was not set by the executor), can't navigate.", (Object)this);
        }
        if (this.executor == null) {
            throw new PogamutException("The 'executor' field is null (ow was not set by the executor), can't navigate.", (Object)this);
        }
        int pathElementIndex = this.executor.getPathElementIndex();
        if (pathElementIndex < 0 || pathElementIndex >= this.executor.getPath().size()) {
            throw new PogamutException("Can't navigate as the current path element index is out of path range (index = " + pathElementIndex + ", path.size() = " + this.executor.getPath().size() + ".", (Object)this);
        }
        if (this.self == null) {
            this.self = (Self)this.bot.getWorldView().getSingle(Self.class);
            if (this.self == null) {
                throw new PogamutException("Can't navigate the bot, no Self instance is available in the world view.", (Object)this);
            }
        }
        this.navigate(focus, pathElementIndex);
    }

    protected abstract void navigate(ILocated var1, int var2);
}

