/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor.aware;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.utils.NullCheck;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationList {
    private List<Location> locations = new ArrayList<Location>();

    public void add(Location location) {
        NullCheck.check((Object)location, (String)"location");
        this.locations.add(location);
    }

    public int getSize() {
        return this.locations.size();
    }

    public Location get(int index) {
        return this.locations.get(index);
    }

    public void add(int index, Location location) {
        this.locations.add(index, location);
    }

    public void addSortZ(Location location) {
        for (int i = 0; i < this.locations.size(); ++i) {
            if (!(this.locations.get((int)i).z < location.z)) continue;
            this.add(i, location);
            return;
        }
        this.add(location);
    }

    public List<Location> getLocation(Location location, double epsilon) {
        NullCheck.check((Object)location, (String)"location");
        ArrayList<Location> result = new ArrayList<Location>();
        for (Location l : this.locations) {
            if (!(l.getDistance(location) < epsilon)) continue;
            result.add(l);
        }
        return result;
    }

    public void remove(Location location, double epsilon) {
        NullCheck.check((Object)location, (String)"location");
        ArrayList result = new ArrayList();
        Iterator<Location> iter = this.locations.iterator();
        while (iter.hasNext()) {
            if (iter.next().getDistance(location) < epsilon) {
                iter.remove();
                continue;
            }
            iter.next();
        }
    }
}

