/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor.aware;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.aware.LocationList;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mover;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.objects.IGBWorldObjectEvent;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.List;

public class Lift
implements IGBWorldObjectEvent,
IWorldObject {
    private static final double LIFT_STOP_EPSILON = 50.0;
    private Mover mover;
    private IWorldObjectEventListener<Mover, WorldObjectUpdatedEvent<Mover>> updateListener = new IWorldObjectEventListener<Mover, WorldObjectUpdatedEvent<Mover>>(){

        public void notify(WorldObjectUpdatedEvent<Mover> event) {
            Lift.this.update();
        }
    };
    private IWorldView worldView;
    private UnrealId liftId;
    private Location previousLocation;
    private Location savedLocation;
    private LiftState state = LiftState.UNKNOWN;
    private boolean currentVisible = false;
    private boolean newVisible = false;
    private LocationList liftStops = new LocationList();
    private boolean changed = false;

    public static boolean isLift(Mover mover) {
        return mover.getId().getStringId().toLowerCase().contains("lift");
    }

    public static Lift getLiftInstance(IWorldView worldView, Mover mover) {
        if (!Lift.isLift(mover)) {
            return null;
        }
        return (Lift)worldView.get((WorldObjectId)Lift.getLiftId(mover));
    }

    public static UnrealId getLiftId(Mover mover) {
        NullCheck.check((Object)mover, (String)"mover");
        if (!Lift.isLift(mover)) {
            return null;
        }
        return UnrealId.get((String)(mover.getId().getStringId() + "_Lift"));
    }

    public Lift(IWorldView worldView, Mover mover) {
        NullCheck.check((Object)worldView, (String)"worldView");
        NullCheck.check((Object)mover, (String)"mover");
        this.mover = mover;
        this.liftId = Lift.getLiftId(mover);
        if (!Lift.isLift(mover)) {
            throw new PogamutException("Mover of id '" + mover.getId().getStringId() + "' is not a lift!", (Object)this);
        }
        if (Lift.getLiftInstance(worldView, mover) != null) {
            throw new PogamutException("Can't create another Lift instance for the mover '" + mover.getId().getStringId() + "' as the lift instance for the mover already exists inside " + worldView + ".", Lift.class);
        }
        this.worldView = worldView;
        worldView.addObjectListener((WorldObjectId)mover.getId(), WorldObjectUpdatedEvent.class, this.updateListener);
        this.currentVisible = this.newVisible = mover.isVisible();
        worldView.notify((IWorldChangeEvent)this);
    }

    private void update() {
        if (this.isVisible()) {
            this.newVisible = true;
            this.updateVisible();
            if (this.changed) {
                this.worldView.notify((IWorldChangeEvent)this);
                this.changed = false;
            }
        } else {
            this.newVisible = false;
            this.state = LiftState.UNKNOWN;
            this.previousLocation = null;
            this.savedLocation = null;
            if (this.currentVisible) {
                this.worldView.notify((IWorldChangeEvent)this);
                this.changed = false;
            }
        }
    }

    private void updateVisible() {
        if (this.currentVisible) {
            this.previousLocation = this.savedLocation;
        }
        this.savedLocation = this.getLocation();
        if (this.previousLocation == null) {
            if (this.getVelocity().isZero(1.0E-4)) {
                if (this.state != LiftState.STANDING_STILL) {
                    this.changed = true;
                }
                this.state = LiftState.STANDING_STILL;
            } else if (this.getVelocity().z > 0.0) {
                if (this.state != LiftState.GOING_UP) {
                    this.changed = true;
                }
                this.state = LiftState.GOING_UP;
            } else if (this.getVelocity().z < 0.0) {
                if (this.state != LiftState.GOING_DOWN) {
                    this.changed = true;
                }
                this.state = LiftState.GOING_DOWN;
            } else {
                if (this.state != LiftState.UNKNOWN) {
                    this.changed = true;
                }
                this.state = LiftState.UNKNOWN;
            }
        } else if (this.previousLocation.equals(this.getLocation(), 1.0E-4)) {
            if (this.state != LiftState.STANDING_STILL) {
                this.changed = true;
            }
            this.state = LiftState.STANDING_STILL;
            List<Location> locs = this.liftStops.getLocation(this.getLocation(), 50.0);
            if (this.liftStops.getLocation(this.getLocation(), 50.0).size() == 0) {
                this.changed = true;
                this.liftStops.addSortZ(this.getLocation());
                if (this.liftStops.getSize() > 2) {
                    throw new PogamutException("Lift '" + this.getId().getStringId() + "' has more that two stops, unsupported, do not use UT2004EnvAwerness with current map.", (Object)this);
                }
            }
        } else if (this.previousLocation.z - this.getLocation().z < 0.0) {
            if (this.state != LiftState.GOING_UP) {
                this.changed = true;
            }
            this.state = LiftState.GOING_UP;
        } else {
            if (this.state != LiftState.GOING_DOWN) {
                this.changed = true;
            }
            this.state = LiftState.GOING_DOWN;
        }
    }

    public boolean isLiftStopsKnown() {
        return this.liftStops.getSize() == 2;
    }

    public Location getLiftBottomStop() {
        if (this.isLiftStopsKnown()) {
            return this.liftStops.get(0);
        }
        return null;
    }

    public Location getLiftUpStop() {
        if (this.isLiftStopsKnown()) {
            return this.liftStops.get(1);
        }
        return null;
    }

    public LiftState getLiftState() {
        return this.state;
    }

    public boolean isLiftStateKnown() {
        return this.state != LiftState.UNKNOWN;
    }

    public UnrealId getId() {
        return this.liftId;
    }

    public UnrealId getMoverId() {
        return this.mover.getId();
    }

    public Location getLocation() {
        return this.mover.getLocation();
    }

    public boolean isVisible() {
        return this.currentVisible;
    }

    public boolean isReachable() {
        return this.mover.isReachable();
    }

    public boolean isDamageTrig() {
        return this.mover.isDamageTrig();
    }

    public String getType() {
        return this.mover.getType();
    }

    public boolean isIsMoving() {
        return this.mover.isIsMoving();
    }

    public Velocity getVelocity() {
        return this.mover.getVelocity();
    }

    public double getMoveTime() {
        return this.mover.getMoveTime();
    }

    public double getOpenTime() {
        return this.mover.getOpenTime();
    }

    public Location getBasePos() {
        return this.mover.getBasePos();
    }

    public Location getBaseRot() {
        return this.mover.getBaseRot();
    }

    public double getDelayTime() {
        return this.mover.getDelayTime();
    }

    public String getState() {
        return this.mover.getState();
    }

    public UnrealId getNavPointMarker() {
        return this.mover.getNavPointMarker();
    }

    public double getLastSeenTime() {
        return this.mover.getLastSeenTime();
    }

    public IWorldObjectUpdateResult update(IWorldObject obj) {
        if (obj == null) {
            this.changed = false;
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.CREATED, (IWorldObject)this);
        }
        if (obj != this) {
            this.worldView.removeObjectListener((WorldObjectId)this.mover.getId(), WorldObjectUpdatedEvent.class, this.updateListener);
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.SAME, obj);
        }
        if (this.currentVisible == this.newVisible && !this.changed) {
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.SAME, (IWorldObject)this);
        }
        this.currentVisible = this.newVisible;
        this.changed = false;
        return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.UPDATED, (IWorldObject)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LiftState {
        GOING_UP,
        STANDING_STILL,
        GOING_DOWN,
        UNKNOWN;

    }
}

