/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPrefsRange;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class WeaponPrefs {
    protected List<WeaponPrefsRange> prefs = new ArrayList<WeaponPrefsRange>();
    protected Weaponry weaponry;
    protected UT2004Bot bot;
    protected WeaponPrefsRange generalPrefs;
    protected WeaponPrefs onlyGeneral;

    public WeaponPrefs(Weaponry weaponry, UT2004Bot bot) {
        this.weaponry = weaponry;
        this.bot = bot;
        this.generalPrefs = new WeaponPrefsRange(this, 0.0);
        this.onlyGeneral = new WeaponPrefs(weaponry, bot, new WeaponPrefsRange(this, 0.0)){

            public WeaponPrefsRange newPrefsRange(double minDistance) {
                throw new IllegalStateException("Can't invoke the method on 'generalOnly' preferences!");
            }

            public WeaponPrefs addGeneralPref(ItemType weapon, boolean usePrimaryMode) {
                throw new IllegalStateException("Can't invoke the method on 'generalOnly' preferences!");
            }

            public WeaponPrefs addGeneralPref(Weapon weapon, boolean usePrimaryMode) {
                throw new IllegalStateException("Can't invoke the method on 'generalOnly' preferences!");
            }
        };
    }

    protected WeaponPrefs(Weaponry weaponry, UT2004Bot bot, WeaponPrefsRange generalPrefs) {
        this.weaponry = weaponry;
        this.bot = bot;
        this.generalPrefs = new WeaponPrefsRange(this, generalPrefs);
        this.onlyGeneral = this;
    }

    public WeaponPrefs asGeneralOnly() {
        return this.onlyGeneral;
    }

    public void clearAllPrefs() {
        this.prefs.clear();
        this.generalPrefs.clear();
        this.onlyGeneral.generalPrefs.clear();
    }

    public WeaponPrefs addGeneralPref(ItemType weapon, boolean usePrimaryMode) {
        this.generalPrefs.add(weapon, usePrimaryMode);
        this.onlyGeneral.generalPrefs.add(weapon, usePrimaryMode);
        return this;
    }

    public WeaponPrefs addGeneralPref(Weapon weapon, boolean usePrimaryMode) {
        this.generalPrefs.add(weapon, usePrimaryMode);
        this.onlyGeneral.generalPrefs.add(weapon, usePrimaryMode);
        return this;
    }

    public WeaponPrefsRange newPrefsRange(double maxDistance) {
        WeaponPrefsRange newPrefs = new WeaponPrefsRange(this, maxDistance);
        this.prefs.add(newPrefs);
        Collections.sort(this.prefs, new Comparator<WeaponPrefsRange>(){

            @Override
            public int compare(WeaponPrefsRange o1, WeaponPrefsRange o2) {
                double diff = o1.getMaxDistance() - o2.getMaxDistance();
                if (diff > 0.0) {
                    return 1;
                }
                if (diff < 0.0) {
                    return -1;
                }
                return 0;
            }
        });
        return newPrefs;
    }

    public WeaponPrefsRange getWeaponPreferences(double distance) {
        if (distance < 0.0) {
            return this.generalPrefs;
        }
        if (this.prefs.size() == 0) {
            return this.generalPrefs;
        }
        int i = 0;
        for (WeaponPrefsRange pref : this.prefs) {
            double minDistance = pref.getMinDistance();
            if (minDistance > distance) {
                if (i == 0) {
                    return null;
                }
                return this.prefs.get(i - 1);
            }
            ++i;
        }
        return this.prefs.get(this.prefs.size() - 1);
    }

    protected WeaponPrefsRange getPreviousRange(WeaponPrefsRange weaponPrefsRange) {
        if (weaponPrefsRange == this.generalPrefs) {
            return null;
        }
        int index = this.prefs.indexOf(weaponPrefsRange);
        if (index < 1) {
            return null;
        }
        return this.prefs.get(index - 1);
    }

    public WeaponPref getWeaponPreference(double distance, ItemType ... forbiddenWeapons) {
        WeaponPrefsRange range;
        WeaponPref pref = null;
        if (distance >= 0.0 && this.prefs.size() != 0 && (pref = (range = this.getWeaponPreferences(distance)).getWeaponPreference(forbiddenWeapons)) != null) {
            return pref;
        }
        pref = this.generalPrefs.getWeaponPreference(forbiddenWeapons);
        if (pref != null) {
            return pref;
        }
        pref = this.generalPrefs.getWeaponPreference(new ItemType[0]);
        if (pref != null) {
            return pref;
        }
        if (this.weaponry.getCurrentWeapon() != null) {
            return new WeaponPref(this.weaponry.getCurrentWeapon().getType(), true);
        }
        return null;
    }

    public WeaponPref getWeaponPreference(ILocated target, ItemType ... forbiddenWeapons) {
        if (target == null) {
            return this.getWeaponPreference(-1.0, forbiddenWeapons);
        }
        return this.getWeaponPreference(this.bot.getLocation().getDistance(target.getLocation()), forbiddenWeapons);
    }

    public WeaponPref getWeaponPreference(ItemType ... forbiddenWeapons) {
        return this.getWeaponPreference(-1.0, forbiddenWeapons);
    }
}

