/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.utils.NullCheck;

public class WeaponPref {
    private ItemType weapon;
    private boolean primary;

    public WeaponPref(ItemType weapon, boolean primary) {
        this.weapon = weapon;
        this.primary = primary;
        NullCheck.check((Object)this.weapon, (String)"weapon");
        if (weapon.getCategory() != ItemType.Category.WEAPON) {
            throw new IllegalArgumentException("passed 'weapon' is not of ItemType.Category.WEAPON but " + weapon.getCategory().toString());
        }
    }

    public WeaponPref(Weapon weapon, boolean primary) {
        this.weapon = weapon.getType();
        this.primary = primary;
        NullCheck.check((Object)this.weapon, (String)"weapon");
    }

    public ItemType getWeapon() {
        return this.weapon;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isSecondary() {
        return !this.primary;
    }

    public String toString() {
        return "WeaponPref[type=" + this.weapon.getName() + ", " + (this.primary ? "primary mode" : "secondary mode") + "]";
    }
}

