/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameRestarted;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerScore;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TeamScore;
import cz.cuni.amis.utils.FilePath;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.maps.LazyMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Formatter;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentStats
extends SensorModule<IObservingAgent> {
    protected boolean observer = false;
    protected Map<UnrealId, Integer> killed = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    protected Map<UnrealId, Integer> killedBy = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    protected Map<UnrealId, PlayerScore> playerScores = new LazyMap<UnrealId, PlayerScore>(){

        protected PlayerScore create(UnrealId key) {
            return new PlayerScore(AgentStats.this.currentUT2004Time, key, 0, 0);
        }
    };
    protected Map<Integer, TeamScore> teamScores = new LazyMap<Integer, TeamScore>(){

        protected TeamScore create(Integer key) {
            return new TeamScore();
        }
    };
    protected int deaths = 0;
    protected int suicides = 0;
    protected int killedByOthers = 0;
    protected int killedOthers = 0;
    protected double travelledDistance = 0.0;
    protected boolean shooting = false;
    protected double timeShooting = 0.0;
    protected double timeMoving = 0.0;
    protected Map<ItemType, Double> weaponsUsedTime = new LazyMap<ItemType, Double>(){

        protected Double create(ItemType key) {
            return 0.0;
        }
    };
    protected Map<ItemType, Integer> itemsCollected = new LazyMap<ItemType, Integer>(){

        protected Integer create(ItemType key) {
            return 0;
        }
    };
    protected Map<ItemType.Category, Integer> itemsByCategoryCollected = new LazyMap<ItemType.Category, Integer>(){

        protected Integer create(ItemType.Category key) {
            return 0;
        }
    };
    protected int totalItemsCollected = 0;
    protected int numberOfPlayersKilledWithoutDeath = 0;
    protected int doubleDamageCount = 0;
    protected double doubleDamageTime = 0.0;
    protected Object statsMutex = new Object();
    protected String pathToOutput = null;
    protected File fileToOutput = null;
    protected Formatter outputFile = null;
    private BeginMessageListener beginMessageListener = new BeginMessageListener(this.worldView);
    private BeginMessage lastBeginMessage = null;
    private double previousUT2004Time = -1.0;
    private long previousSystemTime = -1L;
    private double currentUT2004Time = -1.0;
    private long currentSystemTime = -1L;
    private double ut2004TimeDelta = -1.0;
    private long systemTimeDelta = -1L;
    EndMessageListener endMessageListener = new EndMessageListener(this.worldView);
    EndMessage lastEndMessage = null;
    private PlayerScoreListener playerScoreListener;
    private TeamScoreListener teamScoreListener;
    private SelfListener selfListener = new SelfListener(this.worldView);
    private Self self = null;
    private BotKilledListener botKilledListener = new BotKilledListener(this.worldView);
    private PlayerKilledListener playerKilledListener = new PlayerKilledListener(this.worldView);
    private GameRestartedListener gameRestartedListener;
    private ItemPickedUpListener itemPickedUpListener = new ItemPickedUpListener(this.worldView);
    private double matchStartTime = 0.0;
    private boolean shouldLog = true;
    private boolean logBeforeMatchRestart = true;
    protected int playerKilledInRow = 0;
    protected Location lastLocation;

    public boolean isObserver() {
        return this.observer;
    }

    public void setObserver(boolean observer) {
        this.observer = observer;
    }

    public UnrealId getBotId() {
        if (this.self == null) {
            return null;
        }
        if (this.isObserver()) {
            return this.self.getBotId();
        }
        return this.self.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputHeader(Formatter output) {
        if (output == null) {
            return;
        }
        Formatter formatter = output;
        synchronized (formatter) {
            output.format("MatchTime;UT2004Time;Health;Armor;Adrenaline;Score;Deaths;Suicides;Killed;WasKilled;NumKillsWithoutDeath;Team;TeamScore;ItemsCollect;WeaponsCollect;AmmoCollect;HealthCollect;ArmorCollect;ShieldCollect;AdrenalineCollect;OtherCollect;TimeMoving;TimeShooting;DoubleDamageCount;DoubleDamageTime;TraveledDistance;Combo;HasDoubleDamage;IsShooting;Velocity;Location_x;Location_y;Location_z", new Object[0]);
            for (ItemType weapon : ItemType.Category.WEAPON.getTypes()) {
                output.format(";" + this.fixSemicolon(weapon.getName()).replace(".", "_") + "_TimeUsed", new Object[0]);
            }
            output.format(";Event;EventParams...\n", new Object[0]);
            output.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputStatLine(Formatter output, double time, String ... eventOutput) {
        if (output == null) {
            return;
        }
        Formatter formatter = output;
        synchronized (formatter) {
            Object[] objectArray = new Object[33];
            objectArray[0] = time;
            objectArray[1] = this.getCurrentUT2004Time();
            objectArray[2] = this.self == null ? 0 : this.self.getHealth();
            objectArray[3] = this.self == null ? 0 : this.self.getArmor();
            objectArray[4] = this.self == null ? 0 : this.self.getAdrenaline();
            objectArray[5] = this.getScore();
            objectArray[6] = this.deaths;
            objectArray[7] = this.suicides;
            objectArray[8] = this.killedOthers;
            objectArray[9] = this.killedByOthers;
            objectArray[10] = this.numberOfPlayersKilledWithoutDeath;
            objectArray[11] = this.self == null ? 255 : this.self.getTeam();
            objectArray[12] = this.getTeamScore();
            objectArray[13] = this.totalItemsCollected;
            objectArray[14] = this.itemsByCategoryCollected.get((Object)ItemType.Category.WEAPON);
            objectArray[15] = this.itemsByCategoryCollected.get((Object)ItemType.Category.AMMO);
            objectArray[16] = this.itemsByCategoryCollected.get((Object)ItemType.Category.HEALTH);
            objectArray[17] = this.itemsByCategoryCollected.get((Object)ItemType.Category.ARMOR);
            objectArray[18] = this.itemsByCategoryCollected.get((Object)ItemType.Category.SHIELD);
            objectArray[19] = this.itemsByCategoryCollected.get((Object)ItemType.Category.ADRENALINE);
            objectArray[20] = this.itemsByCategoryCollected.get((Object)ItemType.Category.OTHER);
            objectArray[21] = this.timeMoving;
            objectArray[22] = this.timeShooting;
            objectArray[23] = this.doubleDamageCount;
            objectArray[24] = this.doubleDamageTime;
            objectArray[25] = this.travelledDistance;
            Object object = objectArray[26] = this.self == null ? "" : this.fixSemicolon(this.self.getCombo());
            objectArray[27] = this.self == null ? 0 : (this.self.getUDamageTime() > 0.0 ? 1 : 0);
            objectArray[28] = this.self == null ? 0 : (this.self.isShooting() || this.self.isAltFiring() ? 1 : 0);
            objectArray[29] = this.self == null ? 0.0 : this.self.getVelocity().size();
            objectArray[30] = this.self == null ? 0.0 : this.self.getLocation().x;
            objectArray[31] = this.self == null ? 0.0 : this.self.getLocation().y;
            objectArray[32] = this.self == null ? 0.0 : this.self.getLocation().z;
            output.format("%.3f;%.3f;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%.3f;%.3f;%d;%.3f;%.3f;%s;%d;%d;%.3f;%.3f;%.3f;%.3f", objectArray);
            for (ItemType weapon : ItemType.Category.WEAPON.getTypes()) {
                output.format(";%.3f", this.weaponsUsedTime.get(weapon));
            }
            for (String event : eventOutput) {
                output.format(";%s", this.fixSemicolon(event));
            }
            output.format("\n", new Object[0]);
            output.flush();
        }
    }

    protected void outputStatLine(double time, String ... eventOutput) {
        if (!this.isLogging()) {
            return;
        }
        if (this.outputFile == null) {
            return;
        }
        this.outputStatLine(this.outputFile, time, eventOutput);
    }

    protected String fixSemicolon(String text) {
        if (text == null) {
            return "";
        }
        return text.replace(";", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        Object object = this.statsMutex;
        synchronized (object) {
            this.self = null;
            this.deaths = 0;
            this.suicides = 0;
            this.killedOthers = 0;
            this.killedByOthers = 0;
            this.numberOfPlayersKilledWithoutDeath = 0;
            this.totalItemsCollected = 0;
            Map<Object, Object> map = this.itemsByCategoryCollected;
            synchronized (map) {
                this.itemsByCategoryCollected.clear();
            }
            this.timeMoving = 0.0;
            this.timeShooting = 0.0;
            this.doubleDamageCount = 0;
            this.doubleDamageTime = 0.0;
            this.travelledDistance = 0.0;
            map = this.itemsCollected;
            synchronized (map) {
                this.itemsCollected.clear();
            }
            map = this.weaponsUsedTime;
            synchronized (map) {
                this.weaponsUsedTime.clear();
            }
            map = this.playerScores;
            synchronized (map) {
                this.playerScores.clear();
            }
            this.playerKilledInRow = 0;
            this.lastLocation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMatchTime() {
        Object object = this.statsMutex;
        synchronized (object) {
            if (this.getCurrentMatchTime() > 0.0) {
                this.matchStartTime = this.getCurrentMatchTime();
            }
        }
    }

    public boolean isOutputting() {
        return this.isLogging() && this.outputFile != null;
    }

    public String getOutputPath() {
        return this.pathToOutput;
    }

    public File getOutputFile() {
        return this.fileToOutput;
    }

    public void startOutput(String pathToFile) {
        this.startOutput(pathToFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopOutput() {
        if (this.outputFile == null) {
            return;
        }
        Formatter formatter = this.outputFile;
        synchronized (formatter) {
            try {
                this.outputFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outputFile = null;
            this.fileToOutput = null;
        }
    }

    protected File getOutputFile(String pathToFile, boolean seekAlternatives) {
        String rest;
        String fragment;
        NullCheck.check((Object)pathToFile, (String)"pathToFile");
        if (!seekAlternatives) {
            File file = new File(pathToFile);
            if (!file.exists() || file.isFile()) {
                return file;
            }
            throw new PogamutException("Can't output stats into " + file.getAbsolutePath() + ", invalid location.", (Object)this);
        }
        if (pathToFile.contains(".")) {
            fragment = pathToFile.substring(0, pathToFile.lastIndexOf("."));
            rest = pathToFile.substring(pathToFile.lastIndexOf("."));
        } else {
            fragment = pathToFile;
            rest = ".csv";
        }
        for (int i = 0; i < 1000; ++i) {
            String num = String.valueOf(i);
            while (num.length() < 3) {
                num = "0" + num;
            }
            String fileName = fragment + "_" + num + rest;
            File file = new File(fileName);
            if (file.exists()) continue;
            return file;
        }
        throw new PogamutException("No suitable filename for stats to the: " + pathToFile + "...", (Object)this);
    }

    public void startOutput(String pathToFile, boolean seekAlternatives) {
        this.stopOutput();
        this.pathToOutput = pathToFile;
        this.fileToOutput = this.getOutputFile(pathToFile, seekAlternatives);
        FilePath.makeDirsToFile((File)this.fileToOutput);
        try {
            this.outputFile = new Formatter(this.fileToOutput);
        }
        catch (FileNotFoundException e) {
            throw new PogamutIOException("Could not start logging into '" + this.fileToOutput.getAbsolutePath() + "' due to: " + e.getMessage(), (Throwable)e, (Object)this);
        }
        this.outputHeader(this.outputFile);
    }

    public Map<UnrealId, Integer> getKilled() {
        return this.killed;
    }

    public Map<UnrealId, PlayerScore> getPlayerScores() {
        return this.playerScores;
    }

    public Map<Integer, TeamScore> getTeamScores() {
        return this.teamScores;
    }

    public double getCurrentMatchTime() {
        if (this.isLogging() && this.currentUT2004Time > 0.0) {
            return this.currentUT2004Time - this.matchStartTime + (double)((System.currentTimeMillis() - this.currentSystemTime) / 1000L);
        }
        return -1.0;
    }

    public double getCurrentUT2004Time() {
        return this.currentUT2004Time;
    }

    public int getKilledOthers() {
        return this.killedOthers;
    }

    public boolean isShooting() {
        return this.shooting;
    }

    public double getTimeShooting() {
        return this.timeShooting;
    }

    public double getTimeMoving() {
        return this.timeMoving;
    }

    public Map<ItemType, Double> getWeaponsUsedTime() {
        return this.weaponsUsedTime;
    }

    public Map<ItemType, Integer> getItemsCollected() {
        return this.itemsCollected;
    }

    public Map<ItemType.Category, Integer> getItemsByCategoryCollected() {
        return this.itemsByCategoryCollected;
    }

    public int getTotalItemsCollected() {
        return this.totalItemsCollected;
    }

    public int getNumberOfPlayersKilledWithoutDeath() {
        return this.numberOfPlayersKilledWithoutDeath;
    }

    public int getDoubleDamageCount() {
        return this.doubleDamageCount;
    }

    public double getDoubleDamageTime() {
        return this.doubleDamageTime;
    }

    public Map<UnrealId, Integer> getKilledBy() {
        return this.killedBy;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public double getTravelledDistance() {
        return this.travelledDistance;
    }

    public int getSuicides() {
        return this.suicides;
    }

    public int getScore() {
        return this.self == null ? 0 : this.playerScores.get(this.getBotId()).getScore();
    }

    public int getTeamScore() {
        return this.self == null ? 0 : this.teamScores.get(this.self.getTeam()).getScore();
    }

    public int getKilledByOthers() {
        return this.killedByOthers;
    }

    public boolean isTimeInitialized() {
        return this.previousUT2004Time > 0.0 && this.currentUT2004Time > 0.0;
    }

    public double getMatchStartTime() {
        return this.matchStartTime;
    }

    public boolean isLogging() {
        return this.isTimeInitialized() && this.shouldLog && this.self != null;
    }

    public boolean isLogBeforeMatchRestart() {
        return this.logBeforeMatchRestart;
    }

    public void setLogBeforeMatchRestart(boolean logBeforeMatchRestart) {
        this.logBeforeMatchRestart = logBeforeMatchRestart;
        this.shouldLog = this.logBeforeMatchRestart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gameRestarted(GameRestarted event) {
        Object object = this.statsMutex;
        synchronized (object) {
            if (event.isFinished()) {
                this.shouldLog = true;
                this.resetStats();
                this.matchStartTime = this.currentUT2004Time;
                this.outputStatLine(0.0, "GAME_RESTARTED");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void botKilled(BotKilled event) {
        Object object = this.statsMutex;
        synchronized (object) {
            if (!this.isLogging()) {
                return;
            }
            ++this.deaths;
            if (event.getKiller() == null || event.getKiller().equals((Object)this.getBotId()) || this.self != null && event.getKiller().equals((Object)this.self.getId())) {
                ++this.suicides;
            } else {
                ++this.killedByOthers;
                Map<UnrealId, Integer> map = this.killedBy;
                synchronized (map) {
                    this.killedBy.put(event.getKiller(), this.killedBy.get(event.getKiller()) + 1);
                }
            }
            this.playerKilledInRow = 0;
            this.lastLocation = null;
            if (event.getKiller() == null || this.self != null && event.getKiller().equals((Object)this.getBotId())) {
                this.outputStatLine(this.getCurrentMatchTime(), "BOT_KILLED", "SUICIDE", event.getDamageType());
            } else {
                this.outputStatLine(this.getCurrentMatchTime(), "BOT_KILLED", event.getKiller().getStringId(), event.getDamageType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void playerKilled(PlayerKilled event) {
        Object object = this.statsMutex;
        synchronized (object) {
            if (!this.isLogging()) {
                return;
            }
            UnrealId killer = event.getKiller();
            UnrealId me = this.getBotId();
            if (event.getId().equals((Object)me)) {
                return;
            }
            if (killer != null && killer.equals((Object)me)) {
                ++this.killedOthers;
                ++this.playerKilledInRow;
                if (this.playerKilledInRow > this.numberOfPlayersKilledWithoutDeath) {
                    this.numberOfPlayersKilledWithoutDeath = this.playerKilledInRow;
                }
                Map<UnrealId, Integer> map = this.killed;
                synchronized (map) {
                    this.killed.put(event.getId(), this.killed.get(event.getId()) + 1);
                }
                this.outputStatLine(this.getCurrentMatchTime(), "PLAYER_KILLED", event.getId().getStringId(), event.getDamageType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemPickedUp(ItemPickedUp event) {
        Object object = this.statsMutex;
        synchronized (object) {
            if (!this.isLogging()) {
                return;
            }
            if (event.getType() == ItemType.U_DAMAGE_PACK) {
                ++this.doubleDamageCount;
            }
            Map<Object, Integer> map = this.itemsCollected;
            synchronized (map) {
                this.itemsCollected.put(event.getType(), this.itemsCollected.get(event.getType()) + 1);
            }
            map = this.itemsByCategoryCollected;
            synchronized (map) {
                this.itemsByCategoryCollected.put(event.getType().getCategory(), this.itemsByCategoryCollected.get((Object)event.getType().getCategory()) + 1);
            }
            this.outputStatLine(this.getCurrentMatchTime(), "ITEM_PICKEDUP", event.getType().getName(), event.getType().getCategory().name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStats(EndMessage event) {
        Object object = this.statsMutex;
        synchronized (object) {
            if (this.self == null) {
                this.log.warning("EndMessage received but no SELF was received.");
                return;
            }
            if (!this.isLogging()) {
                return;
            }
            if (this.self.getVelocity().size() > 1.0) {
                this.timeMoving += this.ut2004TimeDelta;
            }
            if (this.self.isShooting()) {
                this.timeShooting += this.ut2004TimeDelta;
                ItemType weapon = ItemType.getWeapon(this.self.getWeapon());
                if (weapon == null) {
                    this.log.warning("Unrecognized weapon of id: " + this.self.getWeapon());
                } else {
                    Map<ItemType, Double> map = this.weaponsUsedTime;
                    synchronized (map) {
                        this.weaponsUsedTime.put(weapon, this.weaponsUsedTime.get(weapon) + this.ut2004TimeDelta);
                    }
                }
            }
            if (this.self.getUDamageTime() > 0.0) {
                this.doubleDamageTime += this.ut2004TimeDelta;
            }
            if (this.lastLocation != null) {
                this.travelledDistance += this.lastLocation.getDistance(this.self.getLocation());
            }
            this.lastLocation = this.self.getLocation();
            this.outputStatLine(this.getCurrentMatchTime(), new String[0]);
        }
    }

    protected void start(boolean startToPaused) {
        super.start(startToPaused);
        this.resetStats();
        this.resetMatchTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() {
        super.stop();
        Object object = this.statsMutex;
        synchronized (object) {
            this.stopOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void kill() {
        super.kill();
        Object object = this.statsMutex;
        synchronized (object) {
            this.stopOutput();
        }
    }

    public AgentStats(IObservingAgent bot) {
        this(bot, null);
    }

    public AgentStats(IObservingAgent bot, Logger log) {
        super(bot, log);
        this.gameRestartedListener = new GameRestartedListener(this.worldView);
        this.playerScoreListener = new PlayerScoreListener(this.worldView);
        this.teamScoreListener = new TeamScoreListener(this.worldView);
        this.cleanUp();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemPickedUpListener
    implements IWorldEventListener<ItemPickedUp> {
        public ItemPickedUpListener(IWorldView worldView) {
            worldView.addEventListener(ItemPickedUp.class, (IWorldEventListener)this);
        }

        public void notify(ItemPickedUp event) {
            AgentStats.this.itemPickedUp(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GameRestartedListener
    implements IWorldEventListener<GameRestarted> {
        public GameRestartedListener(IWorldView worldView) {
            worldView.addEventListener(GameRestarted.class, (IWorldEventListener)this);
        }

        public void notify(GameRestarted event) {
            AgentStats.this.gameRestarted(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlayerKilledListener
    implements IWorldEventListener<PlayerKilled> {
        public PlayerKilledListener(IWorldView worldView) {
            worldView.addEventListener(PlayerKilled.class, (IWorldEventListener)this);
        }

        public void notify(PlayerKilled event) {
            AgentStats.this.playerKilled(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BotKilledListener
    implements IWorldEventListener<BotKilled> {
        public BotKilledListener(IWorldView worldView) {
            worldView.addEventListener(BotKilled.class, (IWorldEventListener)this);
        }

        public void notify(BotKilled event) {
            AgentStats.this.botKilled(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelfListener
    implements IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> {
        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(WorldObjectUpdatedEvent<Self> event) {
            Object object = AgentStats.this.statsMutex;
            synchronized (object) {
                AgentStats.this.self = (Self)event.getObject();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TeamScoreListener
    implements IWorldObjectEventListener<TeamScore, WorldObjectUpdatedEvent<TeamScore>> {
        public TeamScoreListener(IWorldView worldView) {
            worldView.addObjectListener(TeamScore.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(WorldObjectUpdatedEvent<TeamScore> event) {
            Object object = AgentStats.this.statsMutex;
            synchronized (object) {
                Map<Integer, TeamScore> map = AgentStats.this.teamScores;
                synchronized (map) {
                    AgentStats.this.teamScores.put(((TeamScore)event.getObject()).getTeam(), (TeamScore)event.getObject());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlayerScoreListener
    implements IWorldEventListener<PlayerScore> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(PlayerScore event) {
            Object object = AgentStats.this.statsMutex;
            synchronized (object) {
                Map<UnrealId, PlayerScore> map = AgentStats.this.playerScores;
                synchronized (map) {
                    AgentStats.this.playerScores.put(event.getId(), event);
                }
            }
        }

        public PlayerScoreListener(IWorldView worldView) {
            worldView.addEventListener(PlayerScore.class, (IWorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EndMessageListener
    implements IWorldEventListener<EndMessage> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(EndMessage event) {
            Object object = AgentStats.this.statsMutex;
            synchronized (object) {
                AgentStats.this.lastEndMessage = event;
                AgentStats.this.updateStats(event);
            }
        }

        public EndMessageListener(IWorldView worldView) {
            worldView.addEventListener(EndMessage.class, (IWorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeginMessageListener
    implements IWorldEventListener<BeginMessage> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(BeginMessage event) {
            Object object = AgentStats.this.statsMutex;
            synchronized (object) {
                AgentStats.this.lastBeginMessage = event;
                if (AgentStats.this.currentUT2004Time <= 0.0 && AgentStats.this.isLogBeforeMatchRestart()) {
                    AgentStats.this.matchStartTime = event.getTime();
                }
                AgentStats.this.previousUT2004Time = AgentStats.this.currentUT2004Time;
                AgentStats.this.currentUT2004Time = event.getTime();
                AgentStats.this.ut2004TimeDelta = AgentStats.this.currentUT2004Time - AgentStats.this.previousUT2004Time;
                AgentStats.this.previousSystemTime = AgentStats.this.currentSystemTime;
                AgentStats.this.currentSystemTime = System.currentTimeMillis();
                AgentStats.this.systemTimeDelta = AgentStats.this.currentSystemTime - AgentStats.this.previousSystemTime;
            }
        }

        public BeginMessageListener(IWorldView worldView) {
            worldView.addEventListener(BeginMessage.class, (IWorldEventListener)this);
        }
    }
}

