/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol.character;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionRotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotLogicController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PlayAnimation;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetWalk;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Stop;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.TurnTo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;

@AgentScoped
public class EmohawkLivingCharacter
extends UT2004BotLogicController {
    private static int FOCUS_DISTANCE_OFFSET = 1500;
    private double defaultSpeed = 440.0;
    private double currentTimeUT;
    private double startStoryTimeUT;
    private long startStoryTime;
    private double startTime = 0.0;
    protected AgentInfo agentInfo;
    protected Game game;
    protected Players players;
    protected Items items;
    protected Self self;
    protected EmohawkCharacter character;
    private ActionAnimation lastAnimation;
    private ActionMovement lastMovement;
    private ActionRotation lastRotation;
    private int actualLoop = 1;
    private Location currentStartLocation;
    private Rotation currentStartRotation;
    private Location currentLocation;
    private Rotation currentRotation;
    private boolean bInitialized = false;
    private boolean bIsStoryPlaying = false;
    private boolean waitForNextAnimation = false;

    public boolean isInitilialized() {
        return this.bInitialized;
    }

    public EmohawkCharacter getMyCharacter() {
        return this.character;
    }

    public double getCurrentTimeUT() {
        return this.currentTimeUT;
    }

    public void setCurrentTimeUT(double currentTimeUT) {
        this.currentTimeUT = currentTimeUT;
    }

    public void stopBot() {
        this.bot.stop();
    }

    public void logic() throws PogamutException {
        Location focusPoint;
        if (this.bIsStoryPlaying && (focusPoint = this.getFocusPoint()) != null) {
            this.getAct().act((CommandMessage)new TurnTo().setLocation(focusPoint));
        }
    }

    public void botKilled(BotKilled event) {
    }

    public Initialize getInitializeCommand() {
        if (this.character == null) {
            if (StoryTools.DEBUG) {
                System.out.println(" !!!!!!!!!! Character null");
            }
            return new Initialize();
        }
        Initialize myInit = new Initialize();
        myInit.setName(this.character.getName());
        myInit.setClassName(this.character.getCharacterProperties().getCharacterClass().getText());
        myInit.setLocation(this.character.getCharacterProperties().getStartLocation());
        return myInit;
    }

    public UT2004Bot getBot() {
        return this.bot;
    }

    public void prepareBot(UT2004Bot bot) {
        super.prepareBot(bot);
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.getAct().act((CommandMessage)new SetWalk().setWalk(Boolean.valueOf(true)));
    }

    public void botSpawned(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
        super.botSpawned(gameInfo, currentConfig, init, self);
        this.self = self;
        this.defaultSpeed = ((InitedMessage)this.getWorldView().getSingle(InitedMessage.class)).getGroundSpeed();
        this.currentRotation = new Rotation(0.0, 0.0, 0.0);
        this.bInitialized = true;
        if (StoryTools.DEBUG) {
            System.out.println("EmohawkLivingCharacter.botSpawned(): BOTSPAWNED !!!");
        }
    }

    public void setbIsStoryPlaying(boolean bIsStoryPlaying) {
        this.bIsStoryPlaying = bIsStoryPlaying;
    }

    public static EmohawkLivingCharacter createAvatar(final EmohawkCharacter ec) throws PogamutException {
        UT2004BotFactory factory = new UT2004BotFactory(new UT2004BotModule(EmohawkLivingCharacter.class));
        UT2004BotRunner botRunner = new UT2004BotRunner((IAgentFactory)factory){

            protected void preStartHook(IAgent agent) throws PogamutException {
                super.preStartHook(agent);
                UT2004Bot bot = (UT2004Bot)agent;
                EmohawkLivingCharacter cont = (EmohawkLivingCharacter)bot.getController();
                cont.setCharacter(ec);
            }
        };
        UT2004Bot bot = (UT2004Bot)botRunner.startAgent();
        EmohawkLivingCharacter thisAvatar = (EmohawkLivingCharacter)bot.getController();
        return thisAvatar;
    }

    public static void main(String[] args) throws PogamutException {
        UT2004BotFactory factory = new UT2004BotFactory(new UT2004BotModule(EmohawkLivingCharacter.class));
        UT2004BotRunner botRunner = new UT2004BotRunner((IAgentFactory)factory){

            protected void preStartHook(IAgent agent) throws PogamutException {
                super.preStartHook(agent);
                UT2004Bot bot = (UT2004Bot)agent;
                EmohawkLivingCharacter cont = (EmohawkLivingCharacter)bot.getController();
            }
        };
        UT2004Bot bot = (UT2004Bot)botRunner.startAgent();
        EmohawkLivingCharacter thisAvatar = (EmohawkLivingCharacter)bot.getController();
    }

    public void setStartStoryTimeUT(double startStoryTimeUT) {
        this.startStoryTimeUT = startStoryTimeUT;
    }

    public void setStartStoryTime(long startStoryTime) {
        this.startStoryTime = startStoryTime;
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public Game getGame() {
        return this.game;
    }

    public Players getPlayers() {
        return this.players;
    }

    public Items getItems() {
        return this.items;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setCharacter(EmohawkCharacter ec) {
        this.character = ec;
    }

    public void playNextActions(double time) {
        ActionAnimation lanim;
        long storyTime = this.startStoryTime + Math.round(time - this.startStoryTimeUT);
        ActionAnimation anim = this.character.getActionAnimation(storyTime);
        ActionMovement move = this.character.getActionMovement(storyTime);
        ActionRotation rot = this.character.getActionRotation(storyTime);
        if (anim != null && anim != this.lastAnimation) {
            if (anim.getTime() >= storyTime - 500L) {
                this.playAnim(anim, anim.getLoopCount() > 1);
                this.actualLoop = 1;
            } else {
                this.lastAnimation = anim;
                this.actualLoop = (int)Math.ceil((double)(storyTime - anim.getTime()) / ((double)anim.getDuration() / (double)anim.getLoopCount()));
            }
        } else if (anim != null) {
            if (anim.getTime() + anim.getDuration() / (long)anim.getLoopCount() * (long)this.actualLoop < storyTime) {
                this.playAnim(anim, anim.getLoopCount() > 1);
                ++this.actualLoop;
            }
        } else if (anim == null && (lanim = this.character.getLastAnimation()) != null && lanim.getTime() + lanim.getDuration() < storyTime) {
            this.getAct().act((CommandMessage)new PlayAnimation().setName("idleanim").setLoop(Boolean.valueOf(false)));
        }
        if (move != null && move != this.lastMovement) {
            this.playMovement(move);
        }
        if (rot != null && rot != this.lastRotation) {
            this.playRotation(rot);
        }
    }

    public void setInitialPosition(long time) {
        this.currentStartLocation = this.character.getLocation(time);
        this.currentStartRotation = this.character.getRotation(time);
        this.currentLocation = this.character.getLocation(time);
        this.currentRotation = this.character.getRotation(time);
        if (StoryTools.DEBUG) {
            System.out.println("First location " + this.currentLocation);
        }
        this.getAct().act((CommandMessage)new Respawn().setStartLocation(this.currentStartLocation).setStartRotation(this.currentStartRotation));
    }

    public void stopPlaying() {
        this.setbIsStoryPlaying(false);
        this.getAct().act((CommandMessage)new Stop());
        this.startStoryTime = 0L;
        this.startStoryTimeUT = 0.0;
        this.lastAnimation = null;
        this.lastMovement = null;
        this.lastRotation = null;
        this.currentStartLocation = null;
        this.currentStartRotation = null;
        this.currentRotation = null;
    }

    public void playAnim(ActionAnimation anim, boolean loop) {
        this.getAct().act((CommandMessage)new PlayAnimation().setName(anim.getAnimationId()).setLoop(Boolean.valueOf(loop)));
        this.lastAnimation = anim;
    }

    public Rotation getCurrentRotation() {
        return this.currentRotation;
    }

    public Location getCurrentLocation() {
        return this.currentLocation;
    }

    private void playMovement(ActionMovement move) {
        if (this.self == null || this.self.getLocation() == null) {
            if (StoryTools.DEBUG) {
                System.out.println("Self or self.getLocation() is null!");
            }
            return;
        }
        Location start = this.self.getLocation();
        double speedMult = move.getEnd().getDistance(start) / move.getDurationInSeconds() / this.defaultSpeed;
        this.getAct().act((CommandMessage)new Configuration().setSpeedMultiplier(Double.valueOf(speedMult)));
        this.getAct().act((CommandMessage)new Move().setFirstLocation(move.getEnd()).setFocusLocation(this.getFocusPoint()));
        this.lastMovement = move;
    }

    private void playRotation(ActionRotation rot) {
        if (this.self == null || this.self.getRotation() == null) {
            if (StoryTools.DEBUG) {
                System.out.println("Self or self.getRotation() is null!");
            }
            return;
        }
        Rotation start = null;
        start = this.lastRotation == null ? this.self.getRotation() : new Rotation(0.0, (double)this.lastRotation.getAngleH(), 0.0);
        Rotation end = new Rotation(0.0, (double)rot.getAngleH(), 0.0);
        double rotDelta = Math.abs(65535.0 - end.yaw - (65535.0 - start.yaw));
        Rotation rate = new Rotation(3072.0, 60000.0, 2048.0);
        rate.yaw = rotDelta / ((double)rot.getDuration() / 500.0);
        this.getAct().act((CommandMessage)new Configuration().setRotationRate(rate));
        this.getAct().act((CommandMessage)new TurnTo().setRotation(end));
        this.currentRotation = end;
        this.lastRotation = rot;
    }

    private Location getFocusPoint() {
        if (this.self != null && this.currentRotation != null) {
            return this.self.getLocation().add(this.currentRotation.toLocation().getNormalized().scale((double)FOCUS_DISTANCE_OFFSET));
        }
        return null;
    }

    public String getLastAnimationID() {
        if (this.lastAnimation != null) {
            return this.lastAnimation.getAnimationId();
        }
        return null;
    }
}

