/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol.character;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionRotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.CharacterProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ECharacterType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacterSave;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkLivingCharacter;
import cz.cuni.amis.utils.collections.ObservableList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmohawkCharacter {
    public static int idIterator = 0;
    public final int id;
    protected StoryController parent;
    protected CharacterProperties charProp;
    ObservableList<ActionAnimation> animationList;
    ObservableList<ActionMovement> movementList;
    ObservableList<ActionRotation> rotationList;
    public EmohawkLivingCharacter avatar;

    public EmohawkLivingCharacter getAvatar() {
        return this.avatar;
    }

    public void setAvatar(EmohawkLivingCharacter avatar) {
        this.avatar = avatar;
    }

    public String getName() {
        return this.charProp.getName();
    }

    public CharacterProperties getCharacterProperties() {
        return this.charProp;
    }

    public ObservableList<ActionAnimation> getAnimations() {
        return this.animationList;
    }

    public ObservableList<ActionMovement> getMovements() {
        return this.movementList;
    }

    public ObservableList<ActionRotation> getRotations() {
        return this.rotationList;
    }

    public long getTimeOfTheLastAction() {
        long time = 0L;
        for (StoryAction a : this.getAnimations()) {
            if (a.getTime() + a.getDuration() <= time) continue;
            time = a.getTime() + a.getDuration();
        }
        for (StoryAction a : this.getMovements()) {
            if (a.getTime() + a.getDuration() <= time) continue;
            time = a.getTime() + a.getDuration();
        }
        for (StoryAction a : this.getRotations()) {
            if (a.getTime() + a.getDuration() <= time) continue;
            time = a.getTime() + a.getDuration();
        }
        return time;
    }

    public ActionRotation getPreviousRotation(ActionRotation rotation) {
        int index = this.rotationList.indexOf((Object)rotation);
        if (index - 1 >= 0) {
            return (ActionRotation)this.rotationList.get(index - 1);
        }
        return null;
    }

    public ActionMovement getPreviousMovement(ActionMovement movement) {
        int index = this.movementList.indexOf((Object)movement);
        if (index - 1 >= 0) {
            return (ActionMovement)this.movementList.get(index - 1);
        }
        return null;
    }

    public ActionMovement getNextMovement(ActionMovement movement) {
        int index = this.movementList.indexOf((Object)movement);
        if (index + 1 < this.movementList.size()) {
            return (ActionMovement)this.movementList.get(index + 1);
        }
        return null;
    }

    public synchronized Location getLocation(long time) {
        Location result = null;
        ActionMovement lastPreceedingMovement = null;
        for (ActionMovement move : this.movementList) {
            if (move.getTime() < time) {
                if (lastPreceedingMovement == null) {
                    lastPreceedingMovement = move;
                } else if (lastPreceedingMovement.getTime() < move.getTime()) {
                    lastPreceedingMovement = move;
                }
            }
            if (time < move.getTime() || time >= move.getTime() + move.getDuration()) continue;
            Location end = move.getEnd();
            Location start = this.getCharacterProperties().getStartLocation();
            ActionMovement lastMove = this.getPreviousMovement(move);
            if (lastMove != null) {
                start = lastMove.getEnd();
            }
            double ratio = (double)(time - move.getTime()) / (double)move.getDuration();
            result = Location.interpolate((Location)start, (Location)end, (double)ratio);
            break;
        }
        if (result != null) {
            return result;
        }
        if (lastPreceedingMovement != null) {
            return lastPreceedingMovement.getEnd();
        }
        return this.getCharacterProperties().getStartLocation();
    }

    public synchronized Rotation getRotation(long time) {
        Rotation startRotation = this.getCharacterProperties().getStartRotation();
        Rotation result = new Rotation(startRotation);
        for (ActionRotation ar : this.rotationList) {
            if (ar.getTime() >= time || ar.getTime() + ar.getDuration() > time) continue;
            result = new Rotation((double)ar.getAngleV(), (double)ar.getAngleH(), 0.0);
        }
        ActionRotation rot = this.getActionRotation(time);
        if (rot != null) {
            double ratio = (double)(time - rot.getTime()) / (double)rot.getDuration();
            result.yaw += (double)rot.getRelativeHorizontalAngle() * ratio;
            result.pitch += rot.getRelativeVerticalAngle() * ratio;
        }
        return result;
    }

    public synchronized ActionAnimation getActionAnimation(long time) {
        for (ActionAnimation anim : this.animationList) {
            if (time < anim.getTime() || time >= anim.getTime() + anim.getDuration()) continue;
            return anim;
        }
        return null;
    }

    public synchronized ActionMovement getActionMovement(long time) {
        for (ActionMovement move : this.movementList) {
            if (time < move.getTime() || time >= move.getTime() + move.getDuration()) continue;
            return move;
        }
        return null;
    }

    public synchronized ActionRotation getActionRotation(long time) {
        for (ActionRotation rot : this.rotationList) {
            if (time < rot.getTime() || time >= rot.getTime() + rot.getDuration()) continue;
            return rot;
        }
        return null;
    }

    public EmohawkCharacter(StoryController parent, CharacterProperties charProp) {
        this.id = idIterator++;
        this.parent = parent;
        this.charProp = charProp;
        this.animationList = new ObservableList(new LinkedList());
        this.movementList = new ObservableList(new LinkedList());
        this.rotationList = new ObservableList(new LinkedList());
        if (charProp.getCharacterClass() == ECharacterType.CAMERA) {
            if (parent.getCamerasCount() != 0) {
                int loopCount = Math.round((parent.getStoryLength() - 1000L) / 1000L);
                this.animationList.add((Object)new ActionAnimation(this, parent.getCameraAnim(false), 0, loopCount, 1));
            } else {
                int loopCount = Math.round((parent.getStoryLength() - 1000L) / 1000L);
                this.animationList.add((Object)new ActionAnimation(this, parent.getCameraAnim(true), 0, loopCount, 1));
            }
        }
    }

    public EmohawkCharacter(StoryController parent, EmohawkCharacterSave emoCharSave) {
        this.id = emoCharSave.id;
        this.parent = parent;
        this.charProp = emoCharSave.charProp;
        this.animationList = new ObservableList(new LinkedList<ActionAnimation>(Arrays.asList(emoCharSave.animationArray)));
        this.movementList = new ObservableList(new LinkedList<ActionMovement>(Arrays.asList(emoCharSave.movementArray)));
        this.rotationList = new ObservableList(new LinkedList<ActionRotation>(Arrays.asList(emoCharSave.rotationArray)));
    }

    public synchronized ActionAnimation getLastAnimation() {
        ActionAnimation last = null;
        for (ActionAnimation aa : this.getAnimations()) {
            if (last == null) {
                last = aa;
                continue;
            }
            if (last.getTime() >= aa.getTime()) continue;
            last = aa;
        }
        return last;
    }

    public StoryController getModel() {
        return this.parent;
    }

    public ActionRotation getLastRotation() {
        ActionRotation last = null;
        for (ActionRotation ar : this.getRotations()) {
            if (last == null) {
                last = ar;
                continue;
            }
            if (last.getTime() >= ar.getTime()) continue;
            last = ar;
        }
        return last;
    }

    public ActionMovement getLastMovement() {
        ActionMovement last = null;
        for (ActionMovement am : this.getMovements()) {
            if (last == null) {
                last = am;
                continue;
            }
            if (last.getTime() >= am.getTime()) continue;
            last = am;
        }
        return last;
    }

    public void addMovement(ActionMovement am) {
        ActionMovement move;
        int index = 0;
        Iterator i$ = this.getMovements().iterator();
        while (i$.hasNext() && (move = (ActionMovement)i$.next()).getTime() <= am.getTime()) {
            ++index;
        }
        this.getMovements().add(index, (Object)am);
    }

    public void addRotation(ActionRotation ar) {
        int index = 0;
        for (ActionRotation rot : this.getRotations()) {
            ++index;
            if (rot.getTime() <= ar.getTime()) continue;
            break;
        }
        this.getRotations().add(index, (Object)ar);
    }

    public long getFreeRotationSpace(long time) {
        if (this.getActionRotation(time) != null) {
            return 0L;
        }
        long min = Long.MAX_VALUE;
        for (ActionRotation ar : this.getRotations()) {
            long delta = ar.getTime() - time;
            if (delta < 0L || delta >= min) continue;
            min = delta;
        }
        return min;
    }
}

