/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol.changes;

import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionRotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeContainer;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.util.Collections;

public class ChangeStoryAction
extends ChangeContainer {
    EmohawkCharacter character;
    StoryActionProperties oldActionProp;
    StoryActionProperties newActionProp;
    StoryAction currentAction;

    public EmohawkCharacter getCharacter() {
        return this.character;
    }

    public StoryAction getCurrentAction() {
        return this.currentAction;
    }

    public StoryActionProperties getNewActionProp() {
        return this.newActionProp;
    }

    public StoryActionProperties getOldActionProp() {
        return this.oldActionProp;
    }

    public boolean processChange(StoryController parent) {
        this.currentAction.setActionProperties(this.newActionProp);
        if (this.getChangeType() == ChangeType.ADD) {
            if (this.currentAction.getClass().equals(ActionAnimation.class)) {
                ActionAnimation aa = (ActionAnimation)this.currentAction;
                this.character.getAnimations().add((Object)aa);
                if (StoryTools.DEBUG) {
                    System.out.println("Animation was added, processChanged.");
                }
            } else if (this.currentAction.getClass().equals(ActionMovement.class)) {
                ActionMovement am = (ActionMovement)this.currentAction;
                this.character.addMovement(am);
            } else {
                ActionRotation ar = (ActionRotation)this.currentAction;
                this.character.addRotation(ar);
            }
        } else if (this.getChangeType() == ChangeType.DELETE) {
            if (this.currentAction.getClass().equals(ActionAnimation.class)) {
                ActionAnimation aa = (ActionAnimation)this.currentAction;
                this.character.getAnimations().remove((Object)aa);
                if (StoryTools.DEBUG) {
                    System.out.println("Animation was deleted, processChanged.");
                }
            } else if (this.currentAction.getClass().equals(ActionMovement.class)) {
                ActionMovement am = (ActionMovement)this.currentAction;
                this.character.getMovements().remove((Object)am);
            } else {
                ActionRotation ar = (ActionRotation)this.currentAction;
                this.character.getRotations().remove((Object)ar);
            }
        }
        return true;
    }

    public boolean processInverseChange(StoryController parent) {
        this.currentAction.setActionProperties(this.oldActionProp);
        if (this.getChangeType() == ChangeType.DELETE) {
            if (this.currentAction.getClass().equals(ActionAnimation.class)) {
                ActionAnimation aa = (ActionAnimation)this.currentAction;
                this.character.getAnimations().add((Object)aa);
                Collections.sort(this.character.getAnimations(), StoryTools.animOrderComparator());
            } else if (this.currentAction.getClass().equals(ActionMovement.class)) {
                ActionMovement am = (ActionMovement)this.currentAction;
                this.character.addMovement(am);
            } else {
                ActionRotation ar = (ActionRotation)this.currentAction;
                this.character.addRotation(ar);
            }
        } else if (this.getChangeType() == ChangeType.ADD) {
            if (this.currentAction.getClass().equals(ActionAnimation.class)) {
                ActionAnimation aa = (ActionAnimation)this.currentAction;
                this.character.getAnimations().remove((Object)aa);
            } else if (this.currentAction.getClass().equals(ActionMovement.class)) {
                ActionMovement am = (ActionMovement)this.currentAction;
                this.character.getMovements().remove((Object)am);
            } else {
                ActionRotation ar = (ActionRotation)this.currentAction;
                this.character.getRotations().remove((Object)ar);
            }
        }
        return true;
    }

    public ChangeStoryAction(ChangeStoryAction changeAction) {
        super(changeAction.changeType);
        this.character = changeAction.character;
        this.oldActionProp = new StoryActionProperties(changeAction.oldActionProp);
        this.newActionProp = new StoryActionProperties(changeAction.newActionProp);
        this.currentAction = changeAction.currentAction;
    }

    public ChangeStoryAction(ChangeType changeType, EmohawkCharacter character, StoryActionProperties oldActionProp, StoryActionProperties newActionProp, StoryAction currentAction) {
        super(changeType);
        this.character = character;
        this.oldActionProp = oldActionProp;
        this.newActionProp = newActionProp;
        this.currentAction = currentAction;
    }

    public ChangeStoryAction(ChangeType changeType, EmohawkCharacter character, StoryActionProperties actionProp, StoryAction action) {
        super(changeType);
        this.character = character;
        this.currentAction = action;
        this.newActionProp = actionProp;
        this.oldActionProp = actionProp;
    }
}

