/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol.changes;

import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeContainer;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.CharacterProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;

public class ChangeCharacter
extends ChangeContainer {
    int charId;
    CharacterProperties oldCharProp;
    CharacterProperties newCharProp;
    EmohawkCharacter character;

    public boolean processChange(StoryController parent) {
        if (this.getChangeType() == ChangeType.ADD) {
            if (this.character == null) {
                this.character = new EmohawkCharacter(parent, this.newCharProp);
                this.charId = this.character.id;
            }
            parent.addCharacter(this.character);
        } else if (this.getChangeType() == ChangeType.DELETE) {
            parent.removeCharacter(this.character);
        } else {
            this.character.getCharacterProperties().setCharacterProperties(this.newCharProp);
        }
        return true;
    }

    public boolean processInverseChange(StoryController parent) {
        if (this.getChangeType() == ChangeType.ADD) {
            parent.removeCharacter(this.character);
        } else if (this.getChangeType() == ChangeType.DELETE) {
            parent.addCharacter(this.character);
        } else {
            this.character.getCharacterProperties().setCharacterProperties(this.oldCharProp);
        }
        return true;
    }

    public int getCharId() {
        return this.charId;
    }

    public EmohawkCharacter getCharacter() {
        return this.character;
    }

    public CharacterProperties getNewCharProp() {
        return this.newCharProp;
    }

    public CharacterProperties getOldCharProp() {
        return this.oldCharProp;
    }

    public ChangeCharacter(ChangeType changeType, int charId, EmohawkCharacter character, CharacterProperties oldCharProp, CharacterProperties newCharProp) {
        super(changeType);
        this.charId = charId;
        this.character = character;
        this.oldCharProp = new CharacterProperties(oldCharProp);
        this.newCharProp = new CharacterProperties(newCharProp);
    }

    public ChangeCharacter(ChangeType changeType, int charId, EmohawkCharacter character) {
        super(changeType);
        this.charId = charId;
        this.character = character;
    }

    public ChangeCharacter(ChangeType changeType, CharacterProperties charProp) {
        super(changeType);
        this.oldCharProp = new CharacterProperties(charProp);
        this.newCharProp = new CharacterProperties(charProp);
    }
}

