/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol.changes;

import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeContainer;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeActionParent
extends ChangeContainer {
    List<ChangeStoryAction> changesList;

    public List<ChangeStoryAction> getChangesList() {
        return this.changesList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean processChange(StoryController parent) {
        long lastEnd = 0L;
        ChangeStoryAction lastAction = null;
        for (ChangeStoryAction action : this.changesList) {
            if (action.getChangeType().equals((Object)ChangeType.DELETE) || action.newActionProp.getTime() + action.newActionProp.getDuration() <= lastEnd) continue;
            lastEnd = action.newActionProp.getTime() + action.newActionProp.getDuration();
            lastAction = action;
        }
        if (lastAction != null) {
            if (parent.areDisallowedProperties(lastAction.newActionProp)) return false;
            if (StoryTools.DEBUG) {
                System.out.println("These properties are ok.");
            }
            for (ChangeStoryAction action : this.changesList) {
                action.processChange(parent);
            }
            return true;
        } else {
            for (ChangeStoryAction action : this.changesList) {
                action.processChange(parent);
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean processInverseChange(StoryController parent) {
        long lastEnd = 0L;
        ChangeStoryAction lastAction = null;
        for (ChangeStoryAction action : this.changesList) {
            if (action.getChangeType().equals((Object)ChangeType.ADD) || action.newActionProp.getTime() + action.newActionProp.getDuration() <= lastEnd) continue;
            lastEnd = action.newActionProp.getTime() + action.newActionProp.getDuration();
            lastAction = action;
        }
        if (lastAction != null) {
            if (parent.areDisallowedProperties(lastAction.oldActionProp)) return false;
            if (StoryTools.DEBUG) {
                System.out.println("These properties are ok.");
            }
            for (ChangeStoryAction action : this.changesList) {
                action.processInverseChange(parent);
            }
            return true;
        } else {
            for (ChangeStoryAction action : this.changesList) {
                action.processInverseChange(parent);
            }
        }
        return true;
    }

    public ChangeActionParent(List<ChangeStoryAction> changesList) {
        this.changesList = changesList;
    }
}

