/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol.action;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emonewt.gui.tools.AnimationInfo;

public class StoryActionProperties {
    protected long time;
    protected long duration;
    protected int order;
    protected String animationName;
    protected String description;
    protected Location end;
    protected int angleH;
    protected int angleV;
    protected int loopCount;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public int getAngleH() {
        return this.angleH;
    }

    public void setAngleH(int angle) {
        this.angleH = angle;
    }

    public int getAngleV() {
        return this.angleV;
    }

    public void setAngleV(int angleV) {
        this.angleV = angleV;
    }

    public String getAnimationName() {
        return this.animationName;
    }

    public void setAnimationId(String animationName) {
        this.animationName = animationName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public double getDurationInSeconds() {
        return (double)this.duration / 1000.0;
    }

    public void setDurationFromSeconds(double duration) {
        this.duration = Math.round(duration * 1000.0);
    }

    public Location getEnd() {
        return this.end;
    }

    public void setEnd(Location end) {
        this.end = end;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public double getTimeInSeconds() {
        return (double)this.time / 1000.0;
    }

    public void setTimeFromSeconds(double time) {
        this.duration = Math.round(time * 1000.0);
    }

    public StoryActionDiff getDiff(StoryActionProperties prop) {
        return new StoryActionDiff(this, prop);
    }

    public StoryActionProperties() {
    }

    public StoryActionProperties(StoryActionProperties SAP) {
        this.time = SAP.time;
        this.duration = SAP.duration;
        this.order = SAP.order;
        this.animationName = SAP.animationName;
        this.description = SAP.description;
        this.end = SAP.end;
        this.angleH = SAP.angleH;
        this.angleV = SAP.angleV;
        this.loopCount = SAP.loopCount;
    }

    public void changeActionProperties(AnimationInfo animInfo) {
        this.duration = animInfo.getDuration();
        this.animationName = animInfo.getAnimationId();
        this.description = animInfo.getLocalizedDescription();
    }

    public class StoryActionDiff {
        protected boolean timeChanged;
        protected boolean durationChanged;
        protected boolean orderChanged;
        protected boolean animationNameChanged;
        protected boolean descriptionChanged;
        protected boolean startChanged;
        protected boolean endChanged;
        protected boolean angleHChanged;
        protected boolean angleVChanged;
        protected boolean loopCountChanged;

        public boolean isEmptyChange() {
            return !this.timeChanged && !this.durationChanged && !this.orderChanged && !this.animationNameChanged && !this.descriptionChanged && !this.startChanged && !this.endChanged && !this.angleHChanged && !this.angleVChanged && !this.loopCountChanged;
        }

        public boolean isAngleHChanged() {
            return this.angleHChanged;
        }

        public boolean isAngleVChanged() {
            return this.angleVChanged;
        }

        public boolean isAnimationNameChanged() {
            return this.animationNameChanged;
        }

        public boolean isDescriptionChanged() {
            return this.descriptionChanged;
        }

        public boolean isDurationChanged() {
            return this.durationChanged;
        }

        public boolean isEndChanged() {
            return this.endChanged;
        }

        public boolean isLoopCountChanged() {
            return this.loopCountChanged;
        }

        public boolean isOrderChanged() {
            return this.orderChanged;
        }

        public boolean isStartChanged() {
            return this.startChanged;
        }

        public boolean isTimeChanged() {
            return this.timeChanged;
        }

        public StoryActionDiff(StoryActionProperties first, StoryActionProperties second) {
            if (first.getAngleH() != second.getAngleH()) {
                this.angleHChanged = true;
            }
            if (first.getAngleV() != second.getAngleV()) {
                this.angleVChanged = true;
            }
            if (first.getAnimationName() != null && second.getAnimationName() == null || first.getAnimationName() == null && second.getAnimationName() != null || first.getAnimationName() != null && second.getAnimationName() != null && !first.getAnimationName().equalsIgnoreCase(second.getAnimationName())) {
                this.animationNameChanged = true;
            }
            if (first.getDescription() == null && second.getDescription() != null || first.getDescription() != null && second.getDescription() == null || first.getDescription() != null && second.getDescription() != null && !first.getDescription().equalsIgnoreCase(second.getDescription())) {
                this.descriptionChanged = true;
            }
            if (first.getDuration() != second.getDuration()) {
                this.durationChanged = true;
            }
            if (first.getEnd() == null && second.getEnd() != null || first.getEnd() != null && second.getEnd() == null || first.getEnd() != null && second.getEnd() != null && !first.getEnd().equals(second.getEnd())) {
                this.endChanged = true;
            }
            if (first.getLoopCount() != second.getLoopCount()) {
                this.loopCountChanged = true;
            }
            if (first.getTime() != second.getTime()) {
                this.timeChanged = true;
            }
            if (first.getOrder() != second.getOrder()) {
                this.orderChanged = true;
            }
        }
    }
}

