/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol.action;

import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.io.Serializable;

public abstract class StoryAction
implements Serializable {
    private static int idIterator = 0;
    private transient EmohawkCharacter owner;
    protected int id;
    protected long time;
    protected long duration;
    protected String description;

    public EmohawkCharacter getOwner() {
        return this.owner;
    }

    public void setOwner(EmohawkCharacter owner) {
        this.owner = owner;
    }

    public StoryAction(EmohawkCharacter owner, long time, long duration, String description) {
        this.owner = owner;
        this.id = idIterator++;
        this.time = time;
        this.duration = duration;
        this.description = description;
    }

    public void setActionProperties(StoryActionProperties newProp) {
        this.time = newProp.getTime();
        this.duration = newProp.getDuration();
        this.description = newProp.getDescription();
    }

    public StoryActionProperties getActionProperties() {
        StoryActionProperties result = new StoryActionProperties();
        result.setTime(this.time);
        result.setDuration(this.duration);
        result.setDescription(this.description);
        return result;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public long getEndTime() {
        return this.time + this.duration;
    }

    public double getDurationInSeconds() {
        return (double)this.getDuration() / 1000.0;
    }

    public double getTimeInSeconds() {
        return (double)this.getTime() / 1000.0;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "StoryAction[OwnerId=" + this.owner.id + ",id=" + this.id + ",time=" + this.time + ",duration=" + this.duration + ",description=" + this.description + "]";
    }
}

