/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol.action;

import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.io.Serializable;

public class ActionRotation
extends StoryAction
implements Serializable {
    protected int angleH = 0;
    protected int angleV = 0;

    public int getAngleH() {
        return this.angleH;
    }

    public int getAngleV() {
        return this.angleV;
    }

    public int getRelativeHorizontalAngle() {
        int relativeUTAngle;
        int endUTAngle = this.getAngleH();
        int startUTAngle = (int)this.getOwner().getCharacterProperties().getStartRotation().yaw;
        Rotation previousRotation = this.getStartHorizontalAngle(this.time);
        if (previousRotation != null) {
            startUTAngle = (int)previousRotation.yaw;
        }
        for (relativeUTAngle = endUTAngle - startUTAngle; relativeUTAngle < Short.MIN_VALUE; relativeUTAngle += 65536) {
        }
        while (relativeUTAngle > Short.MAX_VALUE) {
            relativeUTAngle -= 65536;
        }
        return relativeUTAngle;
    }

    public ActionRotation(EmohawkCharacter owner, long time, long duration, int angleH, String description) {
        super(owner, time, duration, description);
        this.angleH = angleH;
        this.angleV = 0;
        this.description = description;
    }

    public ActionRotation(EmohawkCharacter owner, long time, long duration, int angleH, int angleV, String description) {
        super(owner, time, duration, description);
        this.angleH = angleH;
        this.angleV = angleV;
        this.description = description;
    }

    public void setActionProperties(StoryActionProperties newProp) {
        super.setActionProperties(newProp);
        this.angleH = newProp.getAngleH();
        this.angleV = newProp.getAngleV();
    }

    public StoryActionProperties getActionProperties() {
        StoryActionProperties result = super.getActionProperties();
        result.setAngleH(this.angleH);
        result.setAngleV(this.angleV);
        return result;
    }

    public Rotation getStartHorizontalAngle(long time) {
        Rotation startRotation = this.getOwner().getCharacterProperties().getStartRotation();
        Rotation result = new Rotation(startRotation);
        long prevTime = Long.MIN_VALUE;
        for (ActionRotation rot : this.getOwner().getRotations()) {
            if (rot.getTime() >= time || rot.getTime() + rot.getDuration() > time || prevTime >= rot.getTime()) continue;
            result.yaw = rot.getAngleH();
            prevTime = rot.getTime();
        }
        return result;
    }

    public Rotation getEndHorizontalAngle(long time) {
        Rotation result = this.getStartHorizontalAngle(time);
        result.yaw = this.getAngleH();
        return result;
    }

    public double getRelativeVerticalAngle() {
        int relativeUTAngle;
        int endUTAngle = this.getAngleV();
        int startUTAngle = (int)this.getOwner().getCharacterProperties().getStartRotation().pitch;
        Rotation previousRotation = this.getStartVerticalAngle(this.time);
        if (previousRotation != null) {
            startUTAngle = (int)previousRotation.pitch;
        }
        for (relativeUTAngle = endUTAngle - startUTAngle; relativeUTAngle < Short.MIN_VALUE; relativeUTAngle += 65536) {
        }
        while (relativeUTAngle > Short.MAX_VALUE) {
            relativeUTAngle -= 65536;
        }
        return relativeUTAngle;
    }

    private Rotation getStartVerticalAngle(long time) {
        Rotation startRotation = this.getOwner().getCharacterProperties().getStartRotation();
        Rotation result = new Rotation(startRotation);
        long prevTime = Long.MIN_VALUE;
        for (ActionRotation rot : this.getOwner().getRotations()) {
            if (rot.getTime() >= time || rot.getTime() + rot.getDuration() > time || prevTime >= rot.getTime()) continue;
            result.pitch = rot.getAngleV();
            prevTime = rot.getTime();
        }
        return result;
    }
}

