/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol.action;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.utils.collections.ObservableList;
import java.io.Serializable;

public class ActionMovement
extends StoryAction
implements Serializable {
    protected Location end;

    public Location getEnd() {
        return new Location(this.end);
    }

    public ActionMovement(EmohawkCharacter owner, long time, long duration, Location end, String description) {
        super(owner, time, duration, description);
        this.end = new Location(end);
    }

    public void setActionProperties(StoryActionProperties newProp) {
        super.setActionProperties(newProp);
        this.end = newProp.getEnd();
    }

    public StoryActionProperties getActionProperties() {
        StoryActionProperties result = super.getActionProperties();
        result.setEnd(this.end);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[end=" + this.end + "]";
    }

    public Location getStart() {
        EmohawkCharacter character = this.getOwner();
        ObservableList<ActionMovement> allMoves = character.getMovements();
        int index = allMoves.indexOf(this);
        if (index == 0) {
            return character.getCharacterProperties().getStartLocation();
        }
        return ((ActionMovement)allMoves.get(index - 1)).getEnd();
    }

    public ActionMovement getPreviousMovement() {
        ObservableList<ActionMovement> moves = this.getOwner().getMovements();
        int index = moves.indexOf(this);
        if (index == -1) {
            throw new IllegalStateException("ActionMovement " + this + " is not in list of movements.");
        }
        if (index > 0) {
            return (ActionMovement)moves.get(index - 1);
        }
        return null;
    }

    public ActionMovement getNextMovement() {
        ObservableList<ActionMovement> moves = this.getOwner().getMovements();
        int index = moves.indexOf(this);
        if (index == -1) {
            throw new IllegalStateException("ActionMovement " + this + " is not in list of movements.");
        }
        if (index + 1 < moves.size()) {
            return (ActionMovement)moves.get(index + 1);
        }
        return null;
    }
}

