/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol.action;

import cz.cuni.amis.pogamut.emonewt.gui.tools.AnimationInfo;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.io.Serializable;

public class ActionAnimation
extends StoryAction
implements Serializable {
    protected String animationID;
    protected int loopCount;
    protected int order;

    public String getAnimationId() {
        return this.animationID;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public int getOrder() {
        return this.order;
    }

    public ActionAnimation(EmohawkCharacter owner, int time, int duration, String animationName, String description, int loopCount, int order) {
        super(owner, time, duration, description);
        this.animationID = animationName;
        this.loopCount = loopCount;
        this.order = order;
    }

    public ActionAnimation(EmohawkCharacter owner, AnimationInfo animInfo, int time, int loopCount, int order) {
        super(owner, time, animInfo.getDuration() * (long)loopCount, animInfo.getLocalizedDescription());
        this.animationID = animInfo.getAnimationId();
        this.loopCount = loopCount;
        this.order = order;
    }

    public void setActionProperties(StoryActionProperties newProp) {
        super.setActionProperties(newProp);
        this.animationID = newProp.getAnimationName();
        this.order = newProp.order;
        this.loopCount = newProp.loopCount;
    }

    public StoryActionProperties getActionProperties() {
        StoryActionProperties result = super.getActionProperties();
        result.setAnimationId(this.animationID);
        result.setLoopCount(this.loopCount);
        result.setOrder(this.order);
        return result;
    }

    public String toString() {
        return "ActionAnimation[id=" + this.id + ",time=" + this.time + ",duration=" + this.duration + ",animationName=" + this.animationID + ",description=" + this.description + ",loopCount=" + this.loopCount + "]";
    }
}

