/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol;

import cz.cuni.amis.pogamut.emonewt.storycontrol.IUndoRedoListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeContainer;
import cz.cuni.amis.utils.collections.ObservableList;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoRedoController {
    StoryController model;
    protected LinkedList<IUndoRedoListener> undoRedoListeners = new LinkedList();

    public void addUndoRedoListener(IUndoRedoListener newListener) {
        this.undoRedoListeners.add(newListener);
    }

    public void removeUndoRedoListener(IUndoRedoListener newListener) {
        this.undoRedoListeners.remove(newListener);
    }

    public ObservableList<ChangeContainer> getChangeActions() {
        return this.model.getChangeActions();
    }

    public ChangeContainer getActualChangePosition() {
        return this.model.getActualChangePosition();
    }

    public void setActualChangePosition(ChangeContainer pos) {
        this.model.actualChangeAction = pos;
    }

    public void undo() {
        ObservableList<ChangeContainer> changeActions = this.getChangeActions();
        if (changeActions.isEmpty()) {
            return;
        }
        ChangeContainer actualChange = this.getActualChangePosition();
        if (actualChange == null) {
            this.setActualChangePosition((ChangeContainer)changeActions.get(changeActions.size() - 1));
            actualChange = this.getActualChangePosition();
        }
        int i = changeActions.indexOf((Object)actualChange);
        if (actualChange.isChangeDone()) {
            if (this.processTasksUndo(actualChange)) {
                actualChange.setChangeDone(false);
            }
        } else if (i > 0) {
            this.setActualChangePosition((ChangeContainer)changeActions.get(i - 1));
            actualChange = this.getActualChangePosition();
            if (actualChange.isChangeDone() && this.processTasksUndo(actualChange)) {
                actualChange.setChangeDone(false);
            }
        }
    }

    public void redo() {
        ObservableList<ChangeContainer> changeActions = this.getChangeActions();
        if (changeActions.isEmpty()) {
            return;
        }
        ChangeContainer actualChange = this.getActualChangePosition();
        if (actualChange == null) {
            this.setActualChangePosition((ChangeContainer)changeActions.get(changeActions.size() - 1));
            actualChange = this.getActualChangePosition();
        }
        int i = changeActions.indexOf((Object)actualChange);
        if (!actualChange.isChangeDone()) {
            if (this.processTasksRedo(actualChange)) {
                actualChange.setChangeDone(true);
            }
        } else if (i < changeActions.size() - 1) {
            this.setActualChangePosition((ChangeContainer)changeActions.get(i + 1));
            actualChange = this.getActualChangePosition();
            if (!actualChange.isChangeDone() && this.processTasksRedo(actualChange)) {
                actualChange.setChangeDone(true);
            }
        }
    }

    public void checkThrowAwayOfRestOfChangeList() {
        ObservableList<ChangeContainer> changeActions = this.getChangeActions();
        if (changeActions.isEmpty() || this.getActualChangePosition() == null) {
            return;
        }
        Iterator itCh = changeActions.iterator();
        boolean bPassed = false;
        while (itCh.hasNext()) {
            ChangeContainer current = (ChangeContainer)itCh.next();
            if (bPassed) {
                itCh.remove();
            }
            if (bPassed || !current.equals(this.getActualChangePosition())) continue;
            if (!current.isChangeDone()) {
                itCh.remove();
            }
            bPassed = true;
        }
    }

    private boolean processTasksUndo(ChangeContainer changePos) {
        if (changePos.processInverseChange(this.model)) {
            for (IUndoRedoListener l : this.undoRedoListeners) {
                l.undoRedoPerformed(changePos, true);
            }
            return true;
        }
        return false;
    }

    private boolean processTasksRedo(ChangeContainer changePos) {
        if (changePos.processChange(this.model)) {
            for (IUndoRedoListener l : this.undoRedoListeners) {
                l.undoRedoPerformed(changePos, false);
            }
            return true;
        }
        return false;
    }

    public UndoRedoController(StoryController model) {
        this.model = model;
    }
}

