/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryControlServer;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ECharacterType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkLivingCharacter;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetSkin;
import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;

public class StoryPlayer {
    private final StoryController model;
    private StoryControlServer controlServer;
    private double startStoryTimeUT;
    private boolean bCharacterInitialized;
    private boolean bStoryPlaying;
    private boolean bInitPlayingSequenceOn = false;
    private static double TIME_MS_MULTIPLIER = 1000.0;
    private static Process utProcess;
    private EmohawkCharacter firstCamera;
    private EmohawkCharacter secondCamera;
    private long startStoryTime;

    public double getStartStoryTimeUT() {
        return this.startStoryTimeUT;
    }

    public EmohawkCharacter getFirstCamera() {
        return this.firstCamera;
    }

    public EmohawkCharacter getSecondCamera() {
        return this.secondCamera;
    }

    public long getStartStoryTime() {
        return this.startStoryTime;
    }

    public void launchSpectate(String host) throws IOException {
        String path = Pogamut.getPlatform().getProperty(PogamutUT2004Property.POGAMUT_UNREAL_HOME.getKey()) + File.separator + "System" + File.separator;
        List<String> cmds = null;
        if (System.getProperty("os.name").contains("Windows")) {
            path = path + "UE2Runtime.exe";
            InetAddress adr = InetAddress.getByName(host);
            cmds = Arrays.asList("cmd.exe", "/c", "start \"UT2004 Spectate\" /low \"" + path + "\" " + adr.getHostAddress());
        }
        ProcessBuilder builder = new ProcessBuilder(cmds);
        utProcess = builder.start();
    }

    public static Process getUtProcess() {
        return utProcess;
    }

    public void destroySpectate() {
        StoryPlayer.getUtProcess().destroy();
    }

    public StoryPlayer(StoryController model) {
        this.model = model;
    }

    public boolean isStoryPlaying() {
        return this.bStoryPlaying;
    }

    public StoryControlServer getControlServer() {
        return this.controlServer;
    }

    public void startPlaying(long time) {
        if (StoryTools.DEBUG) {
            System.out.println("StoryPlayer.startPlaying(): The play is starting.");
        }
        this.bInitPlayingSequenceOn = true;
        this.startStoryTime = time;
        if (this.controlServer == null) {
            this.controlServer = StoryControlServer.createServer(this);
        }
        for (EmohawkCharacter ec : this.model.getStoryCharacters()) {
            if (ec.getCharacterProperties().getCharacterClass().equals((Object)ECharacterType.CAMERA) || ec.getAvatar() != null) continue;
            EmohawkLivingCharacter live = EmohawkLivingCharacter.createAvatar(ec);
            ec.setAvatar(live);
        }
        if (StoryTools.DEBUG) {
            System.out.println("StoryPlayer.startPlaying(): Characters initialized.");
        }
        this.firstCamera = null;
        this.secondCamera = null;
        this.startStoryTimeUT = this.controlServer.getCurrentUTTime() * TIME_MS_MULTIPLIER;
        for (EmohawkCharacter ec : this.model.getStoryCharacters()) {
            if (StoryTools.DEBUG) {
                System.out.println("Starting character: " + ec.getName());
            }
            if (ec.getCharacterProperties().getCharacterClass().equals((Object)ECharacterType.CAMERA)) {
                if (this.firstCamera == null) {
                    this.firstCamera = ec;
                    continue;
                }
                if (this.secondCamera != null) continue;
                this.secondCamera = ec;
                continue;
            }
            if (ec.getAvatar() != null) {
                ec.getAvatar().setStartStoryTimeUT(this.startStoryTimeUT);
                ec.getAvatar().setStartStoryTime(time);
                ec.getAvatar().setInitialPosition(time);
                ec.getAvatar().setbIsStoryPlaying(true);
                String clothes = Integer.valueOf(ec.getCharacterProperties().getBodyTexture().getTextureID()).toString();
                String skin = Integer.valueOf(ec.getCharacterProperties().getSkinTexture().getTextureID()).toString();
                ec.getAvatar().getAct().act((CommandMessage)new SetSkin().setURClothes(clothes).setURSkin(skin));
                continue;
            }
            throw new PogamutException("Avatar is null", (Object)this);
        }
        this.bCharacterInitialized = true;
        this.bStoryPlaying = true;
        this.controlServer.startPlaying(time);
        this.bInitPlayingSequenceOn = false;
    }

    public void notifyGameTick(double time) {
        if (this.bStoryPlaying) {
            long storyTime = (long)((double)Math.round(time * TIME_MS_MULTIPLIER) - this.startStoryTimeUT);
            for (EmohawkCharacter ec : this.model.getStoryCharacters()) {
                if (ec.getAvatar() != null) {
                    ec.getAvatar().playNextActions(time * TIME_MS_MULTIPLIER);
                    continue;
                }
                if (ec.getCharacterProperties().getCharacterClass().equals((Object)ECharacterType.CAMERA)) continue;
                throw new PogamutException("Avatar is null", (Object)this);
            }
        }
    }

    public void stopPlaying() {
        if (StoryTools.DEBUG) {
            System.out.println("StoryPlayer.stopPlaying(): The play stopped.");
        }
        this.controlServer.stopPlaying();
        if (this.bInitPlayingSequenceOn) {
            return;
        }
        for (EmohawkCharacter ec : this.model.getStoryCharacters()) {
            if (ec.getAvatar() == null) continue;
            ec.getAvatar().stopPlaying();
        }
        this.bCharacterInitialized = false;
        this.bStoryPlaying = false;
    }

    public void animationPreview(ActionAnimation animation, boolean bLoop) {
        if (StoryTools.DEBUG) {
            System.out.println("StoryPlayer.animationPreview(): Animation preview started.");
        }
        EmohawkCharacter character = animation.getOwner();
        this.bInitPlayingSequenceOn = true;
        if (this.controlServer == null) {
            this.controlServer = StoryControlServer.createServer(this);
        }
        boolean wasNull = false;
        if (character.getAvatar() == null) {
            wasNull = true;
            EmohawkLivingCharacter live = EmohawkLivingCharacter.createAvatar(character);
            character.setAvatar(live);
        }
        this.bCharacterInitialized = true;
        if (character.getAvatar() != null) {
            if (wasNull) {
                character.getAvatar().setInitialPosition(0L);
            }
            character.getAvatar().playAnim(animation, bLoop);
        } else if (!character.getCharacterProperties().getCharacterClass().equals((Object)ECharacterType.CAMERA)) {
            throw new PogamutException("Avatar is null", (Object)this);
        }
        this.bInitPlayingSequenceOn = false;
    }

    public void characterPreview(EmohawkCharacter character, String clothes, String skin) {
        this.bInitPlayingSequenceOn = true;
        if (this.controlServer == null) {
            this.controlServer = StoryControlServer.createServer(this);
        }
        boolean wasNull = false;
        if (character.getAvatar() == null) {
            wasNull = true;
            EmohawkLivingCharacter live = EmohawkLivingCharacter.createAvatar(character);
            character.setAvatar(live);
        }
        this.bCharacterInitialized = true;
        if (character.getAvatar() != null) {
            if (wasNull) {
                character.getAvatar().setInitialPosition(0L);
            }
            character.getAvatar().getAct().act((CommandMessage)new SetSkin().setURClothes(clothes).setURSkin(skin));
            if (StoryTools.DEBUG) {
                System.out.println("StoryPLayer.characterPreview(): Character " + character.getName() + " textura: " + clothes + " skin " + skin);
            }
        } else if (!character.getCharacterProperties().getCharacterClass().equals((Object)ECharacterType.CAMERA)) {
            throw new PogamutException("Avatar is null", (Object)this);
        }
        character.avatar.stopPlaying();
        this.bInitPlayingSequenceOn = false;
    }

    long getCurrentStoryTime() {
        return this.model.getCurrentStoryTime();
    }

    public void startControlServer() {
        this.controlServer = StoryControlServer.createServer(this);
    }
}

