/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.gui.chars.PColorGenerator;
import cz.cuni.amis.pogamut.emonewt.gui.tools.AnimationInfo;
import cz.cuni.amis.pogamut.emonewt.gui.tools.AnimationsStorage;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.ICharacterNumberChangeListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IScaleChangeListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryLenghtChangeListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IUndoRedoListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettingsSave;
import cz.cuni.amis.pogamut.emonewt.storycontrol.UndoRedoController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionRotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeActionParent;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeCharacter;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeContainer;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.CharacterProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EBodyTexType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ECharacterType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ESkinTexType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacterSave;
import cz.cuni.amis.utils.collections.ObservableList;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryController {
    public long currentStoryTime;
    protected ObservableList<ChangeContainer> changeActions;
    protected ChangeContainer actualChangeAction;
    protected ObservableList<EmohawkCharacter> storyCharacters;
    protected UndoRedoController undoRedoController;
    protected StorySettings settings;
    public AnimationsStorage animations;
    public PColorGenerator colorsGenerator = new PColorGenerator();
    private LinkedList<ICharacterNumberChangeListener> charListeners = new LinkedList();
    private final HashSet<StoryControllerListener> listeners = new HashSet();

    public void addCharacterNumberChangeListener(ICharacterNumberChangeListener listener) {
        this.charListeners.add(listener);
    }

    public void addUndoRedoListener(IUndoRedoListener newListener) {
        this.undoRedoController.addUndoRedoListener(newListener);
    }

    public void removeUndoRedoListener(IUndoRedoListener newListener) {
        this.undoRedoController.removeUndoRedoListener(newListener);
    }

    public void addScaleListener(IScaleChangeListener newListener) {
        this.settings.addScaleChangedListener(newListener);
    }

    public ChangeContainer getActualChangePosition() {
        return this.actualChangeAction;
    }

    public ObservableList<ChangeContainer> getChangeActions() {
        return this.changeActions;
    }

    public void clearChanges() {
        this.getChangeActions().clear();
        this.actualChangeAction = null;
    }

    public synchronized ObservableList<EmohawkCharacter> getStoryCharacters() {
        return this.storyCharacters;
    }

    public int getCamerasCount() {
        int count = 0;
        for (EmohawkCharacter charac : this.storyCharacters) {
            if (!charac.getCharacterProperties().getCharacterClass().equals((Object)ECharacterType.CAMERA)) continue;
            ++count;
        }
        return count;
    }

    public void addCharacters(ObservableList<EmohawkCharacter> storyCharacters) {
        for (EmohawkCharacter character : storyCharacters) {
            this.addCharacter(character);
        }
    }

    public float getScale() {
        return this.settings.getScale();
    }

    public void setScale(float newScale) {
        this.settings.setScale(newScale);
    }

    public long getStoryLength() {
        return this.settings.getStoryLength();
    }

    public long getStoryEnd() {
        long max = 0L;
        for (EmohawkCharacter ec : this.getStoryCharacters()) {
            for (ActionAnimation anim : ec.getAnimations()) {
                if (anim.getEndTime() <= max) continue;
                max = anim.getEndTime();
            }
            for (ActionMovement move : ec.getMovements()) {
                if (move.getEndTime() <= max) continue;
                max = move.getEndTime();
            }
            for (ActionRotation rot : ec.getRotations()) {
                if (rot.getEndTime() <= max) continue;
                max = rot.getEndTime();
            }
        }
        return max;
    }

    private void deleteAllActionsAfterTheStoryLength() {
        LinkedList<ChangeStoryAction> changesList = new LinkedList<ChangeStoryAction>();
        for (EmohawkCharacter ec : this.getStoryCharacters()) {
            ChangeStoryAction newChange;
            for (StoryAction a : ec.getAnimations()) {
                if (a.getTime() + a.getDuration() <= this.getStoryLength()) continue;
                newChange = new ChangeStoryAction(ChangeType.DELETE, ec, ((ActionAnimation)a).getActionProperties(), a);
                changesList.add(newChange);
            }
            for (StoryAction a : ec.getMovements()) {
                if (a.getTime() + a.getDuration() <= this.getStoryLength()) continue;
                newChange = new ChangeStoryAction(ChangeType.DELETE, ec, ((ActionMovement)a).getActionProperties(), a);
                changesList.add(newChange);
            }
            for (StoryAction a : ec.getRotations()) {
                if (a.getTime() + a.getDuration() <= this.getStoryLength()) continue;
                newChange = new ChangeStoryAction(ChangeType.DELETE, ec, ((ActionRotation)a).getActionProperties(), a);
                changesList.add(newChange);
            }
        }
        if (StoryTools.DEBUG) {
            System.out.println("PROCESSING DELETE ACTION CHANGE");
        }
        this.undoRedoController.checkThrowAwayOfRestOfChangeList();
        ChangeActionParent newContainer = new ChangeActionParent(changesList);
        ((ChangeContainer)newContainer).processChange(this);
        newContainer.setChangeDone(true);
        this.changeActions.add((Object)newContainer);
        this.actualChangeAction = newContainer;
        for (EmohawkCharacter ec : this.getStoryCharacters()) {
            Collections.sort(ec.getAnimations(), StoryTools.animOrderComparator());
            Collections.sort(ec.getMovements(), StoryTools.actionTimeComparator());
            Collections.sort(ec.getRotations(), StoryTools.actionTimeComparator());
        }
    }

    public void setStoryLength(long storyLength) {
        long oldStoryLength = this.getSettings().getStoryLength();
        if (oldStoryLength > storyLength && this.getTimeOfTheLastActionOfAllCharacters() > storyLength) {
            int result;
            if (StoryTools.DEBUG) {
                System.out.println("Too short story length. We have some actions there.");
            }
            if ((result = JOptionPane.showConfirmDialog(null, StorySettings.currentBundle.getString("ASKDELETESTORYLENGTH"))) == 0) {
                if (StoryTools.DEBUG) {
                    System.out.println("Opravdu zkr\u00e1tit a smazat akce, kter\u00e9 p\u0159esahuj\u00ed.");
                }
                this.getSettings().setStoryLength(storyLength);
                this.deleteAllActionsAfterTheStoryLength();
            } else {
                if (StoryTools.DEBUG) {
                    System.out.println("Nechat p\u016fvodn\u00ed d\u00e9lku sc\u00e9nky.");
                }
                return;
            }
        }
        this.getSettings().setStoryLength(storyLength);
    }

    private long getTimeOfTheLastActionOfAllCharacters() {
        long time = 0L;
        for (EmohawkCharacter ch : this.getStoryCharacters()) {
            if (ch.getTimeOfTheLastAction() <= time) continue;
            time = ch.getTimeOfTheLastAction();
        }
        return time;
    }

    public void setSnappingTime(long snappingTime) {
        this.settings.setSNAPPING_TIME(snappingTime);
    }

    public long getSnappingTime() {
        return this.settings.getSNAPPING_TIME();
    }

    public long getCurrentStoryTime() {
        return this.currentStoryTime;
    }

    public boolean processChangeCharacter(ChangeCharacter changeChar) {
        changeChar.processChange(this);
        this.undoRedoController.checkThrowAwayOfRestOfChangeList();
        changeChar.setChangeDone(true);
        this.changeActions.add((Object)changeChar);
        this.actualChangeAction = changeChar;
        return true;
    }

    public void notifyCharacterNumberChangedListeners() {
        for (ICharacterNumberChangeListener listener : this.charListeners) {
            listener.characterNumberChanged();
        }
    }

    public synchronized boolean processChangeStoryAction(ChangeStoryAction changeAction, boolean bShiftRight) {
        if (changeAction.getCurrentAction().getClass().equals(ActionAnimation.class)) {
            return this.processChangeAnimation(changeAction);
        }
        if (changeAction.getCurrentAction().getClass().equals(ActionMovement.class)) {
            return this.processChangeMovement(changeAction, bShiftRight);
        }
        if (changeAction.getCurrentAction().getClass().equals(ActionRotation.class)) {
            return this.processChangeRotation(changeAction, bShiftRight);
        }
        return false;
    }

    public synchronized boolean processChangeStoryAction(ChangeStoryAction changeAction) {
        return this.processChangeStoryAction(changeAction, false);
    }

    public void undo() {
        this.undoRedoController.undo();
    }

    public void redo() {
        this.undoRedoController.redo();
    }

    public void resetModel() {
        this.removeAllCharacters();
        this.clearChanges();
    }

    public void save(String file) throws IOException {
        FileOutputStream f_out = new FileOutputStream(file);
        ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
        Integer count = this.storyCharacters.size();
        obj_out.writeObject(count);
        obj_out.writeObject(this.getSettings().getStoryLength());
        for (EmohawkCharacter ec : this.storyCharacters) {
            EmohawkCharacterSave charSave = new EmohawkCharacterSave(ec);
            obj_out.writeObject(charSave);
        }
        obj_out.close();
        f_out.close();
    }

    public void load(String file) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream f_in = new FileInputStream(file);
        ObservableList newStoryCharacters = new ObservableList(new ArrayList());
        ObjectInputStream obj_in = new ObjectInputStream(f_in);
        Integer count = (Integer)obj_in.readObject();
        this.setStoryLength((Long)obj_in.readObject());
        int maxId = 0;
        for (int i = 0; i < count; ++i) {
            EmohawkCharacterSave emoCharSave = (EmohawkCharacterSave)obj_in.readObject();
            EmohawkCharacter character = new EmohawkCharacter(this, emoCharSave);
            if (emoCharSave.id > maxId) {
                maxId = emoCharSave.id;
            }
            emoCharSave.setOwnerToActions(character);
            newStoryCharacters.add((Object)character);
        }
        EmohawkCharacter.idIterator = maxId + 1;
        this.resetModel();
        this.addCharacters((ObservableList<EmohawkCharacter>)newStoryCharacters);
        this.clearChanges();
    }

    public StorySettings getSettings() {
        return this.settings;
    }

    public StoryController() {
        this.animations = new AnimationsStorage();
        this.undoRedoController = new UndoRedoController(this);
        StorySettingsSave savedSettings = StoryTools.loadSettings(".\\config\\settings.xml");
        this.settings = new StorySettings(savedSettings);
        this.changeActions = new ObservableList(new ArrayList());
        this.storyCharacters = new ObservableList(new ArrayList());
        CharacterProperties charProp = new CharacterProperties("Thomas");
        charProp.setStartLocation(new Location(-1800.0, -1470.0, -3420.0));
        charProp.setCharacterClass(ECharacterType.THOMAS);
        charProp.setBodyTexture(EBodyTexType.THOMAS_TEX01);
        charProp.setSkinTexture(ESkinTexType.THOMAS_TEX01);
        EmohawkCharacter ec = new EmohawkCharacter(this, charProp);
        ec.getAnimations().add((Object)new ActionAnimation(ec, this.animations.getAnimation(ec.getCharacterProperties().getCharacterClass(), "walk_loop"), 0, 15, 1));
        ec.getAnimations().add((Object)new ActionAnimation(ec, this.animations.getAnimation(ec.getCharacterProperties().getCharacterClass(), "social_explain"), 15500, 1, 2));
        ec.addMovement(new ActionMovement(ec, 0L, 15500L, new Location(418.0, -1441.0, -3420.0), ""));
        ec.addRotation(new ActionRotation(ec, 15500L, 5000L, 15600, ""));
        this.storyCharacters.add((Object)ec);
        charProp = new CharacterProperties("Barbara");
        charProp.setStartLocation(new Location(3140.0, -1441.0, -3420.0));
        charProp.setStartRotation(new Rotation(0.0, 32767.0, 0.0));
        charProp.setCharacterClass(ECharacterType.BARBARA);
        charProp.setBodyTexture(EBodyTexType.BARBARA_TEX01);
        charProp.setSkinTexture(ESkinTexType.BARBARA_TEX01);
        ec = new EmohawkCharacter(this, charProp);
        ec.getAnimations().add((Object)new ActionAnimation(ec, this.animations.getAnimation(ec.getCharacterProperties().getCharacterClass(), "walk_loop"), 0, 15, 1));
        ec.getAnimations().add((Object)new ActionAnimation(ec, this.animations.getAnimation(ec.getCharacterProperties().getCharacterClass(), "social_explain"), 15500, 1, 2));
        ec.addMovement(new ActionMovement(ec, 0L, 15500L, new Location(1186.0, -1441.0, -3420.0), ""));
        ec.addRotation(new ActionRotation(ec, 15500L, 5000L, 15600, ""));
        this.storyCharacters.add((Object)ec);
    }

    private EmohawkCharacter getCharacter(int charId) {
        for (EmohawkCharacter ec : this.getStoryCharacters()) {
            if (ec.id != charId) continue;
            return ec;
        }
        return null;
    }

    public void addCharacter(EmohawkCharacter character) {
        this.getStoryCharacters().add((Object)character);
        this.notifyCharacterNumberChangedListeners();
    }

    public void removeCharacter(EmohawkCharacter character) {
        if (character.getAvatar() != null) {
            character.getAvatar().stopBot();
        }
        this.getStoryCharacters().remove((Object)character);
        this.notifyCharacterNumberChangedListeners();
    }

    public void removeAllCharacters() {
        ObservableList charactersToRemove = new ObservableList(new ArrayList());
        for (EmohawkCharacter character : this.getStoryCharacters()) {
            charactersToRemove.add((Object)character);
        }
        for (EmohawkCharacter character : charactersToRemove) {
            this.removeCharacter(character);
        }
    }

    public List<AnimationInfo> getAnimations(EmohawkCharacter character) {
        return this.animations.getAnimations(character.getCharacterProperties().getCharacterClass());
    }

    public AnimationInfo getCameraAnim(boolean bActive) {
        List<AnimationInfo> anims = this.animations.getAnimations(ECharacterType.CAMERA);
        for (AnimationInfo anim : anims) {
            if (bActive && anim.getAnimationId().toLowerCase().equals("active")) {
                return anim;
            }
            if (bActive || !anim.getAnimationId().toLowerCase().equals("inactive")) continue;
            return anim;
        }
        return null;
    }

    public boolean areDisallowedProperties(StoryActionProperties sap) {
        if (sap.getTime() + sap.getDuration() > this.settings.getStoryLength()) {
            int result;
            if (StoryTools.DEBUG) {
                System.out.println("This action ends outside the story.");
            }
            if ((result = JOptionPane.showConfirmDialog(null, StorySettings.currentBundle.getString("PROLONG"))) == 0) {
                if (StoryTools.DEBUG) {
                    System.out.println("We must prolong the story length.");
                }
                this.setStoryLength(sap.getTime() + sap.getDuration());
            } else {
                if (StoryTools.DEBUG) {
                    System.out.println("We won't prolong the story length.");
                }
                return true;
            }
        }
        if (sap.getDuration() <= 0L) {
            if (StoryTools.DEBUG) {
                System.out.println("Negative duration is forbidden.");
            }
            return true;
        }
        if (sap.getTime() < 0L) {
            if (StoryTools.DEBUG) {
                System.out.println("Negative time is forbidden.");
            }
            return true;
        }
        return false;
    }

    private void changingOrder(ChangeStoryAction changeAction, LinkedList<ChangeStoryAction> changesList, int oldOrder, int newOrder) {
        boolean isLatest = true;
        if (oldOrder > newOrder) {
            StoryAction lastAnim = null;
            for (ActionAnimation anim : changeAction.getCharacter().getAnimations()) {
                if (anim.getOrder() >= newOrder && anim.getOrder() < oldOrder) {
                    StoryActionProperties oldProp = anim.getActionProperties();
                    StoryActionProperties newProp = new StoryActionProperties(oldProp);
                    if (anim.getOrder() == newOrder) {
                        if (lastAnim == null) {
                            changeAction.getNewActionProp().setTime(0L);
                        } else {
                            changeAction.getNewActionProp().setTime(anim.getTime());
                            if (this.areDisallowedProperties(changeAction.getNewActionProp())) {
                                return;
                            }
                        }
                        newProp.setTime(changeAction.getNewActionProp().getTime() + changeAction.getNewActionProp().getDuration());
                        if (this.areDisallowedProperties(newProp)) {
                            return;
                        }
                        isLatest = false;
                    } else if (anim.getOrder() > newOrder && anim.getOrder() < oldOrder) {
                        newProp.setTime(anim.getTime() + changeAction.getNewActionProp().getDuration());
                        if (this.areDisallowedProperties(newProp)) {
                            return;
                        }
                    }
                    newProp.setOrder(anim.getOrder() + 1);
                    ChangeStoryAction newChange = new ChangeStoryAction(ChangeType.CHANGE, changeAction.getCharacter(), oldProp, newProp, anim);
                    changesList.add(newChange);
                }
                lastAnim = anim;
            }
            if (isLatest) {
                if (lastAnim == null) {
                    changeAction.getNewActionProp().setTime(0L);
                } else {
                    changeAction.getNewActionProp().setTime(lastAnim.getTime() + lastAnim.getDuration());
                    if (this.areDisallowedProperties(changeAction.getNewActionProp())) {
                        return;
                    }
                }
            }
        } else if (oldOrder < newOrder) {
            long newTime = 0L;
            for (ActionAnimation anim : changeAction.getCharacter().getAnimations()) {
                if (anim.getOrder() <= oldOrder || anim.getOrder() > newOrder) continue;
                StoryActionProperties oldProp = anim.getActionProperties();
                StoryActionProperties newProp = new StoryActionProperties(oldProp);
                if (anim.getOrder() == newOrder) {
                    newTime = anim.getTime() - changeAction.getNewActionProp().getDuration() + anim.getDuration();
                }
                if (anim.getOrder() == oldOrder + 1) {
                    newProp.setTime(changeAction.getOldActionProp().getTime());
                    if (this.areDisallowedProperties(newProp)) {
                        return;
                    }
                } else if (anim.getOrder() > oldOrder && anim.getOrder() <= newOrder) {
                    newProp.setTime(anim.getTime() - changeAction.getNewActionProp().getDuration());
                    if (this.areDisallowedProperties(newProp)) {
                        return;
                    }
                }
                newProp.setOrder(anim.getOrder() - 1);
                ChangeStoryAction newChange = new ChangeStoryAction(ChangeType.CHANGE, changeAction.getCharacter(), oldProp, newProp, anim);
                changesList.add(newChange);
            }
            changeAction.getNewActionProp().setTime(newTime);
            if (this.areDisallowedProperties(changeAction.getNewActionProp())) {
                return;
            }
        } else {
            return;
        }
        changesList.add(changeAction);
    }

    private void processChangeOrder(ChangeStoryAction changeAction, LinkedList<ChangeStoryAction> changesList) {
        int oldOrder = changeAction.getOldActionProp().getOrder();
        int newOrder = changeAction.getNewActionProp().getOrder();
        if (newOrder > changeAction.getCharacter().getAnimations().size() || newOrder < 1) {
            if (StoryTools.DEBUG) {
                System.out.println("The order must be between 1 and count of actual actions.");
            }
            return;
        }
        this.changingOrder(changeAction, changesList, oldOrder, newOrder);
    }

    private boolean processChangeAnimation(ChangeStoryAction changeAction) {
        ActionAnimation currentAnim;
        if (this.detectEmptyChange(changeAction)) {
            return false;
        }
        LinkedList<ChangeStoryAction> changesList = new LinkedList<ChangeStoryAction>();
        if (StoryTools.DEBUG) {
            System.out.println("Animation." + (Object)((Object)changeAction.getChangeType()));
        }
        if (changeAction.getChangeType() == ChangeType.ADD) {
            currentAnim = (ActionAnimation)changeAction.getCurrentAction();
            if (StoryTools.DEBUG) {
                System.out.println("Animation added.");
            }
            ChangeStoryAction copyChangeAction = new ChangeStoryAction(changeAction);
            this.changingOrder(copyChangeAction, changesList, Integer.MAX_VALUE, currentAnim.getOrder());
        } else if (changeAction.getChangeType() == ChangeType.DELETE) {
            currentAnim = (ActionAnimation)changeAction.getCurrentAction();
            if (StoryTools.DEBUG) {
                System.out.println("Animation deleted.");
            }
            ChangeStoryAction copyChangeAction = new ChangeStoryAction(changeAction);
            this.changingOrder(copyChangeAction, changesList, currentAnim.getOrder(), Integer.MAX_VALUE);
        } else {
            StoryActionProperties.StoryActionDiff diff = changeAction.getOldActionProp().getDiff(changeAction.getNewActionProp());
            if (diff.isOrderChanged()) {
                this.processChangeOrder(changeAction, changesList);
            } else if (diff.isTimeChanged()) {
                long newTime = changeAction.getNewActionProp().getTime();
                long oldTime = changeAction.getOldActionProp().getTime();
                StoryAction lastAnim = null;
                for (ActionAnimation anim : changeAction.getCharacter().getAnimations()) {
                    lastAnim = anim;
                    if (anim.getTime() > newTime || newTime >= anim.getTime() + anim.getDuration()) continue;
                    long threshold = 500L;
                    if (anim.getDuration() <= 1500L) {
                        threshold = anim.getDuration() / 3L;
                    }
                    if (newTime + threshold < anim.getTime() + anim.getDuration()) {
                        changeAction.getNewActionProp().setOrder(anim.getOrder());
                    }
                    if (!StoryTools.DEBUG) break;
                    System.out.println("New order " + anim.getOrder());
                    break;
                }
                if (lastAnim.getTime() + lastAnim.getDuration() <= newTime) {
                    changeAction.getNewActionProp().setOrder(((ActionAnimation)lastAnim).getOrder());
                }
                changeAction.getNewActionProp().setTime(oldTime);
                if (changeAction.getOldActionProp().getOrder() == changeAction.getNewActionProp().getOrder()) {
                    return false;
                }
                this.processChangeOrder(changeAction, changesList);
            } else if (diff.isDurationChanged()) {
                int firstToChange = changeAction.getNewActionProp().getOrder();
                if (this.areDisallowedProperties(changeAction.getNewActionProp())) {
                    return false;
                }
                for (ActionAnimation anim : changeAction.getCharacter().getAnimations()) {
                    if (anim.getOrder() <= firstToChange) continue;
                    StoryActionProperties oldProp = anim.getActionProperties();
                    StoryActionProperties newProp = new StoryActionProperties(oldProp);
                    newProp.setTime(anim.getTime() + changeAction.getNewActionProp().getDuration() - changeAction.getOldActionProp().getDuration());
                    if (this.areDisallowedProperties(newProp)) {
                        return false;
                    }
                    ChangeStoryAction newChange = new ChangeStoryAction(ChangeType.CHANGE, changeAction.getCharacter(), oldProp, newProp, anim);
                    changesList.add(newChange);
                }
                changesList.add(changeAction);
            } else if (diff.isAnimationNameChanged()) {
                changesList.add(changeAction);
            }
        }
        if (StoryTools.DEBUG) {
            System.out.println("PROCESSING ANIM CHANGE");
        }
        this.undoRedoController.checkThrowAwayOfRestOfChangeList();
        ChangeActionParent newContainer = new ChangeActionParent(changesList);
        ((ChangeContainer)newContainer).processChange(this);
        newContainer.setChangeDone(true);
        this.changeActions.add((Object)newContainer);
        this.actualChangeAction = newContainer;
        Collections.sort(changeAction.getCharacter().getAnimations(), StoryTools.animOrderComparator());
        return true;
    }

    private void processSnapping(long startTime, long stopTime, ChangeStoryAction changeAction) {
        for (ActionAnimation anim : changeAction.getCharacter().getAnimations()) {
            if (Math.abs(anim.getTime() - startTime) <= this.getSnappingTime()) {
                changeAction.getNewActionProp().setTime(anim.getTime());
                if (StoryTools.DEBUG) {
                    System.out.println("Snapping - We change the start time (according to the start time of an animation).");
                }
            }
            if (Math.abs(anim.getTime() + anim.getDuration() - stopTime) <= this.getSnappingTime()) {
                changeAction.getNewActionProp().setDuration(anim.getTime() + anim.getDuration() - startTime);
                if (StoryTools.DEBUG) {
                    System.out.println("Snapping - We change the stop time (according to the stop time of an animation).");
                }
            }
            if (Math.abs(anim.getTime() + anim.getDuration() - startTime) > this.getSnappingTime()) continue;
            changeAction.getNewActionProp().setTime(anim.getTime() + anim.getDuration());
            if (!StoryTools.DEBUG) continue;
            System.out.println("Snapping - We change the start time (according to the stop time of an animation).");
        }
        startTime = changeAction.getNewActionProp().getTime();
        stopTime = startTime + changeAction.getNewActionProp().getDuration();
    }

    private boolean processChangeCutOverlapMovements(ChangeStoryAction changeAction) {
        if (this.areDisallowedProperties(changeAction.getNewActionProp())) {
            return false;
        }
        long startTime = changeAction.getNewActionProp().getTime();
        long stopTime = startTime + changeAction.getNewActionProp().getDuration();
        if (this.settings.isbSnappingMoveEnabled()) {
            this.processSnapping(startTime, stopTime, changeAction);
        }
        for (ActionMovement mov : changeAction.getCharacter().getMovements()) {
            if (mov == (ActionMovement)changeAction.getCurrentAction() || mov.getTime() == changeAction.getOldActionProp().getTime() && mov.getDuration() == changeAction.getOldActionProp().getDuration()) continue;
            if (mov.getTime() <= startTime && startTime < mov.getTime() + mov.getDuration()) {
                if (StoryTools.DEBUG) {
                    System.out.print("The start of the action intervenes (from the left side) with other action. That is forbidden.");
                }
                return false;
            }
            if (startTime > mov.getTime() || mov.getTime() >= stopTime) continue;
            changeAction.getNewActionProp().setDuration(mov.getTime() - startTime);
            if (!StoryTools.DEBUG) break;
            System.out.println("Too long action. We must cut it.");
            break;
        }
        return true;
    }

    private boolean processChangeMovement(ChangeStoryAction changeAction, boolean bShiftRight) {
        if (this.detectEmptyChange(changeAction)) {
            return false;
        }
        LinkedList<ChangeStoryAction> newList = new LinkedList<ChangeStoryAction>();
        if (changeAction.getChangeType() == ChangeType.CHANGE && bShiftRight) {
            StoryActionProperties.StoryActionDiff diff = changeAction.getOldActionProp().getDiff(changeAction.getNewActionProp());
            long shiftTime = 0L;
            if (diff.isTimeChanged()) {
                shiftTime = changeAction.getNewActionProp().getTime() - changeAction.getOldActionProp().getTime();
            } else if (diff.isDurationChanged()) {
                shiftTime = changeAction.getNewActionProp().getDuration() - changeAction.getOldActionProp().getDuration();
            }
            if (shiftTime != 0L) {
                this.undoRedoController.checkThrowAwayOfRestOfChangeList();
                newList.add(changeAction);
                newList.addAll(this.computeMovementsShift(changeAction, shiftTime));
                ChangeActionParent newContainer = new ChangeActionParent(newList);
                ((ChangeContainer)newContainer).processChange(this);
                newContainer.setChangeDone(true);
                this.changeActions.add((Object)newContainer);
                this.actualChangeAction = newContainer;
                Collections.sort(changeAction.getCharacter().getRotations(), StoryTools.actionTimeComparator());
                return true;
            }
        }
        if (!this.processChangeCutOverlapMovements(changeAction)) {
            return false;
        }
        this.undoRedoController.checkThrowAwayOfRestOfChangeList();
        newList.add(changeAction);
        ChangeActionParent newContainer = new ChangeActionParent(newList);
        ((ChangeContainer)newContainer).processChange(this);
        newContainer.setChangeDone(true);
        this.changeActions.add((Object)newContainer);
        this.actualChangeAction = newContainer;
        Collections.sort(changeAction.getCharacter().getMovements(), StoryTools.actionTimeComparator());
        return true;
    }

    private List<ChangeStoryAction> computeMovementsShift(ChangeStoryAction changeAction, long shiftTime) {
        ArrayList<ChangeStoryAction> changes = new ArrayList<ChangeStoryAction>();
        for (ActionMovement mov : changeAction.getCharacter().getMovements()) {
            if (mov == changeAction.getCurrentAction() || mov.getTime() <= changeAction.getOldActionProp().getTime()) continue;
            StoryActionProperties oldProp = mov.getActionProperties();
            StoryActionProperties newProp = new StoryActionProperties(oldProp);
            newProp.setTime(oldProp.getTime() + shiftTime);
            ChangeStoryAction newChange = new ChangeStoryAction(ChangeType.CHANGE, changeAction.getCharacter(), oldProp, newProp, mov);
            changes.add(newChange);
        }
        return changes;
    }

    private boolean processChangeCutOverlapRotations(ChangeStoryAction changeAction) {
        if (this.areDisallowedProperties(changeAction.getNewActionProp())) {
            return false;
        }
        long startTime = changeAction.getNewActionProp().getTime();
        long stopTime = startTime + changeAction.getNewActionProp().getDuration();
        if (this.settings.isbSnappingRotateEnabled()) {
            this.processSnapping(startTime, stopTime, changeAction);
        }
        for (ActionRotation rotate : changeAction.getCharacter().getRotations()) {
            if (rotate == (ActionRotation)changeAction.getCurrentAction()) continue;
            if (rotate.getTime() <= startTime && startTime < rotate.getTime() + rotate.getDuration()) {
                if (StoryTools.DEBUG) {
                    System.out.print("The start of the action intervenes (from the left side) with other action. That is forbidden.");
                }
                return false;
            }
            if (startTime > rotate.getTime() || rotate.getTime() >= stopTime) continue;
            changeAction.getNewActionProp().setDuration(rotate.getTime() - startTime);
            if (!StoryTools.DEBUG) break;
            System.out.println("Too long action. We must cut it.");
            break;
        }
        return true;
    }

    private List<ChangeStoryAction> computeRotationsShift(ChangeStoryAction changeAction, long shiftTime) {
        ArrayList<ChangeStoryAction> changes = new ArrayList<ChangeStoryAction>();
        for (ActionRotation rotate : changeAction.getCharacter().getRotations()) {
            if (rotate == changeAction.getCurrentAction() || rotate.getTime() <= changeAction.getOldActionProp().getTime()) continue;
            StoryActionProperties oldProp = rotate.getActionProperties();
            StoryActionProperties newProp = new StoryActionProperties(oldProp);
            newProp.setTime(oldProp.getTime() + shiftTime);
            ChangeStoryAction newChange = new ChangeStoryAction(ChangeType.CHANGE, changeAction.getCharacter(), oldProp, newProp, rotate);
            changes.add(newChange);
        }
        return changes;
    }

    private boolean processChangeRotation(ChangeStoryAction changeAction, boolean bShiftRight) {
        if (this.detectEmptyChange(changeAction)) {
            return false;
        }
        LinkedList<ChangeStoryAction> newList = new LinkedList<ChangeStoryAction>();
        if (changeAction.getChangeType() == ChangeType.CHANGE && bShiftRight) {
            StoryActionProperties.StoryActionDiff diff = changeAction.getOldActionProp().getDiff(changeAction.getNewActionProp());
            long shiftTime = 0L;
            if (diff.isTimeChanged()) {
                shiftTime = changeAction.getNewActionProp().getTime() - changeAction.getOldActionProp().getTime();
            } else if (diff.isDurationChanged()) {
                shiftTime = changeAction.getNewActionProp().getDuration() - changeAction.getOldActionProp().getDuration();
            }
            if (shiftTime != 0L) {
                this.undoRedoController.checkThrowAwayOfRestOfChangeList();
                newList.add(changeAction);
                newList.addAll(this.computeRotationsShift(changeAction, shiftTime));
                ChangeActionParent newContainer = new ChangeActionParent(newList);
                ((ChangeContainer)newContainer).processChange(this);
                newContainer.setChangeDone(true);
                this.changeActions.add((Object)newContainer);
                this.actualChangeAction = newContainer;
                Collections.sort(changeAction.getCharacter().getRotations(), StoryTools.actionTimeComparator());
                return true;
            }
        }
        if (!this.processChangeCutOverlapRotations(changeAction)) {
            return false;
        }
        this.undoRedoController.checkThrowAwayOfRestOfChangeList();
        newList.add(changeAction);
        ChangeActionParent newContainer = new ChangeActionParent(newList);
        ((ChangeContainer)newContainer).processChange(this);
        newContainer.setChangeDone(true);
        this.changeActions.add((Object)newContainer);
        this.actualChangeAction = newContainer;
        Collections.sort(changeAction.getCharacter().getRotations(), StoryTools.actionTimeComparator());
        return true;
    }

    private boolean detectEmptyChange(ChangeStoryAction changeAction) {
        return changeAction.getChangeType().equals((Object)ChangeType.CHANGE) && changeAction.getNewActionProp().getDiff(changeAction.getOldActionProp()).isEmptyChange();
    }

    public void addStoryLengthChangedListener(IStoryLenghtChangeListener aThis) {
        this.settings.addStoryLengthChangedListener(aThis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoryControllerListener(StoryControllerListener listener) {
        HashSet<StoryControllerListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStoryControllerListener(StoryControllerListener listener) {
        HashSet<StoryControllerListener> hashSet = this.listeners;
        synchronized (hashSet) {
            return this.listeners.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStoryControllerListener(StoryControllerListener listener) {
        HashSet<StoryControllerListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentTime(long time) {
        StoryControllerListener[] array;
        if (time == this.currentStoryTime) {
            return;
        }
        long oldTime = this.currentStoryTime;
        this.currentStoryTime = time;
        HashSet<StoryControllerListener> hashSet = this.listeners;
        synchronized (hashSet) {
            array = this.listeners.toArray(new StoryControllerListener[0]);
        }
        for (StoryControllerListener listener : array) {
            listener.currentTimeChanged(oldTime, this.currentStoryTime);
        }
    }

    public static interface StoryControllerListener {
        public void currentTimeChanged(long var1, long var3);
    }
}

