/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.storycontrol;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryControlServerModule;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryPlayer;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionRotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkLivingCharacter;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Kick;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.MoveCamera;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetCamera;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AliveMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MapList;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mutator;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerJoinsGame;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLeft;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryControlServer
extends UT2004Server
implements IUT2004Server {
    private double currentUTTime = 0.0;
    private StoryPlayer storyPlayer;
    private Map<String, Player> playerMap = new HashMap<String, Player>();
    private Map<Integer, EmohawkLivingCharacter> storyCharacterAvatars = new HashMap<Integer, EmohawkLivingCharacter>();
    private UnrealId playerId;
    private static final int TIME_MS_MULTIPLIER = 1000;
    private boolean bCameraSet = false;
    private EmohawkCharacter lastCamera;
    private EmohawkCharacter firstCamera;
    private EmohawkCharacter secondCamera;
    private Player cameraPlayer;
    private ActionMovement lastCamMove = null;
    private ActionRotation lastCamRot = null;
    private MoveCamera resultMoveCamera = null;
    private boolean bInitialized = false;
    IWorldObjectEventListener<AliveMessage, WorldObjectUpdatedEvent<AliveMessage>> myAliveListener = new IWorldObjectEventListener<AliveMessage, WorldObjectUpdatedEvent<AliveMessage>>(){

        public void notify(WorldObjectUpdatedEvent<AliveMessage> event) {
            StoryControlServer.this.currentUTTime = ((AliveMessage)event.getObject()).getTime();
            if (!StoryControlServer.this.bInitialized) {
                StoryControlServer.this.bInitialized = true;
            }
            StoryControlServer.this.storyPlayer.notifyGameTick(StoryControlServer.this.currentUTTime);
            StoryControlServer.this.processCameraCommands(StoryControlServer.this.currentUTTime * 1000.0);
        }
    };
    IWorldObjectEventListener<Player, WorldObjectUpdatedEvent<Player>> myPlayerListener = new IWorldObjectEventListener<Player, WorldObjectUpdatedEvent<Player>>(){

        public void notify(WorldObjectUpdatedEvent<Player> event) {
            if (!StoryControlServer.this.playerMap.containsKey(((Player)event.getObject()).getName())) {
                StoryControlServer.this.playerMap.put(((Player)event.getObject()).getName(), event.getObject());
            }
        }
    };
    IWorldEventListener<PlayerLeft> myPlayerLeftListener = new IWorldEventListener<PlayerLeft>(){

        public void notify(PlayerLeft event) {
            if (event.getId().toString().contains("GBPlayer") && StoryTools.DEBUG) {
                System.out.println("Player left: " + event.getId().toString());
            }
        }
    };
    IWorldEventListener<PlayerJoinsGame> myPlayerJoinListener = new IWorldEventListener<PlayerJoinsGame>(){

        public void notify(PlayerJoinsGame event) {
            if (StoryTools.DEBUG) {
                System.out.println("Player joined 2: " + event.getId().toString());
            }
            if (event.getId().toString().contains("GBPlayer") && StoryTools.DEBUG) {
                System.out.println("Player joined: " + event.getId().toString());
            }
        }
    };

    public boolean isbInitialized() {
        return this.bInitialized;
    }

    public synchronized double getCurrentUTTime() {
        return this.currentUTTime;
    }

    private void initCamera() {
        this.firstCamera = this.storyPlayer.getFirstCamera();
        this.secondCamera = this.storyPlayer.getSecondCamera();
        EmohawkCharacter camera = this.getActiveCamera(this.storyPlayer.getCurrentStoryTime());
        this.lastCamMove = null;
        this.lastCamRot = null;
        if (camera == null) {
            if (StoryTools.DEBUG) {
                System.out.println("Kamera je null.");
            }
            return;
        }
        if (StoryTools.DEBUG) {
            System.out.println("initCamera.");
        }
        this.setCamera();
        if (this.playerId != null) {
            this.bCameraSet = true;
            Location newLoc = camera.getLocation(camera.getModel().getCurrentStoryTime());
            this.getAct().act((CommandMessage)new SetCamera().setId(this.playerId).setLocation(newLoc).setRotation(camera.getRotation(camera.getModel().getCurrentStoryTime())));
            if (StoryTools.DEBUG) {
                System.out.println("in init: SETCAMERA.");
            }
        }
    }

    private void processCameraCommands(double UTtime) {
        EmohawkCharacter camera;
        long time = this.storyPlayer.getCurrentStoryTime();
        if (!this.storyPlayer.isStoryPlaying()) {
            time = this.storyPlayer.getCurrentStoryTime();
        }
        if ((camera = this.getActiveCamera(time)) != null && camera != this.lastCamera) {
            if (this.playerId == null) {
                this.setCamera();
            }
            this.getAct().act((CommandMessage)new SetCamera().setId(this.playerId).setLocation(camera.getLocation(camera.getModel().getCurrentStoryTime())).setRotation(camera.getRotation(camera.getModel().getCurrentStoryTime())));
            if (StoryTools.DEBUG) {
                System.out.println("SET CAMERA");
            }
        }
        this.lastCamera = camera;
        if (!this.storyPlayer.isStoryPlaying() && camera == null) {
            if (this.playerId != null && this.bCameraSet) {
                this.getAct().act((CommandMessage)new SetCamera().setId(this.playerId).setRelease(Boolean.valueOf(true)));
                this.bCameraSet = false;
            }
            return;
        }
        if (!this.storyPlayer.isStoryPlaying() && camera != null) {
            this.getAct().act((CommandMessage)new MoveCamera().setId(this.playerId).setSpeed(Double.valueOf(0.0)).setRotationSpeed(new Rotation(0.0, 0.0, 0.0)));
            this.getAct().act((CommandMessage)new SetCamera().setId(this.playerId).setLocation(camera.getLocation(camera.getModel().getCurrentStoryTime())).setRotation(camera.getRotation(camera.getModel().getCurrentStoryTime())));
        } else if (camera == null) {
            return;
        }
        boolean bCommandEmpty = true;
        if (this.storyPlayer.isStoryPlaying()) {
            this.resultMoveCamera = new MoveCamera().setId(this.playerId);
            if (this.cameraPlayer != null) {
                ActionRotation newRot;
                ActionMovement newMove = camera.getActionMovement(time);
                if (newMove != null && newMove != this.lastCamMove) {
                    Location currentCameraLoc = camera.getLocation(time);
                    double speed = newMove.getEnd().getDistance(currentCameraLoc) / (double)((newMove.getTime() + newMove.getDuration() - time) / 1000L);
                    Location direction = Location.sub((Location)newMove.getEnd(), (Location)currentCameraLoc);
                    direction = direction.getNormalized().scale(100.0);
                    direction = this.getRounded(direction);
                    this.resultMoveCamera.setSpeed(Double.valueOf(speed)).setDirection(new Vector3d((Tuple3d)direction.asPoint3d())).setDestination(newMove.getEnd());
                    bCommandEmpty = false;
                    this.lastCamMove = newMove;
                }
                if ((newRot = camera.getActionRotation(time)) != null && newRot != this.lastCamRot) {
                    Rotation curRot = camera.getRotation(time);
                    double playerYaw = curRot.yaw;
                    double playerPitch = curRot.pitch;
                    double desiredYaw = newRot.getAngleH();
                    double desiredPitch = newRot.getAngleV();
                    if (desiredYaw < 0.0) {
                        desiredYaw += 65556.0;
                    }
                    if (desiredPitch < 0.0) {
                        desiredPitch += 65556.0;
                    }
                    if (playerYaw < 0.0) {
                        playerYaw += 65556.0;
                    }
                    if (playerPitch < 0.0) {
                        playerPitch += 65556.0;
                    }
                    double deltaYaw = this.getDeltaRotation(playerYaw, desiredYaw);
                    double deltaPitch = this.getDeltaRotation(playerPitch, desiredPitch);
                    System.out.println("PY:" + playerYaw + ";PP:" + playerPitch + ";DY:" + desiredYaw + ";DP::" + desiredPitch + ";DDY:" + deltaYaw + ";DDP" + deltaPitch);
                    if (deltaYaw < 50.0) {
                        deltaYaw = 0.0;
                    }
                    if (deltaPitch < 50.0) {
                        deltaPitch = 0.0;
                    }
                    double yawRotationSpeed = Math.min(65000L, Math.round(deltaYaw / (double)((newRot.getTime() + newRot.getDuration() - time) / 1000L)));
                    double pitchRotationSpeed = Math.min(65000L, Math.round(deltaPitch / (double)((newRot.getTime() + newRot.getDuration() - time) / 1000L)));
                    Rotation desiredRot = new Rotation((double)newRot.getAngleV(), (double)newRot.getAngleH(), 0.0);
                    if (desiredRot.pitch < 0.0) {
                        desiredRot.pitch += 65556.0;
                    }
                    if (desiredRot.yaw < 0.0) {
                        desiredRot.yaw += 65556.0;
                    }
                    this.resultMoveCamera.setRotation(desiredRot);
                    curRot.pitch = Math.round(curRot.pitch);
                    curRot.yaw = Math.round(curRot.yaw);
                    curRot.roll = Math.round(curRot.roll);
                    this.resultMoveCamera.setRotationSpeed(new Rotation(pitchRotationSpeed, yawRotationSpeed, 0.0));
                    bCommandEmpty = false;
                    this.lastCamRot = newRot;
                }
                if (!bCommandEmpty) {
                    this.getAct().act((CommandMessage)this.resultMoveCamera);
                    if (StoryTools.DEBUG) {
                        System.out.println("CAM: " + camera.getCharacterProperties().getName() + ", com: " + this.resultMoveCamera);
                    }
                }
            }
        }
    }

    public double getDeltaRotation(double rot1, double rot2) {
        double result = 0.0;
        result = rot1 > rot2 ? rot1 - rot2 : rot2 - rot1;
        if (result >= 32778.0) {
            result = 65556.0 - result;
        }
        return result;
    }

    public Map<String, Player> getPlayerMap() {
        return this.playerMap;
    }

    @Inject
    public StoryControlServer(UT2004AgentParameters params, IAgentLogger agentLogger, IComponentBus bus, SocketConnection connection, UT2004WorldView worldView, IAct act) {
        super(params, agentLogger, bus, connection, worldView, act);
    }

    public void initialize() {
        ((UT2004WorldView)this.getWorldView()).addEventListener(PlayerLeft.class, this.myPlayerLeftListener);
        ((UT2004WorldView)this.getWorldView()).addEventListener(PlayerJoinsGame.class, this.myPlayerJoinListener);
        ((UT2004WorldView)this.getWorldView()).addObjectListener(AliveMessage.class, WorldObjectUpdatedEvent.class, this.myAliveListener);
        ((UT2004WorldView)this.getWorldView()).addObjectListener(Player.class, WorldObjectUpdatedEvent.class, this.myPlayerListener);
        if (StoryTools.DEBUG) {
            System.out.print("StoryControlServer initialized. Yes.");
        }
    }

    public synchronized void stopPlaying() {
    }

    public synchronized void startPlaying(double time) {
        this.getAct().act((CommandMessage)new Configuration().setVisionTime(Double.valueOf(0.1)));
        this.initCamera();
    }

    public UnrealId getBotId(UT2004Bot bot) {
        Self self = (Self)bot.getWorldView().getSingle(Self.class);
        if (self != null) {
            return self.getId();
        }
        return null;
    }

    public void kick(UT2004Bot bot) {
        Self self = (Self)bot.getWorldView().getSingle(Self.class);
        if (self != null) {
            this.getAct().act((CommandMessage)new Kick().setId(self.getId()));
        }
    }

    public void kick(UnrealId id) {
        this.getAct().act((CommandMessage)new Kick().setId(id));
    }

    public void kick(String botId) {
        this.getAct().act((CommandMessage)new Kick().setId(UnrealId.get((String)botId)));
    }

    public static StoryControlServer createServer(StoryPlayer storyPlayer) throws PogamutException {
        UT2004ServerRunner runner = new UT2004ServerRunner((IAgentFactory)new UT2004ServerFactory((UT2004ServerModule)new StoryControlServerModule()));
        StoryControlServer server = (StoryControlServer)runner.startAgent();
        server.storyPlayer = storyPlayer;
        server.initialize();
        return server;
    }

    public static void main(String[] args) throws PogamutException {
        UT2004ServerRunner runner = new UT2004ServerRunner((IAgentFactory)new UT2004ServerFactory((UT2004ServerModule)new StoryControlServerModule()));
        StoryControlServer server = (StoryControlServer)runner.startAgent();
        server.initialize();
    }

    protected synchronized void addAvatar(int id, EmohawkLivingCharacter avatar) {
        this.storyCharacterAvatars.put(id, avatar);
    }

    public Collection<MapList> getAvailableMaps() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<Mutator> getMutators() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCamera() {
        Player result = null;
        this.lastCamMove = null;
        this.lastCamRot = null;
        Collection col = ((UT2004WorldView)this.getWorldView()).getAll(Player.class).values();
        for (Player p : col) {
            if (result == null && p.getId().toString().contains("GBPlayer")) {
                result = p;
                continue;
            }
            if (!p.getId().toString().contains("GBPlayer") || !(p.getLastSeenTime() > result.getLastSeenTime())) continue;
            result = p;
        }
        if (result != null) {
            if (StoryTools.DEBUG) {
                System.out.println("Player " + result.getId().toString());
            }
            this.playerId = result.getId();
            this.cameraPlayer = result;
        }
    }

    private EmohawkCharacter getActiveCamera(long storyTime) {
        ActionAnimation anim;
        ActionAnimation anim2;
        if (storyTime < 0L) {
            storyTime = 0L;
        }
        EmohawkCharacter firstCam = this.firstCamera;
        if (StoryTools.DEBUG) {
            System.out.println("First: " + firstCam);
        }
        if (firstCam != null && (anim2 = firstCam.getActionAnimation(storyTime)) != null && anim2.getAnimationId().equals("active")) {
            return firstCam;
        }
        EmohawkCharacter secondCam = this.secondCamera;
        if (StoryTools.DEBUG) {
            System.out.println("Second: " + secondCam);
        }
        if (secondCam != null && (anim = secondCam.getActionAnimation(storyTime)) != null && anim.getAnimationId().equals("active")) {
            return secondCam;
        }
        return null;
    }

    public Rotation getRotationSnapFromUnreal() {
        if (this.cameraPlayer == null) {
            this.setCamera();
        }
        if (this.cameraPlayer != null) {
            if (StoryTools.DEBUG) {
                System.out.println("StoryControlServer.getRotationSnapFromUnreal(), Rotation:" + this.cameraPlayer.getRotation());
            }
            return this.cameraPlayer.getRotation();
        }
        return new Rotation();
    }

    private Location getRounded(Location direction) {
        Location result = new Location();
        result.x = Math.round(direction.x);
        result.y = Math.round(direction.y);
        result.z = Math.round(direction.z);
        return result;
    }

    private Rotation getRounded(Rotation direction) {
        Rotation result = new Rotation();
        result.pitch = Math.round(direction.pitch);
        result.yaw = Math.round(direction.yaw);
        result.roll = Math.round(direction.roll);
        return result;
    }

    public void clearCamera() {
        this.firstCamera = null;
        this.secondCamera = null;
        this.lastCamMove = null;
        this.lastCamRot = null;
        if (this.bCameraSet) {
            this.getAct().act((CommandMessage)new SetCamera().setId(this.playerId).setRelease(Boolean.valueOf(true)));
            this.bCameraSet = false;
        }
    }
}

