/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.tools;

import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.openide.util.Exceptions;

public class UE2Wrapper {
    private Process utProcess;

    public void startUnrealRuntime(String host) throws IOException {
        if (this.utProcess != null) {
            return;
        }
        String path = StorySettings.ue2path + File.separator + "System" + File.separator;
        List<String> cmds = null;
        if (System.getProperty("os.name").contains("Windows")) {
            path = path + "UE2Runtime.exe";
            InetAddress adr = InetAddress.getByName(host);
            cmds = Arrays.asList("cmd.exe", "/c", "start \"UT2004 Spectate\" /low \"" + path + "\" " + adr.getHostAddress());
        }
        ProcessBuilder builder = new ProcessBuilder(cmds);
        this.utProcess = builder.start();
    }

    public boolean isRunning() {
        return this.utProcess != null;
    }

    public void destroySpectate() {
        if (this.utProcess != null) {
            for (int it = 0; it < 10000; ++it) {
                this.utProcess.destroy();
                int i = this.utProcess.exitValue();
                if (this.utProcess.exitValue() != 0) continue;
                try {
                    this.utProcess.waitFor();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            this.utProcess = null;
        }
    }
}

