/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.tools;

import cz.cuni.amis.pogamut.emonewt.gui.tools.AnimationFilePath;
import cz.cuni.amis.pogamut.emonewt.gui.tools.AnimationFiles;
import cz.cuni.amis.pogamut.emonewt.gui.tools.AnimationInfo;
import cz.cuni.amis.pogamut.emonewt.gui.tools.AnimationsWrapper;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettingsSave;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryTools {
    private static double DEFAULT_Z_COORD = -3420.0;
    public static boolean DEBUG = false;

    public static void userNotificationDialog(Component comp, String text) {
        JOptionPane.showMessageDialog(comp, text);
    }

    public static boolean userConfirmedDialog(Component comp, String text) {
        int result = JOptionPane.showConfirmDialog(comp, text);
        return result == 0;
    }

    public static int userYesNoCancelDialog(Component comp, String text) {
        return JOptionPane.showConfirmDialog(comp, text);
    }

    public static Comparator animOrderComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                int val2;
                int val1 = ((ActionAnimation)o1).getOrder();
                return val1 < (val2 = ((ActionAnimation)o2).getOrder()) ? -1 : (val1 == val2 ? 0 : 1);
            }
        };
    }

    public static Comparator animationInfoOrderComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                String val1 = ((AnimationInfo)o1).getAnimationId();
                String val2 = ((AnimationInfo)o2).getAnimationId();
                return val1.compareTo(val2);
            }
        };
    }

    public static Comparator animationInfoDescriptionOrderComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                String val1 = ((AnimationInfo)o1).getLocalizedDescription();
                String val2 = ((AnimationInfo)o2).getLocalizedDescription();
                return val1.compareTo(val2);
            }
        };
    }

    public static Comparator actionTimeComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                long val2;
                long val1 = ((StoryAction)o1).getTime();
                return val1 < (val2 = ((StoryAction)o2).getTime()) ? -1 : (val1 == val2 ? 0 : 1);
            }
        };
    }

    public static StorySettingsSave loadSettings(String filePath) {
        File file = new File(filePath);
        StorySettingsSave wrapper = null;
        try {
            FileInputStream reader = new FileInputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{StorySettingsSave.class});
            Unmarshaller u = context.createUnmarshaller();
            wrapper = (StorySettingsSave)u.unmarshal((InputStream)reader);
        }
        catch (Exception e) {
            System.err.println("Error in loading " + filePath + "\n" + e);
        }
        return wrapper;
    }

    public static void saveSettings(String filePath, StorySettingsSave settings) {
        File file = new File(filePath);
        try {
            FileOutputStream writer = new FileOutputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{StorySettingsSave.class});
            Marshaller u = context.createMarshaller();
            u.marshal((Object)settings, (OutputStream)writer);
        }
        catch (Exception e) {
            System.err.println("Error in saving " + filePath + "\n" + e);
        }
    }

    public static ArrayList<AnimationFilePath> loadAnimationFilesPaths(String filePath) {
        File file = new File(filePath);
        AnimationFiles wrapper = null;
        try {
            FileInputStream reader = new FileInputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AnimationFiles.class});
            Unmarshaller u = context.createUnmarshaller();
            wrapper = (AnimationFiles)u.unmarshal((InputStream)reader);
        }
        catch (Exception e) {
            System.err.println("Error in loading " + filePath + "\n" + e);
        }
        return wrapper.filePaths;
    }

    public static ArrayList<AnimationInfo> loadAnimations(String filePath) {
        File file = new File(filePath);
        AnimationsWrapper wrapper = null;
        try {
            FileInputStream reader = new FileInputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AnimationsWrapper.class});
            Unmarshaller u = context.createUnmarshaller();
            wrapper = (AnimationsWrapper)u.unmarshal((InputStream)reader);
        }
        catch (Exception e) {
            System.err.println("Error in loading " + filePath + "\n" + e);
        }
        return wrapper.animationList;
    }

    public static void saveAnimations(String filePath, AnimationsWrapper animations) {
        File file = new File(filePath);
        try {
            FileOutputStream writer = new FileOutputStream(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AnimationsWrapper.class});
            Marshaller u = context.createMarshaller();
            u.marshal((Object)animations, (OutputStream)writer);
        }
        catch (Exception e) {
            System.err.println("Error in saving " + filePath + "\n" + e);
        }
    }

    public static int angleToUTUnits(double angle) {
        return (int)Math.round(angle * 65535.0 / 360.0);
    }

    public static int unitsToAngle(double units) {
        int result = (int)Math.round(units / 182.04166666666666);
        if (result > 180) {
            result -= 360;
        }
        return result;
    }

    public static double getDefaultZ() {
        return DEFAULT_Z_COORD;
    }

    private static boolean killUTprocess() {
        Process p;
        try {
            p = Runtime.getRuntime().exec("\\Recording\\TaskkillEN\\taskkillEN.exe /T /F /FI \"imagename eq UE2Runtime.exe\"");
            p.waitFor();
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            return false;
        }
        catch (InterruptedException ex) {
            System.out.println(ex.toString());
            return false;
        }
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String outputFull = "";
        try {
            String outputLine;
            while ((outputLine = stdInput.readLine()) != null) {
                outputFull = outputFull.concat(outputLine);
            }
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
        if (DEBUG) {
            System.out.println("\nUTwindow kill invoked output from taskkill.exe is: " + outputFull);
        }
        return outputFull.matches("^SUCCESS.*");
    }
}

