/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.tools;

import cz.cuni.amis.pogamut.emonewt.gui.tools.NumericPlainDocument;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;

public class NumericTextField
extends JTextField
implements NumericPlainDocument.InsertErrorListener {
    public NumericTextField() {
        this(null, 0, null);
    }

    public NumericTextField(String text, int columns, DecimalFormat format) {
        super(null, text, columns);
        NumericPlainDocument numericDoc = (NumericPlainDocument)this.getDocument();
        if (format != null) {
            numericDoc.setFormat(format);
        }
        numericDoc.addInsertErrorListener(this);
    }

    public NumericTextField(int columns, DecimalFormat format) {
        this(null, columns, format);
    }

    public NumericTextField(String text) {
        this(text, 0, null);
    }

    public NumericTextField(String text, int columns) {
        this(text, columns, null);
    }

    public void setFormat(DecimalFormat format) {
        ((NumericPlainDocument)this.getDocument()).setFormat(format);
    }

    public DecimalFormat getFormat() {
        return ((NumericPlainDocument)this.getDocument()).getFormat();
    }

    public void formatChanged() {
        this.setFormat(this.getFormat());
    }

    public Long getLongValue() throws ParseException {
        return ((NumericPlainDocument)this.getDocument()).getLongValue();
    }

    public Double getDoubleValue() throws ParseException {
        return ((NumericPlainDocument)this.getDocument()).getDoubleValue();
    }

    public Number getNumberValue() throws ParseException {
        return ((NumericPlainDocument)this.getDocument()).getNumberValue();
    }

    public void setValue(Number number) {
        this.setText(this.getFormat().format(number));
    }

    public void setValue(long l) {
        this.setText(this.getFormat().format(l));
    }

    public void setValue(double d) {
        this.setText(this.getFormat().format(d));
    }

    public void normalize() throws ParseException {
        this.setText(this.getFormat().format(this.getNumberValue()));
    }

    public void insertFailed(NumericPlainDocument doc, int offset, String str, AttributeSet a) {
        Toolkit.getDefaultToolkit().beep();
    }

    protected Document createDefaultModel() {
        return new NumericPlainDocument();
    }
}

