/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.tools;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IntTextField
extends JTextField {
    protected Document createDefaultModel() {
        return new IntTextDocument();
    }

    public boolean isValid() {
        if (this.getDocument() != null && this.getText() != null) {
            try {
                Integer.parseInt(this.getText());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    class IntTextDocument
    extends PlainDocument {
        IntTextDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            String oldString = this.getText(0, this.getLength());
            String newString = oldString.substring(0, offs) + str + oldString.substring(offs);
            try {
                Integer.parseInt(newString + "0");
                super.insertString(offs, str, a);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }
}

