/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.tools;

import cz.cuni.amis.pogamut.emonewt.gui.tools.AnimationFilePath;
import cz.cuni.amis.pogamut.emonewt.gui.tools.AnimationInfo;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ECharacterType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimationsStorage {
    protected Map<ECharacterType, Map<String, AnimationInfo>> animations = new HashMap<ECharacterType, Map<String, AnimationInfo>>();

    private void addAnimations(ArrayList<AnimationInfo> anims) {
        for (AnimationInfo anim : anims) {
            if (!this.animations.containsKey((Object)anim.getType())) {
                this.animations.put(anim.getType(), new HashMap());
            }
            if (this.animations.get((Object)anim.getType()).containsKey(anim.getAnimationId())) continue;
            this.animations.get((Object)anim.getType()).put(anim.getAnimationId(), anim);
            if (!StoryTools.DEBUG) continue;
            System.out.println(anim.toString());
        }
    }

    public List<AnimationInfo> getAnimations(ECharacterType type) {
        ArrayList<AnimationInfo> result = new ArrayList<AnimationInfo>();
        if (this.animations.containsKey((Object)type)) {
            result.addAll(this.animations.get((Object)type).values());
        }
        return result;
    }

    public AnimationInfo getAnimation(ECharacterType type, String id) {
        if (this.animations.containsKey((Object)type)) {
            return this.animations.get((Object)type).get(id);
        }
        return null;
    }

    public Map<ECharacterType, Map<String, AnimationInfo>> getAnimations() {
        return this.animations;
    }

    public void setAnimations(Map<ECharacterType, Map<String, AnimationInfo>> animations) {
        this.animations = animations;
    }

    public AnimationsStorage() {
        ArrayList<AnimationFilePath> paths = StoryTools.loadAnimationFilesPaths("config\\animationFiles.xml");
        for (AnimationFilePath path : paths) {
            this.addAnimations(StoryTools.loadAnimations("config\\" + path.path));
        }
    }
}

