/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.dialogs;

import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.tools.IntTextField;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class NewtSettingsDialog
extends JDialog {
    private static final long TIME_TO_SECONDS_MULTIPLIER = 1000L;
    private final StoryController model;
    private JPanel advancedPanel;
    private JButton btnCancel;
    private JButton btnOk;
    private JButton btnSave;
    private JPanel buttonPanel;
    private JCheckBox chbAlwaysConfirmChanges;
    private JCheckBox chbAskSaveOnClose;
    private JCheckBox chbShowMapDebug;
    private JCheckBox chbSnappingMoveEnabled;
    private JCheckBox chbSnappingRotateEnabled;
    private JPanel checkBoxPanel;
    private JComboBox cmbLanguage;
    private JPanel languagePanel;
    private JLabel lblLanguageNote;
    private JLabel lblSnappingTime;
    private JLabel lblStoryLength;
    private JLabel lblUE2Path;
    private JPanel settingsMainPanel;
    private JTextField txtSnappingTime;
    private JTextField txtStoryLength;
    private JTextField txtUE2Path;

    public NewtSettingsDialog(EmoNewtFrame parent, boolean modal, StoryController model) {
        super((Frame)parent, modal);
        this.model = model;
        this.initComponents();
        this.cmbLanguage.setModel(new DefaultComboBoxModel<Object>(new Object[]{StorySettings.ELang.CZ, StorySettings.ELang.EN}));
        this.resetValues();
    }

    private void destroyDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void propagateChanges() {
        if (this.model.getSettings().getStoryLength() != Long.valueOf(this.txtStoryLength.getText()) * 1000L) {
            this.model.setStoryLength(Long.valueOf(this.txtStoryLength.getText()) * 1000L);
        }
        this.model.getSettings().setbAskSaveStoryOnClose(this.chbAskSaveOnClose.isSelected());
        this.model.getSettings().setbAlwaysConfirmChanges(this.chbAlwaysConfirmChanges.isSelected());
        this.model.getSettings().setbSnappingMoveEnabled(this.chbSnappingMoveEnabled.isSelected());
        this.model.getSettings().setbSnappingRotateEnabled(this.chbSnappingRotateEnabled.isSelected());
        this.model.getSettings();
        StorySettings.language = (StorySettings.ELang)((Object)this.cmbLanguage.getSelectedItem());
        this.model.getSettings().setSNAPPING_TIME(Long.valueOf(this.txtSnappingTime.getText()));
        this.model.getSettings().setbMapDebug(this.chbShowMapDebug.isSelected());
        this.model.getSettings();
        StorySettings.ue2path = this.txtUE2Path.getText();
        this.model.getSettings().updateCurrentBundle();
    }

    private void initComponents() {
        this.settingsMainPanel = new JPanel();
        this.checkBoxPanel = new JPanel();
        this.chbAlwaysConfirmChanges = new JCheckBox();
        this.chbSnappingMoveEnabled = new JCheckBox();
        this.chbSnappingRotateEnabled = new JCheckBox();
        this.chbAskSaveOnClose = new JCheckBox();
        this.chbShowMapDebug = new JCheckBox();
        this.languagePanel = new JPanel();
        this.lblLanguageNote = new JLabel();
        this.cmbLanguage = new JComboBox();
        this.advancedPanel = new JPanel();
        this.txtStoryLength = new IntTextField();
        this.lblStoryLength = new JLabel();
        this.lblSnappingTime = new JLabel();
        this.txtSnappingTime = new IntTextField();
        this.txtUE2Path = new JTextField();
        this.lblUE2Path = new JLabel();
        this.buttonPanel = new JPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.btnSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(StorySettings.currentBundle.getString("SETTINGS"));
        this.setResizable(false);
        this.settingsMainPanel.setBorder(BorderFactory.createTitledBorder(StorySettings.currentBundle.getString("SETTINGS")));
        this.settingsMainPanel.setName("settingsMainPanel");
        this.checkBoxPanel.setName("checkBoxPanel");
        this.checkBoxPanel.setLayout(new BoxLayout(this.checkBoxPanel, 1));
        this.chbAlwaysConfirmChanges.setText(StorySettings.currentBundle.getString("ALWAYS CONFIRM CHANGES."));
        this.chbAlwaysConfirmChanges.setName("chbAlwaysConfirmChanges");
        this.checkBoxPanel.add(this.chbAlwaysConfirmChanges);
        this.chbSnappingMoveEnabled.setText(StorySettings.currentBundle.getString("SNAPPING OF MOVEMENTS ENABLED."));
        this.chbSnappingMoveEnabled.setName("chbSnappingMoveEnabled");
        this.checkBoxPanel.add(this.chbSnappingMoveEnabled);
        this.chbSnappingRotateEnabled.setText(StorySettings.currentBundle.getString("SNAPPING OF ROTATIONS ENABLED."));
        this.chbSnappingRotateEnabled.setName("chbSnappingRotateEnabled");
        this.checkBoxPanel.add(this.chbSnappingRotateEnabled);
        this.chbAskSaveOnClose.setText(StorySettings.currentBundle.getString("ASK TO SAVE STORY ON WINDOW CLOSE."));
        this.chbAskSaveOnClose.setName("chbAskSaveOnClose");
        this.checkBoxPanel.add(this.chbAskSaveOnClose);
        this.chbShowMapDebug.setText(StorySettings.currentBundle.getString("SHOW_BIRDVIEW_CHAR_DEBUG"));
        this.chbShowMapDebug.setName("chbShowMapDebug");
        this.checkBoxPanel.add(this.chbShowMapDebug);
        this.languagePanel.setBorder(BorderFactory.createTitledBorder(StorySettings.currentBundle.getString("LANGUAGE:")));
        this.languagePanel.setName("languagePanel");
        this.lblLanguageNote.setText(StorySettings.currentBundle.getString("CHANGES TAKE EFFECT AFTER RESTART WITH THE NEW SETTING."));
        this.lblLanguageNote.setName("lblLanguageNote");
        this.cmbLanguage.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbLanguage.setName("cmbLanguage");
        GroupLayout languagePanelLayout = new GroupLayout(this.languagePanel);
        this.languagePanel.setLayout(languagePanelLayout);
        languagePanelLayout.setHorizontalGroup(languagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(languagePanelLayout.createSequentialGroup().addContainerGap().addGroup(languagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbLanguage, -2, 96, -2).addComponent(this.lblLanguageNote)).addContainerGap(321, Short.MAX_VALUE)));
        languagePanelLayout.setVerticalGroup(languagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(languagePanelLayout.createSequentialGroup().addComponent(this.cmbLanguage, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLanguageNote)));
        this.advancedPanel.setBorder(BorderFactory.createTitledBorder(StorySettings.currentBundle.getString("SETTINGS_ADVANCED")));
        this.advancedPanel.setName("advancedPanel");
        this.txtStoryLength.setHorizontalAlignment(4);
        this.txtStoryLength.setName("txtStoryLength");
        this.lblStoryLength.setText(StorySettings.currentBundle.getString("STORY LENGTH (SECONDS):"));
        this.lblStoryLength.setName("lblStoryLength");
        this.lblSnappingTime.setText(StorySettings.currentBundle.getString("SNAPPING TIME (MS):"));
        this.lblSnappingTime.setName("lblSnappingTime");
        this.txtSnappingTime.setHorizontalAlignment(4);
        this.txtSnappingTime.setName("txtSnappingTime");
        this.txtUE2Path.setHorizontalAlignment(2);
        this.txtUE2Path.setName("txtUE2Path");
        this.lblUE2Path.setText(StorySettings.currentBundle.getString("UE2PATH_LABEL"));
        this.lblUE2Path.setName("lblUE2Path");
        GroupLayout advancedPanelLayout = new GroupLayout(this.advancedPanel);
        this.advancedPanel.setLayout(advancedPanelLayout);
        advancedPanelLayout.setHorizontalGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedPanelLayout.createSequentialGroup().addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblStoryLength).addComponent(this.lblUE2Path).addComponent(this.lblSnappingTime)).addGap(18, 18, 18).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtSnappingTime, -2, 106, -2).addComponent(this.txtStoryLength, -2, 106, -2).addComponent(this.txtUE2Path, -2, 307, -2)).addGap(15, 15, 15)));
        advancedPanelLayout.setVerticalGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedPanelLayout.createSequentialGroup().addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblStoryLength).addComponent(this.txtStoryLength, -2, -1, -2)).addGap(12, 12, 12).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSnappingTime).addComponent(this.txtSnappingTime, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblUE2Path).addComponent(this.txtUE2Path, -2, -1, -2)).addContainerGap(16, Short.MAX_VALUE)));
        this.buttonPanel.setName("buttonPanel");
        this.btnOk.setText("Ok");
        this.btnOk.setName("btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtSettingsDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setText(StorySettings.currentBundle.getString("CANCEL"));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtSettingsDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnSave.setText(StorySettings.currentBundle.getString("SAVE"));
        this.btnSave.setName("btnSave");
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtSettingsDialog.this.btnSaveActionPerformed(evt);
            }
        });
        GroupLayout buttonPanelLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.btnOk, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addGap(18, 18, 18).addComponent(this.btnSave).addContainerGap(142, Short.MAX_VALUE)));
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPanelLayout.createSequentialGroup().addContainerGap().addGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnCancel).addComponent(this.btnSave)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout settingsMainPanelLayout = new GroupLayout(this.settingsMainPanel);
        this.settingsMainPanel.setLayout(settingsMainPanelLayout);
        settingsMainPanelLayout.setHorizontalGroup(settingsMainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsMainPanelLayout.createSequentialGroup().addGroup(settingsMainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxPanel, -2, -1, -2).addComponent(this.languagePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.advancedPanel, GroupLayout.Alignment.TRAILING, -1, 439, Short.MAX_VALUE).addComponent(this.buttonPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        settingsMainPanelLayout.setVerticalGroup(settingsMainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsMainPanelLayout.createSequentialGroup().addComponent(this.checkBoxPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.languagePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.advancedPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPanel, -2, -1, -2).addGap(80, 80, 80)));
        this.getContentPane().add((Component)this.settingsMainPanel, "Center");
        this.pack();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.propagateChanges();
        StoryTools.saveSettings(".\\config\\settings.xml", this.model.getSettings().getStorySettingsSave());
        this.destroyDialog();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.destroyDialog();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        this.propagateChanges();
        StoryTools.saveSettings(".\\config\\settings.xml", this.model.getSettings().getStorySettingsSave());
    }

    private void resetValues() {
        this.txtStoryLength.setText(String.valueOf(this.model.getSettings().getStoryLength() / 1000L));
        this.txtSnappingTime.setText(String.valueOf(this.model.getSnappingTime()));
        this.model.getSettings();
        this.txtUE2Path.setText(StorySettings.ue2path);
        this.chbAlwaysConfirmChanges.setSelected(this.model.getSettings().isbAlwaysConfirmChanges());
        this.chbSnappingMoveEnabled.setSelected(this.model.getSettings().isbSnappingMoveEnabled());
        this.chbSnappingRotateEnabled.setSelected(this.model.getSettings().isbSnappingRotateEnabled());
        this.chbAskSaveOnClose.setSelected(this.model.getSettings().isbAskSaveStoryOnClose());
        this.chbShowMapDebug.setSelected(this.model.getSettings().isbMapDebug());
        this.model.getSettings();
        this.cmbLanguage.setSelectedItem((Object)StorySettings.language);
    }
}

