/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.dialogs;

import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.tools.IntTextField;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NewtRecordingSettingsDialog
extends JDialog {
    private final StoryController model;
    private JSlider recTimeLapseSlider = null;
    private JSlider recQualitySlider = null;
    public static final String CScontrollerPath = ".\\Recording\\CScontrol\\CScontrol.exe";
    JPanel panel = new JPanel();
    Component component = null;
    private JButton btnCancel;
    private JButton btnOk;
    private JPanel capturePropertiesPanel;
    private JCheckBox chbHackUT;
    private JCheckBox chbRecUseXVIDCodec;
    private JCheckBox chbRecViewFlashingRectangle;
    private JCheckBox chbSaveRecToCSDir;
    private JLabel lblFrameRate;
    private JLabel lblFrames1;
    private JLabel lblFramesPS1;
    private JLabel lblFramesPerSecond1;
    private JLabel lblKeyFrameRate;
    private JLabel lblPlaybackRate;
    private JLabel lblWindowName;
    private JPanel recordingQualityPanel;
    public JSlider slRecQuality;
    private JSlider slRecTimeLapse;
    private JPanel timeLapsePanel;
    private JTextField txtFrameRate;
    private JTextField txtKeyFrameRate;
    private JLabel txtMs;
    private JTextField txtPlaybackRate;
    private JLabel txtQuality1;
    private JLabel txtQuality100;
    private JLabel txtTimeLapse;

    private JSlider getQualitySliderRef() {
        Component[] components = this.recordingQualityPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            this.component = components[i];
            if (!(this.component instanceof JSlider)) continue;
            return (JSlider)this.component;
        }
        return null;
    }

    private JSlider getTimeLapseSliderRef() {
        Component[] components = this.timeLapsePanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            this.component = components[i];
            if (!(this.component instanceof JSlider)) continue;
            return (JSlider)this.component;
        }
        return null;
    }

    public NewtRecordingSettingsDialog(EmoNewtFrame parent, boolean modal, StoryController model) {
        super((Frame)parent, modal);
        this.model = model;
        this.initComponents();
        this.recQualitySlider = this.getQualitySliderRef();
        this.recTimeLapseSlider = this.getTimeLapseSliderRef();
        this.resetValues();
    }

    private void destroyDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void propagateChanges() {
        this.model.getSettings().setRecordingFrameTimeLapse(this.getTimeLapseValueForCSINI(this.slRecTimeLapse.getValue()));
        this.model.getSettings().setbPerformUThack(this.chbHackUT.isSelected());
        this.model.getSettings().setRecordingQuality(this.slRecQuality.getValue());
        this.model.getSettings().setbDrawRecordingAreaRectangle(this.chbRecViewFlashingRectangle.isSelected());
        this.model.getSettings().setbUseXVIDCodec(this.chbRecUseXVIDCodec.isSelected());
        this.model.getSettings().setbAutoSaveRecToCStudioDir(this.chbSaveRecToCSDir.isSelected());
        this.model.getSettings().setFrameRateSliderPosition(this.slRecTimeLapse.getValue());
    }

    private void initComponents() {
        this.btnOk = new JButton();
        this.lblWindowName = new JLabel();
        this.chbRecUseXVIDCodec = new JCheckBox();
        this.chbSaveRecToCSDir = new JCheckBox();
        this.btnCancel = new JButton();
        this.capturePropertiesPanel = new JPanel();
        this.lblFramesPS1 = new JLabel();
        this.lblFrameRate = new JLabel();
        this.lblPlaybackRate = new JLabel();
        this.txtKeyFrameRate = new IntTextField();
        this.txtPlaybackRate = new IntTextField();
        this.lblFramesPerSecond1 = new JLabel();
        this.txtFrameRate = new IntTextField();
        this.lblKeyFrameRate = new JLabel();
        this.lblFrames1 = new JLabel();
        this.recordingQualityPanel = new JPanel();
        this.slRecQuality = new JSlider();
        this.txtQuality1 = new JLabel();
        this.txtQuality100 = new JLabel();
        this.timeLapsePanel = new JPanel();
        this.txtTimeLapse = new JLabel();
        this.slRecTimeLapse = new JSlider();
        this.txtMs = new JLabel();
        this.chbHackUT = new JCheckBox();
        this.chbRecViewFlashingRectangle = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(StorySettings.currentBundle.getString("SETTINGS"));
        this.setResizable(false);
        this.btnOk.setText("Ok");
        this.btnOk.setName("btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtRecordingSettingsDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.lblWindowName.setFont(new Font("Tahoma", 1, 13));
        this.lblWindowName.setName("lblWindowName");
        this.chbRecUseXVIDCodec.setText(StorySettings.currentBundle.getString("REC_USE_XVID_CODEC"));
        this.chbRecUseXVIDCodec.setName("chbRecUseXVIDCodec");
        this.chbSaveRecToCSDir.setText(StorySettings.currentBundle.getString("REC_SAVE_INTO_CS_DIRECTORY"));
        this.chbSaveRecToCSDir.setName("chbSaveRecToCSDir");
        this.btnCancel.setText(StorySettings.currentBundle.getString("CANCEL"));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtRecordingSettingsDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.capturePropertiesPanel.setBorder(BorderFactory.createTitledBorder(StorySettings.currentBundle.getString("REC_CAPTURE_SETTINGS")));
        this.capturePropertiesPanel.setName("capturePropertiesPanel");
        this.lblFramesPS1.setText(StorySettings.currentBundle.getString("REC_FRAMES_PER_SECOND_ABBREV"));
        this.lblFramesPS1.setName("lblFramesPS1");
        this.lblFrameRate.setText(StorySettings.currentBundle.getString("REC_FRAMERATE"));
        this.lblFrameRate.setName("lblFrameRate");
        this.lblPlaybackRate.setText(StorySettings.currentBundle.getString("REC_PLAYBACK_SPEED"));
        this.lblPlaybackRate.setName("lblPlaybackRate");
        this.txtKeyFrameRate.setEditable(false);
        this.txtKeyFrameRate.setHorizontalAlignment(4);
        this.txtKeyFrameRate.setDisabledTextColor(new Color(0, 0, 0));
        this.txtKeyFrameRate.setName("txtKeyFrameRate");
        this.txtPlaybackRate.setEditable(false);
        this.txtPlaybackRate.setHorizontalAlignment(4);
        this.txtPlaybackRate.setDisabledTextColor(new Color(0, 0, 0));
        this.txtPlaybackRate.setName("txtPlaybackRate");
        this.lblFramesPerSecond1.setText(StorySettings.currentBundle.getString("REC_MILISECOND_ABBREV"));
        this.lblFramesPerSecond1.setName("lblFramesPerSecond1");
        this.txtFrameRate.setEditable(false);
        this.txtFrameRate.setHorizontalAlignment(4);
        this.txtFrameRate.setDisabledTextColor(new Color(0, 0, 0));
        this.txtFrameRate.setEnabled(false);
        this.txtFrameRate.setFocusTraversalPolicyProvider(true);
        this.txtFrameRate.setName("txtFrameRate");
        this.lblKeyFrameRate.setText(StorySettings.currentBundle.getString("REC_KEYFRAME_EVERY"));
        this.lblFrames1.setText(StorySettings.currentBundle.getString("REC_FRAMES"));
        this.lblFrames1.setName("lblFrames1");
        GroupLayout capturePropertiesPanelLayout = new GroupLayout(this.capturePropertiesPanel);
        this.capturePropertiesPanel.setLayout(capturePropertiesPanelLayout);
        capturePropertiesPanelLayout.setHorizontalGroup(capturePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(capturePropertiesPanelLayout.createSequentialGroup().addContainerGap().addGroup(capturePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblFrameRate, GroupLayout.Alignment.TRAILING, -1, 177, Short.MAX_VALUE).addComponent(this.lblPlaybackRate, GroupLayout.Alignment.TRAILING, -1, 177, Short.MAX_VALUE).addComponent(this.lblKeyFrameRate, -1, 177, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(capturePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtFrameRate).addComponent(this.txtKeyFrameRate).addComponent(this.txtPlaybackRate, -2, 50, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(capturePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblFramesPS1).addComponent(this.lblFrames1, -1, 117, Short.MAX_VALUE).addComponent(this.lblFramesPerSecond1, -1, 117, Short.MAX_VALUE)).addContainerGap()));
        capturePropertiesPanelLayout.setVerticalGroup(capturePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(capturePropertiesPanelLayout.createSequentialGroup().addContainerGap().addGroup(capturePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtFrameRate, -2, -1, -2).addComponent(this.lblFramesPerSecond1, -2, 14, -2).addComponent(this.lblFrameRate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(capturePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtKeyFrameRate, -2, -1, -2).addComponent(this.lblFrames1).addComponent(this.lblKeyFrameRate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(capturePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPlaybackRate, -2, -1, -2).addComponent(this.lblPlaybackRate).addComponent(this.lblFramesPS1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.recordingQualityPanel.setBorder(BorderFactory.createTitledBorder(StorySettings.currentBundle.getString("REC_SETTING_QUALITY")));
        this.recordingQualityPanel.setName("recordingQualityPanel");
        this.slRecQuality.setMajorTickSpacing(20);
        this.slRecQuality.setMinorTickSpacing(10);
        this.slRecQuality.setPaintLabels(true);
        this.slRecQuality.setPaintTicks(true);
        this.slRecQuality.setName("slRecQuality");
        this.txtQuality1.setText(StorySettings.currentBundle.getString("REC_QUALITY_LOWEST"));
        this.txtQuality1.setFocusCycleRoot(true);
        this.txtQuality1.setName("txtQuality1");
        this.txtQuality100.setText(StorySettings.currentBundle.getString("REC_QUALITY_HIGHEST"));
        this.txtQuality100.setAlignmentX(10.0f);
        this.txtQuality100.setAlignmentY(50.0f);
        this.txtQuality100.setName("txtQuality100");
        GroupLayout recordingQualityPanelLayout = new GroupLayout(this.recordingQualityPanel);
        this.recordingQualityPanel.setLayout(recordingQualityPanelLayout);
        recordingQualityPanelLayout.setHorizontalGroup(recordingQualityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, recordingQualityPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.txtQuality1, -1, 72, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slRecQuality, -2, -1, -2).addGap(16, 16, 16).addComponent(this.txtQuality100).addContainerGap()));
        recordingQualityPanelLayout.setVerticalGroup(recordingQualityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(recordingQualityPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.txtQuality1)).addGroup(recordingQualityPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.txtQuality100)).addGroup(GroupLayout.Alignment.TRAILING, recordingQualityPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.slRecQuality, -2, 48, -2)));
        this.timeLapsePanel.setBorder(BorderFactory.createTitledBorder(StorySettings.currentBundle.getString("REC_TIMELAPSE")));
        this.timeLapsePanel.setName("timeLapsePanel");
        this.txtTimeLapse.setText(StorySettings.currentBundle.getString("REC_MAX_FRAMERATE"));
        this.txtTimeLapse.setAlignmentX(10.0f);
        this.txtTimeLapse.setAlignmentY(50.0f);
        this.txtTimeLapse.setName("txtTimeLapse");
        this.slRecTimeLapse.setMajorTickSpacing(10);
        this.slRecTimeLapse.setMaximum(56);
        this.slRecTimeLapse.setMinimum(1);
        this.slRecTimeLapse.setMinorTickSpacing(5);
        this.slRecTimeLapse.setPaintTicks(true);
        this.slRecTimeLapse.setName("slRecTimeLapse");
        this.slRecTimeLapse.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewtRecordingSettingsDialog.this.slRecTimeLapseStateChanged(evt);
            }
        });
        this.txtMs.setText(StorySettings.currentBundle.getString("REC_MIN_FRAMERATE"));
        this.txtMs.setAlignmentX(10.0f);
        this.txtMs.setAlignmentY(50.0f);
        this.txtMs.setName("txtMs");
        GroupLayout timeLapsePanelLayout = new GroupLayout(this.timeLapsePanel);
        this.timeLapsePanel.setLayout(timeLapsePanelLayout);
        timeLapsePanelLayout.setHorizontalGroup(timeLapsePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timeLapsePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.txtTimeLapse).addComponent(this.slRecTimeLapse, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtMs).addContainerGap(26, Short.MAX_VALUE)));
        timeLapsePanelLayout.setVerticalGroup(timeLapsePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timeLapsePanelLayout.createSequentialGroup().addContainerGap().addGroup(timeLapsePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.slRecTimeLapse, -2, -1, -2).addGroup(timeLapsePanelLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.txtMs)).addGroup(timeLapsePanelLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.txtTimeLapse))).addContainerGap(14, Short.MAX_VALUE)));
        this.chbHackUT.setText(StorySettings.currentBundle.getString("REC_PERFORM_UT_HACK"));
        this.chbHackUT.setName("chbHackUT");
        this.chbRecViewFlashingRectangle.setText(StorySettings.currentBundle.getString("REC_SHOW_RECORDING_RECTANGLE"));
        this.chbRecViewFlashingRectangle.setName("chbRecViewFlashingRectangle");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblWindowName)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.capturePropertiesPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.timeLapsePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.recordingQualityPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btnOk, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnCancel)).addComponent(this.chbSaveRecToCSDir, GroupLayout.Alignment.LEADING, -1, 360, Short.MAX_VALUE).addComponent(this.chbHackUT, GroupLayout.Alignment.LEADING, -2, 360, -2).addComponent(this.chbRecViewFlashingRectangle, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.chbRecUseXVIDCodec, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblWindowName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 32, Short.MAX_VALUE).addComponent(this.chbRecUseXVIDCodec).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chbRecViewFlashingRectangle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chbSaveRecToCSDir).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chbHackUT).addGap(18, 18, 18).addComponent(this.recordingQualityPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeLapsePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.capturePropertiesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addGap(21, 21, 21)));
        this.pack();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.propagateChanges();
        StoryTools.saveSettings(".\\config\\settings.xml", this.model.getSettings().getStorySettingsSave());
        this.destroyDialog();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.destroyDialog();
    }

    private int getTimeLapseValueForCSINI(int sliderValue) {
        return (int)Math.floor(1000 / (sliderValue <= 16 ? 210 - 10 * sliderValue : 57 - sliderValue));
    }

    private void slRecTimeLapseStateChanged(ChangeEvent evt) {
        int slValue = this.slRecTimeLapse.getValue();
        int tempKFRate = slValue <= 16 ? 210 - 10 * slValue : 57 - slValue;
        this.txtFrameRate.setText(String.valueOf(this.getTimeLapseValueForCSINI(slValue)));
        this.txtKeyFrameRate.setText(String.valueOf(tempKFRate));
        this.txtPlaybackRate.setText(String.valueOf(tempKFRate));
    }

    private void resetValues() {
        this.chbRecViewFlashingRectangle.setSelected(this.model.getSettings().getbDrawRecordingAreaRectangle());
        this.chbRecUseXVIDCodec.setSelected(this.model.getSettings().getbUseXVIDCodec());
        this.chbSaveRecToCSDir.setSelected(this.model.getSettings().isbAutoSaveRecToCStudioDir());
        this.chbHackUT.setSelected(this.model.getSettings().getbPerformUThack());
        this.recQualitySlider.setValue(this.model.getSettings().getbRecordingQuality());
        this.recTimeLapseSlider.setValue(this.model.getSettings().getFrameRateSliderPosition());
    }
}

