/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.dialogs;

import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.tools.IntTextField;
import cz.cuni.amis.pogamut.emonewt.gui.tools.NumericTextField;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionRotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class NewtNewRotationDialog
extends JDialog {
    private final EmohawkCharacter character;
    private final EmoNewtFrame frame;
    private JButton btnAddRotation;
    private JButton btnCancel;
    private JButton btnSnapAngle;
    private JLabel lblAngleH;
    private JLabel lblAngleV;
    private JLabel lblDescription;
    private JLabel lblDuration;
    private JLabel lblTime;
    private JLabel lblWindowName;
    private JTextField txtAngleH;
    private JTextField txtAngleV;
    private JTextField txtDescription;
    private JTextField txtDuration;
    private JTextField txtTime;

    public NewtNewRotationDialog(EmoNewtFrame parent, boolean modal, EmohawkCharacter ec) {
        super((Frame)parent, modal);
        this.frame = parent;
        this.character = ec;
        this.initComponents();
    }

    private void destroyDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.btnAddRotation = new JButton();
        this.btnCancel = new JButton();
        this.lblWindowName = new JLabel();
        this.lblDescription = new JLabel();
        this.txtDescription = new JTextField();
        this.lblTime = new JLabel();
        this.lblAngleH = new JLabel();
        this.txtAngleH = new IntTextField();
        this.txtTime = new NumericTextField();
        this.lblDuration = new JLabel();
        this.txtDuration = new NumericTextField();
        this.lblAngleV = new JLabel();
        this.txtAngleV = new IntTextField();
        this.btnSnapAngle = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(StorySettings.currentBundle.getString("NEW ROTATION"));
        this.btnAddRotation.setText(StorySettings.currentBundle.getString("ADD"));
        this.btnAddRotation.setToolTipText(StorySettings.currentBundle.getString("USE_H"));
        this.btnAddRotation.setName("btnAddRotation");
        this.btnAddRotation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtNewRotationDialog.this.btnAddRotationActionPerformed(evt);
            }
        });
        this.btnCancel.setText(StorySettings.currentBundle.getString("CANCEL"));
        this.btnCancel.setToolTipText(StorySettings.currentBundle.getString("CANCEL"));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtNewRotationDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.lblWindowName.setFont(new Font("Tahoma", 1, 13));
        this.lblWindowName.setText(StorySettings.currentBundle.getString("NEW ROTATION"));
        this.lblWindowName.setName("lblWindowName");
        this.lblDescription.setText(StorySettings.currentBundle.getString("DESCRIPTION:"));
        this.lblDescription.setName("lblDescription");
        this.txtDescription.setToolTipText(StorySettings.currentBundle.getString("DESCRIPTION_H"));
        this.txtDescription.setName("txtDescription");
        this.lblTime.setText(StorySettings.currentBundle.getString("TIME:"));
        this.lblTime.setName("lblTime");
        this.lblAngleH.setText(StorySettings.currentBundle.getString("ANGLEH:"));
        this.lblAngleH.setName("lblAngleH");
        this.txtAngleH.setHorizontalAlignment(4);
        this.txtAngleH.setToolTipText(StorySettings.currentBundle.getString("ROT_ANGLE_H"));
        this.txtAngleH.setName("txtAngleH");
        this.txtTime.setHorizontalAlignment(4);
        this.txtTime.setToolTipText(StorySettings.currentBundle.getString("TIME_H"));
        this.txtTime.setName("txtTime");
        this.lblDuration.setText(StorySettings.currentBundle.getString("DURATION:"));
        this.lblDuration.setName("lblDuration");
        this.txtDuration.setHorizontalAlignment(4);
        this.txtDuration.setToolTipText(StorySettings.currentBundle.getString("DURATION_H"));
        this.txtDuration.setName("txtDuration");
        this.lblAngleV.setText(StorySettings.currentBundle.getString("ANGLEV:"));
        this.lblAngleV.setName("lblAngleV");
        this.txtAngleV.setHorizontalAlignment(4);
        this.txtAngleV.setToolTipText(StorySettings.currentBundle.getString("ROT_ANGLE_H"));
        this.txtAngleV.setName("txtAngleV");
        this.btnSnapAngle.setText(StorySettings.currentBundle.getString("ANGLE_SNAP"));
        this.btnSnapAngle.setToolTipText(StorySettings.currentBundle.getString("ANGLE_SNAP_TOOLTIP"));
        this.btnSnapAngle.setName("btnSnapAngle");
        this.btnSnapAngle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtNewRotationDialog.this.btnSnapAngleActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblWindowName).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDescription).addComponent(this.lblTime).addComponent(this.lblDuration).addComponent(this.lblAngleH).addComponent(this.lblAngleV)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtDescription, -1, 251, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.txtAngleV, GroupLayout.Alignment.LEADING).addComponent(this.txtAngleH, GroupLayout.Alignment.LEADING).addComponent(this.txtTime, GroupLayout.Alignment.LEADING).addComponent(this.txtDuration, GroupLayout.Alignment.LEADING, -1, 66, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 185, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.btnAddRotation).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSnapAngle))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblWindowName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDescription).addComponent(this.txtDescription, -2, -1, -2)).addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDuration).addComponent(this.txtDuration, -2, -1, -2)).addGap(39, 39, 39).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.txtAngleH, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtAngleV, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lblAngleH).addGap(18, 18, 18).addComponent(this.lblAngleV))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAddRotation).addComponent(this.btnCancel).addComponent(this.btnSnapAngle))).addGroup(layout.createSequentialGroup().addGap(92, 92, 92).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTime).addComponent(this.txtTime, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnAddRotationActionPerformed(ActionEvent evt) {
        long newTime = 0L;
        long newDuration = 0L;
        int newAngleH = 0;
        int newAngleV = 0;
        try {
            newTime = (long)(((NumericTextField)this.txtTime).getDoubleValue() * 1000.0);
            newDuration = (long)(((NumericTextField)this.txtDuration).getDoubleValue() * 1000.0);
            newAngleH = Integer.valueOf(this.txtAngleH.getText());
            newAngleV = Integer.valueOf(this.txtAngleV.getText());
            if (newAngleH > 180 || newAngleH < -180) {
                StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("ROTATION MUST BE BETWEEN -180 and 180 DEGREES"));
                return;
            }
            if (newAngleV > 180 || newAngleV < -180) {
                StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("ROTATION MUST BE BETWEEN -180 and 180 DEGREES"));
                return;
            }
            new StoryTools();
            newAngleH = StoryTools.angleToUTUnits(newAngleH);
            new StoryTools();
            newAngleV = StoryTools.angleToUTUnits(newAngleV);
        }
        catch (ParseException ex) {
            StoryTools.userNotificationDialog(this, ResourceBundle.getBundle("cz/cuni/amis/pogamut/emonewt/gui/resources/NewtStrings").getString("PLEASE FILL IN ALL FIELDS"));
            return;
        }
        catch (NumberFormatException e) {
            StoryTools.userNotificationDialog(this, ResourceBundle.getBundle("cz/cuni/amis/pogamut/emonewt/gui/resources/NewtStrings").getString("PLEASE FILL IN ALL FIELDS"));
            return;
        }
        ActionRotation newRotation = new ActionRotation(this.character, newTime, newDuration, newAngleH, newAngleV, this.txtDescription.getText());
        ChangeStoryAction change = new ChangeStoryAction(ChangeType.ADD, this.character, newRotation.getActionProperties(), newRotation);
        this.character.getModel().processChangeStoryAction(change);
        this.destroyDialog();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.destroyDialog();
    }

    private void btnSnapAngleActionPerformed(ActionEvent evt) {
        Rotation rotationSnap = this.frame.getController().getUnrealStoryPlayer().getRotationSnapFromUnreal();
        this.txtAngleH.setText(String.valueOf(StoryTools.unitsToAngle(rotationSnap.yaw)));
        this.txtAngleV.setText(String.valueOf(StoryTools.unitsToAngle(rotationSnap.pitch)));
    }
}

