/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.dialogs;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.tools.DrawingPanel;
import cz.cuni.amis.pogamut.emonewt.gui.tools.IntTextField;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeCharacter;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.CharacterProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EBodyTexType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ECharacterType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.ESkinTexType;
import java.awt.Font;
import java.awt.Frame;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewtNewCharDialog
extends JDialog {
    private final StoryController model;
    private final EmoNewtFrame frame;
    private List<ECharacterType> characterTypes;
    private List<ESkinTexType> skinTexs;
    private List<EBodyTexType> bodyTexs;
    private Map<ECharacterType, Map<Integer, String>> imageFiles;
    private Location initialLocation = new Location(0.0, 0.0, 0.0);
    private JButton btnAddCharacter;
    private JButton btnCancel;
    private JButton btnSnapAngle;
    private ScrollPane charShowPane;
    private JComboBox cmbBodyTex;
    private JComboBox cmbCharType;
    private JComboBox cmbSkinTex;
    private JLabel lblBodyTexture;
    private JLabel lblCharName;
    private JLabel lblCharType;
    private JLabel lblLocationValueXY;
    private JLabel lblNotification;
    private JLabel lblSkinTexture;
    private JLabel lblStartLocation;
    private JLabel lblStartRotation;
    private JLabel lblWindowName;
    private JTextField txtAngleH;
    private JTextField txtAngleV;
    private JTextField txtCharName;
    private JTextField txtLocationZ;

    public NewtNewCharDialog(EmoNewtFrame parent, boolean modal, StoryController model) {
        super((Frame)parent, modal);
        this.model = model;
        this.frame = parent;
        this.characterTypes = new ArrayList<ECharacterType>();
        this.characterTypes.addAll(ECharacterType.getCollection());
        this.initComponents();
        this.resetTextures((ECharacterType)((Object)this.cmbCharType.getSelectedItem()));
        this.cmbCharType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    NewtNewCharDialog.this.resetTextures((ECharacterType)((Object)e.getItem()));
                }
                NewtNewCharDialog.this.updateTextures();
            }
        });
        this.cmbBodyTex.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                NewtNewCharDialog.this.updateTextures();
            }
        });
        this.imageFiles = this.initializeImages();
        this.updateTextures();
        this.txtCharName.setText(this.cmbCharType.getSelectedItem().toString());
        this.initialLocation = new Location(0.0, 0.0, StoryTools.getDefaultZ());
        this.lblLocationValueXY.setText(Math.round(this.initialLocation.x) + "," + Math.round(this.initialLocation.y));
        ((IntTextField)this.txtLocationZ).setText(String.valueOf(Math.round(this.initialLocation.z)));
    }

    public void setInitialLocation(Location loc) {
        loc.x = Math.round(loc.x);
        loc.y = Math.round(loc.y);
        loc.z = Math.round(loc.z);
        this.initialLocation = new Location(loc);
        this.lblLocationValueXY.setText(loc.x + "," + loc.y);
        ((IntTextField)this.txtLocationZ).setText(String.valueOf(Math.round(loc.z)));
    }

    private Map<ECharacterType, Map<Integer, String>> initializeImages() {
        HashMap<ECharacterType, Map<Integer, String>> ims = new HashMap<ECharacterType, Map<Integer, String>>();
        ims.put(ECharacterType.THOMAS, new HashMap());
        ((Map)ims.get((Object)ECharacterType.THOMAS)).put(0, "images/charScreenshots/BoyBlue.jpg");
        ((Map)ims.get((Object)ECharacterType.THOMAS)).put(1, "images/charScreenshots/BoyYellow.jpg");
        ((Map)ims.get((Object)ECharacterType.THOMAS)).put(2, "images/charScreenshots/BoyUfo.jpg");
        ((Map)ims.get((Object)ECharacterType.THOMAS)).put(3, "images/charScreenshots/BoyNone.jpg");
        ims.put(ECharacterType.NATALIE, new HashMap());
        ((Map)ims.get((Object)ECharacterType.NATALIE)).put(0, "images/charScreenshots/GirlOnePinkandWhite.jpg");
        ((Map)ims.get((Object)ECharacterType.NATALIE)).put(1, "images/charScreenshots/GirlOneYellowandGray.jpg");
        ((Map)ims.get((Object)ECharacterType.NATALIE)).put(2, "images/charScreenshots/GirlOneBlue.jpg");
        ((Map)ims.get((Object)ECharacterType.NATALIE)).put(3, "images/charScreenshots/GirlOnePink.jpg");
        ((Map)ims.get((Object)ECharacterType.NATALIE)).put(4, "images/charScreenshots/GirlOneUfo.jpg");
        ((Map)ims.get((Object)ECharacterType.NATALIE)).put(5, "images/charScreenshots/GirlOneNone.jpg");
        ims.put(ECharacterType.BARBARA, new HashMap());
        ((Map)ims.get((Object)ECharacterType.BARBARA)).put(0, "images/charScreenshots/GirlTwoPink.jpg");
        ((Map)ims.get((Object)ECharacterType.BARBARA)).put(1, "images/charScreenshots/GirlTwoViolet.jpg");
        ((Map)ims.get((Object)ECharacterType.BARBARA)).put(2, "images/charScreenshots/GirlTwoBlue.jpg");
        ((Map)ims.get((Object)ECharacterType.BARBARA)).put(3, "images/charScreenshots/GirlTwoTyrkis.jpg");
        ((Map)ims.get((Object)ECharacterType.BARBARA)).put(4, "images/charScreenshots/GirlTwoRed.jpg");
        ((Map)ims.get((Object)ECharacterType.BARBARA)).put(5, "images/charScreenshots/GirlTwoUfo.jpg");
        ((Map)ims.get((Object)ECharacterType.BARBARA)).put(6, "images/charScreenshots/GirlTwoNone.jpg");
        ims.put(ECharacterType.UDN_MALE, new HashMap());
        ((Map)ims.get((Object)ECharacterType.UDN_MALE)).put(0, "images/charScreenshots/UDNMaleGray.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_MALE)).put(1, "images/charScreenshots/UDNMaleBlue1.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_MALE)).put(2, "images/charScreenshots/UDNMaleBlue2.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_MALE)).put(3, "images/charScreenshots/UDNMaleBrown.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_MALE)).put(4, "images/charScreenshots/UDNMaleGreen1.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_MALE)).put(5, "images/charScreenshots/UDNMaleGreen2.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_MALE)).put(6, "images/charScreenshots/UDNMaleRed.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_MALE)).put(7, "images/charScreenshots/UDNMaleWhite1.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_MALE)).put(8, "images/charScreenshots/UDNMaleWhite2.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_MALE)).put(9, "images/charScreenshots/UDNMaleYellow.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_MALE)).put(10, "images/charScreenshots/UDNMaleNone.jpg");
        ims.put(ECharacterType.UDN_FEMALE, new HashMap());
        ((Map)ims.get((Object)ECharacterType.UDN_FEMALE)).put(0, "images/charScreenshots/UDNFemalePurple1.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_FEMALE)).put(1, "images/charScreenshots/UDNFemaleGreen1.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_FEMALE)).put(2, "images/charScreenshots/UDNFemaleBlue1.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_FEMALE)).put(3, "images/charScreenshots/UDNFemaleBlue2.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_FEMALE)).put(4, "images/charScreenshots/UDNFemaleBlue3.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_FEMALE)).put(5, "images/charScreenshots/UDNFemalePurple2.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_FEMALE)).put(6, "images/charScreenshots/UDNFemaleOrange.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_FEMALE)).put(7, "images/charScreenshots/UDNFemaleGreen2.jpg");
        ((Map)ims.get((Object)ECharacterType.UDN_FEMALE)).put(8, "images/charScreenshots/UDNFemaleNone.jpg");
        ims.put(ECharacterType.EMOHAWK, new HashMap());
        ((Map)ims.get((Object)ECharacterType.EMOHAWK)).put(0, "images/charScreenshots/EmohawkDefault.jpg");
        ((Map)ims.get((Object)ECharacterType.EMOHAWK)).put(1, "images/charScreenshots/EmohawkDark.jpg");
        ((Map)ims.get((Object)ECharacterType.EMOHAWK)).put(2, "images/charScreenshots/EmohawkNone.jpg");
        return ims;
    }

    private void updateTextures() {
        if (this.cmbBodyTex.getSelectedItem() == null) {
            DrawingPanel drawingPanel = new DrawingPanel(null);
            this.charShowPane.add(drawingPanel);
            this.lblNotification.setText("No preview available");
            return;
        }
        EBodyTexType type = (EBodyTexType)((Object)this.cmbBodyTex.getSelectedItem());
        String filePath = "";
        if (this.imageFiles.containsKey((Object)type.getType()) && this.imageFiles.get((Object)type.getType()).containsKey(type.getTextureID())) {
            filePath = this.imageFiles.get((Object)type.getType()).get(type.getTextureID());
        }
        if (filePath.equals("")) {
            DrawingPanel drawingPanel = new DrawingPanel(null);
            this.charShowPane.add(drawingPanel);
            this.lblNotification.setText("No preview available");
            return;
        }
        File f = new File(filePath);
        BufferedImage bimage = null;
        try {
            bimage = ImageIO.read(f);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        DrawingPanel drawingPanel = new DrawingPanel(bimage.getScaledInstance(this.charShowPane.getWidth(), this.charShowPane.getHeight(), 4));
        this.charShowPane.add(drawingPanel);
        this.lblNotification.setText("");
        this.txtCharName.setText(this.cmbCharType.getSelectedItem().toString());
    }

    private void resetTextures(ECharacterType type) {
        this.skinTexs = new ArrayList<ESkinTexType>(ESkinTexType.getSkinTextures(type));
        this.bodyTexs = new ArrayList<EBodyTexType>(EBodyTexType.getBodyTextures(type));
        this.cmbBodyTex.setModel(new DefaultComboBoxModel<Object>(this.bodyTexs.toArray()));
        this.cmbSkinTex.setModel(new DefaultComboBoxModel<Object>(this.skinTexs.toArray()));
    }

    private void destroyDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.lblWindowName = new JLabel();
        this.lblBodyTexture = new JLabel();
        this.lblSkinTexture = new JLabel();
        this.btnAddCharacter = new JButton();
        this.cmbCharType = new JComboBox();
        this.lblStartLocation = new JLabel();
        this.lblStartRotation = new JLabel();
        this.lblCharName = new JLabel();
        this.lblLocationValueXY = new JLabel();
        this.cmbBodyTex = new JComboBox();
        this.lblCharType = new JLabel();
        this.cmbSkinTex = new JComboBox();
        this.txtCharName = new JTextField();
        this.btnCancel = new JButton();
        this.charShowPane = new ScrollPane();
        this.lblNotification = new JLabel();
        this.txtAngleH = new IntTextField();
        this.txtAngleV = new IntTextField();
        this.btnSnapAngle = new JButton();
        this.txtLocationZ = new IntTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle(StorySettings.currentBundle.getString("NEW CHARACTER"));
        this.setResizable(false);
        this.lblWindowName.setFont(new Font("Tahoma", 1, 13));
        this.lblWindowName.setText(StorySettings.currentBundle.getString("NEW CHARACTER"));
        this.lblWindowName.setName("lblWindowName");
        this.lblBodyTexture.setText(StorySettings.currentBundle.getString("BODY TEX:"));
        this.lblBodyTexture.setName("lblBodyTexture");
        this.lblSkinTexture.setText(StorySettings.currentBundle.getString("SKIN TEX:"));
        this.lblSkinTexture.setName("lblSkinTexture");
        this.btnAddCharacter.setText(StorySettings.currentBundle.getString("ADD"));
        this.btnAddCharacter.setToolTipText(StorySettings.currentBundle.getString("USE_H"));
        this.btnAddCharacter.setName("btnAddCharacter");
        this.btnAddCharacter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtNewCharDialog.this.btnAddCharacterActionPerformed(evt);
            }
        });
        this.cmbCharType.setModel(new DefaultComboBoxModel<Object>(this.characterTypes.toArray()));
        this.cmbCharType.setToolTipText(StorySettings.currentBundle.getString("CHAR_TYPE_H"));
        this.cmbCharType.setName("cmbCharType");
        this.lblStartLocation.setText(StorySettings.currentBundle.getString("START LOC:"));
        this.lblStartLocation.setName("lblStartLocation");
        this.lblStartRotation.setText(StorySettings.currentBundle.getString("START ROT:"));
        this.lblStartRotation.setName("lblStartRotation");
        this.lblCharName.setText(StorySettings.currentBundle.getString("CHAR NAME:"));
        this.lblCharName.setName("lblCharName");
        this.lblLocationValueXY.setText("0,0");
        this.lblLocationValueXY.setName("lblLocationValueXY");
        this.cmbBodyTex.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbBodyTex.setName("cmbBodyTex");
        this.lblCharType.setText(StorySettings.currentBundle.getString("CHAR TYPE:"));
        this.lblCharType.setName("lblCharType");
        this.cmbSkinTex.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbSkinTex.setName("cmbSkinTex");
        this.txtCharName.setToolTipText(StorySettings.currentBundle.getString("CHAR_NAME_H"));
        this.txtCharName.setName("txtCharName");
        this.btnCancel.setText(StorySettings.currentBundle.getString("CANCEL"));
        this.btnCancel.setToolTipText(StorySettings.currentBundle.getString("CANCEL"));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtNewCharDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.charShowPane.setName("charShowPane");
        this.lblNotification.setName("lblNotification");
        this.txtAngleH.setHorizontalAlignment(4);
        this.txtAngleH.setText("0");
        this.txtAngleH.setToolTipText(StorySettings.currentBundle.getString("ROTATION_YAW"));
        this.txtAngleH.setName("txtAngleH");
        this.txtAngleV.setHorizontalAlignment(4);
        this.txtAngleV.setText("0");
        this.txtAngleV.setToolTipText(StorySettings.currentBundle.getString("ROT_ANGLE_H"));
        this.txtAngleV.setName("txtAngleV");
        this.btnSnapAngle.setText(StorySettings.currentBundle.getString("ANGLE_SNAP"));
        this.btnSnapAngle.setToolTipText(StorySettings.currentBundle.getString("ANGLE_SNAP_TOOLTIP"));
        this.btnSnapAngle.setName("btnSnapAngle");
        this.btnSnapAngle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtNewCharDialog.this.btnSnapAngleActionPerformed(evt);
            }
        });
        this.txtLocationZ.setHorizontalAlignment(4);
        this.txtLocationZ.setText("0");
        this.txtLocationZ.setToolTipText(StorySettings.currentBundle.getString("ROT_ANGLE_H"));
        this.txtLocationZ.setName("txtLocationZ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblWindowName).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnSnapAngle, GroupLayout.Alignment.LEADING, -1, 99, Short.MAX_VALUE).addComponent(this.lblCharName, GroupLayout.Alignment.LEADING, -1, 99, Short.MAX_VALUE).addComponent(this.lblCharType, GroupLayout.Alignment.LEADING).addComponent(this.lblSkinTexture, GroupLayout.Alignment.LEADING).addComponent(this.lblBodyTexture, GroupLayout.Alignment.LEADING).addComponent(this.lblStartLocation, GroupLayout.Alignment.LEADING).addComponent(this.lblStartRotation, GroupLayout.Alignment.LEADING).addComponent(this.btnAddCharacter, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmbBodyTex, 0, -1, Short.MAX_VALUE).addComponent(this.cmbSkinTex, 0, -1, Short.MAX_VALUE).addComponent(this.cmbCharType, 0, -1, Short.MAX_VALUE).addComponent(this.txtCharName, -2, 143, -2)).addComponent(this.btnCancel).addGroup(layout.createSequentialGroup().addComponent(this.lblLocationValueXY, -2, 92, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 4, Short.MAX_VALUE).addComponent(this.txtLocationZ, -2, 47, -2)).addGroup(layout.createSequentialGroup().addComponent(this.txtAngleH, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtAngleV, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(73, 73, 73).addComponent(this.lblNotification)).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.charShowPane, -2, 173, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.charShowPane, -2, 201, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNotification)).addGroup(layout.createSequentialGroup().addComponent(this.lblWindowName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCharName).addComponent(this.txtCharName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCharType).addComponent(this.cmbCharType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSkinTexture).addComponent(this.cmbSkinTex, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBodyTexture).addComponent(this.cmbBodyTex, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblStartLocation).addComponent(this.lblLocationValueXY).addComponent(this.txtLocationZ, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblStartRotation).addComponent(this.txtAngleH, -2, -1, -2).addComponent(this.txtAngleV, -2, -1, -2)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAddCharacter).addComponent(this.btnCancel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSnapAngle))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnAddCharacterActionPerformed(ActionEvent evt) {
        if (((IntTextField)this.txtAngleH).getValue() < -180) {
            this.txtAngleH.setText(String.valueOf(-180));
        } else if (((IntTextField)this.txtAngleH).getValue() > 180) {
            this.txtAngleH.setText(String.valueOf(180));
        }
        if (((IntTextField)this.txtAngleV).getValue() < -180) {
            this.txtAngleV.setText(String.valueOf(-180));
        } else if (((IntTextField)this.txtAngleV).getValue() > 180) {
            this.txtAngleV.setText(String.valueOf(180));
        }
        Location loc = this.initialLocation;
        loc.z = ((IntTextField)this.txtLocationZ).getValue();
        CharacterProperties charProp = new CharacterProperties(this.txtCharName.getText(), loc, new Rotation((double)StoryTools.angleToUTUnits(((IntTextField)this.txtAngleV).getValue()), (double)StoryTools.angleToUTUnits(((IntTextField)this.txtAngleH).getValue()), 0.0), (ECharacterType)((Object)this.cmbCharType.getSelectedItem()), (EBodyTexType)((Object)this.cmbBodyTex.getSelectedItem()), (ESkinTexType)((Object)this.cmbSkinTex.getSelectedItem()));
        if ((ECharacterType)((Object)this.cmbCharType.getSelectedItem()) == ECharacterType.CAMERA && this.model.getCamerasCount() >= 2) {
            StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("CAMERAS_NUMBER_EXCEEDED"));
            return;
        }
        ChangeCharacter change = new ChangeCharacter(ChangeType.ADD, charProp);
        this.model.processChangeCharacter(change);
        this.destroyDialog();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.destroyDialog();
    }

    private void btnSnapAngleActionPerformed(ActionEvent evt) {
        Rotation rotationSnap = this.frame.getController().getUnrealStoryPlayer().getRotationSnapFromUnreal();
        this.txtAngleH.setText(String.valueOf(StoryTools.unitsToAngle(rotationSnap.yaw)));
        this.txtAngleV.setText(String.valueOf(StoryTools.unitsToAngle(rotationSnap.pitch)));
    }
}

