/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.dialogs;

import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtAnimationProperties;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtCharacterProperties;
import cz.cuni.amis.pogamut.emonewt.gui.tools.AnimationInfo;
import cz.cuni.amis.pogamut.emonewt.gui.tools.NumericTextField;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.Exceptions;

public class NewtNewAnimationDialog
extends JDialog {
    private final ViewController controller;
    private final EmohawkCharacter character;
    private List<AnimationInfo> animations;
    public final EmoNewtFrame frame;
    private JButton btnAddAnimation;
    private JButton btnCancel;
    private JButton btnLoopPreview;
    private JButton btnPreview;
    private JScrollPane jScrollPane1;
    private JLabel lblAnimationName;
    private JLabel lblDescription;
    private JLabel lblDuration;
    private JLabel lblLoopCount;
    private JLabel lblOrder;
    private JLabel lblTime;
    private JLabel lblWindowName;
    private JList lstAnimations;
    private JSpinner spnLoopCount;
    private JSpinner spnOrder;
    private JTextField txtAnimName;
    private JTextField txtDescription;
    private JTextField txtDuration;
    private JTextField txtTime;

    public NewtNewAnimationDialog(EmoNewtFrame parent, boolean modal, EmohawkCharacter ec) {
        super((Frame)parent, modal);
        this.frame = parent;
        this.character = ec;
        this.controller = parent.getController();
        this.animations = this.character.getModel().getAnimations(this.character);
        StoryTools storyTools = new StoryTools();
        Collections.sort(this.animations, storyTools.animationInfoDescriptionOrderComparator());
        this.initComponents();
        this.spnOrder.setModel(new SpinnerNumberModel(this.character.getAnimations().size() + 1, 1, this.character.getAnimations().size() + 1, 1));
        this.lstAnimations.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AnimationInfo anim = (AnimationInfo)NewtNewAnimationDialog.this.lstAnimations.getSelectedValue();
                NewtNewAnimationDialog.this.txtAnimName.setText(anim.getAnimationId());
                ((NumericTextField)NewtNewAnimationDialog.this.txtDuration).setValue(anim.getDurationInSeconds() * (double)((Integer)NewtNewAnimationDialog.this.spnLoopCount.getValue()).intValue());
                NewtNewAnimationDialog.this.txtDescription.setText(anim.getLocalizedDescription());
            }
        });
        this.spnLoopCount.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (NewtNewAnimationDialog.this.lstAnimations.getSelectedValue() == null) {
                    return;
                }
                AnimationInfo anim = (AnimationInfo)NewtNewAnimationDialog.this.lstAnimations.getSelectedValue();
                ((NumericTextField)NewtNewAnimationDialog.this.txtDuration).setValue(anim.getDurationInSeconds() * (double)((Integer)NewtNewAnimationDialog.this.spnLoopCount.getValue()).intValue());
            }
        });
    }

    private void destroyDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.btnAddAnimation = new JButton();
        this.btnCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.lstAnimations = new JList();
        this.spnOrder = new JSpinner();
        this.lblOrder = new JLabel();
        this.spnLoopCount = new JSpinner();
        this.txtAnimName = new JTextField();
        this.lblLoopCount = new JLabel();
        this.lblDuration = new JLabel();
        this.txtDuration = new NumericTextField();
        this.lblAnimationName = new JLabel();
        this.txtTime = new NumericTextField();
        this.lblTime = new JLabel();
        this.lblWindowName = new JLabel();
        this.lblDescription = new JLabel();
        this.txtDescription = new JTextField();
        this.btnPreview = new JButton();
        this.btnLoopPreview = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(StorySettings.currentBundle.getString("NEW ANIMATION"));
        this.btnAddAnimation.setText(StorySettings.currentBundle.getString("ADD"));
        this.btnAddAnimation.setToolTipText(StorySettings.currentBundle.getString("USE_H"));
        this.btnAddAnimation.setName("btnAddAnimation");
        this.btnAddAnimation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtNewAnimationDialog.this.btnAddAnimationActionPerformed(evt);
            }
        });
        this.btnCancel.setText(StorySettings.currentBundle.getString("CANCEL"));
        this.btnCancel.setToolTipText(StorySettings.currentBundle.getString("CANCEL"));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtNewAnimationDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.lstAnimations.setModel(new AbstractListModel(){
            Object[] strings;
            {
                this.strings = NewtNewAnimationDialog.this.animations.toArray();
            }

            public int getSize() {
                return NewtNewAnimationDialog.this.animations.size();
            }

            public Object getElementAt(int i) {
                return NewtNewAnimationDialog.this.animations.get(i);
            }
        });
        this.lstAnimations.setSelectionMode(0);
        this.lstAnimations.setToolTipText(StorySettings.currentBundle.getString("ANIMCHOOSERHELP"));
        this.lstAnimations.setName("lstAnimations");
        this.jScrollPane1.setViewportView(this.lstAnimations);
        this.spnOrder.setToolTipText(StorySettings.currentBundle.getString("ORDERHELP"));
        this.spnOrder.setEditor(new JSpinner.NumberEditor(this.spnOrder, ""));
        this.spnOrder.setName("spnOrder");
        this.spnOrder.setValue(this.character.getAnimations().size() + 1);
        this.lblOrder.setText(StorySettings.currentBundle.getString("ORDER:"));
        this.lblOrder.setName("lblOrder");
        this.spnLoopCount.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.spnLoopCount.setToolTipText(StorySettings.currentBundle.getString("LOOPHELP"));
        this.spnLoopCount.setEditor(new JSpinner.NumberEditor(this.spnLoopCount, ""));
        this.spnLoopCount.setName("spnLoopCount");
        this.txtAnimName.setEditable(false);
        this.txtAnimName.setName("txtAnimName");
        this.lblLoopCount.setText(StorySettings.currentBundle.getString("LOOP COUNT:"));
        this.lblLoopCount.setName("lblLoopCount");
        this.lblDuration.setText(StorySettings.currentBundle.getString("DURATION:"));
        this.lblDuration.setName("lblDuration");
        this.txtDuration.setEditable(false);
        this.txtDuration.setHorizontalAlignment(4);
        this.txtDuration.setText("0");
        this.txtDuration.setCursor(new Cursor(2));
        this.txtDuration.setName("txtDuration");
        this.lblAnimationName.setText(StorySettings.currentBundle.getString("ANIM ID:"));
        this.lblAnimationName.setName("lblAnimationName");
        this.txtTime.setEditable(false);
        this.txtTime.setHorizontalAlignment(4);
        this.txtTime.setText("0");
        this.txtTime.setName("txtTime");
        this.lblTime.setText(StorySettings.currentBundle.getString("TIME:"));
        this.lblTime.setName("lblTime");
        this.lblWindowName.setFont(new Font("Tahoma", 1, 13));
        this.lblWindowName.setText(StorySettings.currentBundle.getString("NEW ANIMATION"));
        this.lblWindowName.setName("lblWindowName");
        this.lblDescription.setText(StorySettings.currentBundle.getString("DESCRIPTION:"));
        this.lblDescription.setName("lblDescription");
        this.txtDescription.setEditable(false);
        this.txtDescription.setName("txtDescription");
        this.btnPreview.setText(StorySettings.currentBundle.getString("PREVIEW"));
        this.btnPreview.setToolTipText(StorySettings.currentBundle.getString("PREVIEWHELP"));
        this.btnPreview.setName("btnPreview");
        this.btnPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtNewAnimationDialog.this.btnPreviewActionPerformed(evt);
            }
        });
        this.btnLoopPreview.setText(StorySettings.currentBundle.getString("LOOPPREVIEW"));
        this.btnLoopPreview.setToolTipText(StorySettings.currentBundle.getString("LOOPPREVIEWHELP"));
        this.btnLoopPreview.setName("btnLoopPreview");
        this.btnLoopPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtNewAnimationDialog.this.btnLoopPreviewActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnAddAnimation, -1, -1, Short.MAX_VALUE).addComponent(this.btnPreview, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnLoopPreview, -1, -1, Short.MAX_VALUE).addComponent(this.btnCancel, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTime).addComponent(this.lblAnimationName).addComponent(this.lblDescription).addComponent(this.lblLoopCount).addComponent(this.lblOrder).addComponent(this.lblDuration)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spnLoopCount, -2, 43, -2).addComponent(this.txtTime, -2, 148, -2).addComponent(this.txtDuration, -2, 148, -2).addComponent(this.txtDescription, -2, 148, -2).addComponent(this.txtAnimName, -2, 148, -2).addComponent(this.spnOrder, -2, 43, -2))).addComponent(this.lblWindowName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 169, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblWindowName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTime).addComponent(this.txtTime, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAnimationName).addComponent(this.txtAnimName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDescription).addComponent(this.txtDescription, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblLoopCount).addComponent(this.spnLoopCount, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOrder).addComponent(this.spnOrder, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDuration).addComponent(this.txtDuration, -2, -1, -2)).addGap(29, 29, 29))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAddAnimation).addComponent(this.btnCancel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnPreview).addComponent(this.btnLoopPreview)).addContainerGap(145, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.jScrollPane1, -1, 377, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnAddAnimationActionPerformed(ActionEvent evt) {
        if (this.lstAnimations.getSelectedValue() == null) {
            return;
        }
        ActionAnimation newAnim = null;
        try {
            newAnim = new ActionAnimation(this.character, (int)(((NumericTextField)this.txtTime).getDoubleValue() * 1000.0), (int)(((NumericTextField)this.txtDuration).getDoubleValue() * 1000.0), this.txtAnimName.getText(), this.txtDescription.getText(), (Integer)this.spnLoopCount.getValue(), (Integer)this.spnOrder.getValue());
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ChangeStoryAction change = new ChangeStoryAction(ChangeType.ADD, this.character, newAnim.getActionProperties(), newAnim);
        this.character.getModel().processChangeStoryAction(change);
        this.frame.getPropertiesPane().setPropertiesPane(new NewtCharacterProperties(this.controller, this.character), new NewtAnimationProperties(this.controller, newAnim));
        this.destroyDialog();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.destroyDialog();
    }

    private void previewAnimation(boolean bLoop) {
        if (!this.controller.isUnrealServerRunning()) {
            StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("REQUESTCONNECT"));
            return;
        }
        if (this.lstAnimations.getSelectedValue() == null) {
            return;
        }
        ActionAnimation animPreview = null;
        try {
            animPreview = new ActionAnimation(this.character, (int)(((NumericTextField)this.txtTime).getDoubleValue() * 1000.0), (int)(((NumericTextField)this.txtDuration).getDoubleValue() * 1000.0), this.txtAnimName.getText(), this.txtDescription.getText(), (Integer)this.spnLoopCount.getValue(), (Integer)this.spnOrder.getValue());
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.controller.previewAnimation(animPreview, bLoop);
    }

    private void btnPreviewActionPerformed(ActionEvent evt) {
        this.previewAnimation(false);
    }

    private void btnLoopPreviewActionPerformed(ActionEvent evt) {
        this.previewAnimation(true);
    }
}

