/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.chars;

import java.awt.Color;
import java.util.LinkedList;
import java.util.Random;

public class PColorGenerator {
    private float h;
    private float s;
    private float b;
    private int a;
    private int memorySize;
    private short memoryFull;
    private LinkedList<Color> memory;
    public static final int METRICBOUND = 10;
    private Random rand;

    public PColorGenerator() {
        this.memorySize = 0;
        this.rand = new Random(System.currentTimeMillis());
    }

    public PColorGenerator(int memorysize) {
        if (memorysize > 100) {
            memorysize = 100;
        }
        this.rand = new Random(System.currentTimeMillis());
        this.memorySize = memorysize;
        this.memoryFull = 0;
        this.memory = new LinkedList();
    }

    public Color stringToColor(String str) {
        this.h = (float)str.hashCode() / 2.1474836E9f;
        this.s = 0.2f + this.rand.nextFloat() * 15.0f / 100.0f;
        this.b = 0.9f;
        Color color = new Color(Color.HSBtoRGB(this.h, this.s, this.b));
        return color;
    }

    public Color nextColor() {
        Color color;
        if (this.memorySize == 0) {
            this.h = this.rand.nextFloat();
            this.s = 0.2f + this.rand.nextFloat() * 15.0f / 100.0f;
            this.b = 0.9f;
            Color color2 = new Color(Color.HSBtoRGB(this.h, this.s, this.b));
            return color2;
        }
        do {
            this.h = this.rand.nextFloat();
            this.s = 0.2f + this.rand.nextFloat() * 15.0f / 100.0f;
            this.b = 0.9f;
        } while (!this.checkMemory(color = new Color(Color.HSBtoRGB(this.h, this.s, this.b))));
        this.memoryFull = (short)(this.memoryFull + 1);
        this.memory.add(color);
        if (this.memoryFull > this.memorySize) {
            this.memory.remove();
            this.memoryFull = (short)(this.memoryFull - 1);
        }
        return color;
    }

    public Color nextColor(int sector) {
        Color color;
        if (this.memorySize == 0) {
            this.h = (float)sector / 8.0f + this.rand.nextFloat() / 8.0f;
            this.s = 0.2f + this.rand.nextFloat() * 15.0f / 100.0f;
            this.b = 0.9f;
            Color color2 = new Color(Color.HSBtoRGB(this.h, this.s, this.b));
            return color2;
        }
        do {
            this.h = (float)sector / 8.0f + this.rand.nextFloat() / 8.0f;
            this.s = 0.2f + this.rand.nextFloat() * 15.0f / 100.0f;
            this.b = 0.9f;
        } while (!this.checkMemory(color = new Color(Color.HSBtoRGB(this.h, this.s, this.b))));
        this.memoryFull = (short)(this.memoryFull + 1);
        this.memory.add(color);
        if (this.memoryFull > this.memorySize) {
            this.memory.remove();
            this.memoryFull = (short)(this.memoryFull - 1);
        }
        return color;
    }

    private boolean checkMemory(Color c) {
        for (Color color : this.memory) {
            if (Math.abs(c.getGreen() - color.getGreen()) + Math.abs(c.getBlue() - color.getBlue()) + Math.abs(c.getRed() - color.getRed()) >= 10) continue;
            return false;
        }
        return true;
    }
}

