/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.chars;

import cz.cuni.amis.pogamut.emonewt.gui.AvatarState;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IScaleChangeListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryLenghtChangeListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryPlayerListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewtSlider
extends JSlider
implements ChangeListener,
StoryController.StoryControllerListener,
IStoryLenghtChangeListener,
IScaleChangeListener,
IStoryPlayerListener {
    private static final long TICK_LENGTH_MS = 1000L;
    private final StoryController model;

    private void registerListeners(ViewController controller) {
        this.addChangeListener(this);
        this.model.addStoryControllerListener(this);
        this.model.addStoryLengthChangedListener(this);
        controller.addStoryPlayerListener(this);
        this.model.addScaleListener(this);
    }

    public NewtSlider(StoryController model, ViewController controller) {
        super(0, Math.round(model.getStoryLength() / 1000L), 0);
        this.model = model;
        this.setMajorTickSpacing(10);
        this.setMinorTickSpacing(1);
        this.setPaintTicks(true);
        this.setPaintLabels(true);
        this.setSnapToTicks(true);
        this.setToolTipText(MessageFormat.format("\u010cas {0}s", this.getValue()));
        this.registerListeners(controller);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.model.setCurrentTime((long)this.getValue() * 1000L);
    }

    @Override
    public void currentTimeChanged(long oldCurrentTime, long newCurrentTime) {
        this.getModel().setValue((int)(newCurrentTime / 1000L));
        this.setToolTipText(MessageFormat.format("\u010cas {0}s", this.getValue()));
    }

    @Override
    public void storyLengthChanged(long oldLength, long newLength) {
        this.setMaximum(Math.round(newLength / 1000L));
        this.setLabelTable(this.createStandardLabels(this.getMajorTickSpacing()));
    }

    @Override
    public void storyPlayChanged(boolean bPaused) {
        this.setEnabled(!bPaused);
    }

    @Override
    public void scaleChanged(float oldScale, float newScale) {
        if (StoryTools.DEBUG) {
            System.out.println("New scale " + newScale);
        }
        if (newScale > 15.0f) {
            this.setMajorTickSpacing(5);
            this.setMinorTickSpacing(1);
        } else if (newScale < 5.0f) {
            this.setMajorTickSpacing(20);
            this.setMinorTickSpacing(5);
        } else {
            this.setMajorTickSpacing(10);
            this.setMinorTickSpacing(1);
        }
        this.setLabelTable(this.createStandardLabels(this.getMajorTickSpacing()));
    }

    @Override
    public void avatarsChanged(long time, Map<EmohawkCharacter, AvatarState> avataStates) {
    }
}

