/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.chars;

import cz.cuni.amis.pogamut.emonewt.gui.AvatarState;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryPlayerListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StoryController;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewtScaleSlider
extends JSlider
implements ChangeListener,
IStoryPlayerListener {
    private final StoryController model;
    private int minimumScale;
    private int maximumScale;
    private int actualScale;

    private void registerListeners(ViewController controller) {
        this.addChangeListener(this);
        controller.addStoryPlayerListener(this);
    }

    public NewtScaleSlider(StoryController model, ViewController controller, int minimumScale, int maximumScale, int actualScale) {
        super(1, minimumScale, maximumScale, actualScale);
        this.minimumScale = minimumScale;
        this.maximumScale = maximumScale;
        this.actualScale = actualScale;
        this.model = model;
        this.setSnapToTicks(true);
        this.setMajorTickSpacing(20);
        this.setMinorTickSpacing(5);
        this.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        JLabel minus = new JLabel(StorySettings.currentBundle.getString("ZOOM_OUT"));
        JLabel plus = new JLabel(StorySettings.currentBundle.getString("ZOOM_IN"));
        JLabel zero = new JLabel("---");
        labelTable.put(new Integer(minimumScale), minus);
        labelTable.put(new Integer(maximumScale), plus);
        labelTable.put(new Integer(actualScale), zero);
        this.setLabelTable(labelTable);
        this.setPaintLabels(true);
        this.registerListeners(controller);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        float setValue = (float)(this.getValue() + 100) / 10.0f;
        this.model.setScale(setValue);
        if (StoryTools.DEBUG) {
            System.out.println("The new scale is " + this.getValue());
        }
    }

    @Override
    public void storyPlayChanged(boolean bPaused) {
        this.setEnabled(!bPaused);
    }

    @Override
    public void avatarsChanged(long time, Map<EmohawkCharacter, AvatarState> avataStates) {
    }
}

