/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.chars;

import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.tools.IntTextField;
import cz.cuni.amis.pogamut.emonewt.gui.tools.NumericTextField;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionRotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class NewtRotationProperties
extends JPanel {
    private ActionRotation rotation;
    private EmoNewtFrame frame;
    private JButton btnApplyChanges;
    private JButton btnResetFields;
    private JButton btnSnapAngle;
    private JPanel jPanel1;
    private JLabel lblAngleH;
    private JLabel lblAngleV;
    private JLabel lblDescription;
    private JLabel lblDuration;
    private JLabel lblTime;
    private JTextField txtAngleH;
    private JTextField txtAngleV;
    private JTextField txtDescription;
    private JTextField txtDuration;
    private JTextField txtTime;

    public NewtRotationProperties(EmoNewtFrame frame, ActionRotation rotation) {
        this.frame = frame;
        this.rotation = rotation;
        this.initComponents();
        this.resetRotation();
    }

    public StoryAction getStoryAction() {
        return this.rotation;
    }

    public void actionChanged(StoryAction action) {
        if (action.getId() == this.rotation.getId()) {
            this.resetRotation();
        }
    }

    public void resetRotation() {
        this.txtDescription.setText(this.rotation.getDescription());
        NumericTextField txtTimeNum = (NumericTextField)this.txtTime;
        txtTimeNum.setValue((double)this.rotation.getTime() / 1000.0);
        NumericTextField txtDurationNum = (NumericTextField)this.txtDuration;
        txtDurationNum.setValue((double)this.rotation.getDuration() / 1000.0);
        this.txtAngleH.setText(String.valueOf(StoryTools.unitsToAngle(this.rotation.getAngleH())));
        this.txtAngleV.setText(String.valueOf(StoryTools.unitsToAngle(this.rotation.getAngleV())));
        this.validate();
    }

    private void initComponents() {
        this.btnApplyChanges = new JButton();
        this.btnResetFields = new JButton();
        this.btnSnapAngle = new JButton();
        this.jPanel1 = new JPanel();
        this.lblTime = new JLabel();
        this.lblDuration = new JLabel();
        this.lblAngleH = new JLabel();
        this.lblDescription = new JLabel();
        this.lblAngleV = new JLabel();
        this.txtDescription = new JTextField();
        this.txtDuration = new NumericTextField();
        this.txtTime = new NumericTextField();
        this.txtAngleH = new IntTextField();
        this.txtAngleV = new IntTextField();
        this.setBorder(BorderFactory.createTitledBorder(StorySettings.currentBundle.getString("ROTATION EDITOR")));
        this.btnApplyChanges.setText(StorySettings.currentBundle.getString("APPLY"));
        this.btnApplyChanges.setToolTipText(StorySettings.currentBundle.getString("USE_H"));
        this.btnApplyChanges.setName("btnApplyChanges");
        this.btnApplyChanges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtRotationProperties.this.btnApplyChangesActionPerformed(evt);
            }
        });
        this.btnResetFields.setText(StorySettings.currentBundle.getString("RESET"));
        this.btnResetFields.setToolTipText(StorySettings.currentBundle.getString("RESET_H"));
        this.btnResetFields.setName("btnResetFields");
        this.btnResetFields.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtRotationProperties.this.btnResetFieldsActionPerformed(evt);
            }
        });
        this.btnSnapAngle.setText(StorySettings.currentBundle.getString("ANGLE_SNAP"));
        this.btnSnapAngle.setToolTipText(StorySettings.currentBundle.getString("ANGLE_SNAP_TOOLTIP"));
        this.btnSnapAngle.setName("btnSnapAngle");
        this.btnSnapAngle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtRotationProperties.this.btnSnapAngleActionPerformed(evt);
            }
        });
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.lblTime.setText(StorySettings.currentBundle.getString("TIME:"));
        this.lblTime.setName("lblTime");
        this.jPanel1.add((Component)this.lblTime, new AbsoluteConstraints(0, 40, -1, -1));
        this.lblDuration.setText(StorySettings.currentBundle.getString("DURATION:"));
        this.lblDuration.setName("lblDuration");
        this.jPanel1.add((Component)this.lblDuration, new AbsoluteConstraints(0, 20, -1, -1));
        this.lblAngleH.setText(StorySettings.currentBundle.getString("ANGLEH:"));
        this.lblAngleH.setName("lblAngleH");
        this.jPanel1.add((Component)this.lblAngleH, new AbsoluteConstraints(0, 60, -1, -1));
        this.lblDescription.setText(StorySettings.currentBundle.getString("DESCRIPTION:"));
        this.lblDescription.setName("lblDescription");
        this.jPanel1.add((Component)this.lblDescription, new AbsoluteConstraints(0, 0, -1, -1));
        this.lblAngleV.setText(StorySettings.currentBundle.getString("ANGLEV:"));
        this.lblAngleV.setName("lblAngleV");
        this.jPanel1.add((Component)this.lblAngleV, new AbsoluteConstraints(0, 80, -1, 19));
        this.txtDescription.setToolTipText(StorySettings.currentBundle.getString("DESCRIPTION_H"));
        this.txtDescription.setCursor(new Cursor(2));
        this.txtDescription.setName("txtDescription");
        this.jPanel1.add((Component)this.txtDescription, new AbsoluteConstraints(90, 0, 136, 20));
        this.txtDuration.setHorizontalAlignment(4);
        this.txtDuration.setToolTipText(StorySettings.currentBundle.getString("DURATION_H"));
        this.txtDuration.setName("txtDuration");
        this.jPanel1.add((Component)this.txtDuration, new AbsoluteConstraints(140, 20, 70, 20));
        this.txtTime.setHorizontalAlignment(4);
        this.txtTime.setToolTipText(StorySettings.currentBundle.getString("TIME_H"));
        this.txtTime.setName("txtTime");
        this.jPanel1.add((Component)this.txtTime, new AbsoluteConstraints(140, 40, 70, 20));
        this.txtAngleH.setHorizontalAlignment(4);
        this.txtAngleH.setToolTipText(StorySettings.currentBundle.getString("ROT_ANGLE_H"));
        this.txtAngleH.setName("txtAngleH");
        this.jPanel1.add((Component)this.txtAngleH, new AbsoluteConstraints(140, 60, 70, 20));
        this.txtAngleV.setHorizontalAlignment(4);
        this.txtAngleV.setToolTipText(StorySettings.currentBundle.getString("ROT_ANGLE_H"));
        this.txtAngleV.setName("txtAngleV");
        this.jPanel1.add((Component)this.txtAngleV, new AbsoluteConstraints(140, 80, 70, 20));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnApplyChanges, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnResetFields, -2, 67, -2).addGap(7, 7, 7).addComponent(this.btnSnapAngle, -2, 65, -2)).addComponent(this.jPanel1, -2, 228, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnApplyChanges).addComponent(this.btnResetFields).addComponent(this.btnSnapAngle))));
    }

    private void btnApplyChangesActionPerformed(ActionEvent evt) {
        StoryActionProperties oldProp = this.rotation.getActionProperties();
        StoryActionProperties newProp = new StoryActionProperties(this.rotation.getActionProperties());
        newProp.setDescription(this.txtDescription.getText());
        try {
            newProp.setTime((long)(((NumericTextField)this.txtTime).getDoubleValue() * 1000.0));
            newProp.setDuration((long)(((NumericTextField)this.txtDuration).getDoubleValue() * 1000.0));
            int newAngleH = Integer.valueOf(this.txtAngleH.getText());
            int newAngleV = Integer.valueOf(this.txtAngleV.getText());
            if (newAngleH > 180 || newAngleH < -180) {
                StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("ROTATION MUST BE BETWEEN -180 and 180 DEGREES"));
                return;
            }
            if (newAngleV > 180 || newAngleV < -180) {
                StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("ROTATION MUST BE BETWEEN -180 and 180 DEGREES"));
                return;
            }
            newProp.setAngleV(StoryTools.angleToUTUnits(newAngleV));
            newProp.setAngleH(StoryTools.angleToUTUnits(newAngleH));
        }
        catch (ParseException ex) {
            StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("PLEASE FILL IN ALL FIELDS"));
            return;
        }
        catch (NumberFormatException e) {
            StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("PLEASE FILL IN ALL FIELDS"));
            return;
        }
        ChangeStoryAction change = new ChangeStoryAction(ChangeType.CHANGE, this.rotation.getOwner(), oldProp, newProp, this.rotation);
        if (!this.rotation.getOwner().getModel().processChangeStoryAction(change)) {
            this.resetRotation();
        }
    }

    private void btnResetFieldsActionPerformed(ActionEvent evt) {
        this.resetRotation();
    }

    private void btnSnapAngleActionPerformed(ActionEvent evt) {
        Rotation rotationSnap = this.frame.getController().getUnrealStoryPlayer().getRotationSnapFromUnreal();
        this.txtAngleH.setText(String.valueOf(StoryTools.unitsToAngle(rotationSnap.yaw)));
        this.txtAngleV.setText(String.valueOf(StoryTools.unitsToAngle(rotationSnap.pitch)));
    }

    public void setEverythingDisable(boolean bEnabled) {
        this.btnApplyChanges.setEnabled(!bEnabled);
        this.btnResetFields.setEnabled(!bEnabled);
        this.lblDescription.setEnabled(!bEnabled);
        this.lblDuration.setEnabled(!bEnabled);
        this.lblTime.setEnabled(!bEnabled);
        this.lblAngleV.setEnabled(!bEnabled);
        this.txtAngleH.setEnabled(!bEnabled);
        this.txtAngleV.setEnabled(!bEnabled);
        this.lblAngleH.setEnabled(!bEnabled);
        this.txtDescription.setEnabled(!bEnabled);
        this.txtDuration.setEnabled(!bEnabled);
        this.txtTime.setEnabled(!bEnabled);
    }
}

