/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.chars;

import cz.cuni.amis.pogamut.emonewt.gui.AvatarState;
import cz.cuni.amis.pogamut.emonewt.gui.EmoNewtFrame;
import cz.cuni.amis.pogamut.emonewt.gui.ViewController;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtAnimationProperties;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtCharacterProperties;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtMovementProperties;
import cz.cuni.amis.pogamut.emonewt.gui.chars.NewtRotationProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.IStoryPlayerListener;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionAnimation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionRotation;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.util.Map;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewtPropertiesPane
extends JPanel
implements IStoryPlayerListener {
    private final EmoNewtFrame frame;
    private NewtCharacterProperties charPropertiesPane;
    private JPanel actionPropertiesPane;

    public NewtPropertiesPane(EmoNewtFrame frame, ViewController controller) {
        this.frame = frame;
        controller.addStoryPlayerListener(this);
    }

    public void setPropertiesPane(NewtCharacterProperties charPropertiesPane, JPanel actionPropertiesPane) {
        this.charPropertiesPane = charPropertiesPane;
        this.actionPropertiesPane = actionPropertiesPane;
        this.removeAll();
        this.add(charPropertiesPane);
        if (actionPropertiesPane != null) {
            this.add(actionPropertiesPane);
        }
        this.frame.validate();
        this.frame.repaint();
    }

    public void clearPropertiesPane() {
        this.charPropertiesPane = null;
        this.actionPropertiesPane = null;
        this.removeAll();
        this.repaint();
    }

    public void notifyCharacterRemoved(EmohawkCharacter ec) {
        if (this.charPropertiesPane != null && this.charPropertiesPane.getCharacter().id == ec.id) {
            this.clearPropertiesPane();
        }
    }

    public void notifyCharacterChanged(EmohawkCharacter ec) {
        if (this.charPropertiesPane != null) {
            this.charPropertiesPane.characterChanged(ec);
        }
        if (this.actionPropertiesPane != null) {
            if (this.actionPropertiesPane.getClass().equals(NewtAnimationProperties.class)) {
                ((NewtAnimationProperties)this.actionPropertiesPane).characterChanged(ec);
            }
            if (this.actionPropertiesPane.getClass().equals(NewtMovementProperties.class)) {
                ((NewtMovementProperties)this.actionPropertiesPane).characterChanged(ec);
            }
        }
    }

    public void notifyActionChanged(StoryAction action) {
        if (this.actionPropertiesPane == null) {
            return;
        }
        if (this.actionPropertiesPane.getClass().equals(NewtAnimationProperties.class) && action.getClass().equals(ActionAnimation.class)) {
            NewtAnimationProperties prop = (NewtAnimationProperties)this.actionPropertiesPane;
            prop.actionChanged(action);
        } else if (this.actionPropertiesPane.getClass().equals(NewtMovementProperties.class) && action.getClass().equals(ActionMovement.class)) {
            NewtMovementProperties prop = (NewtMovementProperties)this.actionPropertiesPane;
            prop.actionChanged(action);
        } else if (this.actionPropertiesPane.getClass().equals(NewtRotationProperties.class) && action.getClass().equals(ActionRotation.class)) {
            NewtRotationProperties prop = (NewtRotationProperties)this.actionPropertiesPane;
            prop.actionChanged(action);
        }
    }

    public void notifyActionRemoved(StoryAction action) {
        NewtRotationProperties prop;
        if (this.actionPropertiesPane == null) {
            return;
        }
        if (this.actionPropertiesPane.getClass().equals(NewtAnimationProperties.class) && action.getClass().equals(ActionAnimation.class)) {
            NewtAnimationProperties prop2 = (NewtAnimationProperties)this.actionPropertiesPane;
            if (prop2.getStoryAction().getId() == action.getId()) {
                this.clearPropertiesPane();
            }
        } else if (this.actionPropertiesPane.getClass().equals(NewtMovementProperties.class) && action.getClass().equals(ActionMovement.class)) {
            NewtMovementProperties prop3 = (NewtMovementProperties)this.actionPropertiesPane;
            if (prop3.getStoryAction().getId() == action.getId()) {
                this.clearPropertiesPane();
            }
        } else if (this.actionPropertiesPane.getClass().equals(NewtRotationProperties.class) && action.getClass().equals(ActionRotation.class) && (prop = (NewtRotationProperties)this.actionPropertiesPane).getStoryAction().getId() == action.getId()) {
            this.clearPropertiesPane();
        }
    }

    @Override
    public void storyPlayChanged(boolean bPaused) {
        this.setEnabled(!bPaused);
        if (this.actionPropertiesPane != null) {
            if (this.actionPropertiesPane.getClass().equals(NewtRotationProperties.class)) {
                NewtRotationProperties prop = (NewtRotationProperties)this.actionPropertiesPane;
                prop.setEverythingDisable(bPaused);
            } else if (this.actionPropertiesPane.getClass().equals(NewtAnimationProperties.class)) {
                NewtAnimationProperties prop = (NewtAnimationProperties)this.actionPropertiesPane;
                prop.setEverythingDisable(bPaused);
            } else if (this.actionPropertiesPane.getClass().equals(NewtMovementProperties.class)) {
                NewtMovementProperties prop = (NewtMovementProperties)this.actionPropertiesPane;
                prop.setEverythingDisable(bPaused);
            }
        }
        if (this.charPropertiesPane != null) {
            this.charPropertiesPane.setEverythingDisable(bPaused);
        }
    }

    @Override
    public void avatarsChanged(long time, Map<EmohawkCharacter, AvatarState> avataStates) {
    }

    public void setButtonsDisabled() {
        this.setEnabled(false);
        if (this.actionPropertiesPane != null) {
            if (this.actionPropertiesPane.getClass().equals(NewtRotationProperties.class)) {
                NewtRotationProperties prop = (NewtRotationProperties)this.actionPropertiesPane;
                prop.setEverythingDisable(true);
            } else if (this.actionPropertiesPane.getClass().equals(NewtAnimationProperties.class)) {
                NewtAnimationProperties prop = (NewtAnimationProperties)this.actionPropertiesPane;
                prop.setEverythingDisable(true);
            } else if (this.actionPropertiesPane.getClass().equals(NewtMovementProperties.class)) {
                NewtMovementProperties prop = (NewtMovementProperties)this.actionPropertiesPane;
                prop.setEverythingDisable(true);
            }
        }
        if (this.charPropertiesPane != null) {
            this.charPropertiesPane.setEverythingDisable(true);
        }
        this.frame.validate();
    }
}

