/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emonewt.gui.chars;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emonewt.gui.tools.IntTextField;
import cz.cuni.amis.pogamut.emonewt.gui.tools.NumericTextField;
import cz.cuni.amis.pogamut.emonewt.gui.tools.StoryTools;
import cz.cuni.amis.pogamut.emonewt.storycontrol.StorySettings;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.ActionMovement;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.action.StoryActionProperties;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeStoryAction;
import cz.cuni.amis.pogamut.emonewt.storycontrol.changes.ChangeType;
import cz.cuni.amis.pogamut.emonewt.storycontrol.character.EmohawkCharacter;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class NewtMovementProperties
extends JPanel {
    private ActionMovement movement;
    private JButton btnApplyChanges;
    private JButton btnResetFields;
    private JPanel jPanel1;
    private JLabel lblDescription;
    private JLabel lblDuration;
    private JLabel lblEndLocation;
    private JLabel lblStartLocation;
    private JLabel lblTime;
    private JLabel lblXCoordName;
    private JLabel lblYCoordName;
    private JLabel lblZCoordName;
    private JTextField txtDescription;
    private JTextField txtDuration;
    private JTextField txtEndX;
    private JTextField txtEndY;
    private JTextField txtEndZ;
    private JTextField txtStartX;
    private JTextField txtStartY;
    private JTextField txtStartZ;
    private JTextField txtTime;

    public NewtMovementProperties(ActionMovement movement) {
        this.initComponents();
        this.movement = movement;
        this.resetMovement();
    }

    public StoryAction getStoryAction() {
        return this.movement;
    }

    public void actionChanged(StoryAction action) {
        if (action.getId() == this.movement.getId()) {
            this.resetMovement();
        }
    }

    public void characterChanged(EmohawkCharacter ec) {
        if (ec != this.movement.getOwner()) {
            return;
        }
        this.resetMovement();
    }

    public void resetMovement() {
        this.txtDescription.setText(this.movement.getDescription());
        NumericTextField txtTimeNum = (NumericTextField)this.txtTime;
        txtTimeNum.setValue((double)this.movement.getTime() / 1000.0);
        NumericTextField txtDurationNum = (NumericTextField)this.txtDuration;
        txtDurationNum.setValue((double)this.movement.getDuration() / 1000.0);
        ActionMovement lastMove = this.movement.getOwner().getPreviousMovement(this.movement);
        int endX = (int)this.movement.getEnd().x;
        int endY = (int)this.movement.getEnd().y;
        int endZ = (int)this.movement.getEnd().z;
        int startX = (int)this.movement.getOwner().getCharacterProperties().getStartLocation().x;
        int startY = (int)this.movement.getOwner().getCharacterProperties().getStartLocation().y;
        int startZ = (int)this.movement.getOwner().getCharacterProperties().getStartLocation().z;
        if (lastMove != null) {
            startX = (int)lastMove.getEnd().x;
            startY = (int)lastMove.getEnd().y;
            startZ = (int)lastMove.getEnd().z;
        }
        this.txtStartX.setText(String.valueOf(startX));
        this.txtStartY.setText(String.valueOf(startY));
        this.txtStartZ.setText(String.valueOf(startZ));
        this.txtEndX.setText(String.valueOf(endX));
        this.txtEndY.setText(String.valueOf(endY));
        this.txtEndZ.setText(String.valueOf(endZ));
        this.validate();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.txtStartX = new IntTextField();
        this.txtDescription = new JTextField();
        this.lblXCoordName = new JLabel();
        this.txtStartY = new IntTextField();
        this.lblYCoordName = new JLabel();
        this.lblDescription = new JLabel();
        this.txtEndX = new IntTextField();
        this.txtDuration = new NumericTextField();
        this.txtEndY = new IntTextField();
        this.txtTime = new NumericTextField();
        this.txtEndZ = new IntTextField();
        this.lblDuration = new JLabel();
        this.txtStartZ = new IntTextField();
        this.lblZCoordName = new JLabel();
        this.lblTime = new JLabel();
        this.lblStartLocation = new JLabel();
        this.lblEndLocation = new JLabel();
        this.btnResetFields = new JButton();
        this.btnApplyChanges = new JButton();
        this.setBorder(BorderFactory.createTitledBorder(StorySettings.currentBundle.getString("MOVEMENT EDITOR")));
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.txtStartX.setEditable(false);
        this.txtStartX.setName("txtStartX");
        this.jPanel1.add((Component)this.txtStartX, new AbsoluteConstraints(100, 80, 38, -1));
        this.txtDescription.setToolTipText(StorySettings.currentBundle.getString("DESCRIPTION_H"));
        this.txtDescription.setName("txtDescription");
        this.jPanel1.add((Component)this.txtDescription, new AbsoluteConstraints(105, 0, 140, 20));
        this.lblXCoordName.setText("x");
        this.lblXCoordName.setName("lblXCoordName");
        this.jPanel1.add((Component)this.lblXCoordName, new AbsoluteConstraints(120, 60, 18, -1));
        this.txtStartY.setEditable(false);
        this.txtStartY.setName("txtStartY");
        this.jPanel1.add((Component)this.txtStartY, new AbsoluteConstraints(150, 80, 38, -1));
        this.lblYCoordName.setText("y");
        this.lblYCoordName.setName("lblYCoordName");
        this.jPanel1.add((Component)this.lblYCoordName, new AbsoluteConstraints(170, 60, 16, -1));
        this.lblDescription.setText(StorySettings.currentBundle.getString("DESCRIPTION:"));
        this.lblDescription.setName("lblDescription");
        this.jPanel1.add((Component)this.lblDescription, new AbsoluteConstraints(0, 0, -1, -1));
        this.txtEndX.setToolTipText(StorySettings.currentBundle.getString("ENDX_H"));
        this.txtEndX.setName("txtEndX");
        this.jPanel1.add((Component)this.txtEndX, new AbsoluteConstraints(100, 110, 38, -1));
        this.txtDuration.setHorizontalAlignment(2);
        this.txtDuration.setToolTipText(StorySettings.currentBundle.getString("DURATION_H"));
        this.txtDuration.setName("txtDuration");
        this.jPanel1.add((Component)this.txtDuration, new AbsoluteConstraints(105, 20, 140, 20));
        this.txtEndY.setToolTipText(StorySettings.currentBundle.getString("ENDY_H"));
        this.txtEndY.setName("txtEndY");
        this.jPanel1.add((Component)this.txtEndY, new AbsoluteConstraints(150, 110, 38, -1));
        this.txtTime.setHorizontalAlignment(2);
        this.txtTime.setToolTipText(StorySettings.currentBundle.getString("TIME_H"));
        this.txtTime.setName("txtTime");
        this.jPanel1.add((Component)this.txtTime, new AbsoluteConstraints(105, 40, 140, 20));
        this.txtEndZ.setText("0");
        this.txtEndZ.setToolTipText(StorySettings.currentBundle.getString("ENDZ_H"));
        this.txtEndZ.setName("txtEndZ");
        this.jPanel1.add((Component)this.txtEndZ, new AbsoluteConstraints(200, 110, 38, -1));
        this.lblDuration.setText(StorySettings.currentBundle.getString("DURATION:"));
        this.lblDuration.setName("lblDuration");
        this.jPanel1.add((Component)this.lblDuration, new AbsoluteConstraints(0, 20, -1, -1));
        this.txtStartZ.setEditable(false);
        this.txtStartZ.setText("0");
        this.txtStartZ.setName("txtStartZ");
        this.jPanel1.add((Component)this.txtStartZ, new AbsoluteConstraints(200, 80, 38, -1));
        this.lblZCoordName.setText("z");
        this.lblZCoordName.setName("lblZCoordName");
        this.jPanel1.add((Component)this.lblZCoordName, new AbsoluteConstraints(220, 60, 20, -1));
        this.lblTime.setText(StorySettings.currentBundle.getString("TIME:"));
        this.lblTime.setName("lblTime");
        this.jPanel1.add((Component)this.lblTime, new AbsoluteConstraints(0, 40, -1, -1));
        this.lblStartLocation.setText(StorySettings.currentBundle.getString("START LOC:"));
        this.lblStartLocation.setName("lblStartLocation");
        this.jPanel1.add((Component)this.lblStartLocation, new AbsoluteConstraints(0, 80, -1, -1));
        this.lblEndLocation.setText(StorySettings.currentBundle.getString("END LOC:"));
        this.lblEndLocation.setName("lblEndLocation");
        this.jPanel1.add((Component)this.lblEndLocation, new AbsoluteConstraints(0, 110, -1, -1));
        this.btnResetFields.setText(StorySettings.currentBundle.getString("RESET"));
        this.btnResetFields.setToolTipText(StorySettings.currentBundle.getString("RESET_H"));
        this.btnResetFields.setName("btnResetFields");
        this.btnResetFields.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtMovementProperties.this.btnResetFieldsActionPerformed(evt);
            }
        });
        this.btnApplyChanges.setText(StorySettings.currentBundle.getString("APPLY"));
        this.btnApplyChanges.setToolTipText(StorySettings.currentBundle.getString("USE_H"));
        this.btnApplyChanges.setName("btnApplyChanges");
        this.btnApplyChanges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewtMovementProperties.this.btnApplyChangesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.btnApplyChanges).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnResetFields)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnApplyChanges).addComponent(this.btnResetFields))));
    }

    private void btnApplyChangesActionPerformed(ActionEvent evt) {
        StoryActionProperties oldProp = this.movement.getActionProperties();
        StoryActionProperties newProp = new StoryActionProperties(this.movement.getActionProperties());
        newProp.setDescription(this.txtDescription.getText());
        try {
            newProp.setTime((long)(((NumericTextField)this.txtTime).getDoubleValue() * 1000.0));
            newProp.setDuration((long)(((NumericTextField)this.txtDuration).getDoubleValue() * 1000.0));
            newProp.setEnd(new Location((double)Integer.valueOf(this.txtEndX.getText()).intValue(), (double)Integer.valueOf(this.txtEndY.getText()).intValue(), (double)Integer.valueOf(this.txtEndZ.getText()).intValue()));
        }
        catch (ParseException ex) {
            StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("PLEASE FILL IN ALL FIELDS"));
        }
        catch (NumberFormatException e) {
            StoryTools.userNotificationDialog(this, StorySettings.currentBundle.getString("PLEASE FILL IN ALL FIELDS"));
        }
        ChangeStoryAction change = new ChangeStoryAction(ChangeType.CHANGE, this.movement.getOwner(), oldProp, newProp, this.movement);
        if (!this.movement.getOwner().getModel().processChangeStoryAction(change)) {
            this.resetMovement();
        }
    }

    private void btnResetFieldsActionPerformed(ActionEvent evt) {
        this.resetMovement();
    }

    public void setEverythingDisable(boolean bEnabled) {
        this.btnApplyChanges.setEnabled(!bEnabled);
        this.btnResetFields.setEnabled(!bEnabled);
        this.txtDescription.setEnabled(!bEnabled);
        this.txtDuration.setEnabled(!bEnabled);
        this.txtEndX.setEnabled(!bEnabled);
        this.txtEndY.setEnabled(!bEnabled);
        this.txtEndZ.setEnabled(!bEnabled);
        this.txtStartX.setEnabled(!bEnabled);
        this.txtStartY.setEnabled(!bEnabled);
        this.txtStartZ.setEnabled(!bEnabled);
        this.txtTime.setEnabled(!bEnabled);
        this.lblDescription.setEnabled(!bEnabled);
        this.lblDuration.setEnabled(!bEnabled);
        this.lblEndLocation.setEnabled(!bEnabled);
        this.lblStartLocation.setEnabled(!bEnabled);
        this.lblTime.setEnabled(!bEnabled);
        this.lblXCoordName.setEnabled(!bEnabled);
        this.lblYCoordName.setEnabled(!bEnabled);
        this.lblZCoordName.setEnabled(!bEnabled);
    }
}

